/*
 * Decompiled with CFR 0.152.
 */
package Util;

import VisiProg.AppOptions;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;

public class FieldChecker {
    private static Locale currentLocale;
    private static ResourceBundle message;
    private static AppOptions options;

    public static boolean checkSerialNumber(String deviceName, String serialNumber) {
        Object[] options;
        HashMap<String, String> nameFamilyMap = new HashMap<String, String>();
        FieldChecker.options.LoadOptions();
        currentLocale = new Locale(FieldChecker.options.language, FieldChecker.options.country);
        message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", currentLocale);
        try {
            nameFamilyMap.put("DS18S20", "10");
            nameFamilyMap.put("DS18B20", "28");
            nameFamilyMap.put("DS2438", "26");
            nameFamilyMap.put("DS2890", "2C");
            nameFamilyMap.put("DS2408", "29");
            nameFamilyMap.put("DS2751", "51");
        }
        catch (Exception ex) {
            return false;
        }
        if (serialNumber.length() != 16) {
            options = new Object[]{message.getString("yes"), message.getString("no"), message.getString("cancel")};
            if (JOptionPane.showOptionDialog(null, message.getString("serie"), message.getString("er"), 1, 2, null, options, options[0]) == 0) {
                return false;
            }
        }
        if (!FieldChecker.checkValidHexString(serialNumber)) {
            options = new Object[]{message.getString("yes"), message.getString("no"), message.getString("cancel")};
            if (JOptionPane.showOptionDialog(null, message.getString("esa"), message.getString("er"), 1, 2, null, options, options[0]) == 0) {
                return false;
            }
        }
        try {
            if (deviceName.equals("DS18S20") || deviceName.equals("DS18B20")) {
                if (!serialNumber.substring(14).equals("10") && !serialNumber.substring(14).equals("28")) {
                    JOptionPane.showMessageDialog(null, message.getString("numfamiglia"), message.getString("er"), 0);
                    return false;
                }
            } else if (!nameFamilyMap.get(deviceName).equals(serialNumber.toUpperCase().substring(14))) {
                JOptionPane.showMessageDialog(null, message.getString("numfamiglia"), message.getString("er"), 0);
                return false;
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, message.getString("disp") + " " + deviceName + " " + message.getString("riconosciuto!"), message.getString("er"), 0);
            return false;
        }
        return true;
    }

    public static boolean checkValidHexString(String stringToCheck) {
        char[] myString = stringToCheck.toCharArray();
        for (int i = 0; i < myString.length; ++i) {
            boolean is_hex_char;
            char current_char = myString[i];
            boolean bl = is_hex_char = current_char >= '0' && current_char <= '9' || current_char >= 'a' && current_char <= 'f' || current_char >= 'A' && current_char <= 'F';
            if (is_hex_char) continue;
            return false;
        }
        return true;
    }

    public static boolean checkValidAddress(String address) {
        if (address.length() == 0) {
            JOptionPane.showMessageDialog(null, message.getString("nulladdr"), message.getString("er"), 0);
            return false;
        }
        if (Integer.parseInt(address) < 0) {
            JOptionPane.showMessageDialog(null, message.getString("erraddr"), message.getString("er"), 0);
            return false;
        }
        return true;
    }

    public static boolean checkStringIsNumeric(String stringToCheck) {
        try {
            Float.parseFloat(stringToCheck);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean checkStringIsNumeric(String stringToCheck, String errorMessage) {
        try {
            Float.parseFloat(stringToCheck);
            return true;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, errorMessage, message.getString("er"), 0);
            return false;
        }
    }

    public static boolean checkStringIsNumericAndPositive(String stringToCheck) {
        if (!FieldChecker.checkStringIsNumeric(stringToCheck)) {
            return false;
        }
        float val = Float.parseFloat(stringToCheck);
        return (double)val >= 0.0;
    }

    public static boolean isValidIP(String ipStringToCheck, String errorMessage) {
        boolean correctFormat = ipStringToCheck.matches("^[\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3}$");
        if (correctFormat) {
            boolean validIp = true;
            String[] values = ipStringToCheck.split("\\.");
            for (int k = 0; k < values.length; ++k) {
                short v = Short.valueOf(values[k]);
                if (v >= 0 && v <= 255) continue;
                validIp = false;
                break;
            }
            if (!validIp) {
                JOptionPane.showMessageDialog(null, errorMessage, message.getString("er"), 0);
            }
            return validIp;
        }
        JOptionPane.showMessageDialog(null, errorMessage, message.getString("er"), 0);
        return false;
    }

    public static boolean isValidIP(String ipStringToCheck) {
        boolean correctFormat = ipStringToCheck.matches("^[\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3}$");
        if (correctFormat) {
            boolean validIp = true;
            String[] values = ipStringToCheck.split("\\.");
            for (int k = 0; k < values.length; ++k) {
                short v = Short.valueOf(values[k]);
                if (v >= 0 && v <= 255) continue;
                validIp = false;
                break;
            }
            return validIp;
        }
        return false;
    }

    public static boolean checkFieldIsValidFileName(String stringToCheck, String errorMessage) {
        File f = new File(stringToCheck);
        try {
            f.getCanonicalPath();
            return true;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, errorMessage, message.getString("er"), 0);
            return false;
        }
    }

    static {
        options = new AppOptions();
    }
}

