/*
 * Decompiled with CFR 0.152.
 */
package VisiProg;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.openide.util.Exceptions;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AppOptions {
    public String lastOpenDir;
    public boolean debugMode = false;
    public boolean showUnusedBlocks = true;
    private static String OPTIONS_FILE_NAME = "./config.xml";
    private static final String OPTIONS_ELEMENT = "Options";
    private static final String VERSION_ATTR = "version";
    private static final String VERSION_VALUE_1 = "1.3.5";
    private static final String LAST_OPEN_PROJ = "LastOpenProj";
    private static final String LAST_DIR_PATH = "path";
    private static final String DEBUG_MODE = "DebugMode";
    private static final String ACTIVE = "active";
    private static final String VAL = "val";
    private static final String SUPERUSER_MODE = "SuperUser";
    private static final String UNUSED_BLOCKS = "UnusedBlocks";
    private static final String SHOW_UNUSED_BLOCKS = "Show";
    private static final String LANGUAGE = "language";
    private static final String COUNTRY = "country";
    private static final String MODIFY_LANGUAGE = "ChangeLanguage";
    private static final String MODIFY_COUNTRY = "ChangeCountry";
    public String language;
    public String country;
    private static final String LAST_SEPARATOR = "LastSeparator";
    private static final String MODIFY_SEPARATOR = "ChangeSeparator";
    public String separator = ";";
    public static final String BOARD_TYPE = "BoardType";
    public String boardtype;
    public static final String TYPE = "type";
    public boolean superUserMode = false;
    private static final String KERNEL_MESSAGE_TIMEOUT = "KernelMessageTimeout";
    public int messageTimeout_ms = 10000;
    private static final String KERNEL_SAVE_TIMEOUT = "KernelSaveTimeout";
    public int saveTimeout_ms = 60000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SaveOptions() {
        File file = null;
        try {
            file = new File(OPTIONS_FILE_NAME);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
            return;
        }
        Document document = XMLUtil.createDocument((String)OPTIONS_ELEMENT, null, null, null);
        Node rootElement = document.getFirstChild();
        AppOptions.setAttribute(document, rootElement, VERSION_ATTR, VERSION_VALUE_1);
        Element nodeElement = document.createElement(MODIFY_LANGUAGE);
        AppOptions.setAttribute(document, nodeElement, LANGUAGE, this.language);
        rootElement.appendChild(nodeElement);
        nodeElement = document.createElement(MODIFY_COUNTRY);
        AppOptions.setAttribute(document, nodeElement, COUNTRY, this.country);
        rootElement.appendChild(nodeElement);
        nodeElement = document.createElement(BOARD_TYPE);
        AppOptions.setAttribute(document, nodeElement, TYPE, this.boardtype);
        rootElement.appendChild(nodeElement);
        nodeElement = document.createElement(MODIFY_SEPARATOR);
        AppOptions.setAttribute(document, nodeElement, LAST_SEPARATOR, this.separator);
        rootElement.appendChild(nodeElement);
        nodeElement = document.createElement(LAST_OPEN_PROJ);
        AppOptions.setAttribute(document, nodeElement, LAST_DIR_PATH, this.lastOpenDir);
        rootElement.appendChild(nodeElement);
        nodeElement = document.createElement(DEBUG_MODE);
        AppOptions.setAttribute(document, nodeElement, ACTIVE, Boolean.toString(this.debugMode));
        rootElement.appendChild(nodeElement);
        nodeElement = document.createElement(UNUSED_BLOCKS);
        AppOptions.setAttribute(document, nodeElement, SHOW_UNUSED_BLOCKS, Boolean.toString(this.showUnusedBlocks));
        rootElement.appendChild(nodeElement);
        nodeElement = document.createElement(KERNEL_MESSAGE_TIMEOUT);
        AppOptions.setAttribute(document, nodeElement, VAL, "" + this.messageTimeout_ms);
        rootElement.appendChild(nodeElement);
        nodeElement = document.createElement(KERNEL_SAVE_TIMEOUT);
        AppOptions.setAttribute(document, nodeElement, VAL, "" + this.saveTimeout_ms);
        rootElement.appendChild(nodeElement);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            XMLUtil.write((Document)document, (OutputStream)fos, (String)"UTF-8");
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public void LoadOptions() {
        File file = null;
        this.lastOpenDir = "./";
        this.language = "it";
        this.country = "IT";
        this.separator = ";";
        this.boardtype = "mPID9MX";
        try {
            file = new File(OPTIONS_FILE_NAME);
            if (!file.exists()) {
                return;
            }
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
            return;
        }
        Node rootElement = AppOptions.getRootNode(file);
        if (!VERSION_VALUE_1.equals(AppOptions.getAttributeValue(rootElement, VERSION_ATTR))) {
            return;
        }
        for (Node element : AppOptions.getChildNode(rootElement)) {
            if (LAST_OPEN_PROJ.equals(element.getNodeName())) {
                this.lastOpenDir = AppOptions.getAttributeValue(element, LAST_DIR_PATH);
                continue;
            }
            if (element.getNodeName().equals(DEBUG_MODE)) {
                this.debugMode = Boolean.parseBoolean(AppOptions.getAttributeValue(element, ACTIVE));
                continue;
            }
            if (element.getNodeName().equals(UNUSED_BLOCKS)) {
                this.showUnusedBlocks = Boolean.parseBoolean(AppOptions.getAttributeValue(element, SHOW_UNUSED_BLOCKS));
                continue;
            }
            if (element.getNodeName().equals(KERNEL_MESSAGE_TIMEOUT)) {
                this.messageTimeout_ms = Integer.parseInt(AppOptions.getAttributeValue(element, VAL));
                continue;
            }
            if (element.getNodeName().equals(KERNEL_SAVE_TIMEOUT)) {
                this.saveTimeout_ms = Integer.parseInt(AppOptions.getAttributeValue(element, VAL));
                continue;
            }
            if (element.getNodeName().equals(MODIFY_LANGUAGE)) {
                this.language = AppOptions.getAttributeValue(element, LANGUAGE);
                continue;
            }
            if (element.getNodeName().equals(MODIFY_COUNTRY)) {
                this.country = AppOptions.getAttributeValue(element, COUNTRY);
                continue;
            }
            if (element.getNodeName().equals(BOARD_TYPE)) {
                this.boardtype = AppOptions.getAttributeValue(element, TYPE);
                continue;
            }
            if (element.getNodeName().equals(MODIFY_SEPARATOR)) {
                this.separator = AppOptions.getAttributeValue(element, LAST_SEPARATOR);
                if (!this.separator.isEmpty()) continue;
                this.separator = ";";
                continue;
            }
            if (!element.getNodeName().equals(SUPERUSER_MODE)) continue;
            this.superUserMode = Boolean.parseBoolean(AppOptions.getAttributeValue(element, ACTIVE));
        }
    }

    private static void setAttribute(Document xml, Node node, String name, String value) {
        NamedNodeMap map = node.getAttributes();
        Attr attribute = xml.createAttribute(name);
        attribute.setValue(value);
        map.setNamedItem(attribute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Node getRootNode(File file) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            Document doc = XMLUtil.parse((InputSource)new InputSource(is), (boolean)false, (boolean)false, (ErrorHandler)new ErrorHandler(){

                @Override
                public void error(SAXParseException e) throws SAXException {
                    throw new SAXException(e);
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    throw new SAXException(e);
                }

                @Override
                public void warning(SAXParseException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }, null);
            Node node = doc.getFirstChild();
            return node;
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        return null;
    }

    private static String getAttributeValue(Node node, String attr) {
        try {
            NamedNodeMap map;
            if (node != null && (map = node.getAttributes()) != null && (node = map.getNamedItem(attr)) != null) {
                return node.getNodeValue();
            }
        }
        catch (DOMException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return null;
    }

    private static Node[] getChildNode(Node node) {
        NodeList childNodes = node.getChildNodes();
        Node[] nodes = new Node[childNodes != null ? childNodes.getLength() : 0];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = childNodes.item(i);
        }
        return nodes;
    }

    public void setLanguage(String lang) {
        this.language = lang;
    }

    public void setCountry(String count) {
        this.country = count;
    }

    public void setSeparator(String sep) {
        this.separator = sep;
    }

    public void setType(String type) {
        this.boardtype = type;
    }

    public String getType() {
        return this.boardtype;
    }
}

