/*
 * Decompiled with CFR 0.152.
 */
package VisiProg;

import VisiProg.VisiProgApp;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import nodes.AFONodeWidget;
import nodes.AFOSystemManager;
import nodes.CommonDefinitions;
import nodes.Project;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.netbeans.api.visual.model.ObjectState;
import sceneManager.AFONode;

public class SearchBlockDialog
extends JDialog {
    public static final int RET_OK = 1;
    public static final int RET_CANCEL = 0;
    public int retVal = 1;
    Project proj;
    private JButton btnOK;
    private JCheckBox chkSearchComment;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTable tableResult;
    public JTextField txtBlockAddress;

    public SearchBlockDialog(Frame parent, boolean modal, Project prj) {
        super(parent, modal);
        this.initComponents();
        this.setTitle("Search Block");
        this.proj = prj;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.txtBlockAddress = new JTextField();
        this.chkSearchComment = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.btnOK = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.tableResult = new JTable();
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        this.jPanel1.setName("jPanel1");
        ResourceMap resourceMap = Application.getInstance(VisiProgApp.class).getContext().getResourceMap(SearchBlockDialog.class);
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.txtBlockAddress.setColumns(5);
        this.txtBlockAddress.setText(resourceMap.getString("txtBlockAddress.text", new Object[0]));
        this.txtBlockAddress.setName("txtBlockAddress");
        this.txtBlockAddress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchBlockDialog.this.txtBlockAddressActionPerformed(evt);
            }
        });
        this.chkSearchComment.setText(resourceMap.getString("chkSearchComment.text", new Object[0]));
        this.chkSearchComment.setName("chkSearchComment");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtBlockAddress, -1, 258, Short.MAX_VALUE)).addComponent(this.chkSearchComment)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.txtBlockAddress, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 8, Short.MAX_VALUE).addComponent(this.chkSearchComment).addContainerGap()));
        this.jPanel2.setName("jPanel2");
        this.btnOK.setIcon(resourceMap.getIcon("btnOK.icon"));
        this.btnOK.setText(resourceMap.getString("btnOK.text", new Object[0]));
        this.btnOK.setName("btnOK");
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchBlockDialog.this.btnOKActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap(272, Short.MAX_VALUE).addComponent(this.btnOK).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.btnOK).addContainerGap()));
        this.jScrollPane1.setName("jScrollPane1");
        this.tableResult.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}}, new String[]{"Address", "Comment", "Type", "Subsystem", "Node"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class, Object.class, Object.class};
                this.canEdit = new boolean[]{false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tableResult.setName("tableResult");
        this.tableResult.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                SearchBlockDialog.this.tableResultMousePressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tableResult);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 353, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 282, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void txtBlockAddressActionPerformed(ActionEvent evt) {
        this.searchBlocks();
    }

    private void cleanTable() {
        DefaultTableModel model = (DefaultTableModel)this.tableResult.getModel();
        while (model.getRowCount() > 0) {
            model.removeRow(0);
        }
        TableColumn column = this.tableResult.getColumnModel().getColumn(4);
        column.setMinWidth(0);
        column.setMaxWidth(0);
        column.setWidth(0);
        column.setPreferredWidth(0);
    }

    private void tableResultMousePressed(MouseEvent evt) {
        try {
            int index = this.tableResult.getSelectedRow();
            if (index < 0) {
                return;
            }
            AFOSystemManager sm = (AFOSystemManager)this.tableResult.getValueAt(index, 3);
            AFONode node = (AFONode)this.tableResult.getValueAt(index, 4);
            if (sm.isSubSystem()) {
                sm.showPropertiesDialog();
                sm.getScene().setFocusedWidget(node.getWidget());
                ((AFONodeWidget)node.getWidget()).setModuleWidgetColor(CommonDefinitions.BORDER_FILL_DARKGREEN);
                node.getWidget().revalidate();
                sm.getScene().revalidate();
            } else {
                sm.getSubSystemScene().setFocusedWidget(node.getWidget());
                ObjectState state = ObjectState.createNormal();
                state = state.deriveSelected(true);
                ((AFONodeWidget)node.getWidget()).setModuleWidgetColor(CommonDefinitions.BORDER_FILL_DARKGREEN);
                node.getWidget().revalidate();
                sm.getSubSystemScene().revalidate();
            }
        }
        catch (Exception exception) {
            Logger.getLogger(SearchBlockDialog.class.getName()).log(Level.SEVERE, null, exception);
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(SearchBlockDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(SearchBlockDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(SearchBlockDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(SearchBlockDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchBlockDialog dialog = new SearchBlockDialog((Frame)new JFrame(), true, null);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    private void searchBlocks() {
        String searchString = this.txtBlockAddress.getText();
        DefaultTableModel model = (DefaultTableModel)this.tableResult.getModel();
        this.cleanTable();
        Object nodeFound = null;
        Object systemManagerFound = null;
        AFOSystemManager sm = this.proj.getMainSystem();
        for (AFONode node : sm.getNodeList()) {
            String nodeAddress;
            if (this.chkSearchComment.isSelected()) {
                String comment = node.getComment();
                if (!comment.contains(searchString) || node.getAddressList().isEmpty()) continue;
                model.addRow(new Object[]{"" + node.getAddressList().get(0), node.getComment(), node.getBlockType().toString(), sm, node});
                continue;
            }
            if (node.getAddressList().isEmpty() || !(nodeAddress = "" + node.getAddressList().get(0)).equals(searchString)) continue;
            model.addRow(new Object[]{nodeAddress, node.getComment(), node.getBlockType().toString(), sm, node});
            break;
        }
        block1: for (AFOSystemManager sms : this.proj.getSubSystemList()) {
            if (sms.getNodeListSize() == 0) continue;
            for (AFONode node : sms.getNodeList()) {
                String nodeAddress;
                if (this.chkSearchComment.isSelected()) {
                    String comment = node.getComment();
                    if (!comment.contains(searchString) || node.getAddressList().isEmpty()) continue;
                    model.addRow(new Object[]{"" + node.getAddressList().get(0), node.getComment(), node.getBlockType().toString(), sms, node});
                    continue;
                }
                if (node.getAddressList().isEmpty() || !(nodeAddress = "" + node.getAddressList().get(0)).equals(searchString)) continue;
                model.addRow(new Object[]{nodeAddress, node.getComment(), node.getBlockType().toString(), sms, node});
                continue block1;
            }
        }
    }
}

