/*
 * Decompiled with CFR 0.152.
 */
package VisiProg;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;

public class SplashScreen
extends JWindow {
    private int duration;
    private Image logo;

    public SplashScreen(int d) {
        this.duration = d;
    }

    public void showSplash(String version) {
        JPanel content = (JPanel)this.getContentPane();
        content.setBackground(Color.white);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            this.logo = toolkit.getImage("./splashVisiprog.png");
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(this.logo, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException ie) {}
        }
        catch (Exception ex) {
            // empty catch block
        }
        int width = this.logo.getWidth(null) + 10;
        int height = this.logo.getHeight(null) + 50;
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screen.width - width) / 2;
        int y = (screen.height - height) / 2;
        this.setBounds(x, y, width, height);
        JLabel label = new JLabel(new ImageIcon(this.logo));
        JLabel copyrt = new JLabel("Version: " + version, 0);
        copyrt.setFont(new Font("Sans-Serif", 1, 20));
        content.add((Component)label, "Center");
        content.add((Component)copyrt, "South");
        Color oraRed = new Color(156, 20, 20, 255);
        content.setBorder(BorderFactory.createLineBorder(oraRed, 1));
        this.setVisible(true);
        try {
            Thread.sleep(this.duration);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setVisible(false);
    }

    public void showSplashAndExit(String version) {
        this.showSplash(version);
        System.exit(0);
    }
}

