/*
 * Decompiled with CFR 0.152.
 */
package connection.gui;

import VisiProg.AppOptions;
import VisiProg.VisiProgApp;
import connection.IKernelEventListener;
import connection.KernelEvent;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class ConnectDialog
extends JDialog
implements IKernelEventListener {
    private static final String[] messages = new String[]{"Opening port...", "Init nodes", "Finalizing"};
    Locale currentLocale;
    ResourceBundle message;
    AppOptions options = new AppOptions();
    private JLabel infoLabel;
    private JLabel jLabel2;
    private JProgressBar progress;

    public ConnectDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.center();
        this.options.LoadOptions();
        this.currentLocale = new Locale(this.options.language, this.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
    }

    private void center() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle frame = this.getBounds();
        this.setLocation((screen.width - frame.width) / 2, (screen.height - frame.height) / 2);
    }

    private void initComponents() {
        this.progress = new JProgressBar();
        this.infoLabel = new JLabel();
        this.jLabel2 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        this.progress.setName("progress");
        ResourceMap resourceMap = Application.getInstance(VisiProgApp.class).getContext().getResourceMap(ConnectDialog.class);
        this.infoLabel.setText(resourceMap.getString("infoLabel.text", new Object[0]));
        this.infoLabel.setName("infoLabel");
        this.jLabel2.setIcon(resourceMap.getIcon("jLabel2.icon"));
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.infoLabel).addComponent(this.progress, -2, 267, -2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(50, 50, 50).addComponent(this.infoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progress, -2, -1, -2)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2))).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConnectDialog dialog = new ConnectDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    @Override
    public void kernelEventOccurred(KernelEvent evt) {
        if (evt.getEventType().equals("Kernel Connecting Progress")) {
            this.progress.getModel().setValue(evt.getEventValue());
            this.infoLabel.setText(evt.getEventMessage());
            this.invalidate();
        } else if (evt.getEventType().equals("ETH Kernel Connected")) {
            JOptionPane.showMessageDialog(null, this.message.getString("kernelok"));
            this.setVisible(false);
        } else if (evt.getEventType().equals("Serial Kernel Connected")) {
            JOptionPane.showMessageDialog(null, this.message.getString("serialportopen"));
            this.setVisible(false);
        } else if (evt.getEventType().equals("Connection failed")) {
            JOptionPane.showMessageDialog(null, this.message.getString("kernelko"));
            this.setVisible(false);
        }
    }
}

