/*
 * Decompiled with CFR 0.152.
 */
package connection.gui;

import VisiProg.VisiProgApp;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class ErrorDialog
extends JDialog {
    private JButton btnClear;
    private JButton btnExit;
    private JScrollPane scrollLog;
    private JTextArea txtErrorArea;

    public ErrorDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.center();
    }

    private void center() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle frame = this.getBounds();
        this.setLocation((screen.width - frame.width) / 2, (screen.height - frame.height) / 2);
    }

    public void addError(String message) {
        JScrollBar vbar = this.scrollLog.getVerticalScrollBar();
        boolean autoScroll = false;
        if (vbar.getValue() + vbar.getVisibleAmount() >= vbar.getMaximum() - 50) {
            autoScroll = true;
        }
        Date data = new Date();
        this.txtErrorArea.append(data.toString() + " " + message + "\n");
        if (autoScroll) {
            this.txtErrorArea.setCaretPosition(this.txtErrorArea.getDocument().getLength());
        }
    }

    private void initComponents() {
        this.btnExit = new JButton();
        this.scrollLog = new JScrollPane();
        this.txtErrorArea = new JTextArea();
        this.btnClear = new JButton();
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        ResourceMap resourceMap = Application.getInstance(VisiProgApp.class).getContext().getResourceMap(ErrorDialog.class);
        this.btnExit.setIcon(resourceMap.getIcon("btnExit.icon"));
        this.btnExit.setText(resourceMap.getString("btnExit.text", new Object[0]));
        this.btnExit.setName("btnExit");
        this.btnExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ErrorDialog.this.btnExitActionPerformed(evt);
            }
        });
        this.scrollLog.setName("scrollLog");
        this.txtErrorArea.setColumns(20);
        this.txtErrorArea.setRows(5);
        this.txtErrorArea.setName("txtErrorArea");
        this.scrollLog.setViewportView(this.txtErrorArea);
        this.btnClear.setIcon(resourceMap.getIcon("btnClear.icon"));
        this.btnClear.setText(resourceMap.getString("btnClear.text", new Object[0]));
        this.btnClear.setName("btnClear");
        this.btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ErrorDialog.this.btnClearActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.btnClear).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 440, Short.MAX_VALUE).addComponent(this.btnExit)).addComponent(this.scrollLog, -1, 600, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.scrollLog, -1, 231, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnExit).addComponent(this.btnClear)).addContainerGap()));
        this.pack();
    }

    private void btnExitActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void btnClearActionPerformed(ActionEvent evt) {
        this.txtErrorArea.setText("");
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ErrorDialog dialog = new ErrorDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

