/*
 * Decompiled with CFR 0.152.
 */
package connection.gui;

import VisiProg.AppOptions;
import VisiProg.VisiProgApp;
import connection.IKernel;
import connection.IKernelEventListener;
import connection.KernelEvent;
import connection.ProgramUploader;
import connection.SerialKernel;
import connection.gui.ConfigureComDlg;
import connection.gui.InfoDialog;
import connection.gui.PnlUpload;
import connection.testProtocol.TestCmd;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingWorker;
import javax.swing.text.BadLocationException;
import nodes.BoardsTypesAndDescription;
import nodes.ComPort;
import nodes.Project;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.openide.util.Exceptions;

public class TerminalDialog
extends JFrame
implements IKernelEventListener {
    private IKernel kernel;
    JFileChooser chooser;
    private Project proj;
    public static int ALLMSG = 0;
    public static int OUTMSG = 1;
    public static int INMSG = 2;
    private boolean debugMode = true;
    private PnlUpload pnlUpload = new PnlUpload();
    InfoDialog dlg = new InfoDialog(null, false);
    private ConfigureComDlg dlgComConfig;
    private ArrayList<String> messageList = new ArrayList();
    public static boolean disconnectOnFinish = false;
    boolean waitingForAnswer = false;
    boolean collectStatus = false;
    Locale currentLocale;
    ResourceBundle message;
    AppOptions options = new AppOptions();
    InfoDialog idlg;
    BoardsTypesAndDescription.BoardType boardType;
    private static int MAX_NUM_ROWS = 1024;
    public JButton btnBrowseFile;
    public JButton btnChangeBoardAddress;
    public JButton btnClearLog;
    public JButton btnExit;
    public JButton btnReadDateTime;
    public JButton btnSend;
    public JButton btnSendDateTime;
    public JButton btnSetMOB;
    public JButton btnSetupPorts;
    public JButton btnStopDataAcquiring;
    public JButton btnUnsetMOB;
    public JButton btnUploadFile;
    public JCheckBox checkShowIN;
    public JCheckBox checkShowOUT;
    public JCheckBox chkmPID3;
    public JComboBox comboSendCommand;
    public JLabel jLabel1;
    public JLabel jLabel2;
    public JLabel jLabel3;
    public JLabel jLabel4;
    public JLabel jLabel5;
    public JLabel jLabel8;
    public JPanel jPanel1;
    public JPanel jPanel2;
    public JPanel jPanel3;
    public JPanel jPanel4;
    public JPanel jPanel5;
    public JScrollPane jScrollPane1;
    public JScrollPane jScrollPane3;
    public JTextArea jTextArea1;
    public JScrollPane pnlScrollLog;
    public JPanel pnlTerminal;
    public JSpinner spnrBoardAddress;
    public JTextField txtDate;
    public JTextField txtFileName;
    public JTextArea txtLog;
    public JTextField txtSendCommand;
    public JTextArea txtSysinfo;
    public JTextField txtTime;

    public TerminalDialog(Frame parent, boolean modal, Project project, IKernel ker) {
        this.initComponents();
        this.checkShowIN.setSelected(true);
        this.checkShowOUT.setSelected(true);
        this.proj = project;
        this.center();
        this.options.LoadOptions();
        this.currentLocale = new Locale(this.options.language, this.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        this.jLabel3.setText(this.message.getString("date"));
        this.jLabel4.setText(this.message.getString("time"));
        this.btnSendDateTime.setText(this.message.getString("btnsend"));
        this.btnReadDateTime.setText(this.message.getString("btnread"));
        this.jLabel5.setText(this.message.getString("file"));
        this.btnUploadFile.setText(this.message.getString("upload2"));
        this.checkShowIN.setText(this.message.getString("Mostraingressi"));
        this.checkShowOUT.setText(this.message.getString("Mostrauscite"));
        this.jLabel8.setText(this.message.getString("boardaddress"));
        this.btnChangeBoardAddress.setText(this.message.getString("cambia"));
        this.btnSetupPorts.setText(this.message.getString("impporta"));
        this.jLabel1.setText(this.message.getString("inviai"));
        this.btnSend.setText(this.message.getString("invia"));
        this.boardType = this.proj.getBoardType();
        if (this.boardType.equals((Object)BoardsTypesAndDescription.BoardType.mPID1CO) || this.boardType.equals((Object)BoardsTypesAndDescription.BoardType.mPID1HC)) {
            this.jLabel3.setVisible(false);
            this.jLabel4.setVisible(false);
            this.txtDate.setVisible(false);
            this.txtTime.setVisible(false);
            this.btnSendDateTime.setVisible(false);
            this.btnReadDateTime.setVisible(false);
        }
        this.kernel = ker;
        this.dlgComConfig = new ConfigureComDlg(null, true, (SerialKernel)this.kernel, project);
        this.dlgComConfig.setupPorts(this.boardType);
    }

    private void center() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle frame = this.getBounds();
        this.setLocation((screen.width - frame.width) / 2, (screen.height - frame.height) / 2);
    }

    public void display() {
        this.spnrBoardAddress.setValue(Integer.parseInt(this.proj.getBoardAddress()));
        if (this.kernel instanceof SerialKernel) {
            // empty if block
        }
        this.invalidate();
        this.setVisible(true);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.txtSysinfo = new JTextArea();
        this.jLabel3 = new JLabel();
        this.txtDate = new JTextField();
        this.jLabel4 = new JLabel();
        this.txtTime = new JTextField();
        this.btnSendDateTime = new JButton();
        this.btnReadDateTime = new JButton();
        this.pnlTerminal = new JPanel();
        this.pnlScrollLog = new JScrollPane();
        this.txtLog = new JTextArea();
        this.jLabel1 = new JLabel();
        this.btnSend = new JButton();
        this.comboSendCommand = new JComboBox();
        this.txtSendCommand = new JTextField();
        this.btnExit = new JButton();
        this.jPanel3 = new JPanel();
        this.jLabel5 = new JLabel();
        this.txtFileName = new JTextField();
        this.btnBrowseFile = new JButton();
        this.btnUploadFile = new JButton();
        this.jPanel4 = new JPanel();
        this.btnStopDataAcquiring = new JButton();
        this.btnSetMOB = new JButton();
        this.btnUnsetMOB = new JButton();
        this.chkmPID3 = new JCheckBox();
        this.jPanel5 = new JPanel();
        this.checkShowIN = new JCheckBox();
        this.checkShowOUT = new JCheckBox();
        this.btnClearLog = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel8 = new JLabel();
        this.spnrBoardAddress = new JSpinner();
        this.btnChangeBoardAddress = new JButton();
        this.btnSetupPorts = new JButton();
        this.jScrollPane1.setName("jScrollPane1");
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setName("jTextArea1");
        this.jScrollPane1.setViewportView(this.jTextArea1);
        ResourceMap resourceMap = Application.getInstance(VisiProgApp.class).getContext().getResourceMap(TerminalDialog.class);
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.setDefaultCloseOperation(2);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent evt) {
                TerminalDialog.this.formWindowOpened(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel1.border.title", new Object[0])));
        this.jPanel1.setName("jPanel1");
        this.jScrollPane3.setEnabled(false);
        this.jScrollPane3.setName("jScrollPane3");
        this.txtSysinfo.setColumns(20);
        this.txtSysinfo.setRows(5);
        this.txtSysinfo.setName("txtSysinfo");
        this.jScrollPane3.setViewportView(this.txtSysinfo);
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.txtDate.setColumns(8);
        this.txtDate.setText(resourceMap.getString("txtDate.text", new Object[0]));
        this.txtDate.setName("txtDate");
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        this.txtTime.setColumns(8);
        this.txtTime.setText(resourceMap.getString("txtTime.text", new Object[0]));
        this.txtTime.setName("txtTime");
        this.btnSendDateTime.setText(resourceMap.getString("btnSendDateTime.text", new Object[0]));
        this.btnSendDateTime.setName("btnSendDateTime");
        this.btnSendDateTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TerminalDialog.this.btnSendDateTimeActionPerformed(evt);
            }
        });
        this.btnReadDateTime.setText(resourceMap.getString("btnReadDateTime.text", new Object[0]));
        this.btnReadDateTime.setName("btnReadDateTime");
        this.btnReadDateTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TerminalDialog.this.btnReadDateTimeActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, -1, 553, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtDate, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtTime, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 208, Short.MAX_VALUE).addComponent(this.btnSendDateTime).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnReadDateTime))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jScrollPane3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.txtDate, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.txtTime, -2, -1, -2).addComponent(this.btnReadDateTime).addComponent(this.btnSendDateTime)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pnlTerminal.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("pnlTerminal.border.title", new Object[0])));
        this.pnlTerminal.setName("pnlTerminal");
        this.pnlScrollLog.setName("pnlScrollLog");
        this.txtLog.setColumns(20);
        this.txtLog.setRows(5);
        this.pnlScrollLog.setViewportView(this.txtLog);
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.btnSend.setText(resourceMap.getString("btnSend.text", new Object[0]));
        this.btnSend.setName("btnSend");
        this.btnSend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TerminalDialog.this.btnSendActionPerformed(evt);
            }
        });
        this.comboSendCommand.setName("comboSendCommand");
        this.comboSendCommand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TerminalDialog.this.comboSendCommandActionPerformed(evt);
            }
        });
        this.txtSendCommand.setText(resourceMap.getString("txtSendCommand.text", new Object[0]));
        this.txtSendCommand.setName("txtSendCommand");
        this.txtSendCommand.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                TerminalDialog.this.txtSendCommandKeyTyped(evt);
            }
        });
        GroupLayout pnlTerminalLayout = new GroupLayout(this.pnlTerminal);
        this.pnlTerminal.setLayout(pnlTerminalLayout);
        pnlTerminalLayout.setHorizontalGroup(pnlTerminalLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlScrollLog, -1, 1009, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, pnlTerminalLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlTerminalLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.comboSendCommand, GroupLayout.Alignment.LEADING, 0, 891, Short.MAX_VALUE).addComponent(this.txtSendCommand, GroupLayout.Alignment.LEADING, -1, 891, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSend).addContainerGap()));
        pnlTerminalLayout.setVerticalGroup(pnlTerminalLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlTerminalLayout.createSequentialGroup().addComponent(this.pnlScrollLog, -1, 305, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.comboSendCommand, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlTerminalLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.txtSendCommand, -2, -1, -2).addComponent(this.btnSend)).addContainerGap()));
        this.btnExit.setIcon(resourceMap.getIcon("btnExit.icon"));
        this.btnExit.setText(resourceMap.getString("btnExit.text", new Object[0]));
        this.btnExit.setName("btnExit");
        this.btnExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TerminalDialog.this.btnExitActionPerformed(evt);
            }
        });
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel3.border.title", new Object[0])));
        this.jPanel3.setName("jPanel3");
        this.jLabel5.setText(resourceMap.getString("jLabel5.text", new Object[0]));
        this.jLabel5.setName("jLabel5");
        this.txtFileName.setColumns(25);
        this.txtFileName.setText(resourceMap.getString("txtFileName.text", new Object[0]));
        this.txtFileName.setName("txtFileName");
        this.btnBrowseFile.setIcon(resourceMap.getIcon("btnBrowseFile.icon"));
        this.btnBrowseFile.setText(resourceMap.getString("btnBrowseFile.text", new Object[0]));
        this.btnBrowseFile.setName("btnBrowseFile");
        this.btnBrowseFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TerminalDialog.this.btnBrowseFileActionPerformed(evt);
            }
        });
        this.btnUploadFile.setIcon(resourceMap.getIcon("btnUploadFile.icon"));
        this.btnUploadFile.setText(resourceMap.getString("btnUploadFile.text", new Object[0]));
        this.btnUploadFile.setName("btnUploadFile");
        this.btnUploadFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TerminalDialog.this.btnUploadFileActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtFileName, -1, 394, Short.MAX_VALUE).addComponent(this.jLabel5).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addComponent(this.btnUploadFile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 222, Short.MAX_VALUE).addComponent(this.btnBrowseFile))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtFileName, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnBrowseFile).addComponent(this.btnUploadFile)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel4.border.title", new Object[0])));
        this.jPanel4.setName("jPanel4");
        this.btnStopDataAcquiring.setText(resourceMap.getString("btnStopDataAcquiring.text", new Object[0]));
        this.btnStopDataAcquiring.setName("btnStopDataAcquiring");
        this.btnStopDataAcquiring.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TerminalDialog.this.btnStopDataAcquiringActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.btnStopDataAcquiring);
        this.btnSetMOB.setText(resourceMap.getString("btnSetMOB.text", new Object[0]));
        this.btnSetMOB.setName("btnSetMOB");
        this.btnSetMOB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TerminalDialog.this.btnSetMOBActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.btnSetMOB);
        this.btnUnsetMOB.setText(resourceMap.getString("btnUnsetMOB.text", new Object[0]));
        this.btnUnsetMOB.setName("btnUnsetMOB");
        this.btnUnsetMOB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TerminalDialog.this.btnUnsetMOBActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.btnUnsetMOB);
        this.chkmPID3.setText(resourceMap.getString("chkmPID3.text", new Object[0]));
        this.chkmPID3.setName("chkmPID3");
        this.jPanel4.add(this.chkmPID3);
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(""));
        this.jPanel5.setName("jPanel5");
        this.checkShowIN.setText(resourceMap.getString("checkShowIN.text", new Object[0]));
        this.checkShowIN.setName("checkShowIN");
        this.checkShowOUT.setText(resourceMap.getString("checkShowOUT.text", new Object[0]));
        this.checkShowOUT.setName("checkShowOUT");
        this.btnClearLog.setIcon(resourceMap.getIcon("btnClearLog.icon"));
        this.btnClearLog.setText(resourceMap.getString("btnClearLog.text", new Object[0]));
        this.btnClearLog.setName("btnClearLog");
        this.btnClearLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TerminalDialog.this.btnClearLogActionPerformed(evt);
            }
        });
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.checkShowIN).addGap(18, 18, 18).addComponent(this.checkShowOUT)).addComponent(this.btnClearLog)).addContainerGap(71, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkShowIN).addComponent(this.checkShowOUT)).addGap(18, 18, 18).addComponent(this.btnClearLog).addContainerGap(12, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel2.border.title", new Object[0])));
        this.jPanel2.setName("jPanel2");
        this.jLabel8.setText(resourceMap.getString("jLabel8.text", new Object[0]));
        this.jLabel8.setName("jLabel8");
        this.spnrBoardAddress.setModel(new SpinnerNumberModel(1, 1, 254, 1));
        this.spnrBoardAddress.setName("spnrBoardAddress");
        this.btnChangeBoardAddress.setText(resourceMap.getString("btnChangeBoardAddress.text", new Object[0]));
        this.btnChangeBoardAddress.setName("btnChangeBoardAddress");
        this.btnChangeBoardAddress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TerminalDialog.this.btnChangeBoardAddressActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spnrBoardAddress, -2, 72, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnChangeBoardAddress).addContainerGap(91, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.spnrBoardAddress, -2, -1, -2).addComponent(this.btnChangeBoardAddress)).addContainerGap(44, Short.MAX_VALUE)));
        this.btnSetupPorts.setIcon(resourceMap.getIcon("btnSetupPorts.icon"));
        this.btnSetupPorts.setText(resourceMap.getString("btnSetupPorts.text", new Object[0]));
        this.btnSetupPorts.setName("btnSetupPorts");
        this.btnSetupPorts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TerminalDialog.this.btnSetupPortsActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlTerminal, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel4, GroupLayout.Alignment.LEADING, -1, 426, Short.MAX_VALUE).addComponent(this.jPanel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.jPanel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addGap(18, 18, 18).addComponent(this.btnSetupPorts)).addComponent(this.btnExit, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, 0, -1, Short.MAX_VALUE)).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -2, -1, -2)).addGap(1, 1, 1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.btnSetupPorts))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlTerminal, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnExit).addContainerGap()));
        this.pack();
    }

    private void btnExitActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void formWindowOpened(WindowEvent evt) {
    }

    private void btnSendActionPerformed(ActionEvent evt) {
        String msg = this.txtSendCommand.getText();
        if (msg.length() > 0) {
            this.messageList = null;
            this.messageList = new ArrayList();
            this.messageList.clear();
            String comm = "<";
            comm = comm + msg;
            comm = comm + " >";
            disconnectOnFinish = false;
            this.getPnlUpload().clearProgressBar();
            this.comboSendCommand.addItem(msg);
            this.collectStatus = this.kernel.getCollectStatus();
            this.messageList.add(comm);
            this.sendMessageList();
        }
    }

    private void btnBrowseFileActionPerformed(ActionEvent evt) {
        this.chooser = new JFileChooser();
        this.chooser.setDialogTitle(this.message.getString("scegli"));
        this.chooser.setFileSelectionMode(0);
        this.chooser.setAcceptAllFileFilterUsed(true);
        if (this.chooser.showOpenDialog(this) == 0) {
            this.txtFileName.setText(this.chooser.getSelectedFile().toString());
            this.validate();
        }
    }

    private void btnUploadFileActionPerformed(ActionEvent evt) {
        File confFile = new File(this.txtFileName.getText());
        if (confFile.exists()) {
            ProgramUploader pu = new ProgramUploader(this.txtFileName.getText(), this.kernel);
            pu.start();
        }
    }

    private void btnStopDataAcquiringActionPerformed(ActionEvent evt) {
        if (this.btnStopDataAcquiring.getText().equals("Stop")) {
            this.kernel.collectPlantData(false);
        } else {
            this.kernel.collectPlantData(true);
        }
    }

    private void btnClearLogActionPerformed(ActionEvent evt) {
        this.txtLog.setText("");
    }

    private void btnReadDateTimeActionPerformed(ActionEvent evt) {
        this.messageList = null;
        this.messageList = new ArrayList();
        this.messageList.clear();
        this.messageList.add("<BL get 0>");
        this.messageList.add("<BL ? >");
        this.messageList.add("<RT ? >");
        disconnectOnFinish = false;
        this.getPnlUpload().clearProgressBar();
        this.collectStatus = this.kernel.getCollectStatus();
        this.txtSysinfo.setText("");
        this.sendMessageList();
    }

    private void comboSendCommandActionPerformed(ActionEvent evt) {
        this.txtSendCommand.setText(this.comboSendCommand.getSelectedItem().toString());
    }

    private void txtSendCommandKeyTyped(KeyEvent evt) {
        if (evt.getKeyChar() == '\n') {
            this.btnSendActionPerformed(null);
        }
    }

    private void btnSendDateTimeActionPerformed(ActionEvent evt) {
        String msg = "<RT ";
        String[] tokens = this.txtDate.getText().split("/");
        try {
            int i;
            for (i = 0; i < 3; ++i) {
                msg = msg + tokens[i] + " ";
            }
            tokens = this.txtTime.getText().split(":");
            for (i = 0; i < 2; ++i) {
                msg = msg + tokens[i] + " ";
            }
            msg = msg + ">";
            this.kernel.sendCommand(msg);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, this.message.getString("errdata"));
        }
    }

    private void btnChangeBoardAddressActionPerformed(ActionEvent evt) {
        String msg = "<PT addr " + this.spnrBoardAddress.getValue().toString() + " >";
        this.kernel.sendCommand(msg);
        this.proj.setBoardAddress(this.spnrBoardAddress.getValue().toString());
    }

    private void setComParameters() {
        ComPort[] comList = this.proj.getPortList();
        this.dlgComConfig.setComboIdx(comList[0].serSpeed, this.dlgComConfig.comboCOM1Speed);
        this.dlgComConfig.setComboIdx(comList[0].serNumbits, this.dlgComConfig.comboCOM1NumBits);
        this.dlgComConfig.setComboIdx(comList[0].serStopBits, this.dlgComConfig.comboCOM1StopBits);
        this.dlgComConfig.setComboIdx(comList[1].serSpeed, this.dlgComConfig.comboCOM2Speed);
        this.dlgComConfig.setComboIdx(comList[1].serNumbits, this.dlgComConfig.comboCOM2NumBits);
        this.dlgComConfig.setComboIdx(comList[1].serStopBits, this.dlgComConfig.comboCOM2StopBits);
        this.dlgComConfig.setComboIdx(comList[1].typeOfProtocol, this.dlgComConfig.comboCOM2Protocol);
        this.dlgComConfig.txtEtherIPAddress.setText(comList[2].ipAddress);
        this.dlgComConfig.txtEtherSubnetMask.setText(comList[2].ipSubnet);
        if (comList[2].ipGateway == null || comList[2].ipGateway.length() == 0) {
            this.dlgComConfig.txtEtherGateway.setText("127.0.0.1");
        } else {
            this.dlgComConfig.txtEtherGateway.setText(comList[2].ipGateway);
        }
        this.dlgComConfig.txtEtherMacAddr.setText(comList[2].ipMac);
    }

    public void saveComParameters() {
        ComPort[] comList = this.proj.getPortList();
        comList[0].serSpeed = this.dlgComConfig.comboCOM1Speed.getSelectedItem().toString();
        comList[0].serNumbits = this.dlgComConfig.comboCOM1NumBits.getSelectedItem().toString();
        comList[0].serStopBits = this.dlgComConfig.comboCOM1StopBits.getSelectedItem().toString();
        comList[1].serSpeed = this.dlgComConfig.comboCOM2Speed.getSelectedItem().toString();
        comList[1].serNumbits = this.dlgComConfig.comboCOM2NumBits.getSelectedItem().toString();
        comList[1].serStopBits = this.dlgComConfig.comboCOM2StopBits.getSelectedItem().toString();
        comList[1].typeOfProtocol = this.dlgComConfig.comboCOM2Protocol.getSelectedItem().toString();
        comList[2].ipAddress = this.dlgComConfig.txtEtherIPAddress.getText();
        comList[2].ipSubnet = this.dlgComConfig.txtEtherSubnetMask.getText();
        comList[2].ipGateway = this.dlgComConfig.txtEtherGateway.getText();
        comList[2].ipMac = this.dlgComConfig.txtEtherMacAddr.getText();
    }

    private void btnSetupPortsActionPerformed(ActionEvent evt) {
        String portRequest;
        this.setComParameters();
        System.out.println((Object)this.boardType);
        int ports = 0;
        this.kernel.collectPlantData(false);
        this.setComParameters();
        this.messageList = null;
        this.messageList = new ArrayList();
        this.messageList.clear();
        ports = BoardsTypesAndDescription.boardNOfSerialPorts[this.boardType.ordinal()];
        for (int i = 0; i < ports; ++i) {
            if (i == 2) {
                i = 4;
            }
            portRequest = "<PT get " + (i + 1) + " >";
            this.messageList.add(portRequest);
        }
        if (BoardsTypesAndDescription.boardNOfEthPorts[this.boardType.ordinal()] != 0) {
            portRequest = "<WB get >";
            this.messageList.add(portRequest);
        }
        this.sendMessageList();
        this.dlgComConfig.showDialog();
        if (this.dlgComConfig.getReturnStatus() == ConfigureComDlg.RET_OK && this.dlgComConfig.hasChanged()) {
            this.saveComParameters();
        }
        this.kernel.collectPlantData(true);
    }

    private void btnSetMOBActionPerformed(ActionEvent evt) {
        int res = JOptionPane.showConfirmDialog(null, "Attenzione!!\r\n Impostare la scheda come espansione ?", "Avviso", 0);
        if (res == 1) {
            return;
        }
        this.messageList.clear();
        if (this.chkmPID3.isSelected()) {
            String msg = "<EW 36 170 >";
            this.messageList.add(msg);
            msg = "<EW 37 102 >";
            this.messageList.add(msg);
        } else {
            String msg = "<EW 0 170 >";
            this.messageList.add(msg);
            msg = "<EW 1 102 >";
            this.messageList.add(msg);
        }
        this.collectStatus = true;
        this.sendMessageList();
    }

    private void btnUnsetMOBActionPerformed(ActionEvent evt) {
        if (this.chkmPID3.isSelected()) {
            this.messageList.clear();
            String msg = "<EW 36 0 >";
            this.messageList.add(msg);
            msg = "<EW 37 0 >";
            this.messageList.add(msg);
        } else {
            this.messageList.clear();
            String msg = "<EW 0 0 >";
            this.messageList.add(msg);
            msg = "<EW 1 0 >";
            this.messageList.add(msg);
        }
        this.collectStatus = true;
        this.sendMessageList();
    }

    private void trimTxtAreaLength() {
        if (this.txtLog.getLineCount() > MAX_NUM_ROWS) {
            int end = 0;
            try {
                end = this.txtLog.getLineEndOffset(0);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.txtLog.replaceRange(null, 0, end);
        }
    }

    public void addMsg(String message, int direction) {
        if (direction == OUTMSG && this.checkShowOUT.isSelected() || direction == INMSG && this.checkShowIN.isSelected() || direction == ALLMSG) {
            JScrollBar vbar = this.pnlScrollLog.getVerticalScrollBar();
            boolean autoScroll = false;
            if (vbar.getValue() + vbar.getVisibleAmount() >= vbar.getMaximum() - 50) {
                autoScroll = true;
            }
            Date data = new Date();
            String msg = data.toString() + " ";
            msg = direction == OUTMSG ? msg + "OUT:" : msg + "IN:";
            this.trimTxtAreaLength();
            this.txtLog.append(msg + message + "\r\n");
            if (direction != OUTMSG) {
                this.trimTxtAreaLength();
                this.txtLog.append("\r\n");
            }
            if (autoScroll) {
                this.txtLog.setCaretPosition(this.txtLog.getDocument().getLength());
            }
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TerminalDialog dialog = new TerminalDialog(new JFrame(), true, null, null);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public void setKernel(IKernel kernel) {
        this.kernel = kernel;
        kernel.addKernelEventListener(this);
    }

    private synchronized void addToTextArea(String txt) {
        this.txtLog.append(txt);
    }

    @Override
    public void kernelEventOccurred(KernelEvent evt) {
        if (evt.getEventType().equals("Data Retriever Running")) {
            this.btnStopDataAcquiring.setText("Stop");
        } else if (evt.getEventType().equals("Data Retriever Stopped")) {
            this.btnStopDataAcquiring.setText("Run");
        } else if (evt.getEventType().equals("Command Executed") || evt.getEventType().equals("Valid Reply Received")) {
            if (!this.waitingForAnswer) {
                return;
            }
            this.waitingForAnswer = false;
            if (this.messageList.isEmpty()) {
                this.dlg.setVisible(false);
                this.kernel.collectPlantData(this.collectStatus);
                this.saveComParameters();
                if (disconnectOnFinish) {
                    JOptionPane.showMessageDialog(null, this.message.getString("disconn"), this.message.getString("info2"), 1);
                    try {
                        this.kernel.disconnect();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    disconnectOnFinish = false;
                }
                this.getPnlUpload().setProgress(100);
            } else {
                this.sendMessageList();
            }
        } else if (evt.getEventType().equals("Command Not Executed") || evt.getEventType().equals("Timeout on command")) {
            if (this.waitingForAnswer) {
                this.dlg.setVisible(false);
                this.messageList.clear();
                JOptionPane.showMessageDialog(null, this.message.getString("riprova"), this.message.getString("er"), 0);
                this.waitingForAnswer = false;
                this.kernel.collectPlantData(this.collectStatus);
            }
        } else if (evt.getEventType().equals("Upload Terminated")) {
            JOptionPane.showMessageDialog(null, this.message.getString("disconn"), this.message.getString("info2"), 1);
            try {
                this.kernel.disconnect();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.invalidate();
    }

    public void setDebugMode(boolean debugActive) {
        this.debugMode = debugActive;
        if (!debugActive) {
            int x = this.pnlTerminal.getLocation().x;
            int y = this.pnlTerminal.getLocation().y;
            int width = this.pnlTerminal.getWidth();
            int height = this.pnlTerminal.getHeight();
            this.getPnlUpload().setSize(width, height / 2);
            this.getPnlUpload().setLocation(x, y);
            this.jPanel5.setSize(241, 102);
            this.pnlTerminal.setVisible(false);
            this.add(this.getPnlUpload());
            this.remove(this.btnExit);
            this.setSize(1071, 600);
            this.btnExit.setLocation(870, 525);
            this.add(this.btnExit);
        }
        this.invalidate();
    }

    public void setSuperUserMode(boolean superUserActive) {
        this.btnSetMOB.setVisible(superUserActive);
        this.btnUnsetMOB.setVisible(superUserActive);
        this.chkmPID3.setVisible(superUserActive);
    }

    public boolean sendMessageList() {
        if (this.messageList.size() == 0) {
            this.getPnlUpload().setProgress(100);
            this.waitingForAnswer = false;
            this.kernel.collectPlantData(this.collectStatus);
            return false;
        }
        this.kernel.collectPlantData(false);
        this.getPnlUpload().setProgress(100 - 30 * this.messageList.size());
        String msg = this.messageList.get(0).toString();
        this.messageList.remove(0);
        if (this.kernel.sendCommand(msg)) {
            this.waitingForAnswer = true;
        } else {
            System.out.println(this.message.getString("imp") + msg);
        }
        return true;
    }

    public PnlUpload getPnlUpload() {
        return this.pnlUpload;
    }

    public void execCommand(TestCmd cmd) {
        if (cmd.getValue("MESSAGE_TYPE").equals("PT")) {
            String protocol = cmd.getValue("TOKEN2");
            if (protocol.equals("1")) {
                int comboVal = Integer.parseInt(cmd.getValue("TOKEN3")) - 1;
                this.dlgComConfig.comboCOM1Speed.setSelectedIndex(comboVal);
                try {
                    comboVal = Integer.parseInt(cmd.getValue("TOKEN4")) - 1;
                    if (comboVal < 2) {
                        this.dlgComConfig.comboCOM1Protocol.setSelectedIndex(comboVal);
                    } else {
                        this.dlgComConfig.comboCOM1Protocol.setSelectedIndex(2);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    comboVal = Integer.parseInt(cmd.getValue("TOKEN5"));
                    this.dlgComConfig.comboCOM1NumBits.setSelectedIndex(comboVal);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    comboVal = Integer.parseInt(cmd.getValue("TOKEN6"));
                    this.dlgComConfig.comboCOM1Parity.setSelectedIndex(comboVal);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    comboVal = Integer.parseInt(cmd.getValue("TOKEN7"));
                    this.dlgComConfig.comboCOM1StopBits.setSelectedIndex(comboVal);
                }
                catch (Exception e) {}
            } else if (protocol.equals("2")) {
                int comboVal = Integer.parseInt(cmd.getValue("TOKEN3")) - 1;
                this.dlgComConfig.comboCOM2Speed.setSelectedIndex(comboVal);
                try {
                    comboVal = Integer.parseInt(cmd.getValue("TOKEN4")) - 1;
                    if (comboVal < 2) {
                        this.dlgComConfig.comboCOM2Protocol.setSelectedIndex(comboVal);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    comboVal = Integer.parseInt(cmd.getValue("TOKEN5"));
                    this.dlgComConfig.comboCOM2NumBits.setSelectedIndex(comboVal);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    comboVal = Integer.parseInt(cmd.getValue("TOKEN6"));
                    this.dlgComConfig.comboCOM2Parity.setSelectedIndex(comboVal);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    comboVal = Integer.parseInt(cmd.getValue("TOKEN7"));
                    this.dlgComConfig.comboCOM2StopBits.setSelectedIndex(comboVal);
                }
                catch (Exception e) {}
            } else if (protocol.equals("5")) {
                int comboVal = Integer.parseInt(cmd.getValue("TOKEN3")) - 1;
                this.dlgComConfig.comboCOM3Speed.setSelectedIndex(comboVal);
                try {
                    comboVal = Integer.parseInt(cmd.getValue("TOKEN4")) - 1;
                    if (comboVal < 2) {
                        this.dlgComConfig.comboCOM3Protocol.setSelectedIndex(comboVal);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    comboVal = Integer.parseInt(cmd.getValue("TOKEN5"));
                    this.dlgComConfig.comboCOM3NumBits.setSelectedIndex(comboVal);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    comboVal = Integer.parseInt(cmd.getValue("TOKEN6"));
                    this.dlgComConfig.comboCOM3Parity.setSelectedIndex(comboVal);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    comboVal = Integer.parseInt(cmd.getValue("TOKEN7"));
                    this.dlgComConfig.comboCOM3StopBits.setSelectedIndex(comboVal);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.saveComParameters();
            this.dlgComConfig.fieldChanged = false;
        } else if (cmd.getValue("MESSAGE_TYPE").equals("WB")) {
            String val = cmd.getValue("TOKEN2");
            this.dlgComConfig.txtEtherIPAddress.setText(val);
            val = cmd.getValue("TOKEN3");
            this.dlgComConfig.txtEtherSubnetMask.setText(val);
            val = cmd.getValue("TOKEN4");
            this.dlgComConfig.txtEtherGateway.setText(val);
            val = cmd.getValue("TOKEN5");
            this.dlgComConfig.txtEtherMacAddr.setText(val);
            this.dlgComConfig.fieldChanged = false;
            this.saveComParameters();
        }
        this.dlgComConfig.validate();
    }

    public IKernel getKernel() {
        return this.kernel;
    }

    class GenericWait
    extends SwingWorker<Void, Void> {
        int waitAmountMS = 0;

        public GenericWait(int amountSec) {
            this.waitAmountMS = amountSec * 1000;
        }

        @Override
        public Void doInBackground() {
            try {
                Thread.sleep(this.waitAmountMS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public void done() {
            TerminalDialog.this.idlg.setVisible(false);
        }
    }
}

