/*
 * Decompiled with CFR 0.152.
 */
package nodes;

import java.awt.Font;
import nodes.CommonDefinitions;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;
import sceneManager.AFOPinWidget;

public class AFONodeWidget
extends Widget {
    protected Widget overallWidget;
    protected Widget moduleWidget;
    protected Widget moduleINPinNames;
    protected Widget moduleOUTPinNames;
    protected Widget inputs;
    protected Widget outputs;
    protected LabelWidget moduleComment;
    private Widget moduleNameWidget;
    private LabelWidget moduleTypeWidget;
    private LabelWidget moduleSubTypeWidget;
    private AFOGraphPinScene scene;
    boolean isRotated;

    public AFONodeWidget(AFOGraphPinScene scene) {
        super((Scene)scene);
        this.scene = scene;
        this.isRotated = false;
        this.setLayout(LayoutFactory.createVerticalFlowLayout());
        this.setBorder(CommonDefinitions.BORDER_4);
        this.setOpaque(true);
        this.setCheckClipping(true);
        this.overallWidget = new Widget((Scene)scene);
        this.overallWidget.setLayout(LayoutFactory.createHorizontalFlowLayout());
        this.overallWidget.setBorder(CommonDefinitions.BORDER_EMPTY);
        this.overallWidget.setOpaque(true);
        this.overallWidget.setCheckClipping(true);
        this.addChild(this.overallWidget);
        this.moduleComment = new LabelWidget((Scene)scene, "comment");
        this.moduleComment.setAlignment(LabelWidget.Alignment.CENTER);
        this.moduleComment.setFont(new Font("SansSerif", 0, 10));
        this.moduleComment.setUseGlyphVector(true);
        this.moduleComment.setCheckClipping(true);
        this.addChild((Widget)this.moduleComment);
        this.inputs = new Widget((Scene)scene);
        this.inputs.setLayout(LayoutFactory.createVerticalFlowLayout());
        this.inputs.setOpaque(false);
        this.inputs.setBorder(CommonDefinitions.BORDER_4);
        this.inputs.setCheckClipping(true);
        this.overallWidget.addChild(this.inputs);
        this.moduleWidget = new Widget((Scene)scene);
        this.moduleWidget.setLayout(LayoutFactory.createHorizontalFlowLayout());
        this.moduleWidget.setBorder(CommonDefinitions.BORDER_LINE);
        this.moduleWidget.setCheckClipping(true);
        this.overallWidget.addChild(this.moduleWidget);
        this.moduleINPinNames = new Widget((Scene)scene);
        this.moduleINPinNames.setLayout(LayoutFactory.createVerticalFlowLayout());
        this.moduleINPinNames.setBorder(CommonDefinitions.BORDER_4);
        this.moduleINPinNames.setCheckClipping(true);
        this.moduleWidget.addChild(this.moduleINPinNames);
        this.moduleNameWidget = new Widget((Scene)scene);
        this.moduleNameWidget.setLayout(LayoutFactory.createVerticalFlowLayout());
        this.moduleNameWidget.setBorder(CommonDefinitions.BORDER_4);
        this.moduleNameWidget.setCheckClipping(true);
        this.moduleWidget.addChild(this.moduleNameWidget);
        this.moduleTypeWidget = new LabelWidget((Scene)scene);
        this.moduleTypeWidget.setFont(scene.getDefaultFont().deriveFont(1));
        this.moduleTypeWidget.setFont(this.moduleTypeWidget.getFont().deriveFont(10.0f));
        this.moduleTypeWidget.setAlignment(LabelWidget.Alignment.CENTER);
        this.moduleTypeWidget.setVerticalAlignment(LabelWidget.VerticalAlignment.CENTER);
        this.moduleTypeWidget.setBorder(CommonDefinitions.BORDER_4);
        this.moduleTypeWidget.setUseGlyphVector(true);
        this.moduleTypeWidget.setCheckClipping(true);
        this.moduleNameWidget.addChild((Widget)this.moduleTypeWidget);
        this.moduleSubTypeWidget = new LabelWidget((Scene)scene);
        this.moduleSubTypeWidget.setFont(scene.getDefaultFont().deriveFont(0));
        this.moduleSubTypeWidget.setFont(this.moduleTypeWidget.getFont().deriveFont(8.0f));
        this.moduleSubTypeWidget.setAlignment(LabelWidget.Alignment.CENTER);
        this.moduleSubTypeWidget.setVerticalAlignment(LabelWidget.VerticalAlignment.CENTER);
        this.moduleSubTypeWidget.setBorder(CommonDefinitions.BORDER_4);
        this.moduleSubTypeWidget.setUseGlyphVector(true);
        this.moduleSubTypeWidget.setCheckClipping(true);
        this.moduleNameWidget.addChild((Widget)this.moduleSubTypeWidget);
        this.moduleOUTPinNames = new Widget((Scene)scene);
        this.moduleOUTPinNames.setLayout(LayoutFactory.createVerticalFlowLayout());
        this.moduleOUTPinNames.setBorder(CommonDefinitions.BORDER_4);
        this.moduleOUTPinNames.setCheckClipping(true);
        this.moduleWidget.addChild(this.moduleOUTPinNames);
        this.outputs = new Widget((Scene)scene);
        this.outputs.setLayout(LayoutFactory.createVerticalFlowLayout());
        this.outputs.setOpaque(false);
        this.outputs.setBorder(CommonDefinitions.BORDER_4);
        this.outputs.setCheckClipping(true);
        this.overallWidget.addChild(this.outputs);
        this.getActions().addAction(scene.createWidgetHoverAction());
        this.getActions().addAction(scene.createSelectAction());
        scene.validate();
    }

    public void setName(String name) {
        this.moduleTypeWidget.setLabel(name);
        this.scene.validate();
    }

    public String getName() {
        return this.moduleTypeWidget.getLabel();
    }

    public void setSubType(String subType) {
        this.moduleSubTypeWidget.setLabel(subType);
        this.scene.validate();
    }

    public String getSubType() {
        return this.moduleSubTypeWidget.getLabel();
    }

    public LabelWidget getModuleComment() {
        return this.moduleComment;
    }

    public void clearPins() {
        this.clearInputPins();
        this.clearOutputPins();
    }

    public void clearInputPins() {
        this.inputs.removeChildren();
        this.scene.validate();
    }

    public void clearOutputPins() {
        this.outputs.removeChildren();
        this.scene.validate();
    }

    public AFOPinWidget addPin(AFOPin pin) {
        LabelWidget pinNameWidget;
        AFOPinWidget member = new AFOPinWidget((Scene)this.scene);
        if (pin.getPinType() == AFOPin.E_PinType.PIN_INPUT) {
            member.setLabel("  >");
            member.setInputState(true);
            this.inputs.addChild((Widget)member);
            pinNameWidget = new LabelWidget((Scene)this.scene, pin.getLabel());
            this.moduleINPinNames.addChild((Widget)pinNameWidget);
        } else if (pin.getPinType() == AFOPin.E_PinType.PIN_COMMAND) {
            member.setLabel("  *");
            member.setInputState(true);
            this.inputs.addChild((Widget)member);
            pinNameWidget = new LabelWidget((Scene)this.scene, pin.getLabel());
            this.moduleINPinNames.addChild((Widget)pinNameWidget);
        } else {
            member.setLabel(">  ");
            this.outputs.addChild((Widget)member);
            pinNameWidget = new LabelWidget((Scene)this.scene, pin.getLabel());
            this.moduleOUTPinNames.addChild((Widget)pinNameWidget);
        }
        pin.setWidget((Widget)member);
        pin.setPinNameWidget(pinNameWidget);
        this.revalidate();
        this.scene.validate();
        return member;
    }

    public void removeInputPin(AFOPin pin) {
        this.inputs.removeChild(pin.getWidget());
        this.moduleINPinNames.removeChild((Widget)pin.getPinNameWidget());
        this.scene.validate();
    }

    public void removeOuptutPin(AFOPin pin) {
        this.outputs.removeChild(pin.getWidget());
        this.moduleOUTPinNames.removeChild((Widget)pin.getPinNameWidget());
        this.scene.validate();
    }

    public void removePin(AFOPin pin) {
        if (pin.getPinType().equals((Object)AFOPin.E_PinType.PIN_INPUT)) {
            this.removeInputPin(pin);
        } else {
            this.removeOuptutPin(pin);
        }
        this.scene.removePinWithEdges(pin);
        this.scene.validate();
    }

    public Widget getNameWidget() {
        return this.moduleNameWidget;
    }

    public void setModuleWidgetColor(Border newBorder) {
        this.moduleWidget.setBorder(newBorder);
    }

    protected void notifyStateChanged(ObjectState previousState, ObjectState state) {
        if (state.isSelected()) {
            this.moduleWidget.setBorder(CommonDefinitions.BORDER_FILL_DARKYELLOW);
            return;
        }
        if (state.isHovered()) {
            this.moduleWidget.setBorder(CommonDefinitions.BORDER_FILL_LIGHTYELLOW);
            return;
        }
        this.moduleWidget.setBorder(CommonDefinitions.BORDER_LINE);
    }

    public Widget GetRotatedInstance() {
        int i = 0;
        this.overallWidget.removeChildren();
        this.moduleWidget.removeChildren();
        this.overallWidget.addChild(this.outputs);
        this.moduleWidget.addChild(this.moduleOUTPinNames);
        this.moduleWidget.addChild(this.moduleNameWidget);
        this.moduleWidget.addChild(this.moduleINPinNames);
        this.overallWidget.addChild(this.moduleWidget);
        this.overallWidget.addChild(this.inputs);
        for (i = 0; i < this.inputs.getChildren().size(); ++i) {
            ((LabelWidget)this.inputs.getChildren().get(i)).setLabel("<");
        }
        for (i = 0; i < this.outputs.getChildren().size(); ++i) {
            ((LabelWidget)this.outputs.getChildren().get(i)).setLabel("<");
        }
        this.isRotated = true;
        return this;
    }

    public Widget GetDirectInstance() {
        int i;
        this.overallWidget.removeChildren();
        this.moduleWidget.removeChildren();
        this.overallWidget.addChild(this.inputs);
        this.overallWidget.addChild(this.moduleWidget);
        this.moduleWidget.addChild(this.moduleINPinNames);
        this.moduleWidget.addChild(this.moduleNameWidget);
        this.moduleWidget.addChild(this.moduleOUTPinNames);
        this.overallWidget.addChild(this.outputs);
        for (i = 0; i < this.inputs.getChildren().size(); ++i) {
            ((LabelWidget)this.inputs.getChildren().get(i)).setLabel(">");
        }
        for (i = 0; i < this.outputs.getChildren().size(); ++i) {
            ((LabelWidget)this.outputs.getChildren().get(i)).setLabel(">");
        }
        this.isRotated = false;
        return this;
    }

    public boolean IsRotated() {
        return this.isRotated;
    }

    public Widget GetModuleWidget() {
        return this.moduleWidget;
    }

    public Widget getInputs() {
        return this.inputs;
    }

    public Widget getModuleINPinNames() {
        return this.moduleINPinNames;
    }

    public Widget getModuleOUTPinNames() {
        return this.moduleOUTPinNames;
    }

    public Widget getOutputs() {
        return this.outputs;
    }
}

