/*
 * Decompiled with CFR 0.152.
 */
package nodes;

import VisiProg.AppOptions;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.undo.UndoManager;
import nodes.AFOSystemManager;
import nodes.BoardsTypesAndDescription;
import nodes.CommonDefinitions;
import nodes.MyGraphPinScene;
import nodes.PrintUIWindow;
import nodes.Project;
import nodes.devices.AddressNode;
import nodes.devices.CheckCommNode;
import nodes.devices.LoggerNode;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.widget.Widget;
import sceneManager.AFONode;

public class AFOScenePopup
implements PopupMenuProvider,
ActionListener {
    private Point point;
    private MyGraphPinScene scene;
    private Project prj;
    private JPopupMenu mainMenu;
    private JMenu addMenu;
    private AFOSystemManager systemManager;
    private JMenuItem menuItemProjectProperties;
    private JMenuItem menuItemAddSubSystem;
    private JMenuItem menuImportSubsystem;
    public JMenuItem menuPaste;
    private JMenuItem menuAddTimer;
    private JMenuItem menuModbusIN;
    private JMenuItem menuModbusOUT;
    private JMenuItem menuMobDSP;
    private JMenuItem menuIModbus;
    private JMenuItem menuLogger;
    private JMenuItem menuPrint;
    private JMenuItem menuAddress;
    private JMenuItem menuCheckComm;
    public JMenuItem menuUndo;
    public JMenuItem menuRedo;
    public JMenuItem menuModbusStation;
    private JMenu menuEdit;
    Locale currentLocale;
    ResourceBundle message;
    private AppOptions options = new AppOptions();
    private final BoardsTypesAndDescription.BoardType type;
    public static String st;
    private UndoManager undoManager = new UndoManager();

    public AFOScenePopup(Project prj, MyGraphPinScene scene, AFOSystemManager systemManager, BoardsTypesAndDescription.BoardType type) {
        this.type = type;
        this.mainMenu = new JPopupMenu();
        this.options.LoadOptions();
        this.currentLocale = new Locale(this.options.language, this.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        this.menuEdit = new JMenu("Edit...");
        if (systemManager.isSubSystem()) {
            this.menuPaste = new JMenuItem(this.message.getString("incollaoggetto"));
            this.menuPaste.setActionCommand(this.message.getString("incollaoggetto"));
            this.menuPaste.addActionListener(this);
            this.menuPaste.setEnabled(true);
            this.menuEdit.add(this.menuPaste);
            this.menuEdit.add(new JSeparator());
        }
        this.menuUndo = new JMenuItem(this.message.getString("undo"));
        this.menuUndo.setActionCommand(this.message.getString("undo"));
        this.menuUndo.addActionListener(this);
        this.menuUndo.setEnabled(false);
        this.menuEdit.add(this.menuUndo);
        this.menuRedo = new JMenuItem(this.message.getString("redo"));
        this.menuRedo.setActionCommand(this.message.getString("redo"));
        this.menuRedo.addActionListener(this);
        this.menuUndo.setEnabled(false);
        this.menuEdit.add(this.menuRedo);
        this.mainMenu.add(new JSeparator());
        this.menuPrint = new JMenuItem(this.message.getString("stampa"));
        this.menuPrint.setActionCommand(this.message.getString("stampa"));
        this.menuPrint.addActionListener(this);
        this.menuEdit.add(this.menuPrint);
        this.mainMenu.add(this.menuEdit);
        this.mainMenu.add(new JSeparator());
        if (!systemManager.isSubSystem()) {
            this.addMenu = new JMenu(this.message.getString("agg"));
            this.mainMenu.add(this.addMenu);
            this.menuMobDSP = new JMenuItem("MobDSP");
            this.menuMobDSP.setActionCommand(CommonDefinitions.blockTypes.Monitor.toString());
            this.menuMobDSP.addActionListener(this);
            this.addMenu.add(this.menuMobDSP);
            JMenu subMenu = new JMenu("Communication");
            this.menuModbusIN = new JMenuItem("Modbus IN");
            this.menuModbusIN.setActionCommand(CommonDefinitions.blockTypes.ModbusIN.toString());
            this.menuModbusIN.addActionListener(this);
            subMenu.add(this.menuModbusIN);
            this.menuModbusOUT = new JMenuItem("Modbus OUT");
            this.menuModbusOUT.setActionCommand(CommonDefinitions.blockTypes.ModbusOUT.toString());
            this.menuModbusOUT.addActionListener(this);
            subMenu.add(this.menuModbusOUT);
            this.menuIModbus = new JMenuItem("IModbus");
            this.menuIModbus.setActionCommand(CommonDefinitions.blockTypes.IModbus.toString());
            this.menuIModbus.addActionListener(this);
            subMenu.add(this.menuIModbus);
            this.menuModbusStation = new JMenuItem("ModbusStation");
            this.menuModbusStation.setActionCommand(CommonDefinitions.blockTypes.ModbusStation.toString());
            this.menuModbusStation.addActionListener(this);
            subMenu.add(this.menuModbusStation);
            this.menuCheckComm = new JMenuItem("CheckComm");
            this.menuCheckComm.setActionCommand(CommonDefinitions.blockTypes.CheckComm.toString());
            this.menuCheckComm.addActionListener(this);
            subMenu.add(this.menuCheckComm);
            this.addMenu.add(subMenu);
            this.menuAddress = new JMenuItem("Address");
            this.menuAddress.setActionCommand(CommonDefinitions.blockTypes.Address.toString());
            this.menuAddress.addActionListener(this);
            this.addMenu.add(this.menuAddress);
            String menuString = this.message.getString("bloc") + " " + CommonDefinitions.blockTypes.Subsystem.toString();
            this.menuItemAddSubSystem = new JMenuItem(menuString);
            this.menuItemAddSubSystem.setActionCommand(CommonDefinitions.blockTypes.Subsystem.toString());
            this.menuItemAddSubSystem.addActionListener(this);
            this.addMenu.add(this.menuItemAddSubSystem);
            if (type.equals((Object)BoardsTypesAndDescription.BoardType.mPID9ST) || type.equals((Object)BoardsTypesAndDescription.BoardType.mPID9MX) || type.equals((Object)BoardsTypesAndDescription.BoardType.mPID6ST) || type.equals((Object)BoardsTypesAndDescription.BoardType.mPID6MX) || type.equals((Object)BoardsTypesAndDescription.BoardType.mPID3STH) || type.equals((Object)BoardsTypesAndDescription.BoardType.mPID3ST)) {
                this.menuAddTimer = new JMenuItem();
                this.menuAddTimer = new JMenuItem(this.message.getString("aggtimer"));
                this.menuAddTimer.setActionCommand(this.message.getString("aggtimer"));
                this.menuAddTimer.addActionListener(this);
                this.addMenu.add(this.menuAddTimer);
            }
            menuString = this.message.getString("bloc") + " " + (Object)((Object)CommonDefinitions.blockTypes.Comment);
            JMenuItem item = new JMenuItem(menuString);
            item.setActionCommand(CommonDefinitions.blockTypes.Comment.toString());
            item.addActionListener(this);
            this.addMenu.add(item);
            this.mainMenu.add(new JSeparator());
            this.menuImportSubsystem = new JMenuItem(this.message.getString("impss"));
            this.menuImportSubsystem.setActionCommand(this.message.getString("impss"));
            this.menuImportSubsystem.addActionListener(this);
            this.mainMenu.add(this.menuImportSubsystem);
            this.menuItemProjectProperties = new JMenuItem(this.message.getString("propproj"));
            this.menuItemProjectProperties.setActionCommand(this.message.getString("propproj"));
            this.menuItemProjectProperties.addActionListener(this);
            this.mainMenu.add(this.menuItemProjectProperties);
        } else {
            this.addMenu = new JMenu(this.message.getString("agg"));
            this.mainMenu.add(this.addMenu);
            this.menuImportSubsystem = new JMenuItem(this.message.getString("impss"));
            this.menuImportSubsystem.setActionCommand(this.message.getString("impss"));
            this.menuImportSubsystem.addActionListener(this);
            this.mainMenu.add(this.menuImportSubsystem);
            for (CommonDefinitions.menuBlockTypes bt : CommonDefinitions.menuBlockTypes.values()) {
                JMenuItem item;
                JMenu subMenu;
                if (bt.ordinal() < CommonDefinitions.blockTypes.Subsystem.ordinal()) continue;
                if (bt == CommonDefinitions.menuBlockTypes.IF) {
                    subMenu = new JMenu(this.message.getString("aggif"));
                    this.addMenu.add(subMenu);
                    for (Enum enum_ : CommonDefinitions.ifTypes.values()) {
                        item = new JMenuItem(CommonDefinitions.ifStrings[enum_.ordinal()]);
                        item.setActionCommand(bt.toString() + "," + enum_.toString());
                        item.addActionListener(this);
                        subMenu.add(item);
                    }
                    continue;
                }
                if (bt == CommonDefinitions.menuBlockTypes.Arithmetic) {
                    subMenu = new JMenu(this.message.getString("aggar"));
                    this.addMenu.add(subMenu);
                    for (Enum enum_ : CommonDefinitions.arithmeticTypes.values()) {
                        item = new JMenuItem(CommonDefinitions.arithmeticStrings[enum_.ordinal()]);
                        item.setActionCommand(bt.toString() + "," + enum_.toString());
                        item.addActionListener(this);
                        subMenu.add(item);
                    }
                    continue;
                }
                if (bt == CommonDefinitions.menuBlockTypes.Trigger) {
                    subMenu = new JMenu(this.message.getString("agtr"));
                    this.addMenu.add(subMenu);
                    for (Enum enum_ : CommonDefinitions.triggerTypes.values()) {
                        item = new JMenuItem(enum_.toString());
                        item.setActionCommand(bt.toString() + "," + enum_.toString());
                        item.addActionListener(this);
                        subMenu.add(item);
                    }
                    continue;
                }
                if (bt == CommonDefinitions.menuBlockTypes.Logic) {
                    subMenu = new JMenu(this.message.getString("aglog"));
                    this.addMenu.add(subMenu);
                    for (Enum enum_ : CommonDefinitions.logicTypes.values()) {
                        item = new JMenuItem(enum_.toString());
                        item.setActionCommand(bt.toString() + "," + enum_.toString());
                        item.addActionListener(this);
                        subMenu.add(item);
                    }
                    continue;
                }
                if (bt == CommonDefinitions.menuBlockTypes.PID) {
                    subMenu = new JMenu(this.message.getString("agreg"));
                    this.addMenu.add(subMenu);
                    for (Enum enum_ : CommonDefinitions.fieldControlBlocks.values()) {
                        item = new JMenuItem(enum_.toString());
                        item.setActionCommand(enum_.toString());
                        item.addActionListener(this);
                        subMenu.add(item);
                    }
                    continue;
                }
                if (bt == CommonDefinitions.menuBlockTypes.Timed) {
                    subMenu = new JMenu(this.message.getString("agtime"));
                    this.addMenu.add(subMenu);
                    for (Enum enum_ : CommonDefinitions.timedBlocks.values()) {
                        if (type.ordinal() < BoardsTypesAndDescription.BoardType.mPID6MX.ordinal() && enum_.equals((Object)CommonDefinitions.timedBlocks.Clock)) continue;
                        item = new JMenuItem(enum_.toString());
                        item.setActionCommand(enum_.toString());
                        item.addActionListener(this);
                        subMenu.add(item);
                    }
                    continue;
                }
                if (bt == CommonDefinitions.menuBlockTypes.Communication) {
                    subMenu = new JMenu(this.message.getString("agcomm"));
                    this.addMenu.add(subMenu);
                    for (Enum enum_ : CommonDefinitions.communicationBlocks.values()) {
                        item = new JMenuItem(enum_.toString());
                        item.setActionCommand(enum_.toString());
                        item.addActionListener(this);
                        subMenu.add(item);
                    }
                    continue;
                }
                if (bt == CommonDefinitions.menuBlockTypes.Control) {
                    subMenu = new JMenu(this.message.getString("agctrl"));
                    this.addMenu.add(subMenu);
                    for (Enum enum_ : CommonDefinitions.programControlBlocks.values()) {
                        item = new JMenuItem(enum_.toString());
                        item.setActionCommand(enum_.toString());
                        item.addActionListener(this);
                        subMenu.add(item);
                    }
                    continue;
                }
                String menuString = this.message.getString("bloc") + " " + bt.toString();
                item = new JMenuItem(menuString);
                item.setActionCommand(bt.toString());
                item.addActionListener(this);
                this.addMenu.add(item);
                if (bt != CommonDefinitions.menuBlockTypes.OUT) continue;
                this.addMenu.add(new JSeparator());
            }
        }
        this.scene = scene;
        this.systemManager = systemManager;
        this.prj = prj;
    }

    public JPopupMenu getPopupMenu(Widget widget, Point point) {
        block24: {
            if (!this.systemManager.isSubSystem()) {
                if (this.prj.getSubSystemList().size() > 0) {
                    this.menuItemAddSubSystem.setEnabled(false);
                    this.menuImportSubsystem.setEnabled(false);
                } else {
                    this.menuItemAddSubSystem.setEnabled(true);
                    this.menuImportSubsystem.setEnabled(true);
                }
                boolean nodePresent = false;
                for (AFONode nd : this.systemManager.getNodeList()) {
                    if (!(nd instanceof LoggerNode)) continue;
                    nodePresent = true;
                    break;
                }
                nodePresent = false;
                for (AFONode nd : this.systemManager.getNodeList()) {
                    if (!(nd instanceof AddressNode)) continue;
                    nodePresent = true;
                    break;
                }
                if (nodePresent) {
                    this.menuAddress.setEnabled(false);
                } else {
                    this.menuAddress.setEnabled(true);
                }
                nodePresent = false;
                for (AFONode nd : this.systemManager.getNodeList()) {
                    if (!(nd instanceof CheckCommNode)) continue;
                    nodePresent = true;
                    break;
                }
                if (nodePresent) {
                    this.menuCheckComm.setEnabled(false);
                } else {
                    this.menuCheckComm.setEnabled(true);
                }
                if (this.systemManager.GetBlockListByType(CommonDefinitions.blockTypes.Monitor).size() > 0 || this.type.equals((Object)BoardsTypesAndDescription.BoardType.mPID3STH_NTC) || this.type.equals((Object)BoardsTypesAndDescription.BoardType.mPID3ST_NTC) || this.type.equals((Object)BoardsTypesAndDescription.BoardType.mPID4DSP) || this.type.equals((Object)BoardsTypesAndDescription.BoardType.mPID4DSP_2014_1) || this.type.equals((Object)BoardsTypesAndDescription.BoardType.mPID4DSP_2014_2) || this.type.equals((Object)BoardsTypesAndDescription.BoardType.mPID3STH) || this.type.equals((Object)BoardsTypesAndDescription.BoardType.mPID3ST)) {
                    this.menuMobDSP.setEnabled(false);
                } else {
                    this.menuMobDSP.setEnabled(true);
                }
                try {
                    if (this.prj.getKernel().isConnected()) {
                        this.menuModbusIN.setEnabled(false);
                        this.menuModbusOUT.setEnabled(false);
                        this.menuAddTimer.setEnabled(false);
                        this.menuIModbus.setEnabled(false);
                        this.menuItemProjectProperties.setEnabled(false);
                        this.menuMobDSP.setEnabled(false);
                    } else {
                        this.menuModbusIN.setEnabled(true);
                        this.menuModbusOUT.setEnabled(true);
                        this.menuIModbus.setEnabled(true);
                        this.menuItemProjectProperties.setEnabled(true);
                        if (this.type.equals((Object)BoardsTypesAndDescription.BoardType.mPID9ST) || this.type.equals((Object)BoardsTypesAndDescription.BoardType.mPID9MX) || this.type.equals((Object)BoardsTypesAndDescription.BoardType.mPID6ST) || this.type.equals((Object)BoardsTypesAndDescription.BoardType.mPID6MX) || this.type.equals((Object)BoardsTypesAndDescription.BoardType.mPID3STH) || this.type.equals((Object)BoardsTypesAndDescription.BoardType.mPID3ST)) {
                            this.menuAddTimer.setEnabled(true);
                        }
                        if (this.type.equals((Object)BoardsTypesAndDescription.BoardType.mPID9ST) || this.type.equals((Object)BoardsTypesAndDescription.BoardType.mPID9MX) || this.type.equals((Object)BoardsTypesAndDescription.BoardType.mPID6ST) || this.type.equals((Object)BoardsTypesAndDescription.BoardType.mPID6MX)) {
                            this.menuMobDSP.setEnabled(true);
                        }
                        if (this.systemManager.isSubSystem()) {
                            this.addMenu.setEnabled(true);
                        }
                    }
                    break block24;
                }
                catch (Exception ex) {
                    this.menuModbusIN.setEnabled(true);
                    this.menuModbusOUT.setEnabled(true);
                    this.menuItemProjectProperties.setEnabled(true);
                    if (this.type.equals((Object)BoardsTypesAndDescription.BoardType.mPID9ST) || this.type.equals((Object)BoardsTypesAndDescription.BoardType.mPID9MX) || this.type.equals((Object)BoardsTypesAndDescription.BoardType.mPID6ST) || this.type.equals((Object)BoardsTypesAndDescription.BoardType.mPID6MX) || this.type.equals((Object)BoardsTypesAndDescription.BoardType.mPID3STH) || this.type.equals((Object)BoardsTypesAndDescription.BoardType.mPID3ST)) {
                        this.menuAddTimer.setEnabled(true);
                    }
                    break block24;
                }
            }
            try {
                if (this.prj.getKernel().isConnected()) {
                    this.addMenu.setEnabled(false);
                    this.menuImportSubsystem.setEnabled(false);
                } else {
                    this.addMenu.setEnabled(true);
                    this.menuImportSubsystem.setEnabled(true);
                }
            }
            catch (Exception ex) {
                this.addMenu.setEnabled(true);
                this.menuImportSubsystem.setEnabled(true);
            }
        }
        this.point = point;
        return this.mainMenu;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String[] splittedEvent = event.getActionCommand().split(",");
        ArrayList<String> command = new ArrayList<String>();
        for (int i = 0; i < splittedEvent.length; ++i) {
            command.add(splittedEvent[i]);
        }
        if (command.size() == 1) {
            command.add("");
        }
        if (event.getActionCommand().equals(this.message.getString("propproj"))) {
            this.prj.showDialog();
        } else if (event.getActionCommand().equals(CommonDefinitions.blockTypes.Subsystem.toString())) {
            if (!this.systemManager.isSubSystem()) {
                this.prj.addSubSystem(this.point, null);
            } else {
                this.prj.addSubSystem(this.systemManager, this.point, null);
            }
        } else if (event.getActionCommand().equals(this.message.getString("aggtimer"))) {
            this.prj.addTimer();
        } else if (event.getActionCommand().equals(this.message.getString("impss"))) {
            this.systemManager.getProject().importSubsystem(this.systemManager);
        } else if (event.getActionCommand().equals(this.message.getString("incollaoggetto"))) {
            this.systemManager.paste(this.scene, this.point);
        } else if (event.getActionCommand().equals(this.message.getString("undo"))) {
            this.systemManager.undo();
        } else if (event.getActionCommand().equals(this.message.getString("redo"))) {
            this.systemManager.redo();
        } else if (event.getActionCommand().equals(this.message.getString("stampa"))) {
            PrintUIWindow.printComponent(this.systemManager.getAfoView());
            st = this.systemManager.getComment();
            System.out.println(st);
        } else {
            this.systemManager.addElementToSystem(splittedEvent, this.point, null, null, true, false);
        }
    }
}

