/*
 * Decompiled with CFR 0.152.
 */
package nodes;

import VisiProg.AppOptions;
import connection.ICmd;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.UndoManager;
import nodes.AFONodeWidget;
import nodes.AFOScenePopup;
import nodes.BoardsTypesAndDescription;
import nodes.ClipBoard;
import nodes.CommonDefinitions;
import nodes.KeyEventLoggerAction;
import nodes.MyGraphPinScene;
import nodes.Project;
import nodes.SceneSerializer;
import nodes.UndoRedo;
import nodes.WidgetPopupMenu;
import nodes.devices.AddressNode;
import nodes.devices.AnalogNode;
import nodes.devices.ArithmeticNode;
import nodes.devices.BinaryDecoderNode;
import nodes.devices.BinaryEncoderNode;
import nodes.devices.ButtonNode;
import nodes.devices.C3PointCtrlNode;
import nodes.devices.CheckCommNode;
import nodes.devices.ClimaticCurveNode;
import nodes.devices.ClockNode;
import nodes.devices.CommentNode;
import nodes.devices.CostantNode;
import nodes.devices.CounterNode;
import nodes.devices.DateTimeNode;
import nodes.devices.DelayNode;
import nodes.devices.DerivateNode;
import nodes.devices.DewPoint;
import nodes.devices.DiDoNode;
import nodes.devices.DipSwitchNode;
import nodes.devices.GateNode;
import nodes.devices.GenericNode;
import nodes.devices.HumidityNode;
import nodes.devices.HysteresisNode;
import nodes.devices.HysteresisNode2;
import nodes.devices.IFNode;
import nodes.devices.IModbusNode;
import nodes.devices.IntegralNode;
import nodes.devices.JumperNode;
import nodes.devices.LedNode;
import nodes.devices.LimitNode;
import nodes.devices.LoggerNode;
import nodes.devices.LogicNode;
import nodes.devices.ModbusNode;
import nodes.devices.ModbusStation;
import nodes.devices.MonitorNode;
import nodes.devices.MonitorNode_2;
import nodes.devices.MonitorNode_4;
import nodes.devices.MovingAverageNode;
import nodes.devices.MuxNode;
import nodes.devices.NTCNode;
import nodes.devices.PIDNode;
import nodes.devices.PIDSingleNode;
import nodes.devices.PWMNode;
import nodes.devices.Pt100Node;
import nodes.devices.PumpCtrlNode;
import nodes.devices.RitNode;
import nodes.devices.SampleAndHoldNode;
import nodes.devices.ScopeNode;
import nodes.devices.StepRelayNode;
import nodes.devices.SubSystemIONode;
import nodes.devices.TeleporOUTNode;
import nodes.devices.TempHumiNode;
import nodes.devices.TimerNode;
import nodes.devices.TriggerNode;
import nodes.devices.UniversalInputNode;
import nodes.gui.SubSystemDlg;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Widget;
import org.openide.util.Exceptions;
import sceneManager.AFOEdge;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFONode;
import sceneManager.AFOPin;
import sceneManager.SceneEvent;
import sceneManager.SceneEventListener;

public class AFOSystemManager
extends GenericNode
implements SceneEventListener {
    private MyGraphPinScene subSystemScene;
    public List<AFONode> nodeList;
    private boolean isSubSystem = false;
    private String subSystemID;
    private AFONode parentNode = null;
    private Widget parentWidget = null;
    private AFOSystemManager parentSystem = null;
    private String fileName = "";
    private JComponent afoView;
    private SubSystemDlg myForm;
    public static final int DEVICE_STARTING_ADDRESS = 499;
    Locale currentLocale;
    ResourceBundle message;
    private AppOptions options = new AppOptions();
    private BoardsTypesAndDescription.BoardType type;
    public AFOScenePopup scenepop;
    public String nameoffile;
    public Collection<AFONode> nodeList2;
    public Collection<AFOEdge> edgeList;
    private UndoManager undomanager = new UndoManager();

    public AFOSystemManager(Project prj, BoardsTypesAndDescription.BoardType type) {
        super("MainSystemID", "MainSystem", null);
        this.type = type;
        this.nodeList = new ArrayList<AFONode>();
        this.scene = null;
        this.isSubSystem = false;
        this.prj = prj;
        this.createSceneAndView();
        this.options.LoadOptions();
        this.currentLocale = new Locale(this.options.language, this.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        this.subSystemID = this.message.getString("sist");
    }

    public ArrayList<AFONode> GetBlockListByType(CommonDefinitions.blockTypes type) {
        ArrayList<AFONode> blockList = new ArrayList<AFONode>();
        for (AFONode node : this.nodeList) {
            if (!node.getBlockType().equals((Object)type)) continue;
            blockList.add(node);
        }
        return blockList;
    }

    public AFOSystemManager(Project prj, String id, String label, MyGraphPinScene scene) {
        super(id, label, scene);
        this.prj = prj;
        this.options.LoadOptions();
        this.currentLocale = new Locale(this.options.language, this.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        this.blockType = CommonDefinitions.blockTypes.Subsystem;
        this.nodeList = new ArrayList<AFONode>();
        this.isSubSystem = true;
        this.subSystemID = this.message.getString("ss") + id;
        this.createSceneAndView();
        this.createWidget();
        this.createPropertiesDialog();
    }

    private void createSceneAndView() {
        this.subSystemScene = new MyGraphPinScene(this);
        this.subSystemScene.addSceneEventListener(this);
        this.afoView = this.subSystemScene.createView();
        this.afoView.addKeyListener(this.subSystemScene);
        if (this.type == null) {
            this.type = this.prj.getBoardType();
        }
        this.scenepop = new AFOScenePopup(this.prj, this.subSystemScene, this, this.type);
        WidgetPopupMenu wpop = new WidgetPopupMenu(this.subSystemScene, this);
        this.subSystemScene.setWidgetPopupMenuActiom(wpop);
        this.subSystemScene.setScenePopupMenuAction(this.scenepop);
        KeyEventLoggerAction keyEvent = new KeyEventLoggerAction(this);
        this.subSystemScene.getSelectProvider().setKeyAction((WidgetAction)keyEvent);
    }

    public int assignConfigNumbers(int startNumber) {
        for (AFONode nodeExamined : this.nodeList) {
            if (nodeExamined.getBlockType().equals((Object)CommonDefinitions.blockTypes.IN) || nodeExamined.getBlockType().equals((Object)CommonDefinitions.blockTypes.OUT)) continue;
            if (nodeExamined instanceof AFOSystemManager) {
                startNumber = ((AFOSystemManager)nodeExamined).assignConfigNumbers(startNumber);
                continue;
            }
            if (nodeExamined.getBlockType().equals((Object)CommonDefinitions.blockTypes.Comment) || nodeExamined.getBlockType().equals((Object)CommonDefinitions.blockTypes.Scope)) continue;
            ((GenericNode)nodeExamined).setIniFileBlockNumber(++startNumber);
        }
        return startNumber;
    }

    public String getSubSystemID() {
        return this.subSystemID;
    }

    public void setSubSystemID(String subSystemID) {
        this.subSystemID = subSystemID;
    }

    public List<AFONode> getNodeList() {
        return this.nodeList;
    }

    public void setNodeList(List<AFONode> nodeList) {
        this.nodeList = nodeList;
    }

    @Override
    public MyGraphPinScene getScene() {
        return (MyGraphPinScene)this.scene;
    }

    public MyGraphPinScene getSubSystemScene() {
        return this.subSystemScene;
    }

    public JComponent getAfoView() {
        return this.afoView;
    }

    public AFONode getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(AFONode node) {
        this.parentNode = node;
    }

    public Widget getParentWidget() {
        return this.parentWidget;
    }

    public void setParentWidget(Widget parentWidget) {
        this.parentWidget = parentWidget;
    }

    public void rescanIOPins() {
        for (AFOPin pin : this.pinList) {
            this.scene.removePinWithEdges(pin);
        }
        ((AFONodeWidget)this.widget).clearPins();
        ((AFONodeWidget)this.widget).getModuleINPinNames().removeChildren();
        ((AFONodeWidget)this.widget).getModuleOUTPinNames().removeChildren();
        for (AFONode node : this.subSystemScene.getNodes()) {
            if (!(node instanceof SubSystemIONode)) continue;
            boolean isInput = node.getBlockType().equals((Object)CommonDefinitions.blockTypes.IN);
            String lbl = node.getLabel();
            this.addIOPin(isInput, lbl);
        }
    }

    public void addNode(AFONode newNode, boolean isUndoAction) {
        this.nodeList.add(newNode);
        if (!isUndoAction) {
            this.addUndoAction(false, (GenericNode)newNode);
        }
    }

    public void removeAllNodes() {
        while (this.nodeList.size() > 0) {
            AFONode subNode = this.nodeList.get(0);
            if (subNode instanceof AFOSystemManager) {
                ((AFOSystemManager)subNode).removeAllNodes();
                this.prj.getSubSystemList().remove((AFOSystemManager)subNode);
            }
            this.nodeList.remove(0);
        }
    }

    public boolean removeNode(AFONode oldNode) {
        if (oldNode instanceof AFOSystemManager) {
            ((AFOSystemManager)oldNode).removeAllNodes();
            this.prj.getSubSystemList().remove((AFOSystemManager)oldNode);
        }
        return this.nodeList.remove(oldNode);
    }

    public void addPin(AFONode node, AFOPin newPin) {
        int nodeIndex = this.nodeList.indexOf(node);
        try {
            this.nodeList.get(nodeIndex).addPin(newPin);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("(AFOSM) - Argh!!! Non sono riuscito ad attaccare il pin all'elemento inserito");
        }
    }

    public int getNodeListSize() {
        return this.nodeList.size();
    }

    public int getPinListSize(AFONode node) {
        try {
            return this.nodeList.get(this.nodeList.indexOf(node)).getPinListSize();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return -1;
        }
    }

    public AFONode getNodeAtIndex(int index) {
        try {
            return this.nodeList.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public AFOPin getPinAtIndex(int index) {
        try {
            return (AFOPin)this.pinList.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public boolean isSubSystem() {
        return this.isSubSystem;
    }

    public AFOSystemManager getParentSystem() {
        return this.parentSystem;
    }

    public void setParentSystem(AFOSystemManager parentSystem) {
        this.parentSystem = parentSystem;
        this.prj = parentSystem.getProject();
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        this.myForm.setTitle(((AFONodeWidget)this.widget).getModuleComment().getLabel());
        this.myForm.setVisible(true);
    }

    public void hidePropertiesDialog() {
        this.myForm.setVisible(false);
    }

    void createPropertiesDialog() {
        JScrollPane panel = new JScrollPane();
        panel.setViewportView(this.afoView);
        panel.addKeyListener(this.subSystemScene);
        this.myForm = new SubSystemDlg(null, true);
        this.myForm.mainPanel.setLayout(new BorderLayout());
        this.myForm.mainPanel.add((Component)panel, "Center");
        this.myForm.mainPanel.validate();
        this.myForm.setSize(800, 600);
        this.myForm.setTitle(((AFONodeWidget)this.widget).getModuleComment().getLabel());
        this.myForm.setLocationRelativeTo(null);
        this.myForm.setModal(false);
    }

    public boolean addElementToSystem(String[] splittedEvent, Point point, String elementID, Integer address, boolean addToDB, boolean isUndoAction) {
        GenericNode node = null;
        boolean inserting = false;
        int max = this.prj.getMaxNumBlocks();
        int cont = 0;
        if (!(splittedEvent[0].equals(CommonDefinitions.blockTypes.IN.toString()) || splittedEvent[0].equals(CommonDefinitions.blockTypes.OUT.toString()) || splittedEvent[0].equals(CommonDefinitions.blockTypes.Scope.toString()) || splittedEvent[0].equals(CommonDefinitions.blockTypes.Comment.toString()) || (cont = this.prj.getNofBlocks()) <= max)) {
            JOptionPane.showMessageDialog(null, this.message.getString("nummax"), this.message.getString("er"), 0);
            return false;
        }
        if (elementID == null) {
            inserting = true;
            elementID = new String("node" + ++this.subSystemScene.nodeIDcounter);
        }
        if (splittedEvent[0].equals(CommonDefinitions.blockTypes.UniversalIN.toString())) {
            node = new UniversalInputNode(elementID, "Universal IN", splittedEvent[1], this.subSystemScene);
        } else if (splittedEvent[0].equals(CommonDefinitions.subBlockTypes.PID_SINGLE.toString()) || splittedEvent.length > 1 && splittedEvent[1].equals(CommonDefinitions.subBlockTypes.PID_SINGLE.toString())) {
            node = new PIDSingleNode(elementID, "PID", this.subSystemScene);
        } else if (splittedEvent[0].equals(CommonDefinitions.subBlockTypes.Derivate.toString()) || splittedEvent.length > 1 && splittedEvent[1].equals(CommonDefinitions.subBlockTypes.Derivate.toString())) {
            node = new DerivateNode(elementID, "Derivate", this.subSystemScene);
        } else if (splittedEvent[0].equals(CommonDefinitions.subBlockTypes.Integral.toString()) || splittedEvent.length > 1 && splittedEvent[1].equals(CommonDefinitions.subBlockTypes.Integral.toString())) {
            node = new IntegralNode(elementID, "Integral", this.subSystemScene);
        } else if (splittedEvent[0].equals(CommonDefinitions.subBlockTypes.PID_LIMIT.toString()) || splittedEvent.length > 1 && splittedEvent[1].equals(CommonDefinitions.subBlockTypes.PID_LIMIT.toString())) {
            node = new PIDNode(elementID, "PID", this.subSystemScene);
        } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.DigitalIN.toString()) || splittedEvent[0].equals(CommonDefinitions.blockTypes.DigitalOUT.toString())) {
            node = new DiDoNode(elementID, splittedEvent[0], splittedEvent[1], this.subSystemScene, this.prj);
        } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.AnalogOUT.toString()) || splittedEvent[0].equals(CommonDefinitions.blockTypes.AnalogIN.toString())) {
            node = new AnalogNode(elementID, splittedEvent[0], splittedEvent[1], this.subSystemScene);
        } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.Pt100.toString())) {
            node = new Pt100Node(elementID, splittedEvent[0], splittedEvent[1], this.subSystemScene);
        } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.NTC.toString())) {
            node = new NTCNode(elementID, splittedEvent[0], splittedEvent[1], this.subSystemScene, this.prj.getBoardType());
        } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.TempHumi.toString())) {
            node = new TempHumiNode(elementID, splittedEvent[0], splittedEvent[1], this.subSystemScene);
        } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.Hum.toString())) {
            node = new HumidityNode(elementID, splittedEvent[0], splittedEvent[1], this.subSystemScene);
        } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.Rit.toString())) {
            node = new RitNode(elementID, splittedEvent[0], splittedEvent[1], this.subSystemScene);
        } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.Monitor.toString())) {
            node = new MonitorNode(elementID, splittedEvent[0], "", this.subSystemScene, this.prj);
        } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.Monitor_2.toString())) {
            node = new MonitorNode_2(elementID, splittedEvent[0], "", this.subSystemScene, this.prj.getBoardType());
        } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.Monitor_4.toString())) {
            node = new MonitorNode_4(elementID, splittedEvent[0], "", this.subSystemScene, this.prj.getBoardType());
        } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.DipSwitch.toString())) {
            node = new DipSwitchNode(elementID, splittedEvent[0], splittedEvent[1], this.subSystemScene);
        } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.Button.toString())) {
            node = new ButtonNode(elementID, splittedEvent[0], splittedEvent[1], this.subSystemScene);
        } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.Jumper.toString())) {
            node = new JumperNode(elementID, splittedEvent[0], splittedEvent[1], this.subSystemScene);
        } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.Led.toString())) {
            node = new LedNode(elementID, splittedEvent[0], splittedEvent[1], this.subSystemScene);
        } else {
            if (splittedEvent[0].equals(CommonDefinitions.blockTypes.IN.toString()) || splittedEvent[0].equals(CommonDefinitions.blockTypes.OUT.toString())) {
                int numIOint = 0;
                int numMax = 15;
                boolean isInput = splittedEvent[0].equals(CommonDefinitions.blockTypes.IN.toString());
                if (inserting) {
                    String numIO = JOptionPane.showInputDialog(null, (Object)this.message.getString("numbloc"));
                    if (numIO == null) {
                        return false;
                    }
                    try {
                        numIOint = Integer.parseInt(numIO);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, this.message.getString("numcompreso"), this.message.getString("er"), 0);
                        return false;
                    }
                } else {
                    numIOint = 1;
                }
                if (numIOint <= numMax) {
                    for (int i = 0; i < numIOint; ++i) {
                        int nOfIO = this.getFreeIONumber(isInput);
                        if (inserting) {
                            elementID = "node" + ++this.subSystemScene.nodeIDcounter;
                        }
                        node = new SubSystemIONode(elementID, splittedEvent[0], this.subSystemScene, nOfIO);
                        AFOPin pin = this.addIOPin(isInput, splittedEvent[0] + nOfIO);
                        ((SubSystemIONode)node).setParentPin(pin);
                        ((SubSystemIONode)node).setParentScene(this.getScene());
                        ((SubSystemIONode)node).setParentIOWidget(pin.getWidget());
                        ((SubSystemIONode)node).setParentIONameWidget((Widget)pin.getPinNameWidget());
                        try {
                            this.getParentSystem().getSubSystemScene().validate();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        try {
                            Point newPt = new Point();
                            newPt.setLocation(point.x, point.y + i * 100);
                            node.getWidget().setPreferredLocation(newPt);
                            this.subSystemScene.validate();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (address == null) {
                            node.generateAddresses(this.getFreeAddress(node));
                        } else {
                            node.generateAddresses(address);
                        }
                        for (AFOPin pins : node.getPinList()) {
                            pins.setParentNode(node);
                        }
                        node.setConnectionStatus(false);
                        node.resetPinValues();
                        this.addNode(node, isUndoAction);
                        this.subSystemScene.validate();
                    }
                    this.subSystemScene.sceneChanged();
                    this.prj.projectDirty = true;
                    return true;
                }
                JOptionPane.showMessageDialog(null, this.message.getString("numcompreso"), this.message.getString("er"), 0);
                return false;
            }
            if (splittedEvent[0].equals(CommonDefinitions.blockTypes.IF.toString())) {
                node = new IFNode(elementID, splittedEvent[1], this.subSystemScene);
            } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.Arithmetic.toString())) {
                node = new ArithmeticNode(elementID, splittedEvent[1], this.subSystemScene);
            } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.Logic.toString())) {
                node = new LogicNode(elementID, splittedEvent[1], this.subSystemScene);
            } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.Limit.toString())) {
                node = new LimitNode(elementID, splittedEvent[0], this.subSystemScene);
            } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.Hysteresys.toString())) {
                node = new HysteresisNode(elementID, splittedEvent[0], this.subSystemScene);
            } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.Hysteresys2.toString())) {
                node = new HysteresisNode2(elementID, splittedEvent[0], this.subSystemScene);
            } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.Costant.toString())) {
                node = new CostantNode(elementID, splittedEvent[0], this.subSystemScene);
            } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.BinaryEncoder.toString())) {
                node = new BinaryEncoderNode(elementID, splittedEvent[0], this.subSystemScene);
            } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.DewPoint.toString())) {
                node = new DewPoint(elementID, splittedEvent[0], this.subSystemScene);
            } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.BinaryDecoder.toString())) {
                node = new BinaryDecoderNode(elementID, splittedEvent[0], this.subSystemScene);
            } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.Mux.toString())) {
                node = new MuxNode(elementID, splittedEvent[0], this.subSystemScene);
            } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.C3PointCtrl.toString())) {
                node = new C3PointCtrlNode(elementID, splittedEvent[0], this.subSystemScene);
            } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.Trigger.toString())) {
                node = new TriggerNode(elementID, splittedEvent[1], this.subSystemScene);
            } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.Clock.toString())) {
                node = new ClockNode(elementID, splittedEvent[0], this.subSystemScene);
            } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.Delay.toString())) {
                node = new DelayNode(elementID, splittedEvent[0], this.subSystemScene);
            } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.SampleAndHold.toString())) {
                node = new SampleAndHoldNode(elementID, splittedEvent[0], this.subSystemScene);
            } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.MovingAverage.toString())) {
                node = new MovingAverageNode(elementID, splittedEvent[0], this.subSystemScene);
            } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.Counter.toString())) {
                node = new CounterNode(elementID, splittedEvent[0], this.subSystemScene);
            } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.Timer.toString())) {
                node = new TimerNode(elementID, splittedEvent[0], this.subSystemScene);
            } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.DateTime.toString())) {
                node = new DateTimeNode(elementID, splittedEvent[0], this.subSystemScene);
            } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.ClimaticCurve.toString())) {
                node = new ClimaticCurveNode(elementID, splittedEvent[0], this.subSystemScene);
            } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.PWM.toString())) {
                node = new PWMNode(elementID, splittedEvent[0], this.subSystemScene);
            } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.Comment.toString())) {
                node = new CommentNode(elementID, splittedEvent[0], this.subSystemScene);
            } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.Scope.toString())) {
                node = new ScopeNode(elementID, splittedEvent[0], this.subSystemScene);
            } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.Gate.toString())) {
                node = new GateNode(elementID, splittedEvent[0], this.subSystemScene);
            } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.PumpControl.toString())) {
                node = new PumpCtrlNode(elementID, splittedEvent[0], this.subSystemScene);
            } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.ModbusIN.toString()) || splittedEvent[0].equals(CommonDefinitions.blockTypes.ModbusOUT.toString())) {
                node = new ModbusNode(elementID, splittedEvent[0], this.subSystemScene, this.prj);
            } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.ModbusStation.toString())) {
                node = new ModbusStation(elementID, splittedEvent[0], this.subSystemScene, this.prj);
            } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.IModbus.toString())) {
                node = new IModbusNode(elementID, splittedEvent[0], this.subSystemScene);
            } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.Logger.toString())) {
                node = new LoggerNode(elementID, splittedEvent[0], this.subSystemScene);
            } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.Address.toString())) {
                node = new AddressNode(elementID, splittedEvent[0], "Address", this.subSystemScene);
            } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.CheckComm.toString())) {
                node = new CheckCommNode(elementID, splittedEvent[0], "CheckComm", this.subSystemScene);
            } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.StepRelay.toString())) {
                node = new StepRelayNode(elementID, splittedEvent[0], this.subSystemScene);
            } else if (splittedEvent[0].equals(CommonDefinitions.blockTypes.TeleportOUT.toString())) {
                node = new TeleporOUTNode(elementID, splittedEvent[0], this.subSystemScene);
            } else {
                JOptionPane.showMessageDialog(null, this.message.getString("att") + splittedEvent[0] + this.message.getString("nonricon"));
                return false;
            }
        }
        try {
            this.subSystemScene.validate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        node.setSysManager(this);
        node.getWidget().setPreferredLocation(point);
        if (address == null) {
            node.generateAddresses(this.getFreeAddress(node));
        } else {
            node.generateAddresses(address);
        }
        for (AFOPin pin : node.getPinList()) {
            pin.setParentNode(node);
        }
        node.setConnectionStatus(false);
        node.resetPinValues();
        if (addToDB) {
            node.setDatabase(this.prj.getProjectDB());
        }
        this.addNode(node, isUndoAction);
        node.setProject(this.prj);
        this.subSystemScene.validate();
        this.subSystemScene.sceneChanged();
        this.prj.projectDirty = true;
        return true;
    }

    void addUndoAction(boolean isDelete, GenericNode node) {
        UndoableEditEvent edit = new UndoableEditEvent(this.subSystemScene, new UndoRedo(node, this, isDelete));
        this.getUndomanager().undoableEditHappened(edit);
        this.scenepop.menuRedo.setEnabled(this.getUndomanager().canRedo());
        this.scenepop.menuUndo.setEnabled(this.getUndomanager().canUndo());
    }

    public void changeEdgeColor(Color newColor) {
        Color sceneColorBackup = this.subSystemScene.getEdgeColor();
        this.subSystemScene.setEdgeColor(newColor);
        Object[] list = this.subSystemScene.getSelectedObjects().toArray();
        ArrayList<Object> selectedObjects = new ArrayList<Object>();
        for (Object obj : list) {
            if (!(obj instanceof AFOEdge)) continue;
            selectedObjects.add(obj);
        }
        for (Object e : selectedObjects) {
            AFOEdge oldEdge = (AFOEdge)e;
            AFOPin sourcePin = (AFOPin)this.subSystemScene.getEdgeSource(oldEdge);
            AFONode sourceNode = (AFONode)this.subSystemScene.getPinNode(sourcePin);
            AFOPin targetPin = (AFOPin)this.subSystemScene.getEdgeTarget(oldEdge);
            AFONode targetNode = (AFONode)this.subSystemScene.getPinNode(targetPin);
            String edgeID = oldEdge.getId();
            ConnectionWidget conn = (ConnectionWidget)this.subSystemScene.findWidget(oldEdge);
            List controlPoints = conn.getControlPoints();
            Widget wdg = this.subSystemScene.findWidget(e);
            this.subSystemScene.removeEdge((AFOEdge)this.subSystemScene.findObject(wdg));
            AFOEdge newEdge = new AFOEdge(edgeID, edgeID, null);
            newEdge.setColor(newColor);
            this.subSystemScene.setEdgeColor(newColor);
            this.subSystemScene.addEdge(newEdge);
            this.subSystemScene.setEdgeSource(newEdge, sourcePin);
            this.subSystemScene.setEdgeTarget(newEdge, targetPin);
            conn = (ConnectionWidget)this.subSystemScene.findWidget(newEdge);
            conn.setControlPoints((Collection)controlPoints, true);
            conn.setRoutingPolicy(ConnectionWidget.RoutingPolicy.DISABLE_ROUTING_UNTIL_END_POINT_IS_MOVED);
        }
        this.subSystemScene.validate();
        this.subSystemScene.setEdgeColor(sceneColorBackup);
    }

    public void deleteElementFromSystem(Widget element, boolean isUndo) {
        Object obj;
        Object[] myOptions = new Object[]{this.message.getString("yes"), this.message.getString("no")};
        if (JOptionPane.showOptionDialog(null, this.message.getString("sicuro"), this.message.getString("er"), 0, 2, null, myOptions, myOptions[0]) == 1) {
            return;
        }
        Object[] list = this.subSystemScene.getSelectedObjects().toArray();
        ArrayList<Object> selectedObjects = new ArrayList<Object>();
        for (Object obj2 : list) {
            if (!(obj2 instanceof AFONode) && !(obj2 instanceof AFOEdge)) continue;
            selectedObjects.add(obj2);
        }
        if (selectedObjects.size() == 0 && (obj = this.subSystemScene.findObject(element)) != null) {
            selectedObjects.add(obj);
        }
        Widget wdg = null;
        while (selectedObjects.size() > 0) {
            wdg = this.subSystemScene.findWidget(selectedObjects.toArray()[0]);
            if (this.subSystemScene.isEdge(this.subSystemScene.findObject(wdg))) {
                this.subSystemScene.removeEdge((AFOEdge)this.subSystemScene.findObject(wdg));
            } else if (this.subSystemScene.findObject(wdg) instanceof AFONode) {
                AFONode oldNode = (AFONode)this.subSystemScene.findObject(wdg);
                if (oldNode == null) {
                    return;
                }
                this.removeNode(oldNode);
                this.subSystemScene.removeNodeWithEdges(oldNode);
                this.subSystemScene.validate();
                if (!isUndo) {
                    this.addUndoAction(true, (GenericNode)oldNode);
                }
                if (!this.isSubSystem && oldNode instanceof AFOSystemManager) {
                    this.prj.getSubSystemList().clear();
                    if (!isUndo) {
                        this.addUndoAction(true, (GenericNode)oldNode);
                    }
                } else if (this.isSubSystem() && oldNode instanceof SubSystemIONode) {
                    Object[] blockEdgeList;
                    SubSystemIONode subSystemNode = (SubSystemIONode)oldNode;
                    AFONodeWidget subSystemParentWidget = (AFONodeWidget)this.getWidget();
                    if (!isUndo) {
                        this.addUndoAction(true, (GenericNode)oldNode);
                    }
                    if (oldNode.getBlockType() == CommonDefinitions.blockTypes.IN) {
                        blockEdgeList = this.getParentSystem().getSubSystemScene().findPinEdges(subSystemNode.getParentPin(), false, true).toArray();
                        if (blockEdgeList.length > 0) {
                            this.getParentSystem().getSubSystemScene().removeEdge((AFOEdge)blockEdgeList[0]);
                        }
                        subSystemNode.getParentIONameWidget().removeFromParent();
                        subSystemNode.getParentIOWidget().removeFromParent();
                    } else {
                        blockEdgeList = this.getParentSystem().getSubSystemScene().findPinEdges(subSystemNode.getParentPin(), true, false).toArray();
                        for (int i = 0; i < blockEdgeList.length; ++i) {
                            this.getParentSystem().getSubSystemScene().removeEdge((AFOEdge)blockEdgeList[i]);
                        }
                        subSystemNode.getParentIONameWidget().removeFromParent();
                        subSystemNode.getParentIOWidget().removeFromParent();
                    }
                    this.pinList.remove(subSystemNode.getParentPin());
                    this.getParentSystem().getSubSystemScene().validate();
                } else if (oldNode.getBlockType() == CommonDefinitions.blockTypes.ClimaticCurve) {
                    this.prj.regenerateClimaticIDs();
                }
                this.getSubSystemScene().validate();
            }
            list = this.subSystemScene.getSelectedObjects().toArray();
            selectedObjects = new ArrayList();
            for (Object obj3 : list) {
                if (!(obj3 instanceof AFONode) && !(obj3 instanceof String)) continue;
                selectedObjects.add(obj3);
            }
        }
        this.prj.projectDirty = true;
        this.getSubSystemScene().sceneChanged();
    }

    private void createWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("SubSystem");
        this.setComment("SubSystem" + this.id);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
        this.getScene().addNode(this);
        this.getScene().revalidate();
    }

    public AFOPin addIOPin(boolean isInput, String label) {
        AFOPin newPin;
        String pinLabel = label;
        if (isInput) {
            String pinID = "pin" + ++this.subSystemScene.pinIDCounter;
            newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
            newPin.setAsBusPin(false);
            newPin.setParentNode(this);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            newPin.setPinIDString("Comment");
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
        } else {
            String pinID = "pin" + ++this.subSystemScene.pinIDCounter;
            newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
            newPin.setAsBusPin(false);
            newPin.setParentNode(this);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            newPin.setPinIDString("Comment");
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
        }
        this.scene.validate();
        return newPin;
    }

    public int getNofIOWidgets(boolean searchInputs) {
        int retVal = 0;
        CommonDefinitions.blockTypes bt = searchInputs ? CommonDefinitions.blockTypes.IN : CommonDefinitions.blockTypes.OUT;
        for (int i = 0; i < this.nodeList.size(); ++i) {
            if (this.nodeList.get(i).getBlockType() != bt) continue;
            ++retVal;
        }
        return retVal;
    }

    public int getFreeIONumber(boolean input) {
        int i;
        ArrayList<Integer> ioNodesNumbers = new ArrayList<Integer>();
        CommonDefinitions.blockTypes bt = input ? CommonDefinitions.blockTypes.IN : CommonDefinitions.blockTypes.OUT;
        if (this.nodeList.size() == 0) {
            return 1;
        }
        for (i = 0; i < this.nodeList.size(); ++i) {
            if (this.nodeList.get(i).getBlockType() != bt) continue;
            ioNodesNumbers.add(((SubSystemIONode)this.nodeList.get(i)).getIoIndex());
        }
        Collections.sort(ioNodesNumbers);
        for (i = 0; i < ioNodesNumbers.size(); ++i) {
            if ((Integer)ioNodesNumbers.get(i) == i + 1) continue;
            return i + 1;
        }
        return ioNodesNumbers.size() + 1;
    }

    public boolean existAddress(String address, Boolean isMonitor) {
        ArrayList<Integer> usedAddressList = new ArrayList<Integer>();
        for (AFONode deviceNode : this.prj.getMainSystem().getNodeList()) {
            if (((GenericNode)deviceNode).getAddressSpace() == 0) continue;
            int maxAddr = Math.max(25, ((GenericNode)deviceNode).getAddressSpace());
            for (int j = 0; j < maxAddr; ++j) {
                usedAddressList.add(((GenericNode)deviceNode).getAddressList().get(0) + j);
            }
        }
        for (AFOSystemManager subSystem : this.prj.getSubSystemList()) {
            if (subSystem.nodeList.isEmpty()) continue;
            for (int i = 0; i < subSystem.nodeList.size(); ++i) {
                List<Integer> nodeAddressList = ((GenericNode)subSystem.nodeList.get(i)).getAddressList();
                if (nodeAddressList.size() == 0) continue;
                int maxAddr = Math.max(25, ((GenericNode)subSystem.nodeList.get(i)).getAddressSpace());
                for (int j = 0; j < maxAddr; ++j) {
                    usedAddressList.add(nodeAddressList.get(0) + j);
                }
            }
        }
        Object[] sortedAddress = usedAddressList.toArray();
        Arrays.sort(sortedAddress);
        Boolean bool = false;
        if (!address.equals("")) {
            for (int i = 0; i < sortedAddress.length; ++i) {
                if (!sortedAddress[i].equals(Integer.parseInt(address))) continue;
                bool = true;
                break;
            }
            Integer retVal = -1;
            boolean gapFound = false;
            int gapSize = 0;
            int gapSizeMin = 0;
            gapSizeMin = 25;
            if (isMonitor.booleanValue()) {
                gapSizeMin = 50;
            }
            for (int y = 0; y < sortedAddress.length - 1; ++y) {
                if (Integer.parseInt(address) <= (Integer)sortedAddress[y] || Integer.parseInt(address) >= (Integer)sortedAddress[y + 1] || (Integer)sortedAddress[y + 1] - (Integer)sortedAddress[y] <= gapSize) continue;
                retVal = (Integer)sortedAddress[y] + 1;
                gapSize = (Integer)sortedAddress[y + 1] - Integer.parseInt(address);
                gapFound = true;
                if (gapSize > gapSizeMin) {
                    bool = false;
                }
                if (gapSize >= gapSizeMin) break;
                bool = true;
                break;
            }
        }
        return bool;
    }

    private Integer getFreeAddress(GenericNode node) {
        ArrayList<Integer> usedAddressList = new ArrayList<Integer>();
        Integer retVal = -1;
        boolean gapFound = false;
        int gapSize = 0;
        for (AFONode deviceNode : this.prj.getMainSystem().getNodeList()) {
            if (((GenericNode)deviceNode).getAddressSpace() == 0) continue;
            int maxAddr = Math.max(25, ((GenericNode)deviceNode).getAddressSpace());
            for (int j = 0; j < maxAddr; ++j) {
                usedAddressList.add(((GenericNode)deviceNode).getAddressList().get(0) + j);
            }
        }
        for (AFOSystemManager subSystem : this.prj.getSubSystemList()) {
            if (subSystem.nodeList.isEmpty()) continue;
            for (int i = 0; i < subSystem.nodeList.size(); ++i) {
                List<Integer> nodeAddressList = ((GenericNode)subSystem.nodeList.get(i)).getAddressList();
                if (nodeAddressList.size() == 0) continue;
                int maxAddr = Math.max(25, ((GenericNode)subSystem.nodeList.get(i)).getAddressSpace());
                for (int j = 0; j < maxAddr; ++j) {
                    usedAddressList.add(nodeAddressList.get(0) + j);
                }
            }
        }
        if (usedAddressList.isEmpty()) {
            return new Integer(500);
        }
        Object[] sortedAddress = usedAddressList.toArray();
        Arrays.sort(sortedAddress);
        gapSize = Math.max(node.getAddressSpace(), 25);
        for (int i = 0; i < sortedAddress.length - 1; ++i) {
            if ((Integer)sortedAddress[i + 1] - (Integer)sortedAddress[i] <= gapSize) continue;
            retVal = (Integer)sortedAddress[i] + 1;
            gapFound = true;
            break;
        }
        if (!gapFound) {
            retVal = (Integer)sortedAddress[sortedAddress.length - 1] + 1;
        }
        return retVal;
    }

    public Project getProject() {
        return this.prj;
    }

    public JDialog getForm() {
        return this.myForm;
    }

    public int createAddressBlocks(int nOfBlocks, FileWriter stream) throws IOException {
        Iterator<AFONode> nodeIt = this.nodeList.iterator();
        boolean subSystemNotEmpty = false;
        while (nodeIt.hasNext()) {
            String blockStr = "";
            GenericNode node = (GenericNode)nodeIt.next();
            if (node.getBlockType().equals((Object)CommonDefinitions.blockTypes.IN) || node.getBlockType().equals((Object)CommonDefinitions.blockTypes.OUT)) continue;
            subSystemNotEmpty = true;
            if (node instanceof ScopeNode || node instanceof CommentNode) continue;
            if (node instanceof AFOSystemManager) {
                nOfBlocks = ((AFOSystemManager)node).createAddressBlocks(nOfBlocks, stream);
                continue;
            }
            String iniStr = "";
            ++nOfBlocks;
            for (int i = 0; i < node.getAddressList().size(); ++i) {
                iniStr = iniStr + node.getBlockType().toString();
                iniStr = iniStr + this.options.separator;
                iniStr = iniStr + node.getComment();
                iniStr = iniStr + this.options.separator;
                iniStr = iniStr + node.getAddressList().get(i);
                iniStr = iniStr + "\r\n";
            }
            stream.write(iniStr);
        }
        if (!subSystemNotEmpty) {
            JOptionPane.showMessageDialog(null, this.message.getString("errnotempty1") + this.comment + this.message.getString("errnotempty2"), this.message.getString("er"), 0);
        }
        return nOfBlocks;
    }

    public int createMoviconBlocks(int nOfBlocks, FileWriter stream) throws IOException {
        Iterator<AFONode> nodeIt = this.nodeList.iterator();
        boolean subSystemNotEmpty = false;
        while (nodeIt.hasNext()) {
            String blockStr = "";
            GenericNode node = (GenericNode)nodeIt.next();
            if (node.getBlockType().equals((Object)CommonDefinitions.blockTypes.IN) || node.getBlockType().equals((Object)CommonDefinitions.blockTypes.OUT)) continue;
            subSystemNotEmpty = true;
            if (node instanceof ScopeNode || node instanceof CommentNode) continue;
            if (node instanceof AFOSystemManager) {
                nOfBlocks = ((AFOSystemManager)node).createMoviconBlocks(nOfBlocks, stream);
                continue;
            }
            String iniStr = "";
            ++nOfBlocks;
            String virgola = ",";
            if (node.getAddressList().size() <= 1) continue;
            for (int i = 1; i < node.getList().size(); ++i) {
                try {
                    iniStr = iniStr + node.getBlockType().toString() + "_" + node.getList().get(i);
                    iniStr = iniStr + virgola;
                    iniStr = iniStr + "HR" + (node.getAddressList().get(0) + i);
                    iniStr = iniStr + virgola;
                    iniStr = iniStr + "WORD";
                    iniStr = iniStr + virgola;
                    iniStr = iniStr + (Object)((Object)node.getBlockType()) + " " + node.getComment();
                    iniStr = iniStr + virgola;
                    iniStr = iniStr + "\r\n";
                    continue;
                }
                catch (IndexOutOfBoundsException ex) {
                    ex.printStackTrace();
                }
            }
            stream.write(iniStr);
        }
        if (!subSystemNotEmpty) {
            JOptionPane.showMessageDialog(null, this.message.getString("errnotempty1") + this.comment + this.message.getString("errnotempty2"), this.message.getString("er"), 0);
        }
        return nOfBlocks;
    }

    public int countSubSystem() {
        int count = 0;
        for (GenericNode genericNode : this.nodeList) {
            if (!(genericNode instanceof AFOSystemManager)) continue;
            ++count;
        }
        return count + 1;
    }

    public int createPrintProject(int nOfPrint) throws IOException {
        Iterator<AFONode> nodeIt = this.nodeList.iterator();
        this.nameoffile = this.prj.getProjectFolder() + "Subsystem" + ++nOfPrint + ".jpeg";
        JComponent image = this.getAfoView();
        Image im = Project.getImage(image);
        Dimension size = image.getSize();
        BufferedImage myImage = new BufferedImage(size.width, size.height, 1);
        Graphics2D g2 = myImage.createGraphics();
        ((Component)image).paint(g2);
        try {
            FileOutputStream out = new FileOutputStream(this.nameoffile);
            ImageIO.write((RenderedImage)myImage, "jpeg", out);
            out.close();
            System.out.println(this.nameoffile);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        while (nodeIt.hasNext()) {
            GenericNode node = (GenericNode)nodeIt.next();
            if (!(node instanceof AFOSystemManager)) continue;
            nOfPrint = ((AFOSystemManager)node).createPrintProject(nOfPrint);
        }
        return nOfPrint;
    }

    public int createConfigBlocks(int nOfBlocks, FileWriter stream) throws IOException {
        Iterator<AFONode> nodeIt = this.nodeList.iterator();
        boolean subSystemNotEmpty = false;
        while (nodeIt.hasNext()) {
            String blockStr = "";
            GenericNode node = (GenericNode)nodeIt.next();
            if (node.getBlockType().equals((Object)CommonDefinitions.blockTypes.IN) || node.getBlockType().equals((Object)CommonDefinitions.blockTypes.OUT)) continue;
            subSystemNotEmpty = true;
            if (node instanceof ScopeNode || node instanceof CommentNode) continue;
            if (node instanceof AFOSystemManager) {
                nOfBlocks = ((AFOSystemManager)node).createConfigBlocks(nOfBlocks, stream);
                continue;
            }
            String iniStr = "";
            ++nOfBlocks;
            iniStr = iniStr + "<BL add ";
            try {
                iniStr = iniStr + node.getConfigString(nOfBlocks);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            iniStr = iniStr + " >\r\n";
            stream.write(iniStr);
            if (!(node instanceof ModbusStation)) continue;
            blockStr = ((ModbusStation)node).getVarConfiguration();
            stream.write(blockStr);
        }
        if (!subSystemNotEmpty) {
            JOptionPane.showMessageDialog(null, this.message.getString("errnotempty1") + this.comment + this.message.getString("errnotempty2"), this.message.getString("er"), 0);
        }
        return nOfBlocks;
    }

    public SubSystemIONode getPinChildNode(AFOPin pin) {
        for (AFONode node : this.nodeList) {
            if (!(node instanceof SubSystemIONode) || !((SubSystemIONode)node).getParentPin().equals(pin)) continue;
            return (SubSystemIONode)node;
        }
        return null;
    }

    void importSubsystem(File openFile, String importedSubsystemID) {
        try {
            int sepIdx = importedSubsystemID.lastIndexOf(".sub");
            if (sepIdx > 0) {
                importedSubsystemID = importedSubsystemID.substring(0, sepIdx);
            }
            this.prj.addSubSystem(this, new Point(0, 0), null);
            int lastNodeIdx = this.nodeList.size() - 1;
            AFONode node = this.nodeList.get(lastNodeIdx);
            int idNum = 1;
            while (this.existsID(importedSubsystemID)) {
                importedSubsystemID = importedSubsystemID + "_" + idNum;
            }
            node.setComment(importedSubsystemID);
            int subSystemSize = this.prj.getSubSystemList().size();
            AFOSystemManager newSystemManager = this.prj.getSubSystemList().get(subSystemSize - 1);
            SceneSerializer.deserializeScene(this.prj, newSystemManager.getSubSystemScene(), openFile, true);
            newSystemManager.getForm().setSize(new Dimension(250, 250));
            newSystemManager.getForm().setLocation(0, 0);
            this.prj.projectDirty = true;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, this.message.getString("errss") + ex.toString(), this.message.getString("er"), 0);
        }
    }

    private boolean existsID(String importedSubsystemID) {
        List<AFOSystemManager> subSysList = this.prj.getSubSystemList();
        for (AFOSystemManager subSys : subSysList) {
            if (!subSys.getComment().equals(importedSubsystemID)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        return false;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    void copySystem(Widget element, AFOGraphPinScene scene) {
        Object[] list = this.subSystemScene.getSelectedObjects().toArray();
        System.out.println(list.length + " " + list.toString());
        File file = new File(this.prj.getProjectFolder() + "Copia");
        ArrayList<Object> selectedObjects = new ArrayList<Object>();
        ArrayList<AFONode> selectedNodes = new ArrayList<AFONode>();
        ArrayList<AFOEdge> selectedEdges = new ArrayList<AFOEdge>();
        for (Object obj : list) {
            if (!(obj instanceof AFONode) && !(obj instanceof AFOEdge)) continue;
            selectedObjects.add(obj);
        }
        for (Object obj2 : list) {
            if (!(obj2 instanceof AFONode)) continue;
            selectedNodes.add((AFONode)obj2);
        }
        for (Object obj2 : list) {
            if (!(obj2 instanceof AFOEdge)) continue;
            selectedEdges.add((AFOEdge)obj2);
        }
        if (selectedObjects.size() == 1) {
            try {
                if (scene.findObject(element) instanceof AFONode) {
                    AFONode oldNode = (AFONode)scene.findObject(element);
                    SceneSerializer.serializeCopy(this.prj, this.subSystemScene, oldNode, file);
                    String string = AFOSystemManager.fileToString(file.getPath());
                    ClipBoard.writeToClipboard(string);
                }
            }
            catch (FileNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            SceneSerializer.serializeCopy2(this.prj, this.subSystemScene, file, selectedNodes, selectedEdges, true);
            String string = AFOSystemManager.fileToString(file.getPath());
            ClipBoard.writeToClipboard(string);
        }
    }

    public void undo() {
        try {
            this.getUndomanager().undo();
            this.scenepop.menuUndo.setEnabled(this.getUndomanager().canUndo());
            this.scenepop.menuRedo.setEnabled(this.getUndomanager().canRedo());
        }
        catch (CannotRedoException cre) {
            cre.printStackTrace();
        }
    }

    public void redo() {
        try {
            this.getUndomanager().redo();
            this.scenepop.menuUndo.setEnabled(this.getUndomanager().canUndo());
            this.scenepop.menuRedo.setEnabled(this.getUndomanager().canRedo());
        }
        catch (CannotRedoException cre) {
            cre.printStackTrace();
        }
    }

    protected static String fileToString(String filePath) {
        BufferedReader reader = null;
        StringBuffer fileData = null;
        try {
            fileData = new StringBuffer(1000);
            reader = new BufferedReader(new FileReader(filePath));
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                fileData.append(readData);
                buf = new char[1024];
            }
            return fileData.toString();
        }
        catch (IOException ex) {
            System.out.println("Eccezione in readFileAsString: " + ex.toString());
            return null;
        }
    }

    void paste(MyGraphPinScene scene, Point point) {
        File file = new File(this.prj.getProjectFolder() + "Copia");
        try {
            String paste = ClipBoard.getClipboard();
            File filepaste = new File(this.prj.getProjectFolder() + "Copia");
            if (filepaste.exists()) {
                filepaste.delete();
            }
            FileWriter out = new FileWriter(filepaste);
            out.write(paste);
            out.close();
            SceneSerializer.deserializeCopy(this.prj, scene, file, point, true);
            file.delete();
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            JOptionPane.showMessageDialog(null, "Impossibile incollare. Selezionare prima un blocco da copiare.", "Error", 0);
        }
    }

    @Override
    public void sceneEventOccurred(SceneEvent evt) {
        if (evt.getEventType().equals("Scene Perform Undo")) {
            if (this.getUndomanager().canUndo()) {
                this.undo();
            }
        } else if (evt.getEventType().equals("Scene Perform Redo")) {
            if (this.getUndomanager().canRedo()) {
                this.redo();
            }
        } else if (evt.getEventType().equals("Scene Copy")) {
            if (this.isSubSystem) {
                Widget wdg = (Widget)evt.getEventObject();
                this.copySystem(wdg, this.scene);
            }
        } else if (evt.getEventType().equals("Scene Paste")) {
            this.paste(this.subSystemScene, new Point(0, 0));
        }
    }

    public UndoManager getUndomanager() {
        return this.undomanager;
    }

    void resetUndo() {
        this.undomanager.discardAllEdits();
        this.scenepop.menuUndo.setEnabled(false);
        this.scenepop.menuRedo.setEnabled(false);
    }
}

