/*
 * Decompiled with CFR 0.152.
 */
package nodes;

import java.awt.Component;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import nodes.CommonDefinitions;
import nodes.devices.GenericNode;

public class ProjectTreeRenderer
extends DefaultTreeCellRenderer {
    private Icon rootIcon = this.createImageIcon("resources/package_system.png");
    private Icon deviceIcon = this.createImageIcon("resources/preferences-desktop.png");
    private Icon subsystemIcon = this.createImageIcon("resources/hdd_mount.png");

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (leaf) {
            return this;
        }
        if (row == 0) {
            this.setIcon(this.rootIcon);
        } else if (this.isSubsystem(value)) {
            this.setIcon(this.subsystemIcon);
        } else {
            this.setIcon(this.deviceIcon);
        }
        return this;
    }

    private boolean isSubsystem(Object value) {
        try {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            GenericNode gn = (GenericNode)node.getUserObject();
            if (gn.getBlockType().equals((Object)CommonDefinitions.blockTypes.Subsystem)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected ImageIcon createImageIcon(String path) {
        URL imgURL = this.getClass().getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }
}

