/*
 * Decompiled with CFR 0.152.
 */
package nodes;

import VisiProg.AppOptions;
import VisiProg.VisiProgAboutBox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.ListIterator;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import nodes.AFONodeWidget;
import nodes.AFOSystemManager;
import nodes.BoardsTypesAndDescription;
import nodes.CommonDefinitions;
import nodes.MyGraphPinScene;
import nodes.Project;
import nodes.devices.AfoTimer;
import nodes.devices.DeviceNode;
import nodes.devices.DiDoNode;
import nodes.devices.DipSwitchNode;
import nodes.devices.GenericNode;
import nodes.devices.IModbusNode;
import nodes.devices.LimitNode;
import nodes.devices.ModbusNode;
import nodes.devices.MonitorNode;
import nodes.devices.MonitorNode_2;
import nodes.devices.SubSystemIONode;
import nodes.devices.UniversalInputNode;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Widget;
import org.openide.util.Exceptions;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import sceneManager.AFOEdge;
import sceneManager.AFONode;
import sceneManager.AFOPin;

public class SceneSerializer {
    private static BoardsTypesAndDescription.BoardType boardType;
    private static String version;
    private static String nOfNodes;
    private static String type;
    private static String subtype;
    private static String comm;
    private static String elemID;
    private static String[] splittedEvent;
    private static final String PROJECT_ELEMENT = "Project";
    private static final String COPY_ELEMENT = "Copy";
    private static final String SCENE_ELEMENT = "Scene";
    private static final String VERSION_ATTR = "version";
    public static final String NOFNODES_ATTR = "totalNOfNodes";
    private static final String SCENE_NODE_COUNTER_ATTR = "nodeIDcounter";
    private static final String SCENE_EDGE_COUNTER_ATTR = "edgeIDcounter";
    private static final String SCENE_SUBSYSTEM_COUNTER_ATTR = "subSystemIDCounter";
    private static final String SCENE_COMMON_PROPERTIES = "CommonProperties";
    private static final String NODE_ELEMENT = "Node";
    private static final String NODE_TYPE = "type";
    public static final String NODE_SUBTYPE = "subType";
    private static final String NODE_ID_ATTR = "id";
    private static final String NODE_X_ATTR = "x";
    private static final String NODE_Y_ATTR = "y";
    public static final String NODE_DRIVER_ID = "driverID";
    private static final String NODE_MAIN_VAL = "mainVal";
    private static final String NODE_SEC_VAL = "secVal";
    private static final String NODE_ADDRESS = "address";
    private static final String NODE_COMMENT = "comment";
    private static final String SUBSYSTEM_NAME = "subSystemName";
    private static final String SUBSYSTEM_ID = "subSystemID";
    private static final String EDGE_ELEMENT = "Edge";
    private static final String EDGE_ID_ATTR = "id";
    private static final String EDGE_SOURCE_NODE = "sourceNode";
    private static final String EDGE_SOURCE_PIN = "sourcePin";
    private static final String EDGE_TARGET_NODE = "targetNode";
    private static final String EDGE_TARGET_PIN = "targetPin";
    private static final String EDGE_CONTROLPOINT = "controlPoint";
    private static final String EDGE_COLOR = "color";
    private static final String VERSION_VALUE_1;
    public static int subSystemNumber;
    private static Locale currentLocale;
    private static ResourceBundle message;
    private static AppOptions options;
    private static DefaultTableModel position;
    private static JTable jtablePosition;
    private static DefaultTableModel modeltable;
    private static JTable jtable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serialize(Project project, MyGraphPinScene scene, File file, boolean isExportAction) {
        options.LoadOptions();
        currentLocale = new Locale(SceneSerializer.options.language, SceneSerializer.options.country);
        message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", currentLocale);
        Document document = XMLUtil.createDocument((String)PROJECT_ELEMENT, null, null, null);
        try {
            Element sceneElement;
            if (!scene.getManager().isSubSystem()) {
                Element timerElement = document.createElement("Timers");
                SceneSerializer.setAttribute(document, timerElement, "nOfTimers", new Integer(project.getTimerList().size()).toString());
                for (int timer = 0; timer < project.getTimerList().size(); ++timer) {
                    project.getTimerList().get(timer).serialize(document, timerElement);
                }
                document.getFirstChild().appendChild(timerElement);
                sceneElement = document.createElement(SCENE_ELEMENT);
                document.getFirstChild().appendChild(sceneElement);
                SceneSerializer.setAttribute(document, sceneElement, VERSION_ATTR, VERSION_VALUE_1);
                SceneSerializer.setAttribute(document, sceneElement, SCENE_NODE_COUNTER_ATTR, Long.toString(scene.nodeIDcounter));
                SceneSerializer.setAttribute(document, sceneElement, SCENE_EDGE_COUNTER_ATTR, Long.toString(scene.edgeIDcounter));
                SceneSerializer.setAttribute(document, sceneElement, NOFNODES_ATTR, "" + project.getNofBlocks());
                SceneSerializer.setAttribute(document, sceneElement, SCENE_SUBSYSTEM_COUNTER_ATTR, Long.toString(project.getNextSubSystemID()));
                Element commonProperties = document.createElement(SCENE_COMMON_PROPERTIES);
                project.serialize(document, commonProperties);
                sceneElement.appendChild(commonProperties);
            } else {
                sceneElement = document.createElement(SCENE_ELEMENT);
                document.getFirstChild().appendChild(sceneElement);
                SceneSerializer.setAttribute(document, sceneElement, VERSION_ATTR, VERSION_VALUE_1);
                SceneSerializer.setAttribute(document, sceneElement, SCENE_NODE_COUNTER_ATTR, Long.toString(scene.nodeIDcounter));
                SceneSerializer.setAttribute(document, sceneElement, SCENE_EDGE_COUNTER_ATTR, Long.toString(scene.edgeIDcounter));
                SceneSerializer.setAttribute(document, sceneElement, SCENE_SUBSYSTEM_COUNTER_ATTR, Long.toString(project.getNextSubSystemID()));
            }
            Collection nodeList = scene.getNodes();
            Object[] sortedAddress = nodeList.toArray();
            Arrays.sort(sortedAddress);
            for (int i = 0; i < sortedAddress.length; ++i) {
                AFONode node = (AFONode)sortedAddress[i];
                Element nodeElement = document.createElement(NODE_ELEMENT);
                SceneSerializer.setAttribute(document, nodeElement, "id", node.getId());
                SceneSerializer.setAttribute(document, nodeElement, NODE_TYPE, node.getBlockType().toString());
                SceneSerializer.setAttribute(document, nodeElement, NODE_COMMENT, node.getComment());
                if (node instanceof DeviceNode) {
                    SceneSerializer.setAttribute(document, nodeElement, NODE_DRIVER_ID, ((DeviceNode)node).getDeviceID());
                    SceneSerializer.setAttribute(document, nodeElement, NODE_ADDRESS, ((GenericNode)node).getAddressList().get(0).toString());
                    if (node instanceof DiDoNode) {
                        ((DiDoNode)node).serializeNode(document, nodeElement);
                    } else if (node instanceof UniversalInputNode) {
                        ((UniversalInputNode)node).serializeNode(document, nodeElement);
                    } else if (node instanceof ModbusNode) {
                        ((ModbusNode)node).serializeNode(document, nodeElement);
                    } else if (node instanceof MonitorNode) {
                        ((MonitorNode)node).serializeNode(document, nodeElement);
                    } else if (node instanceof MonitorNode_2) {
                        ((MonitorNode_2)node).serializeNode(document, nodeElement);
                    } else if (node instanceof DipSwitchNode) {
                        ((DipSwitchNode)node).serializeNode(document, nodeElement);
                    } else {
                        node.serializeNode(document, nodeElement);
                    }
                } else if (node instanceof SubSystemIONode) {
                    AFOPin parentPin = ((SubSystemIONode)node).getParentPin();
                    AFOSystemManager manager = scene.getManager();
                    Integer parentPinIdx = manager.getPinList().indexOf(parentPin);
                    SceneSerializer.setAttribute(document, nodeElement, "parentPINIdx", parentPinIdx.toString());
                } else if (node.getBlockType().equals((Object)CommonDefinitions.blockTypes.Subsystem)) {
                    String subSystemName = "SubSystem" + subSystemNumber;
                    int nPOS = file.getAbsolutePath().lastIndexOf(File.separatorChar) + 1;
                    String subSystemFileName = file.getAbsolutePath().substring(0, nPOS) + subSystemName;
                    SceneSerializer.setAttribute(document, nodeElement, SUBSYSTEM_NAME, subSystemName);
                    ++subSystemNumber;
                    subSystemFileName = subSystemFileName + ".sub";
                    File subSystemFile = new File(subSystemFileName);
                    AFOSystemManager subSystemManager = null;
                    for (int subSystemIndex = 0; subSystemIndex < project.getSubSystemList().size(); ++subSystemIndex) {
                        if (project.getSubSystemList().get(subSystemIndex).getParentNode() != node) continue;
                        subSystemManager = project.getSubSystemList().get(subSystemIndex);
                        break;
                    }
                    if (subSystemManager == null) {
                        JOptionPane.showMessageDialog(null, message.getString("errsavess") + message.getString("errfindss"));
                        return;
                    }
                    SceneSerializer.setAttribute(document, nodeElement, SUBSYSTEM_ID, subSystemManager.getSubSystemID());
                    SceneSerializer.setAttribute(document, nodeElement, "frameWidth", new Integer(subSystemManager.getForm().getWidth()).toString());
                    SceneSerializer.setAttribute(document, nodeElement, "frameHeight", new Integer(subSystemManager.getForm().getHeight()).toString());
                    SceneSerializer.setAttribute(document, nodeElement, "frameX", new Integer(subSystemManager.getForm().getLocation().x).toString());
                    SceneSerializer.setAttribute(document, nodeElement, "frameY", new Integer(subSystemManager.getForm().getLocation().y).toString());
                    if (!isExportAction) {
                        subSystemManager.setFileName(subSystemFileName);
                    }
                    SceneSerializer.serialize(project, subSystemManager.getSubSystemScene(), subSystemFile, isExportAction);
                } else if (node.getBlockType().ordinal() >= CommonDefinitions.blockTypes.IF.ordinal()) {
                    if (((GenericNode)node).getAddressSpace() > 0) {
                        SceneSerializer.setAttribute(document, nodeElement, NODE_ADDRESS, ((GenericNode)node).getAddressList().get(0).toString());
                    }
                    switch (node.getBlockType()) {
                        case Arithmetic: 
                        case IF: {
                            try {
                                nodeElement = node.serializeNode(document, nodeElement);
                                SceneSerializer.setAttribute(document, nodeElement, NODE_SUBTYPE, node.getSubType().toString());
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            break;
                        }
                        case Logic: 
                        case BinaryEncoder: 
                        case Mux: {
                            try {
                                nodeElement = node.serializeNode(document, nodeElement);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            break;
                        }
                        case Gate: 
                        case Trigger: {
                            SceneSerializer.setAttribute(document, nodeElement, NODE_SUBTYPE, node.getSubType().toString());
                            break;
                        }
                        case Costant: {
                            nodeElement = node.serializeNode(document, nodeElement);
                            SceneSerializer.setAttribute(document, nodeElement, NODE_SUBTYPE, node.getBlockType().toString());
                            break;
                        }
                        case Hysteresys: {
                            try {
                                nodeElement = node.serializeNode(document, nodeElement);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            break;
                        }
                        case Limit: {
                            SceneSerializer.setAttribute(document, nodeElement, NODE_SUBTYPE, node.getBlockType().toString());
                            SceneSerializer.setAttribute(document, nodeElement, NODE_MAIN_VAL, ((LimitNode)node).getUpperLimit());
                            SceneSerializer.setAttribute(document, nodeElement, NODE_SEC_VAL, ((LimitNode)node).getLowerLimit());
                            break;
                        }
                        default: {
                            try {
                                nodeElement = node.serializeNode(document, nodeElement);
                                break;
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                }
                Widget widget = scene.findWidget(node);
                Point location = widget.getPreferredLocation();
                SceneSerializer.setAttribute(document, nodeElement, NODE_X_ATTR, Integer.toString(location.x));
                SceneSerializer.setAttribute(document, nodeElement, NODE_Y_ATTR, Integer.toString(location.y));
                sceneElement.appendChild(nodeElement);
            }
            Collection edgeList = scene.getEdges();
            Object[] sortedEdges = edgeList.toArray();
            for (int i = 0; i < sortedEdges.length; ++i) {
                Color c;
                AFOPin targetPin;
                AFONode targetNode;
                AFOEdge edge = (AFOEdge)sortedEdges[i];
                Element edgeElement = document.createElement(EDGE_ELEMENT);
                SceneSerializer.setAttribute(document, edgeElement, "id", edge.getId());
                AFOPin sourcePin = (AFOPin)scene.getEdgeSource(edge);
                AFONode sourceNode = (AFONode)scene.getPinNode(sourcePin);
                if (sourceNode != null) {
                    SceneSerializer.setAttribute(document, edgeElement, EDGE_SOURCE_NODE, sourceNode.getId());
                    SceneSerializer.setAttribute(document, edgeElement, EDGE_SOURCE_PIN, "" + sourceNode.getPinList().indexOf(sourcePin));
                    ConnectionWidget conn = (ConnectionWidget)scene.findWidget(edge);
                    ListIterator iterator = conn.getControlPoints().listIterator();
                    while (iterator.hasNext()) {
                        Point ctrlPt = (Point)iterator.next();
                        Element controlEl = document.createElement(EDGE_CONTROLPOINT);
                        controlEl.setAttribute(NODE_X_ATTR, new Integer(ctrlPt.x).toString());
                        controlEl.setAttribute(NODE_Y_ATTR, new Integer(ctrlPt.y).toString());
                        edgeElement.appendChild(controlEl);
                    }
                }
                if ((targetNode = (AFONode)scene.getPinNode(targetPin = (AFOPin)scene.getEdgeTarget(edge))) != null) {
                    SceneSerializer.setAttribute(document, edgeElement, EDGE_TARGET_NODE, targetNode.getId());
                    SceneSerializer.setAttribute(document, edgeElement, EDGE_TARGET_PIN, "" + targetNode.getPinList().indexOf(targetPin));
                }
                if ((c = edge.getColor()) == null) {
                    c = Color.BLUE;
                }
                SceneSerializer.setAttribute(document, edgeElement, EDGE_COLOR, "" + c.getRGB());
                sceneElement.appendChild(edgeElement);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, message.getString("errgen") + " " + ex.toString());
            return;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            XMLUtil.write((Document)document, (OutputStream)fos, (String)"UTF-8");
            project.projectDirty = false;
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    public static void deserializeVersion(File file, boolean doImport) throws Exception {
        Node rootNode = SceneSerializer.getRootNode(file);
        for (Node xmlNode : SceneSerializer.getChildNode(rootNode)) {
            if (!xmlNode.getNodeName().equals(SCENE_ELEMENT)) continue;
            version = SceneSerializer.getAttributeValue(xmlNode, VERSION_ATTR);
            if (version == null) {
                version = "1.0.0";
            }
            if ((nOfNodes = SceneSerializer.getAttributeValue(xmlNode, NOFNODES_ATTR)) != null) continue;
            nOfNodes = "-1";
        }
    }

    public static String getVersion() {
        return version;
    }

    public static int getNofBlocks() {
        try {
            return Integer.parseInt(nOfNodes);
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public static void deserializeType(File file, boolean doImport) throws Exception {
        Node rootNode = SceneSerializer.getRootNode(file);
        for (Node xmlNode : SceneSerializer.getChildNode(rootNode)) {
            if (!xmlNode.getNodeName().equals(SCENE_ELEMENT)) continue;
            for (Node element : SceneSerializer.getChildNode(xmlNode)) {
                if (!SCENE_COMMON_PROPERTIES.equals(element.getNodeName())) continue;
                String brdType = SceneSerializer.getAttributeValue(element, "BoardType");
                if (brdType == null) {
                    boardType = BoardsTypesAndDescription.BoardType.mPID9MX;
                } else {
                    for (BoardsTypesAndDescription.BoardType bt : BoardsTypesAndDescription.BoardType.values()) {
                        if (!bt.toString().equals(brdType)) continue;
                        boardType = bt;
                        break;
                    }
                }
                if (boardType != null) continue;
                boardType = BoardsTypesAndDescription.BoardType.mPID9MX;
            }
        }
    }

    public static BoardsTypesAndDescription.BoardType getTypeSerialized() {
        return boardType;
    }

    public static void deserialize(Project project, MyGraphPinScene scene, File file, boolean doImport) throws Exception {
        SceneSerializer.deserializeScene(project, scene, file, doImport);
        SceneSerializer.deserializeTimers(project, scene, file);
    }

    public static void deserializePreviousVersion(Project project, MyGraphPinScene scene, File file, boolean doImport) throws Exception {
        SceneSerializer.deserializeTimers(project, scene, file);
    }

    public static boolean deserializeScene(Project project, MyGraphPinScene scene, File file, boolean doImport) throws Exception {
        ArrayList<IONodeTempData> ioList = new ArrayList<IONodeTempData>();
        try {
            AFOSystemManager systemManager = scene.getManager();
            Node rootNode = SceneSerializer.getRootNode(file);
            System.out.println("Apertura file:" + file.toString());
            if (rootNode == null) {
                return false;
            }
            for (Node xmlNode : SceneSerializer.getChildNode(rootNode)) {
                if (!xmlNode.getNodeName().equals(SCENE_ELEMENT)) continue;
                scene.nodeIDcounter = Long.parseLong(SceneSerializer.getAttributeValue(xmlNode, SCENE_NODE_COUNTER_ATTR));
                scene.edgeIDcounter = Long.parseLong(SceneSerializer.getAttributeValue(xmlNode, SCENE_EDGE_COUNTER_ATTR));
                long nextID = Long.parseLong(SceneSerializer.getAttributeValue(xmlNode, SCENE_SUBSYSTEM_COUNTER_ATTR)) + 1L;
                if (nextID > project.getNextSubSystemID()) {
                    project.setNextSubSystemID(nextID);
                }
                for (Node element : SceneSerializer.getChildNode(xmlNode)) {
                    Integer address;
                    if (SCENE_COMMON_PROPERTIES.equals(element.getNodeName())) {
                        project.deserialize(element);
                        continue;
                    }
                    if (!NODE_ELEMENT.equals(element.getNodeName())) continue;
                    String nodeId = SceneSerializer.getAttributeValue(element, "id");
                    String nodeType = SceneSerializer.getAttributeValue(element, NODE_TYPE);
                    String nodeSubType = SceneSerializer.getAttributeValue(element, NODE_SUBTYPE);
                    if (nodeSubType == null) {
                        nodeSubType = CommonDefinitions.subBlockStrings[CommonDefinitions.subBlockTypes.NONE.ordinal()];
                    }
                    int x = Integer.parseInt(SceneSerializer.getAttributeValue(element, NODE_X_ATTR));
                    int y = Integer.parseInt(SceneSerializer.getAttributeValue(element, NODE_Y_ATTR));
                    if (nodeType.equals(CommonDefinitions.blockTypes.IN.toString()) || nodeType.equals(CommonDefinitions.blockTypes.OUT.toString())) {
                        IONodeTempData data = new IONodeTempData();
                        data.id = SceneSerializer.getAttributeValue(element, "id");
                        data.names[0] = SceneSerializer.getAttributeValue(element, NODE_TYPE);
                        data.names[1] = SceneSerializer.getAttributeValue(element, NODE_COMMENT);
                        data.position = new Point(x, y);
                        data.pinIdx = Integer.parseInt(SceneSerializer.getAttributeValue(element, "parentPINIdx"));
                        ioList.add(data);
                        continue;
                    }
                    if (nodeType.equals(CommonDefinitions.blockTypes.Subsystem.toString())) {
                        String subSystemID = SceneSerializer.getAttributeValue(element, SUBSYSTEM_ID);
                        if (systemManager.isSubSystem()) {
                            project.addSubSystem(systemManager, new Point(x, y), nodeId);
                        } else {
                            project.addSubSystem(new Point(x, y), nodeId);
                        }
                        int lastNodeIdx = systemManager.getNodeListSize() - 1;
                        AFONode node = systemManager.getNodeList().get(lastNodeIdx);
                        node.setComment(SceneSerializer.getAttributeValue(element, NODE_COMMENT));
                        try {
                            scene.validate();
                        }
                        catch (ConcurrentModificationException ex) {
                            // empty catch block
                        }
                        int subSystemSize = project.getSubSystemList().size();
                        AFOSystemManager newSystemManager = project.getSubSystemList().get(subSystemSize - 1);
                        int nPOS = file.getAbsolutePath().lastIndexOf(File.separatorChar) + 1;
                        String subSystemFileName = file.getAbsolutePath().substring(0, nPOS) + SceneSerializer.getAttributeValue(element, SUBSYSTEM_NAME) + ".sub";
                        File subSystemFile = new File(subSystemFileName);
                        if (!SceneSerializer.deserializeScene(project, newSystemManager.getSubSystemScene(), subSystemFile, doImport)) continue;
                        int frameX = Integer.parseInt(SceneSerializer.getAttributeValue(element, "frameX"));
                        int frameY = Integer.parseInt(SceneSerializer.getAttributeValue(element, "frameY"));
                        int width = Integer.parseInt(SceneSerializer.getAttributeValue(element, "frameWidth"));
                        int height = Integer.parseInt(SceneSerializer.getAttributeValue(element, "frameHeight"));
                        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                        if (frameX < dim.width && frameY < dim.height) {
                            newSystemManager.getForm().setSize(new Dimension(width, height));
                            newSystemManager.getForm().setLocation(frameX, frameY);
                        }
                        if (!doImport) {
                            newSystemManager.setFileName(subSystemFileName);
                            continue;
                        }
                        newSystemManager.setFileName("");
                        continue;
                    }
                    String[] elementTypes = new String[]{nodeType, nodeSubType};
                    try {
                        address = Integer.parseInt(SceneSerializer.getAttributeValue(element, NODE_ADDRESS));
                    }
                    catch (Exception ex) {
                        address = Integer.MAX_VALUE;
                    }
                    if (doImport) {
                        if (!systemManager.addElementToSystem(elementTypes, new Point(x, y), nodeId, null, false, false)) {
                            return false;
                        }
                    } else if (!systemManager.addElementToSystem(elementTypes, new Point(x, y), nodeId, address, false, true)) continue;
                    int lastNodeIdx = systemManager.getNodeListSize() - 1;
                    AFONode node = systemManager.getNodeList().get(lastNodeIdx);
                    node.setComment(SceneSerializer.getAttributeValue(element, NODE_COMMENT));
                    System.out.println("Deserializzo Nodo: " + node.getBlockType().toString() + " -- Indirizzo: " + address);
                    try {
                        scene.validate();
                    }
                    catch (ConcurrentModificationException e) {
                        // empty catch block
                    }
                    if (node.getBlockType().ordinal() >= CommonDefinitions.blockTypes.IF.ordinal()) {
                        switch (node.getBlockType()) {
                            case Costant: {
                                node.deserializeNode(element);
                                break;
                            }
                            case Hysteresys: {
                                try {
                                    node.deserializeNode(element);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                                break;
                            }
                            case Limit: {
                                ((LimitNode)node).setUpperLimit(SceneSerializer.getAttributeValue(element, NODE_MAIN_VAL));
                                ((LimitNode)node).setLowerLimit(SceneSerializer.getAttributeValue(element, NODE_SEC_VAL));
                                ((AFONodeWidget)node.getWidget()).setSubType(SceneSerializer.getAttributeValue(element, NODE_SEC_VAL) + "-" + SceneSerializer.getAttributeValue(element, NODE_MAIN_VAL));
                                break;
                            }
                            default: {
                                try {
                                    node.deserializeNode(element);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                                break;
                            }
                        }
                        continue;
                    }
                    if (!(node instanceof DeviceNode)) continue;
                    node.deserializeNode(element);
                }
            }
            if (ioList.size() > 0) {
                Collections.sort(ioList);
                for (int i = 0; i < ioList.size(); ++i) {
                    systemManager.addElementToSystem(((IONodeTempData)ioList.get((int)i)).names, ((IONodeTempData)ioList.get((int)i)).position, ((IONodeTempData)ioList.get((int)i)).id, null, false, true);
                    int lastNodeIdx = systemManager.getNodeListSize() - 1;
                    AFONode node = systemManager.getNodeList().get(lastNodeIdx);
                    node.setComment(((IONodeTempData)ioList.get((int)i)).names[1]);
                    if (((IONodeTempData)ioList.get((int)i)).names[1].equals("Comment")) continue;
                    ((SubSystemIONode)node).getParentPin().getPinNameWidget().setLabel(((IONodeTempData)ioList.get((int)i)).names[1]);
                }
            }
            for (Node xmlNode : SceneSerializer.getChildNode(rootNode)) {
                if (!xmlNode.getNodeName().equals(SCENE_ELEMENT)) continue;
                for (Node element : SceneSerializer.getChildNode(xmlNode)) {
                    Color c;
                    String tempNodeID;
                    int i;
                    if (!EDGE_ELEMENT.equals(element.getNodeName())) continue;
                    String edge = SceneSerializer.getAttributeValue(element, "id");
                    AFONode sourceNode = null;
                    AFONode targetNode = null;
                    String sourceNodeID = SceneSerializer.getAttributeValue(element, EDGE_SOURCE_NODE);
                    String targetNodeID = SceneSerializer.getAttributeValue(element, EDGE_TARGET_NODE);
                    for (i = 0; i < systemManager.getNodeListSize(); ++i) {
                        tempNodeID = systemManager.getNodeList().get(i).getId();
                        if (!tempNodeID.equals(sourceNodeID)) continue;
                        sourceNode = systemManager.getNodeList().get(i);
                        break;
                    }
                    for (i = 0; i < systemManager.getNodeListSize(); ++i) {
                        tempNodeID = systemManager.getNodeList().get(i).getId();
                        if (!tempNodeID.equals(targetNodeID)) continue;
                        targetNode = systemManager.getNodeList().get(i);
                        break;
                    }
                    if (targetNode == null || sourceNode == null) {
                        return false;
                    }
                    int sourcePinIdx = new Integer(SceneSerializer.getAttributeValue(element, EDGE_SOURCE_PIN));
                    if (sourcePinIdx >= sourceNode.getPinList().size()) {
                        JOptionPane.showMessageDialog(null, "Indice del pin sorgente maggiore del numero pin del nodo sorgente (" + sourceNode.toString() + ")");
                        continue;
                    }
                    AFOPin sourcePin = sourceNode.getPinList().get(sourcePinIdx);
                    int targetPinIdx = new Integer(SceneSerializer.getAttributeValue(element, EDGE_TARGET_PIN));
                    if (targetPinIdx >= targetNode.getPinList().size()) {
                        JOptionPane.showMessageDialog(null, "Indice del pin destinazione maggiore del numero pin del nodo destinazione (" + targetNode.toString() + ")");
                        continue;
                    }
                    AFOPin targetPin = targetNode.getPinList().get(targetPinIdx);
                    int colorRGB = 0;
                    try {
                        colorRGB = new Integer(SceneSerializer.getAttributeValue(element, EDGE_COLOR));
                        c = new Color(colorRGB);
                    }
                    catch (Exception ex) {
                        c = Color.BLUE;
                    }
                    AFOEdge newEdge = new AFOEdge(edge, edge, null);
                    newEdge.setColor(c);
                    scene.setEdgeColor(c);
                    scene.addEdge(newEdge);
                    scene.setEdgeSource(newEdge, sourcePin);
                    scene.setEdgeTarget(newEdge, targetPin);
                    ArrayList<Point> ctrlPointsList = new ArrayList<Point>();
                    for (Node controlNode : SceneSerializer.getChildNode(element)) {
                        if (!controlNode.getNodeName().equalsIgnoreCase(EDGE_CONTROLPOINT)) continue;
                        int x = Integer.parseInt(SceneSerializer.getAttributeValue(controlNode, NODE_X_ATTR));
                        int y = Integer.parseInt(SceneSerializer.getAttributeValue(controlNode, NODE_Y_ATTR));
                        ctrlPointsList.add(new Point(x, y));
                    }
                    ConnectionWidget conn = (ConnectionWidget)scene.findWidget(newEdge);
                    conn.setControlPoints(ctrlPointsList, true);
                    conn.setRoutingPolicy(ConnectionWidget.RoutingPolicy.UPDATE_END_POINTS_ONLY);
                    try {
                        scene.validate();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    scene.setEdgeColor(Color.BLUE);
                }
            }
            scene.validate();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    private static void deserializeTimers(Project project, MyGraphPinScene scene, File file) throws Exception {
        Node rootNode = SceneSerializer.getRootNode(file);
        for (Node xmlNode : SceneSerializer.getChildNode(rootNode)) {
            if (!xmlNode.getNodeName().equals("Timers")) continue;
            for (Node element : SceneSerializer.getChildNode(xmlNode)) {
                if (!element.getNodeName().equalsIgnoreCase("Clock")) continue;
                String timerID = SceneSerializer.getAttributeValue(element, "id");
                AfoTimer timer = new AfoTimer(Integer.parseInt(timerID), "Clock " + timerID, project.getKernel(), project);
                timer.getTimerPanel();
                timer.deserialize(element);
                project.addTimer(timer);
            }
        }
    }

    public static void setAttribute(Document xml, Node node, String name, String value) {
        NamedNodeMap map = node.getAttributes();
        Attr attribute = xml.createAttribute(name);
        attribute.setValue(value);
        map.setNamedItem(attribute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Node getRootNode(File file) {
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            factory.setFeature("http://xml.org/sax/features/namespaces", false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(is));
            Node node = doc.getFirstChild();
            return node;
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        return null;
    }

    public static String getAttributeValue(Node node, String attr) {
        try {
            NamedNodeMap map;
            if (node != null && (map = node.getAttributes()) != null && (node = map.getNamedItem(attr)) != null) {
                return node.getNodeValue();
            }
        }
        catch (DOMException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return null;
    }

    public static Node[] getChildNode(Node node) {
        Node[] nodes = new Node[1];
        try {
            NodeList childNodes = node.getChildNodes();
            nodes = new Node[childNodes != null ? childNodes.getLength() : 0];
            for (int i = 0; i < nodes.length; ++i) {
                nodes[i] = childNodes.item(i);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serializeCopy(Project project, MyGraphPinScene scene, AFONode nodes, File file) throws FileNotFoundException {
        Document document = XMLUtil.createDocument((String)COPY_ELEMENT, null, null, null);
        Element sceneElement = document.createElement(SCENE_ELEMENT);
        document.getFirstChild().appendChild(sceneElement);
        SceneSerializer.setAttribute(document, sceneElement, VERSION_ATTR, VERSION_VALUE_1);
        SceneSerializer.setAttribute(document, sceneElement, SCENE_NODE_COUNTER_ATTR, Long.toString(scene.nodeIDcounter));
        SceneSerializer.setAttribute(document, sceneElement, SCENE_EDGE_COUNTER_ATTR, Long.toString(scene.edgeIDcounter));
        SceneSerializer.setAttribute(document, sceneElement, SCENE_SUBSYSTEM_COUNTER_ATTR, Long.toString(project.getNextSubSystemID()));
        AFONode node = nodes;
        Element nodeElement = document.createElement(NODE_ELEMENT);
        SceneSerializer.setAttribute(document, nodeElement, "id", node.getId());
        SceneSerializer.setAttribute(document, nodeElement, NODE_TYPE, node.getBlockType().toString());
        SceneSerializer.setAttribute(document, nodeElement, NODE_COMMENT, node.getComment());
        if (node instanceof DeviceNode) {
            SceneSerializer.setAttribute(document, nodeElement, NODE_DRIVER_ID, ((DeviceNode)node).getDeviceID());
            SceneSerializer.setAttribute(document, nodeElement, NODE_ADDRESS, ((GenericNode)node).getAddressList().get(0).toString());
            if (node instanceof DiDoNode) {
                try {
                    ((DiDoNode)node).serializeNode(document, nodeElement);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else if (node instanceof UniversalInputNode) {
                try {
                    ((UniversalInputNode)node).serializeNode(document, nodeElement);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else if (node instanceof ModbusNode) {
                try {
                    ((ModbusNode)node).serializeNode(document, nodeElement);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else if (node instanceof IModbusNode) {
                try {
                    ((IModbusNode)node).serializeNode(document, nodeElement);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else if (node instanceof MonitorNode) {
                try {
                    ((MonitorNode)node).serializeNode(document, nodeElement);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else if (node instanceof MonitorNode_2) {
                try {
                    ((MonitorNode_2)node).serializeNode(document, nodeElement);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                try {
                    node.serializeNode(document, nodeElement);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        } else if (node instanceof SubSystemIONode) {
            AFOPin parentPin = ((SubSystemIONode)node).getParentPin();
            AFOSystemManager manager = scene.getManager();
            Integer parentPinIdx = manager.getPinList().indexOf(parentPin);
            SceneSerializer.setAttribute(document, nodeElement, "parentPINIdx", parentPinIdx.toString());
        } else if (node.getBlockType().equals((Object)CommonDefinitions.blockTypes.Subsystem)) {
            String subSystemName = "SubSystem" + subSystemNumber;
            int nPOS = file.getAbsolutePath().lastIndexOf(File.separatorChar) + 1;
            String subSystemFileName = file.getAbsolutePath().substring(0, nPOS) + subSystemName;
            SceneSerializer.setAttribute(document, nodeElement, SUBSYSTEM_NAME, subSystemName);
            ++subSystemNumber;
            subSystemFileName = subSystemFileName + ".sub";
            File subSystemFile = new File(subSystemFileName);
            AFOSystemManager subSystemManager = null;
            for (int subSystemIndex = 0; subSystemIndex < project.getSubSystemList().size(); ++subSystemIndex) {
                if (project.getSubSystemList().get(subSystemIndex).getParentNode() != node) continue;
                subSystemManager = project.getSubSystemList().get(subSystemIndex);
                break;
            }
            if (subSystemManager == null) {
                JOptionPane.showMessageDialog(null, message.getString("errsavess") + message.getString("errfindss"));
                return;
            }
            SceneSerializer.setAttribute(document, nodeElement, SUBSYSTEM_ID, subSystemManager.getSubSystemID());
            SceneSerializer.setAttribute(document, nodeElement, "frameWidth", new Integer(subSystemManager.getForm().getPreferredSize().width).toString());
            SceneSerializer.setAttribute(document, nodeElement, "frameHeight", new Integer(subSystemManager.getForm().getPreferredSize().height).toString());
            SceneSerializer.setAttribute(document, nodeElement, "frameX", new Integer(subSystemManager.getForm().getLocation().x).toString());
            SceneSerializer.setAttribute(document, nodeElement, "frameY", new Integer(subSystemManager.getForm().getLocation().y).toString());
            SceneSerializer.serialize(project, subSystemManager.getSubSystemScene(), subSystemFile, false);
        } else if (node.getBlockType().ordinal() >= CommonDefinitions.blockTypes.IF.ordinal()) {
            if (((GenericNode)node).getAddressSpace() > 0) {
                SceneSerializer.setAttribute(document, nodeElement, NODE_ADDRESS, ((GenericNode)node).getAddressList().get(0).toString());
            }
            switch (node.getBlockType()) {
                case Arithmetic: {
                    try {
                        nodeElement = node.serializeNode(document, nodeElement);
                        SceneSerializer.setAttribute(document, nodeElement, NODE_SUBTYPE, node.getSubType().toString());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    break;
                }
                case Logic: {
                    try {
                        nodeElement = node.serializeNode(document, nodeElement);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    break;
                }
                case IF: 
                case Mux: 
                case Gate: 
                case Trigger: {
                    SceneSerializer.setAttribute(document, nodeElement, NODE_SUBTYPE, node.getSubType().toString());
                    break;
                }
                case Costant: {
                    try {
                        nodeElement = node.serializeNode(document, nodeElement);
                        SceneSerializer.setAttribute(document, nodeElement, NODE_SUBTYPE, node.getBlockType().toString());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    break;
                }
                case Hysteresys: {
                    try {
                        nodeElement = node.serializeNode(document, nodeElement);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    break;
                }
                case Limit: {
                    SceneSerializer.setAttribute(document, nodeElement, NODE_SUBTYPE, node.getBlockType().toString());
                    SceneSerializer.setAttribute(document, nodeElement, NODE_MAIN_VAL, ((LimitNode)node).getUpperLimit());
                    SceneSerializer.setAttribute(document, nodeElement, NODE_SEC_VAL, ((LimitNode)node).getLowerLimit());
                    break;
                }
                default: {
                    try {
                        nodeElement = node.serializeNode(document, nodeElement);
                        break;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        Widget widget = scene.findWidget(node);
        Point location = widget.getPreferredLocation();
        SceneSerializer.setAttribute(document, nodeElement, NODE_X_ATTR, Integer.toString(location.x));
        SceneSerializer.setAttribute(document, nodeElement, NODE_Y_ATTR, Integer.toString(location.y));
        sceneElement.appendChild(nodeElement);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            XMLUtil.write((Document)document, (OutputStream)fos, (String)"UTF-8");
            project.projectDirty = false;
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    static boolean deserializeCopy(Project prj, MyGraphPinScene scene, File file, Point point, boolean doImport) {
        Point pointPosition = new Point();
        ArrayList<IONodeTempData> ioList = new ArrayList<IONodeTempData>();
        SceneSerializer.deserializePoint(prj, scene, file, point, doImport);
        try {
            AFOSystemManager systemManager = scene.getManager();
            Node rootNode = SceneSerializer.getRootNode(file);
            JTable jtable2 = new JTable(0, 2);
            DefaultTableModel table = (DefaultTableModel)jtable2.getModel();
            for (Node xmlNode : SceneSerializer.getChildNode(rootNode)) {
                if (!xmlNode.getNodeName().equals(SCENE_ELEMENT)) continue;
                long nextID = scene.nodeIDcounter + 1L;
                if (nextID > prj.getNextSubSystemID()) {
                    prj.setNextSubSystemID(nextID);
                }
                for (Node element : SceneSerializer.getChildNode(xmlNode)) {
                    Integer address;
                    if (SCENE_COMMON_PROPERTIES.equals(element.getNodeName())) {
                        prj.deserialize(element);
                        continue;
                    }
                    if (!NODE_ELEMENT.equals(element.getNodeName())) continue;
                    String nodeId = "node" + Long.toString(++scene.nodeIDcounter);
                    String nodeIdOld = SceneSerializer.getAttributeValue(element, "id");
                    Object[] riga = new String[]{nodeIdOld, nodeId};
                    table.addRow(riga);
                    jtable2.setModel(table);
                    String nodeType = SceneSerializer.getAttributeValue(element, NODE_TYPE);
                    String nodeSubType = SceneSerializer.getAttributeValue(element, NODE_SUBTYPE);
                    if (nodeSubType == null) {
                        nodeSubType = CommonDefinitions.subBlockStrings[CommonDefinitions.subBlockTypes.NONE.ordinal()];
                    }
                    int x = Integer.parseInt(SceneSerializer.getAttributeValue(element, NODE_X_ATTR));
                    int y = Integer.parseInt(SceneSerializer.getAttributeValue(element, NODE_Y_ATTR));
                    if (nodeType.equals(CommonDefinitions.blockTypes.IN.toString()) || nodeType.equals(CommonDefinitions.blockTypes.OUT.toString())) {
                        IONodeTempData data = new IONodeTempData();
                        data.id = nodeId;
                        data.names[0] = SceneSerializer.getAttributeValue(element, NODE_TYPE);
                        data.names[1] = SceneSerializer.getAttributeValue(element, NODE_COMMENT);
                        data.position = point;
                        data.pinIdx = Integer.parseInt(SceneSerializer.getAttributeValue(element, "parentPINIdx"));
                        ioList.add(data);
                        continue;
                    }
                    if (nodeType.equals(CommonDefinitions.blockTypes.Subsystem.toString())) {
                        String subSystemID = SceneSerializer.getAttributeValue(element, SUBSYSTEM_ID);
                        for (int ser = 0; ser < modeltable.getRowCount(); ++ser) {
                            if (!Integer.toString(x).equals(modeltable.getValueAt(ser, 0)) || !Integer.toString(y).equals(modeltable.getValueAt(ser, 1))) continue;
                            int xposition = point.x + (Integer.parseInt(position.getValueAt(ser, 0).toString()) - Integer.parseInt(position.getValueAt(0, 0).toString()));
                            int yposition = point.y + (Integer.parseInt(position.getValueAt(ser, 1).toString()) - Integer.parseInt(position.getValueAt(0, 1).toString()));
                            pointPosition = new Point();
                            pointPosition.x = xposition;
                            pointPosition.y = yposition;
                        }
                        if (systemManager.isSubSystem()) {
                            prj.addSubSystem(systemManager, pointPosition, null);
                        } else {
                            prj.addSubSystem(pointPosition, null);
                        }
                        int lastNodeIdx = systemManager.getNodeListSize() - 1;
                        AFONode node = systemManager.getNodeList().get(lastNodeIdx);
                        node.setComment(SceneSerializer.getAttributeValue(element, NODE_COMMENT));
                        try {
                            scene.validate();
                        }
                        catch (ConcurrentModificationException ex) {
                            // empty catch block
                        }
                        int subSystemSize = prj.getSubSystemList().size();
                        AFOSystemManager newSystemManager = prj.getSubSystemList().get(subSystemSize - 1);
                        int nPOS = file.getAbsolutePath().lastIndexOf(File.separatorChar) + 1;
                        String subSystemFileName = file.getAbsolutePath().substring(0, nPOS) + SceneSerializer.getAttributeValue(element, SUBSYSTEM_NAME) + ".sub";
                        File subSystemFile = new File(subSystemFileName);
                        if (!SceneSerializer.deserializeScene(prj, newSystemManager.getSubSystemScene(), subSystemFile, doImport)) {
                            return false;
                        }
                        int frameX = Integer.parseInt(SceneSerializer.getAttributeValue(element, "frameX"));
                        int frameY = Integer.parseInt(SceneSerializer.getAttributeValue(element, "frameY"));
                        int width = Integer.parseInt(SceneSerializer.getAttributeValue(element, "frameWidth"));
                        int height = Integer.parseInt(SceneSerializer.getAttributeValue(element, "frameHeight"));
                        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                        if (frameX < dim.width && frameY < dim.height) {
                            newSystemManager.getForm().setSize(new Dimension(width, height));
                            newSystemManager.getForm().setLocation(frameX, frameY);
                        }
                        if (!doImport) {
                            newSystemManager.setFileName(subSystemFileName);
                            continue;
                        }
                        newSystemManager.setFileName("");
                        continue;
                    }
                    String[] elementTypes = new String[]{nodeType, nodeSubType};
                    try {
                        address = Integer.parseInt(SceneSerializer.getAttributeValue(element, NODE_ADDRESS));
                    }
                    catch (Exception ex) {
                        address = Integer.MAX_VALUE;
                    }
                    for (int ser = 0; ser < modeltable.getRowCount(); ++ser) {
                        if (!Integer.toString(x).equals(modeltable.getValueAt(ser, 0)) || !Integer.toString(y).equals(modeltable.getValueAt(ser, 1))) continue;
                        int xposition2 = point.x + (Integer.parseInt(modeltable.getValueAt(ser, 0).toString()) - Integer.parseInt(modeltable.getValueAt(0, 0).toString()));
                        int yposition2 = point.y + (Integer.parseInt(modeltable.getValueAt(ser, 1).toString()) - Integer.parseInt(modeltable.getValueAt(0, 1).toString()));
                        pointPosition = new Point();
                        pointPosition.x = xposition2;
                        pointPosition.y = yposition2;
                    }
                    if (doImport) {
                        systemManager.addElementToSystem(elementTypes, pointPosition, nodeId, null, false, false);
                        System.out.println(pointPosition.x + " " + pointPosition.y);
                    } else if (!systemManager.addElementToSystem(elementTypes, pointPosition, nodeId, address, false, true)) {
                        return false;
                    }
                    int lastNodeIdx = systemManager.getNodeListSize() - 1;
                    AFONode node = systemManager.getNodeList().get(lastNodeIdx);
                    node.setComment(SceneSerializer.getAttributeValue(element, NODE_COMMENT));
                    try {
                        scene.validate();
                    }
                    catch (ConcurrentModificationException e) {
                        // empty catch block
                    }
                    if (node.getBlockType().ordinal() >= CommonDefinitions.blockTypes.IF.ordinal()) {
                        switch (node.getBlockType()) {
                            case Costant: {
                                node.deserializeNode(element);
                                break;
                            }
                            case Hysteresys: {
                                try {
                                    node.deserializeNode(element);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                                break;
                            }
                            case Limit: {
                                ((LimitNode)node).setUpperLimit(SceneSerializer.getAttributeValue(element, NODE_MAIN_VAL));
                                ((LimitNode)node).setLowerLimit(SceneSerializer.getAttributeValue(element, NODE_SEC_VAL));
                                ((AFONodeWidget)node.getWidget()).setSubType(SceneSerializer.getAttributeValue(element, NODE_SEC_VAL) + "-" + SceneSerializer.getAttributeValue(element, NODE_MAIN_VAL));
                                break;
                            }
                            default: {
                                try {
                                    node.deserializeNode(element);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                                break;
                            }
                        }
                        continue;
                    }
                    if (!(node instanceof DeviceNode)) continue;
                    node.deserializeNode(element);
                }
            }
            if (ioList.size() > 0) {
                Collections.sort(ioList);
                for (int i = 0; i < ioList.size(); ++i) {
                    systemManager.addElementToSystem(((IONodeTempData)ioList.get((int)i)).names, ((IONodeTempData)ioList.get((int)i)).position, ((IONodeTempData)ioList.get((int)i)).id, null, false, true);
                    int lastNodeIdx = systemManager.getNodeListSize() - 1;
                    AFONode node = systemManager.getNodeList().get(lastNodeIdx);
                    node.setComment(((IONodeTempData)ioList.get((int)i)).names[1]);
                    if (((IONodeTempData)ioList.get((int)i)).names[1].equals("Comment")) continue;
                    ((SubSystemIONode)node).getParentPin().getPinNameWidget().setLabel(((IONodeTempData)ioList.get((int)i)).names[1]);
                }
            }
            for (Node xmlNode : SceneSerializer.getChildNode(rootNode)) {
                if (!xmlNode.getNodeName().equals(SCENE_ELEMENT)) continue;
                for (Node element : SceneSerializer.getChildNode(xmlNode)) {
                    Color c;
                    String tempNodeID;
                    int i;
                    if (!EDGE_ELEMENT.equals(element.getNodeName())) continue;
                    String edgeOld = SceneSerializer.getAttributeValue(element, "id");
                    String edge = "edge" + Long.toString(++scene.edgeIDcounter);
                    AFONode sourceNode = null;
                    AFONode targetNode = null;
                    String sourceNodeIDOld = SceneSerializer.getAttributeValue(element, EDGE_SOURCE_NODE);
                    String targetNodeIDOld = SceneSerializer.getAttributeValue(element, EDGE_TARGET_NODE);
                    String sourceNodeID = "";
                    String targetNodeID = "";
                    for (int riga2 = 0; riga2 < table.getRowCount(); ++riga2) {
                        if (table.getValueAt(riga2, 0).equals(sourceNodeIDOld)) {
                            sourceNodeID = table.getValueAt(riga2, 1).toString();
                            continue;
                        }
                        if (!table.getValueAt(riga2, 0).equals(targetNodeIDOld)) continue;
                        targetNodeID = table.getValueAt(riga2, 1).toString();
                    }
                    for (i = 0; i < systemManager.getNodeListSize(); ++i) {
                        tempNodeID = systemManager.getNodeList().get(i).getId();
                        if (!tempNodeID.equals(sourceNodeID)) continue;
                        sourceNode = systemManager.getNodeList().get(i);
                        break;
                    }
                    for (i = 0; i < systemManager.getNodeListSize(); ++i) {
                        tempNodeID = systemManager.getNodeList().get(i).getId();
                        if (!tempNodeID.equals(targetNodeID)) continue;
                        targetNode = systemManager.getNodeList().get(i);
                        break;
                    }
                    if (targetNode == null || sourceNode == null) {
                        return false;
                    }
                    int sourcePinIdx = new Integer(SceneSerializer.getAttributeValue(element, EDGE_SOURCE_PIN));
                    if (sourcePinIdx >= sourceNode.getPinList().size()) {
                        JOptionPane.showMessageDialog(null, "Indice del pin sorgente maggiore del numero pin del nodo sorgente (" + sourceNode.toString() + ")");
                        continue;
                    }
                    AFOPin sourcePin = sourceNode.getPinList().get(sourcePinIdx);
                    int targetPinIdx = new Integer(SceneSerializer.getAttributeValue(element, EDGE_TARGET_PIN));
                    if (targetPinIdx >= targetNode.getPinList().size()) {
                        JOptionPane.showMessageDialog(null, "Indice del pin destinazione maggiore del numero pin del nodo destinazione (" + targetNode.toString() + ")");
                        continue;
                    }
                    AFOPin targetPin = targetNode.getPinList().get(targetPinIdx);
                    int colorRGB = 0;
                    try {
                        colorRGB = new Integer(SceneSerializer.getAttributeValue(element, EDGE_COLOR));
                        c = new Color(colorRGB);
                    }
                    catch (Exception ex) {
                        c = Color.BLUE;
                    }
                    AFOEdge newEdge = new AFOEdge(edge, edge, null);
                    newEdge.setColor(c);
                    scene.setEdgeColor(c);
                    scene.addEdge(newEdge);
                    scene.setEdgeSource(newEdge, sourcePin);
                    scene.setEdgeTarget(newEdge, targetPin);
                    try {
                        scene.validate();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    scene.setEdgeColor(Color.BLUE);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    static void deserializePoint(Project prj, MyGraphPinScene scene, File file, Point point, boolean doImport) {
        int i;
        ArrayList ioList = new ArrayList();
        int[] vec = null;
        AFOSystemManager systemManager = scene.getManager();
        Node rootNode = SceneSerializer.getRootNode(file);
        jtablePosition = new JTable(0, 2);
        position = (DefaultTableModel)jtablePosition.getModel();
        jtable = new JTable(0, 2);
        modeltable = (DefaultTableModel)jtable.getModel();
        for (Node xmlNode : SceneSerializer.getChildNode(rootNode)) {
            if (!xmlNode.getNodeName().equals(SCENE_ELEMENT)) continue;
            for (Node element : SceneSerializer.getChildNode(xmlNode)) {
                if (SCENE_COMMON_PROPERTIES.equals(element.getNodeName())) {
                    try {
                        prj.deserialize(element);
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    continue;
                }
                if (!NODE_ELEMENT.equals(element.getNodeName())) continue;
                int x = Integer.parseInt(SceneSerializer.getAttributeValue(element, NODE_X_ATTR));
                int y = Integer.parseInt(SceneSerializer.getAttributeValue(element, NODE_Y_ATTR));
                System.out.println(x);
                System.out.println(y);
                Object[] rigaposition = new String[]{Integer.toString(x), Integer.toString(y)};
                position.addRow(rigaposition);
            }
        }
        vec = new int[position.getRowCount()];
        for (i = 0; i < position.getRowCount(); ++i) {
            System.out.println(position.getRowCount());
            System.out.println(i);
            System.out.println(position.getValueAt(i, 0));
            vec[i] = Integer.parseInt(position.getValueAt(i, 0).toString());
            System.out.println(vec[i]);
        }
        for (i = 0; i < vec.length; ++i) {
            System.out.print(vec[i] + " ");
        }
        System.out.print("\r\n");
        Arrays.sort(vec);
        for (i = 0; i < vec.length; ++i) {
            System.out.print(vec[i] + " ");
        }
        System.out.print("\r\n");
        for (i = 0; i < vec.length; ++i) {
            System.out.print(vec[i] + " ");
        }
        System.out.print("\r\n");
        for (int y2 = 0; y2 < vec.length; ++y2) {
            for (int i2 = 0; i2 < position.getRowCount(); ++i2) {
                if (!Integer.toString(vec[y2]).equals(position.getValueAt(i2, 0))) continue;
                System.out.println(vec[y2]);
                Object[] valuetable = new String[2];
                valuetable[0] = position.getValueAt(i2, 0).toString();
                System.out.println(valuetable[0]);
                valuetable[1] = position.getValueAt(i2, 1).toString();
                System.out.println(valuetable[1]);
                modeltable.addRow(valuetable);
            }
        }
        for (int i3 = 0; i3 < modeltable.getRowCount() - 1; ++i3) {
            if (!modeltable.getValueAt(i3, 0).equals(modeltable.getValueAt(i3 + 1, 0)) || Integer.parseInt(modeltable.getValueAt(i3, 0).toString()) <= Integer.parseInt(modeltable.getValueAt(i3 + 1, 0).toString())) continue;
            System.out.println(modeltable.getValueAt(i3, 0) + " " + modeltable.getValueAt(i3 + 1, 0));
            modeltable.setValueAt(modeltable.getValueAt(i3 + 1, 1), i3, 1);
            modeltable.setValueAt(modeltable.getValueAt(i3, 1), i3 + 1, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void serializeCopy2(Project project, MyGraphPinScene scene, File file, ArrayList<AFONode> nodeList, ArrayList<AFOEdge> edgeList, boolean isExportAction) {
        Element sceneElement;
        Document document = XMLUtil.createDocument((String)PROJECT_ELEMENT, null, null, null);
        if (!scene.getManager().isSubSystem()) {
            Element timerElement = document.createElement("Timers");
            SceneSerializer.setAttribute(document, timerElement, "nOfTimers", new Integer(project.getTimerList().size()).toString());
            for (int timer = 0; timer < project.getTimerList().size(); ++timer) {
                try {
                    project.getTimerList().get(timer).serialize(document, timerElement);
                    continue;
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            document.getFirstChild().appendChild(timerElement);
            sceneElement = document.createElement(SCENE_ELEMENT);
            document.getFirstChild().appendChild(sceneElement);
            SceneSerializer.setAttribute(document, sceneElement, VERSION_ATTR, VERSION_VALUE_1);
            SceneSerializer.setAttribute(document, sceneElement, SCENE_NODE_COUNTER_ATTR, Long.toString(scene.nodeIDcounter));
            SceneSerializer.setAttribute(document, sceneElement, SCENE_EDGE_COUNTER_ATTR, Long.toString(scene.edgeIDcounter));
            SceneSerializer.setAttribute(document, sceneElement, SCENE_SUBSYSTEM_COUNTER_ATTR, Long.toString(project.getNextSubSystemID()));
            Element commonProperties = document.createElement(SCENE_COMMON_PROPERTIES);
            project.serialize(document, commonProperties);
            sceneElement.appendChild(commonProperties);
        } else {
            sceneElement = document.createElement(SCENE_ELEMENT);
            document.getFirstChild().appendChild(sceneElement);
            SceneSerializer.setAttribute(document, sceneElement, VERSION_ATTR, VERSION_VALUE_1);
            SceneSerializer.setAttribute(document, sceneElement, SCENE_NODE_COUNTER_ATTR, Long.toString(scene.nodeIDcounter));
            SceneSerializer.setAttribute(document, sceneElement, SCENE_EDGE_COUNTER_ATTR, Long.toString(scene.edgeIDcounter));
            SceneSerializer.setAttribute(document, sceneElement, SCENE_SUBSYSTEM_COUNTER_ATTR, Long.toString(project.getNextSubSystemID()));
        }
        Object[] sortedAddress = nodeList.toArray();
        Arrays.sort(sortedAddress);
        for (int i = 0; i < sortedAddress.length; ++i) {
            AFONode node = (AFONode)sortedAddress[i];
            Element nodeElement = document.createElement(NODE_ELEMENT);
            SceneSerializer.setAttribute(document, nodeElement, "id", node.getId());
            SceneSerializer.setAttribute(document, nodeElement, NODE_TYPE, node.getBlockType().toString());
            SceneSerializer.setAttribute(document, nodeElement, NODE_COMMENT, node.getComment());
            if (node instanceof DeviceNode) {
                SceneSerializer.setAttribute(document, nodeElement, NODE_DRIVER_ID, ((DeviceNode)node).getDeviceID());
                SceneSerializer.setAttribute(document, nodeElement, NODE_ADDRESS, ((GenericNode)node).getAddressList().get(0).toString());
                if (node instanceof DiDoNode) {
                    try {
                        ((DiDoNode)node).serializeNode(document, nodeElement);
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else if (node instanceof UniversalInputNode) {
                    try {
                        ((UniversalInputNode)node).serializeNode(document, nodeElement);
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else if (node instanceof ModbusNode) {
                    try {
                        ((ModbusNode)node).serializeNode(document, nodeElement);
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else if (node instanceof MonitorNode) {
                    try {
                        ((MonitorNode)node).serializeNode(document, nodeElement);
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else if (node instanceof MonitorNode_2) {
                    try {
                        ((MonitorNode_2)node).serializeNode(document, nodeElement);
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            } else if (node instanceof SubSystemIONode) {
                AFOPin parentPin = ((SubSystemIONode)node).getParentPin();
                AFOSystemManager manager = scene.getManager();
                Integer parentPinIdx = manager.getPinList().indexOf(parentPin);
                SceneSerializer.setAttribute(document, nodeElement, "parentPINIdx", parentPinIdx.toString());
            } else if (node.getBlockType().equals((Object)CommonDefinitions.blockTypes.Subsystem)) {
                String subSystemName = "SubSystem" + subSystemNumber;
                int nPOS = file.getAbsolutePath().lastIndexOf(File.separatorChar) + 1;
                String subSystemFileName = file.getAbsolutePath().substring(0, nPOS) + subSystemName;
                SceneSerializer.setAttribute(document, nodeElement, SUBSYSTEM_NAME, subSystemName);
                ++subSystemNumber;
                subSystemFileName = subSystemFileName + ".sub";
                File subSystemFile = new File(subSystemFileName);
                AFOSystemManager subSystemManager = null;
                for (int subSystemIndex = 0; subSystemIndex < project.getSubSystemList().size(); ++subSystemIndex) {
                    if (project.getSubSystemList().get(subSystemIndex).getParentNode() != node) continue;
                    subSystemManager = project.getSubSystemList().get(subSystemIndex);
                    break;
                }
                if (subSystemManager == null) {
                    JOptionPane.showMessageDialog(null, message.getString("errsavess") + message.getString("errfindss"));
                    return;
                }
                if (!isExportAction) {
                    File oldFile = new File(subSystemManager.getFileName());
                    try {
                        if (oldFile.exists()) {
                            oldFile.delete();
                        }
                        if (!subSystemFile.exists()) {
                            subSystemFile.createNewFile();
                        } else {
                            subSystemFile.delete();
                            subSystemFile.createNewFile();
                        }
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(null, message.getString("errsavess") + iOException.getLocalizedMessage());
                        return;
                    }
                }
                SceneSerializer.setAttribute(document, nodeElement, SUBSYSTEM_ID, subSystemManager.getSubSystemID());
                SceneSerializer.setAttribute(document, nodeElement, "frameWidth", new Integer(subSystemManager.getForm().getPreferredSize().width).toString());
                SceneSerializer.setAttribute(document, nodeElement, "frameHeight", new Integer(subSystemManager.getForm().getPreferredSize().height).toString());
                SceneSerializer.setAttribute(document, nodeElement, "frameX", new Integer(subSystemManager.getForm().getLocation().x).toString());
                SceneSerializer.setAttribute(document, nodeElement, "frameY", new Integer(subSystemManager.getForm().getLocation().y).toString());
                if (!isExportAction) {
                    subSystemManager.setFileName(subSystemFileName);
                }
                SceneSerializer.serialize(project, subSystemManager.getSubSystemScene(), subSystemFile, isExportAction);
            } else if (node.getBlockType().ordinal() >= CommonDefinitions.blockTypes.IF.ordinal()) {
                if (((GenericNode)node).getAddressSpace() > 0) {
                    SceneSerializer.setAttribute(document, nodeElement, NODE_ADDRESS, ((GenericNode)node).getAddressList().get(0).toString());
                }
                switch (node.getBlockType()) {
                    case Arithmetic: {
                        try {
                            nodeElement = node.serializeNode(document, nodeElement);
                            SceneSerializer.setAttribute(document, nodeElement, NODE_SUBTYPE, node.getSubType().toString());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        break;
                    }
                    case Logic: {
                        try {
                            nodeElement = node.serializeNode(document, nodeElement);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        break;
                    }
                    case IF: 
                    case Mux: 
                    case Gate: 
                    case Trigger: {
                        SceneSerializer.setAttribute(document, nodeElement, NODE_SUBTYPE, node.getSubType().toString());
                        break;
                    }
                    case Costant: {
                        try {
                            nodeElement = node.serializeNode(document, nodeElement);
                            SceneSerializer.setAttribute(document, nodeElement, NODE_SUBTYPE, node.getBlockType().toString());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        break;
                    }
                    case Hysteresys: {
                        try {
                            nodeElement = node.serializeNode(document, nodeElement);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        break;
                    }
                    case Limit: {
                        SceneSerializer.setAttribute(document, nodeElement, NODE_SUBTYPE, node.getBlockType().toString());
                        SceneSerializer.setAttribute(document, nodeElement, NODE_MAIN_VAL, ((LimitNode)node).getUpperLimit());
                        SceneSerializer.setAttribute(document, nodeElement, NODE_SEC_VAL, ((LimitNode)node).getLowerLimit());
                        break;
                    }
                    default: {
                        try {
                            nodeElement = node.serializeNode(document, nodeElement);
                            break;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
            Widget widget = scene.findWidget(node);
            Point location = widget.getPreferredLocation();
            SceneSerializer.setAttribute(document, nodeElement, NODE_X_ATTR, Integer.toString(location.x));
            SceneSerializer.setAttribute(document, nodeElement, NODE_Y_ATTR, Integer.toString(location.y));
            sceneElement.appendChild(nodeElement);
        }
        Object[] sortedEdges = edgeList.toArray();
        for (int i = 0; i < sortedEdges.length; ++i) {
            Color c;
            AFOPin targetPin;
            AFONode targetNode;
            AFOEdge edge = (AFOEdge)sortedEdges[i];
            Element edgeElement = document.createElement(EDGE_ELEMENT);
            SceneSerializer.setAttribute(document, edgeElement, "id", edge.getId());
            AFOPin sourcePin = (AFOPin)scene.getEdgeSource(edge);
            AFONode sourceNode = (AFONode)scene.getPinNode(sourcePin);
            if (sourceNode != null) {
                SceneSerializer.setAttribute(document, edgeElement, EDGE_SOURCE_NODE, sourceNode.getId());
                SceneSerializer.setAttribute(document, edgeElement, EDGE_SOURCE_PIN, "" + sourceNode.getPinList().indexOf(sourcePin));
                ConnectionWidget conn = (ConnectionWidget)scene.findWidget(edge);
                ListIterator iterator = conn.getControlPoints().listIterator();
                while (iterator.hasNext()) {
                    Point ctrlPt = (Point)iterator.next();
                    Element controlEl = document.createElement(EDGE_CONTROLPOINT);
                    controlEl.setAttribute(NODE_X_ATTR, new Integer(ctrlPt.x).toString());
                    controlEl.setAttribute(NODE_Y_ATTR, new Integer(ctrlPt.y).toString());
                    edgeElement.appendChild(controlEl);
                }
            }
            if ((targetNode = (AFONode)scene.getPinNode(targetPin = (AFOPin)scene.getEdgeTarget(edge))) != null) {
                SceneSerializer.setAttribute(document, edgeElement, EDGE_TARGET_NODE, targetNode.getId());
                SceneSerializer.setAttribute(document, edgeElement, EDGE_TARGET_PIN, "" + targetNode.getPinList().indexOf(targetPin));
            }
            if ((c = edge.getColor()) == null) {
                c = Color.BLUE;
            }
            SceneSerializer.setAttribute(document, edgeElement, EDGE_COLOR, "" + c.getRGB());
            sceneElement.appendChild(edgeElement);
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            XMLUtil.write((Document)document, (OutputStream)fos, (String)"UTF-8");
            project.projectDirty = false;
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    static {
        VERSION_VALUE_1 = VisiProgAboutBox.getCurrentVersion();
        subSystemNumber = 1;
        options = new AppOptions();
    }

    private static class IONodeTempData
    implements Comparable {
        public String id;
        public String[] names = new String[2];
        public Point position;
        public int pinIdx;

        private IONodeTempData() {
        }

        public int compareTo(Object o) {
            IONodeTempData temp = (IONodeTempData)o;
            if (this.pinIdx == temp.pinIdx) {
                return 0;
            }
            if (this.pinIdx > temp.pinIdx) {
                return 1;
            }
            return -1;
        }
    }
}

