/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import VisiProg.AppOptions;
import connection.ICmd;
import connection.IKernel;
import connection.IKernelEventListener;
import connection.KernelEvent;
import connection.ProgramUploader;
import connection.SerialKernel;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import nodes.CommonDefinitions;
import nodes.Project;
import nodes.SceneSerializer;
import nodes.gui.PanelDevice;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AfoTimer
implements ActionListener,
PropertyChangeListener,
IKernelEventListener {
    private int num;
    private String name;
    private JSpinner[] digitalLevel;
    private JSpinner[] analogLevel;
    private JTable[] tzTable;
    private JButton[] insertButtonArray;
    private JButton[] deleteButtonArray;
    private JButton enableButton;
    private JButton btnUpdateTimerData;
    private JButton btnSendTimer;
    private JButton btnAddTimer;
    private final String[] DAYS = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private final String TIMER_NODE = "Clock";
    private final String LEVEL_NODE = "Level";
    JPanel timerPanel;
    private final int MAX_NUM_ZONES_PER_DAY = 5;
    private JButton[] copyButtonArray;
    private JButton[] copyAllButtonArray;
    private IKernel kernel;
    private boolean timerDirty = false;
    private final Project project;
    Locale currentLocale;
    ResourceBundle message;
    private AppOptions options = new AppOptions();
    private static Dimension boxdim = new Dimension(250, 450);
    PanelDevice mainLevelPanel;
    private DailyZoneList[] myTimer = new DailyZoneList[7];
    private LevelStruct[] levels = new LevelStruct[3];

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof JTable) {
            int index = 0;
            for (index = 0; index < 7 && !evt.getSource().equals(this.tzTable[index]); ++index) {
            }
            if (index == 7) {
                return;
            }
            if (evt.getPropertyName().equalsIgnoreCase("tableCellEditor")) {
                if (this.tzTable[index].getModel().getRowCount() <= 1) {
                    this.timerDirty = true;
                    return;
                }
                this.tzTable[index].getRowSorter().allRowsChanged();
                this.tzTable[index].invalidate();
            }
        }
        this.timerDirty = true;
    }

    public boolean isTimerDirty() {
        return this.timerDirty;
    }

    public void setTimerDirty(boolean timerDirty) {
        this.timerDirty = timerDirty;
    }

    private void addComponentEventListener() {
        for (int day = 0; day < 7; ++day) {
            this.tzTable[day].addPropertyChangeListener(this);
        }
        for (int i = 0; i < 3; ++i) {
            this.analogLevel[i].addPropertyChangeListener(this);
            this.digitalLevel[i].addPropertyChangeListener(this);
        }
    }

    private void removeComponentEventListener() {
        for (int day = 0; day < 7; ++day) {
            this.tzTable[day].removePropertyChangeListener(this);
        }
        for (int i = 0; i < 3; ++i) {
            this.analogLevel[i].removePropertyChangeListener(this);
            this.digitalLevel[i].removePropertyChangeListener(this);
        }
    }

    @Override
    public void kernelEventOccurred(KernelEvent evt) {
        if (evt.getEventType().equals("Kernel Disconnected")) {
            this.setConnectionStatus(false);
        } else if (evt.getEventType().equals("ETH Kernel Connected") || evt.getEventType().equals("Serial Kernel Connected")) {
            this.setConnectionStatus(true);
        }
    }

    public AfoTimer(int num, String name, IKernel kernel, Project prj) {
        this.name = name;
        this.num = num;
        this.kernel = kernel;
        this.project = prj;
        this.options.LoadOptions();
        this.currentLocale = new Locale(this.options.language, this.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        this.createDefaultTimer();
        this.createTimerPanel();
        this.setTimerPanelData();
        this.addComponentEventListener();
    }

    private void createDefaultTimer() {
        for (int i = 0; i < 7; ++i) {
            DailyZoneList dl = new DailyZoneList();
            dl.dailyZones = new ArrayList();
            ZoneStruct zs = new ZoneStruct();
            zs.ora = "00:00";
            zs.livello = "1";
            dl.dailyZones.add(zs);
            zs = new ZoneStruct();
            zs.ora = "23:30";
            zs.livello = "1";
            dl.dailyZones.add(zs);
            this.myTimer[i] = dl;
        }
        this.levels[0] = new LevelStruct();
        this.levels[0].analog = 0.0;
        this.levels[0].digital = 0;
        this.levels[1] = new LevelStruct();
        this.levels[1].analog = 10.0;
        this.levels[1].digital = 1;
        this.levels[2] = new LevelStruct();
        this.levels[2].analog = 20.0;
        this.levels[2].digital = 0;
    }

    public int getTimerID() {
        return this.num;
    }

    public void sortAllTables() {
        for (int i = 0; i < 7; ++i) {
            this.tzTable[i].setRowSorter(null);
            TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.tzTable[i].getModel());
            ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
            sortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
            sorter.setSortKeys(sortKeys);
            this.tzTable[i].setRowSorter(sorter);
        }
    }

    public void execCommand(ICmd cmd) {
        try {
            if (!cmd.getValue("TOKEN3").equals("" + this.num)) {
                return;
            }
            if (cmd.getValue("TOKEN4").equals("lev")) {
                for (int i = 0; i < 3; ++i) {
                    String level = cmd.getValue("TOKEN" + (5 + i));
                    int index = level.indexOf(45);
                    this.digitalLevel[i].setValue(Integer.parseInt(level.substring(0, index)));
                    this.analogLevel[i].setValue(Double.parseDouble(level.substring(index + 1)));
                    this.mainLevelPanel.validate();
                }
            } else if (cmd.getValue("TOKEN4").equals("day")) {
                int day = Integer.parseInt(cmd.getValue("TOKEN5"));
                int nOfZones = Integer.parseInt(cmd.getValue("TOKEN6"));
                DefaultTableModel tblModel = (DefaultTableModel)this.tzTable[day].getModel();
                this.cleanTable(tblModel);
                for (int zone = 0; zone < nOfZones; ++zone) {
                    String zoneStr = cmd.getValue("TOKEN" + (zone + 7));
                    String[] tzToken = zoneStr.split("-");
                    tblModel.addRow((Object[])new Object[0][]);
                    tblModel.setValueAt(tzToken[0].substring(0, 2) + ":" + tzToken[0].substring(2), zone, 0);
                    tblModel.setValueAt(tzToken[1], zone, 1);
                }
                this.sortAllTables();
                this.getTimerPanelData();
                this.timerDirty = false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getConfiguration() {
        this.sortAllTables();
        this.timerDirty = false;
        String retVal = "";
        retVal = retVal + "<BL tmr " + this.num + " set lev ";
        for (int i = 0; i < 3; ++i) {
            retVal = retVal + "" + this.digitalLevel[i].getValue().toString() + "-" + this.analogLevel[i].getValue().toString() + " ";
        }
        retVal = retVal + " >\r\n";
        for (int day = 0; day < 7; ++day) {
            retVal = retVal + "<BL tmr " + this.num + " set day " + day + " ";
            DefaultTableModel tableModel = (DefaultTableModel)this.tzTable[day].getModel();
            if (tableModel.getRowCount() == 0) {
                JOptionPane.showMessageDialog(null, this.message.getString("tabpiena") + " " + day + "  (" + CommonDefinitions.daysStrings[day] + ") " + this.message.getString("tabpiena2"));
                retVal = retVal + "2 0000-1 2359-1";
            } else {
                retVal = retVal + "" + tableModel.getRowCount() + " ";
                for (int row = 0; row < this.tzTable[day].getRowCount(); ++row) {
                    int rowModelIndex = this.tzTable[day].convertRowIndexToModel(row);
                    String hourStr = tableModel.getValueAt(rowModelIndex, 0).toString();
                    int columnPos = hourStr.indexOf(58);
                    if (columnPos < 0) {
                        JOptionPane.showMessageDialog(null, this.message.getString("errparam"));
                        return "";
                    }
                    retVal = retVal + hourStr.substring(0, columnPos) + hourStr.substring(columnPos + 1) + "-" + tableModel.getValueAt(rowModelIndex, 1).toString() + " ";
                }
                retVal = retVal.substring(0, retVal.length() - 1);
            }
            retVal = retVal + " >\r\n";
        }
        return retVal;
    }

    public String getName() {
        return this.name;
    }

    private void createTimerPanel() {
        this.timerPanel = new JPanel();
        GridLayout gl = new GridLayout(0, 3);
        gl.setHgap(5);
        gl.setVgap(5);
        this.timerPanel.setLayout(gl);
        this.timerPanel.add(this.createButtonPanel());
        this.timerPanel.add(this.createLevelPanel());
        this.createDayPanel(this.timerPanel);
    }

    public void restorePanelData() {
    }

    public JPanel getTimerPanel() {
        return this.timerPanel;
    }

    public void setEnabled(boolean b) {
        for (int i = 0; i < 7; ++i) {
            this.insertButtonArray[i].setEnabled(b);
            this.deleteButtonArray[i].setEnabled(b);
        }
        this.enableButton.setEnabled(b);
        this.btnUpdateTimerData.setEnabled(b);
        this.btnSendTimer.setEnabled(b);
        this.btnAddTimer.setEnabled(b);
    }

    private JPanel createButtonPanel() {
        PanelDevice buttonPanel = new PanelDevice(this.message.getString("com"), boxdim, 0);
        JPanel pd2 = new JPanel();
        this.btnUpdateTimerData = new JButton(this.message.getString("tim"));
        this.btnUpdateTimerData.setToolTipText(this.message.getString("timdata"));
        this.btnUpdateTimerData.addActionListener(this);
        this.btnUpdateTimerData.setEnabled(false);
        pd2.add(this.btnUpdateTimerData);
        JPanel pd3 = new JPanel();
        this.btnSendTimer = new JButton(this.message.getString("timsend"));
        this.btnSendTimer.setToolTipText(this.message.getString("timsend2"));
        this.btnSendTimer.addActionListener(this);
        this.btnSendTimer.setEnabled(false);
        pd3.add(this.btnSendTimer);
        buttonPanel.add(pd2);
        buttonPanel.add(pd3);
        return buttonPanel;
    }

    public void enableButtonPanel(boolean enable) {
        this.btnSendTimer.setEnabled(enable);
        this.btnUpdateTimerData.setEnabled(enable);
    }

    private JPanel createLevelPanel() {
        this.mainLevelPanel = new PanelDevice(this.message.getString("level"), new Dimension(200, 250), 0);
        this.digitalLevel = new JSpinner[3];
        this.analogLevel = new JSpinner[3];
        for (int level = 0; level < 3; ++level) {
            String panelName = this.message.getString("lev") + " ";
            panelName = panelName + (level + 1);
            PanelDevice levelPanel = new PanelDevice(panelName, new Dimension(200, 250), 0);
            JPanel pd = new JPanel();
            pd.setLayout(new FlowLayout(1));
            pd.add(new JLabel(this.message.getString("di")));
            this.digitalLevel[level] = new JSpinner(new SpinnerNumberModel(0, 0, 1, 1));
            pd.add(this.digitalLevel[level]);
            pd.add(new JLabel(this.message.getString("an")));
            this.analogLevel[level] = new JSpinner(new SpinnerNumberModel(0.0, -1000.0, 1000.0, 0.5));
            pd.add(this.analogLevel[level]);
            levelPanel.add(pd);
            this.mainLevelPanel.add(levelPanel);
        }
        this.digitalLevel[1].setValue(1);
        return this.mainLevelPanel;
    }

    private void createDayPanel(JPanel p) {
        Locale myLocale = Locale.getDefault();
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(myLocale);
        String[] dayNames = dateFormatSymbols.getWeekdays();
        this.tzTable = new JTable[7];
        this.insertButtonArray = new JButton[7];
        this.deleteButtonArray = new JButton[7];
        this.copyButtonArray = new JButton[7];
        this.copyAllButtonArray = new JButton[7];
        for (int i = 0; i < 7; ++i) {
            DefaultTableModel tzTableModel = new DefaultTableModel(new Object[0][], new String[]{"Hour", "Lev"});
            PanelDevice newDay = new PanelDevice(dayNames[i + 1], boxdim, 0);
            this.tzTable[i] = new JTable();
            this.tzTable[i].setModel(tzTableModel);
            this.setupTableColumns(this.tzTable[i]);
            JPanel pd = new JPanel();
            pd.setLayout(new FlowLayout(1));
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setPreferredSize(new Dimension(150, 200));
            scrollPane.setViewportView(this.tzTable[i]);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setPreferredSize(new Dimension(125, 200));
            this.insertButtonArray[i] = new JButton(this.message.getString("ins"));
            this.insertButtonArray[i].setActionCommand("Insert");
            this.insertButtonArray[i].addActionListener(this);
            buttonPanel.add(this.insertButtonArray[i]);
            this.deleteButtonArray[i] = new JButton(this.message.getString("el"));
            this.deleteButtonArray[i].setActionCommand("Delete");
            this.deleteButtonArray[i].addActionListener(this);
            buttonPanel.add(this.deleteButtonArray[i]);
            this.copyButtonArray[i] = new JButton(this.message.getString("cop"));
            this.copyButtonArray[i].setActionCommand("Copy Next");
            this.copyButtonArray[i].setToolTipText(this.message.getString("cop2"));
            this.copyButtonArray[i].addActionListener(this);
            buttonPanel.add(this.copyButtonArray[i]);
            Dimension dim = this.copyButtonArray[i].getPreferredSize();
            this.copyAllButtonArray[i] = new JButton(this.message.getString("copia"));
            this.copyAllButtonArray[i].setActionCommand("Copy All");
            this.copyButtonArray[i].setToolTipText(this.message.getString("copia2"));
            this.copyAllButtonArray[i].addActionListener(this);
            buttonPanel.add(this.copyAllButtonArray[i]);
            this.insertButtonArray[i].setPreferredSize(dim);
            this.deleteButtonArray[i].setPreferredSize(dim);
            this.copyAllButtonArray[i].setPreferredSize(dim);
            pd.add(buttonPanel);
            pd.add(scrollPane);
            newDay.add(pd);
            p.add(newDay);
        }
    }

    public void setTimerPanelData() {
        for (int day = 0; day < 7; ++day) {
            DefaultTableModel model = (DefaultTableModel)this.tzTable[day].getModel();
            while (model.getRowCount() > 0) {
                model.removeRow(0);
            }
            for (ZoneStruct zs : this.myTimer[day].dailyZones) {
                model.addRow(new Object[]{""});
                model.setValueAt(zs.ora, model.getRowCount() - 1, 0);
                model.setValueAt(zs.livello, model.getRowCount() - 1, 1);
            }
        }
        for (int i = 0; i < 3; ++i) {
            this.digitalLevel[i].setValue(this.levels[i].digital);
            this.analogLevel[i].setValue(this.levels[i].analog);
        }
        this.timerPanel.invalidate();
        this.sortAllTables();
        this.addComponentEventListener();
    }

    public void getTimerPanelData() {
        this.timerPanel.validate();
        for (int day = 0; day < 7; ++day) {
            DefaultTableModel model = (DefaultTableModel)this.tzTable[day].getModel();
            this.myTimer[day].dailyZones.clear();
            for (int zone = 0; zone < this.tzTable[day].getRowCount(); ++zone) {
                int modelIndex = this.tzTable[day].convertRowIndexToModel(zone);
                ZoneStruct zs = new ZoneStruct();
                zs.ora = (String)model.getValueAt(modelIndex, 0);
                zs.livello = (String)model.getValueAt(modelIndex, 1);
                this.myTimer[day].dailyZones.add(zs);
            }
        }
        for (int i = 0; i < 3; ++i) {
            this.levels[i].digital = (Integer)this.digitalLevel[i].getValue();
            this.levels[i].analog = (Double)this.analogLevel[i].getValue();
        }
        this.timerDirty = false;
    }

    public JTable[] getTzTable() {
        return (JTable[])this.tzTable.clone();
    }

    public JSpinner[] getAnalogLevels() {
        return (JSpinner[])this.analogLevel.clone();
    }

    public JSpinner[] getDigitalLevels() {
        return (JSpinner[])this.digitalLevel.clone();
    }

    private DefaultTableModel cloneTableModel(JTable tableToClone, JTable tableDest) {
        DefaultTableModel newModel = new DefaultTableModel(new Object[0][], new String[]{"Hour", "Lev"});
        this.cleanTable((DefaultTableModel)tableDest.getModel());
        DefaultTableModel modelToClone = (DefaultTableModel)tableToClone.getModel();
        tableDest.setModel(newModel);
        for (int i = 0; i < modelToClone.getRowCount(); ++i) {
            newModel.addRow(new Object[]{""});
            Object value = modelToClone.getValueAt(i, 0);
            newModel.setValueAt(value, i, 0);
            value = modelToClone.getValueAt(i, 1);
            newModel.setValueAt(value, i, 1);
        }
        newModel.fireTableDataChanged();
        this.setupTableColumns(tableDest);
        return newModel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase("Insert")) {
            int dayIndex = -1;
            for (int i = 0; i < 7; ++i) {
                if (this.insertButtonArray[i] != e.getSource()) continue;
                dayIndex = i;
                break;
            }
            if (dayIndex < 0) {
                return;
            }
            if (((DefaultTableModel)this.tzTable[dayIndex].getModel()).getRowCount() == 5) {
                JOptionPane.showMessageDialog(null, this.message.getString("zonemax"));
                return;
            }
            if (this.tzTable[dayIndex].getSelectedRow() >= 0) {
                ((DefaultTableModel)this.tzTable[dayIndex].getModel()).insertRow(this.tzTable[dayIndex].getSelectedRow(), new Object[]{""});
            } else if (this.tzTable[dayIndex].getRowCount() == 0) {
                ((DefaultTableModel)this.tzTable[dayIndex].getModel()).addRow(new Object[]{""});
            } else {
                return;
            }
            ((DefaultTableModel)this.tzTable[dayIndex].getModel()).fireTableDataChanged();
            this.tzTable[dayIndex].invalidate();
        } else if (e.getActionCommand().equalsIgnoreCase("Delete")) {
            int dayIndex = -1;
            for (int i = 0; i < 7; ++i) {
                if (this.deleteButtonArray[i] != e.getSource()) continue;
                dayIndex = i;
                break;
            }
            if (dayIndex < 0) {
                return;
            }
            if (this.tzTable[dayIndex].getSelectedRow() >= 0) {
                ((DefaultTableModel)this.tzTable[dayIndex].getModel()).removeRow(this.tzTable[dayIndex].getSelectedRow());
            }
        } else if (e.getActionCommand().equalsIgnoreCase("Copy Next")) {
            int dayIndex = -1;
            int nextDayIdx = -1;
            for (int i = 0; i < 7; ++i) {
                if (this.copyButtonArray[i] != e.getSource()) continue;
                dayIndex = i;
                break;
            }
            if (dayIndex < 0) {
                return;
            }
            nextDayIdx = (dayIndex + 1) % 7;
            this.tzTable[nextDayIdx].setRowSorter(null);
            this.cloneTableModel(this.tzTable[dayIndex], this.tzTable[nextDayIdx]);
            this.timerPanel.invalidate();
            this.sortAllTables();
        } else if (e.getActionCommand().equalsIgnoreCase("Copy All")) {
            int i;
            int dayIndex = -1;
            for (i = 0; i < 7; ++i) {
                if (this.copyAllButtonArray[i] != e.getSource()) continue;
                dayIndex = i;
                break;
            }
            this.removeComponentEventListener();
            if (dayIndex < 0) {
                return;
            }
            for (i = 0; i < 7; ++i) {
                this.tzTable[i].setRowSorter(null);
                if (i == dayIndex) continue;
                this.cloneTableModel(this.tzTable[dayIndex], this.tzTable[i]);
            }
            this.sortAllTables();
            this.timerPanel.validate();
            this.addComponentEventListener();
        } else if (e.getSource().equals(this.btnUpdateTimerData)) {
            if (this.kernel instanceof SerialKernel) {
                String msg = "<BL tmr " + this.num + " get >";
                this.kernel.sendCommand(msg);
            }
        } else if (e.getSource().equals(this.btnSendTimer)) {
            if (this.kernel instanceof SerialKernel) {
                this.sendTimer();
            }
        } else if (e.getActionCommand().equalsIgnoreCase("Add Timer") && this.kernel instanceof SerialKernel) {
            String msg = "<BL tmr " + this.num + " add >";
            this.kernel.sendCommand(msg);
            msg = "<BL save >";
            this.kernel.sendCommand(msg);
        }
    }

    private void setupTableColumns(JTable table) {
        TableColumn levelColumn = table.getColumnModel().getColumn(1);
        JComboBox<String> comboBox = new JComboBox<String>();
        comboBox.addItem("1");
        comboBox.addItem("2");
        comboBox.addItem("3");
        comboBox.setAlignmentX(0.5f);
        levelColumn.setCellEditor(new DefaultCellEditor(comboBox));
        TableColumn hourColumn = table.getColumnModel().getColumn(0);
        JComboBox<String> hourCombo = new JComboBox<String>();
        for (int hour = 0; hour < 24; ++hour) {
            for (int minute = 0; minute < 60; minute += 30) {
                hourCombo.addItem(String.format("%1$02d", hour) + ":" + String.format("%1$02d", minute));
            }
        }
        hourColumn.setCellEditor(new DefaultCellEditor(hourCombo));
    }

    private HashMap<String, String> createMap(String inputString) {
        HashMap<String, String> hm = new HashMap<String, String>();
        for (int pos = 0; pos < inputString.length(); ++pos) {
            while (inputString.charAt(pos) == ' ') {
                ++pos;
            }
            StringBuilder key = new StringBuilder();
            while (inputString.charAt(pos) != ':') {
                key.append(inputString.charAt(pos));
                ++pos;
            }
            ++pos;
            StringBuilder value = new StringBuilder();
            while (pos < inputString.length() && inputString.charAt(pos) != ',') {
                value.append(inputString.charAt(pos));
                ++pos;
            }
            hm.put(key.toString().trim(), value.toString().trim());
        }
        return hm;
    }

    public void deserialize(Node node) throws Exception {
        this.removeComponentEventListener();
        for (Node element : SceneSerializer.getChildNode(node)) {
            String attribute;
            if (element.getNodeName().equals("Level1")) {
                attribute = SceneSerializer.getAttributeValue(element, "Digital");
                this.levels[0].digital = Integer.parseInt(attribute);
                this.levels[0].analog = Double.parseDouble(SceneSerializer.getAttributeValue(element, "Analog"));
                continue;
            }
            if (element.getNodeName().equals("Level2")) {
                attribute = SceneSerializer.getAttributeValue(element, "Digital");
                this.levels[1].digital = Integer.parseInt(attribute);
                this.levels[1].analog = Double.parseDouble(SceneSerializer.getAttributeValue(element, "Analog"));
                continue;
            }
            if (element.getNodeName().equals("Level3")) {
                attribute = SceneSerializer.getAttributeValue(element, "Digital");
                this.levels[2].digital = Integer.parseInt(attribute);
                this.levels[2].analog = Double.parseDouble(SceneSerializer.getAttributeValue(element, "Analog"));
                continue;
            }
            int dayIndex = -1;
            for (int i = 0; i < 7; ++i) {
                if (!element.getNodeName().equals(this.DAYS[i])) continue;
                dayIndex = i;
                break;
            }
            if (dayIndex < 0) continue;
            this.myTimer[dayIndex].dailyZones.clear();
            for (Node dayInterval : SceneSerializer.getChildNode(element)) {
                if (!dayInterval.getNodeName().equalsIgnoreCase("interval")) continue;
                ZoneStruct zs = new ZoneStruct();
                zs.ora = SceneSerializer.getAttributeValue(dayInterval, "time");
                zs.livello = SceneSerializer.getAttributeValue(dayInterval, "level");
                this.myTimer[dayIndex].dailyZones.add(zs);
            }
        }
        this.setTimerPanelData();
        for (int i = 0; i < 7; ++i) {
            this.tzTable[i].invalidate();
        }
        this.addComponentEventListener();
    }

    public Element serialize(Document document, Element nodeElement) throws Exception {
        Element timerNode = document.createElement("Clock");
        SceneSerializer.setAttribute(document, timerNode, "id", new Integer(this.num).toString());
        for (int i = 1; i <= 3; ++i) {
            Element levelNode = document.createElement("Level" + i);
            SceneSerializer.setAttribute(document, levelNode, "Digital", this.levels[i - 1].digital.toString());
            SceneSerializer.setAttribute(document, levelNode, "Analog", Double.toString(this.levels[i - 1].analog));
            timerNode.appendChild(levelNode);
        }
        for (int day = 0; day < 7; ++day) {
            Element dayNode = document.createElement(this.DAYS[day]);
            for (ZoneStruct zs : this.myTimer[day].dailyZones) {
                Element intervalNode = document.createElement("Interval");
                SceneSerializer.setAttribute(document, intervalNode, "time", zs.ora);
                SceneSerializer.setAttribute(document, intervalNode, "level", zs.livello);
                dayNode.appendChild(intervalNode);
            }
            timerNode.appendChild(dayNode);
        }
        nodeElement.appendChild(timerNode);
        return nodeElement;
    }

    private void cleanTable(DefaultTableModel tableModel) {
        while (tableModel.getRowCount() > 0) {
            tableModel.removeRow(0);
        }
    }

    public void setKernel(IKernel aThis) {
        this.kernel = aThis;
        if (this.kernel != null) {
            this.kernel.addKernelEventListener(this);
        }
    }

    public void setConnectionStatus(boolean connected) {
    }

    public void sendTimer() {
        try {
            this.getTimerPanelData();
            String fileName = this.project.getProjectFolder() + "Clock" + this.num + ".txt";
            File timerFile = new File(fileName);
            String config = this.getConfiguration();
            String[] configSplit = config.split("\r\n");
            if (!timerFile.exists()) {
                timerFile.createNewFile();
            } else {
                timerFile.delete();
                timerFile.createNewFile();
            }
            FileWriter iniWriter = new FileWriter(timerFile);
            iniWriter.write(config);
            iniWriter.write("<BL save >");
            iniWriter.close();
            this.kernel.getTerminalDialog().setVisible(true);
            ProgramUploader pu = new ProgramUploader(fileName, this.kernel);
            pu.addKernelEventListener(this.kernel.getTerminalDialog().getPnlUpload());
            pu.start();
            for (int day = 0; day < 7; ++day) {
                DefaultTableModel tableModel = (DefaultTableModel)this.tzTable[day].getModel();
                if (tableModel.getRowCount() != 0) continue;
                JOptionPane.showMessageDialog(null, this.message.getString("table") + day + this.message.getString("table2"));
                tableModel.setNumRows(2);
                tableModel.setValueAt("00:00", 0, 0);
                tableModel.setValueAt("1", 0, 1);
                tableModel.setValueAt("23:30", 1, 0);
                tableModel.setValueAt("1", 1, 1);
                tableModel.fireTableDataChanged();
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, this.message.getString("errtimefile"), this.message.getString("er"), 0);
        }
    }

    class DailyZoneList {
        public ArrayList<ZoneStruct> dailyZones;

        DailyZoneList() {
        }
    }

    class LevelStruct {
        public Integer digital;
        public double analog;

        LevelStruct() {
        }
    }

    class ZoneStruct {
        public String ora;
        public String livello;

        ZoneStruct() {
        }
    }
}

