/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import connection.SerialKernel;
import javax.swing.JOptionPane;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.DeviceNode;
import nodes.devices.GenericNode;
import nodes.gui.SimplePropertiesDlg;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class AnalogNode
extends DeviceNode {
    private String type;
    public static final int ANALOG_OUT_ID = 4;
    public static final int ANALOG_IN_ID = 26;
    public String minValue = "0.0";
    public String maxValue = "10.0";

    public AnalogNode(String id, String label, String analogID, AFOGraphPinScene scene) {
        super(id, label, analogID, scene);
        this.type = label;
        if (this.type.equals(CommonDefinitions.blockTypes.AnalogIN.toString())) {
            this.propertiesDialog = new SimplePropertiesDlg(null, true, this.deviceID, this);
            ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.removeAllItems();
            ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.addItem(this.deviceID);
            ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.setSelectedIndex(0);
            ((SimplePropertiesDlg)this.propertiesDialog).jLabel3.setVisible(true);
            ((SimplePropertiesDlg)this.propertiesDialog).jLabel5.setVisible(true);
            ((SimplePropertiesDlg)this.propertiesDialog).txtMaxOut.setVisible(true);
            ((SimplePropertiesDlg)this.propertiesDialog).txtMinOut.setVisible(true);
            this.blockType = CommonDefinitions.blockTypes.AnalogIN;
            this.numberOfInputs = 0;
            this.setConnectionStatus(false);
            this.createWidget();
            this.addressSpace = 2;
            this.minValue = "0.0";
            this.maxValue = "10.0";
            this.codici.add("AnalogIN");
            this.codici.add("AnalogIN_Value");
            this.simDialog.tabbedPaneMain.remove(1);
            this.simDialog.tabbedPaneMain.setTitleAt(0, "Params");
        } else if (this.type.equals(CommonDefinitions.blockTypes.AnalogOUT.toString())) {
            this.propertiesDialog = new SimplePropertiesDlg(null, true, this.deviceID, this);
            ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.removeAllItems();
            ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.addItem(this.deviceID);
            ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.setSelectedIndex(0);
            ((SimplePropertiesDlg)this.propertiesDialog).chkBox.setVisible(true);
            ((SimplePropertiesDlg)this.propertiesDialog).chkBox.setText("Manual operation");
            this.blockType = CommonDefinitions.blockTypes.AnalogOUT;
            this.numberOfInputs = 1;
            this.setConnectionStatus(false);
            this.createWidget();
            this.addressSpace = 3;
            this.codici.add("AnalogOut");
            this.codici.add("AnalogOut_Value");
            this.codici.add("AnalogOut_Manual");
            this.simDialog.tabbedPaneMain.removeAll();
        }
        this.setList(this.codici);
    }

    public String getAddress() {
        String newAddress = ((SimplePropertiesDlg)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void createWidget() {
        AFOPin newPin;
        String pinID;
        String pinLabel;
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName(this.type);
        this.getScene().addNode(this);
        if (this.type.equals(CommonDefinitions.blockTypes.AnalogIN.toString())) {
            pinLabel = "IN";
            pinID = "pin" + ++this.scene.pinIDCounter;
            newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
            newPin.setAsBusPin(false);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            newPin.setPinIDString("OUT1");
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
        }
        if (this.type.equals(CommonDefinitions.blockTypes.AnalogOUT.toString())) {
            pinLabel = "OUT";
            pinID = "pin" + ++this.scene.pinIDCounter;
            newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
            newPin.setAsBusPin(false);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            newPin.setPinIDString("IN1");
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
        }
        ((AFONodeWidget)this.widget).setSubType(this.deviceID);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        this.requestData();
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.setSelectedItem(this.deviceID);
        ((SimplePropertiesDlg)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((SimplePropertiesDlg)this.propertiesDialog).indexLabel.setVisible(false);
        if (this.type.equals(CommonDefinitions.blockTypes.AnalogIN.toString())) {
            ((SimplePropertiesDlg)this.propertiesDialog).lblValue.setVisible(false);
            ((SimplePropertiesDlg)this.propertiesDialog).txtValue.setVisible(false);
            ((SimplePropertiesDlg)this.propertiesDialog).txtMaxOut.setVisible(true);
            ((SimplePropertiesDlg)this.propertiesDialog).txtMinOut.setVisible(true);
            ((SimplePropertiesDlg)this.propertiesDialog).txtMaxOut.setText(this.maxValue);
            ((SimplePropertiesDlg)this.propertiesDialog).txtMinOut.setText(this.minValue);
        }
        this.propertiesDialog.setVisible(true);
        if (((SimplePropertiesDlg)this.propertiesDialog).getReturnStatus() == 1 && ((SimplePropertiesDlg)this.propertiesDialog).fieldChanged) {
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.propertiesDialog.setVisible(false);
            this.scene.sceneChanged();
            this.deviceID = (String)((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.getSelectedItem();
            ((AFONodeWidget)this.widget).setSubType(this.deviceID);
            if (this.type.equals(CommonDefinitions.blockTypes.AnalogOUT.toString())) {
                this.addressList.set(0, Integer.parseInt(((SimplePropertiesDlg)this.propertiesDialog).txtAddress.getText()));
                ((SimplePropertiesDlg)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
                if (this.kernel != null && this.kernel instanceof SerialKernel) {
                    this.commandQueue.clear();
                    double valInt = 0.0;
                    String msg = "<BL set " + this.addressList.get(1) + " ";
                    String val = ((SimplePropertiesDlg)this.propertiesDialog).txtValue.getText();
                    valInt = Float.parseFloat(val);
                    if (valInt < 0.0) {
                        valInt = 0.0;
                        msg = msg + valInt;
                    } else if (valInt > 10.0) {
                        valInt = 10.0;
                        msg = msg + valInt;
                    } else {
                        msg = msg + val;
                    }
                    msg = msg + " >";
                    this.commandQueue.add(msg);
                    msg = "<BL set " + this.addressList.get(2) + " ";
                    msg = ((SimplePropertiesDlg)this.propertiesDialog).chkBox.isSelected() ? msg + "1" : msg + "0";
                    msg = msg + " >";
                    this.commandQueue.add(msg);
                    this.sendMessageQueue(true);
                }
            } else if (this.type.equals(CommonDefinitions.blockTypes.AnalogIN.toString())) {
                this.minValue = ((SimplePropertiesDlg)this.propertiesDialog).txtMinOut.getText();
                this.maxValue = ((SimplePropertiesDlg)this.propertiesDialog).txtMaxOut.getText();
                if (this.kernel != null && this.kernel instanceof SerialKernel) {
                    this.minValue = ((SimplePropertiesDlg)this.propertiesDialog).txtMinOut.getText();
                    this.maxValue = ((SimplePropertiesDlg)this.propertiesDialog).txtMaxOut.getText();
                    if (this.kernel != null && this.kernel instanceof SerialKernel) {
                        if (!this.sendingCommandQueue.booleanValue()) {
                            this.commandQueue.clear();
                            int offset = 2;
                            String msg = "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " " + this.minValue + " >";
                            this.commandQueue.add(msg);
                            msg = "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " " + this.maxValue + " >";
                            this.commandQueue.add(msg);
                            this.sendMessageQueue(true);
                        } else {
                            JOptionPane.showMessageDialog(null, "Another Send is in progress", "Warning", 2);
                        }
                    }
                }
            }
        }
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        if (this.type.equals(CommonDefinitions.blockTypes.AnalogIN.toString())) {
            int num = Integer.parseInt(this.deviceID.substring(this.deviceID.length() - 1)) - 1;
            retVal = retVal + "26 " + this.getCommonData() + num;
            retVal = retVal + " " + this.minValue + " " + this.maxValue;
        } else if (this.type.equals(CommonDefinitions.blockTypes.AnalogOUT.toString())) {
            int num = Integer.parseInt(this.deviceID.substring(this.deviceID.length() - 1)) - 1;
            retVal = retVal + "4 " + this.getCommonData() + num;
        }
        return retVal;
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        int msgAddr = 0;
        msgAddr = Integer.parseInt(cmd.getValue("ADDRESS"));
        if (msgAddr == (Integer)this.addressList.get(0)) {
            this.parseStandardBlockCmd(cmd);
            if (this.blockType.equals((Object)CommonDefinitions.blockTypes.AnalogOUT)) {
                String tempVal = cmd.getValue("OUT1");
                ((AFONodeWidget)this.widget).setSubType(this.deviceID + " -- Val: " + tempVal);
                this.scene.validate();
            }
        } else if (msgAddr == (Integer)this.addressList.get(1)) {
            ((SimplePropertiesDlg)this.propertiesDialog).txtValue.setText(cmd.getValue("TOKEN3"));
        } else if (msgAddr == (Integer)this.addressList.get(2)) {
            Integer value = Integer.parseInt(cmd.getValue("TOKEN3"));
            ((SimplePropertiesDlg)this.propertiesDialog).chkBox.setSelected(value == 1);
        }
        return true;
    }

    @Override
    public void setConnectionStatus(boolean isConnected) {
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        if (this.type.equals(CommonDefinitions.blockTypes.AnalogIN.toString())) {
            SceneSerializer.setAttribute(document, nodeElement, "minValue", this.minValue);
            SceneSerializer.setAttribute(document, nodeElement, "maxValue", this.maxValue);
        }
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        this.deviceID = SceneSerializer.getAttributeValue(node, "driverID");
        ((AFONodeWidget)this.widget).setSubType(this.deviceID);
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.removeAllItems();
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.addItem(this.deviceID);
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.setSelectedIndex(0);
        if (this.type.equals(CommonDefinitions.blockTypes.AnalogIN.toString())) {
            this.maxValue = SceneSerializer.getAttributeValue(node, "maxValue");
            if (this.maxValue == null) {
                this.maxValue = "10.0";
            }
            this.minValue = SceneSerializer.getAttributeValue(node, "minValue");
            if (this.minValue == null) {
                this.minValue = "0.0";
            }
        }
    }

    @Override
    public void initSimulation() {
        super.initSimulation();
        if (this.type.equals(CommonDefinitions.blockTypes.AnalogIN.toString())) {
            this.simInputTimer = new GenericNode.SimTimer(this);
        }
    }

    @Override
    public void simulate() {
        super.simulate();
        if (this.type.equals(CommonDefinitions.blockTypes.AnalogIN.toString())) {
            double x;
            GenericNode.SimData out = this.GetMData(0);
            out.data = x = this.waveGenerator();
            out.isValid = true;
            this.SetMData(0, out);
            this.updateSimOutputs();
        }
    }

    @Override
    public void showSimulationDialog() {
        super.showSimulationDialog();
    }

    @Override
    protected void simDialogClosed() {
        if (this.type.equals(CommonDefinitions.blockTypes.AnalogIN.toString())) {
            super.simDialogClosed();
        }
    }
}

