/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.GenericNode;
import nodes.gui.GenericBlockDialog;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOEdge;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class BinaryDecoderNode
extends GenericNode {
    int numberofOutputs = 4;
    public static final int BIN_ENCDEC_ID = 18;

    public BinaryDecoderNode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        this.blockType = CommonDefinitions.blockTypes.BinaryDecoder;
        this.addressSpace = 2;
        this.codici = new ArrayList();
        this.codici.add(0, "BinDecoder");
        this.codici.add(1, "BinDecoder_R");
        this.setList(this.codici);
        this.numberOfInputs = 1;
        this.CreateWidget();
        this.CreatePropertiesDialog();
        this.cleanSimDialog();
    }

    public String getAddress() {
        String newAddress = ((GenericBlockDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("Decoder");
        this.getScene().addNode(this);
        String pinLabel = "IN";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN1");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        this.createOutputPins();
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    private void createOutputPins() {
        int i;
        for (AFOPin pin : this.pinList) {
            if (!pin.getPinType().equals((Object)AFOPin.E_PinType.PIN_OUTPUT)) continue;
            ArrayList edgeList = (ArrayList)this.scene.findPinEdges(pin, false, true);
            for (AFOEdge edge : edgeList) {
                this.scene.removeEdge(edge);
            }
        }
        ((AFONodeWidget)this.widget).clearOutputPins();
        ((AFONodeWidget)this.widget).getModuleOUTPinNames().removeChildren();
        for (i = 0; i < this.pinList.size(); ++i) {
            if (!((AFOPin)this.pinList.get(i)).getPinType().equals((Object)AFOPin.E_PinType.PIN_OUTPUT)) continue;
            this.pinList.remove(i);
            --i;
        }
        for (i = 1; i <= this.numberofOutputs; ++i) {
            String pinLabel = "OUT" + (i - 1);
            String pinID = "pin" + ++this.scene.pinIDCounter;
            AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
            newPin.setAsBusPin(false);
            newPin.setPinIDString("OUT" + i);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
        }
        for (AFOPin pin : this.pinList) {
            pin.setParentNode(this);
        }
        this.resetPinValues();
        this.scene.validate();
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new GenericBlockDialog(null, true, this);
        ((GenericBlockDialog)this.propertiesDialog).lblCombo.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).lblField1.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).lblField2.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).lblField2.setText("Number of Outputs :");
        ((GenericBlockDialog)this.propertiesDialog).txtField2.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).txtField2.getDocument().addDocumentListener(new FieldChangeListener());
        ((GenericBlockDialog)this.propertiesDialog).btnSendParam2.setVisible(false);
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        this.requestData();
        ((GenericBlockDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((GenericBlockDialog)this.propertiesDialog).indexLabel.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).txtField2.setText("" + this.numberofOutputs);
        ((GenericBlockDialog)this.propertiesDialog).btnOk.setEnabled(!this.kernelConnected);
        this.propertiesDialog.setModal(true);
        this.propertiesDialog.setVisible(true);
        if (((GenericBlockDialog)this.propertiesDialog).getReturnStatus() == 1) {
            if (!((GenericBlockDialog)this.propertiesDialog).fieldChanged) {
                return;
            }
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.propertiesDialog.setVisible(false);
            this.scene.sceneChanged();
            int newouts = (int)Float.parseFloat(((GenericBlockDialog)this.propertiesDialog).txtField2.getText());
            if (newouts > 1 && newouts != this.numberofOutputs) {
                this.numberofOutputs = newouts;
                this.createOutputPins();
            }
        }
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        float type = Float.parseFloat("" + (this.subType.ordinal() - CommonDefinitions.subBlockTypes.IF_NE.ordinal()));
        retVal = retVal + "18 " + this.getCommonData() + this.numberofOutputs + " 1.0 0.0 ";
        return retVal;
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
        }
        return true;
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "NOfOutputs", "" + this.numberofOutputs);
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        String nOfInputs = SceneSerializer.getAttributeValue(node, "NOfOutputs");
        this.numberofOutputs = nOfInputs == null ? 4 : Integer.parseInt(nOfInputs);
        this.createOutputPins();
    }

    @Override
    public void simulate() {
        super.simulate();
        double inVal = ((GenericNode.SimData)this.inputData.get((int)0)).data;
        if (!((GenericNode.SimData)this.inputData.get((int)0)).isValid) {
            for (int i = 0; i < this.m_Data.size(); ++i) {
                this.m_Data.set(i, new GenericNode.SimData(this));
            }
        } else {
            for (int i = 0; i < this.m_Data.size(); ++i) {
                if (((int)inVal & 1 << i) != 0) {
                    this.m_Data.set(i, new GenericNode.SimData(this, 1.0, true));
                    continue;
                }
                this.m_Data.set(i, new GenericNode.SimData(this, 0.0, true));
            }
        }
        this.updateSimOutputs();
        System.out.println(((GenericNode.SimData)this.m_Data.get((int)0)).data + "-" + ((GenericNode.SimData)this.m_Data.get((int)0)).isValid);
    }

    class FieldChangeListener
    implements DocumentListener {
        private int MAX_OUTPUTS = 16;

        FieldChangeListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.control();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        public void control() {
            int nOfIn = 0;
            try {
                nOfIn = (int)Float.parseFloat(((GenericBlockDialog)((BinaryDecoderNode)BinaryDecoderNode.this).propertiesDialog).txtField2.getText());
                if (nOfIn > this.MAX_OUTPUTS) {
                    throw new Exception("Max Num Inputs");
                }
                if (nOfIn < 2) {
                    ((GenericBlockDialog)((BinaryDecoderNode)BinaryDecoderNode.this).propertiesDialog).btnOk.setEnabled(false);
                } else {
                    ((GenericBlockDialog)((BinaryDecoderNode)BinaryDecoderNode.this).propertiesDialog).btnOk.setEnabled(true);
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Errore nel campo Numero Uscite", "Errore", 0);
                ((GenericBlockDialog)((BinaryDecoderNode)BinaryDecoderNode.this).propertiesDialog).btnOk.setEnabled(false);
            }
        }
    }
}

