/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import connection.SerialKernel;
import java.util.ArrayList;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.GenericNode;
import nodes.gui.C3PointDialog;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class C3PointCtrlNode
extends GenericNode {
    private String setpoint = "20.0";
    private String setpointH = "35.0";
    private String setpointL = "15.0";
    private String moveTime = "180";
    private String nullZone = "3.0";
    private String summer = "0";
    private String address;
    public static final int C3POINT_ID = 19;
    public final String SETPOINT = "Setpoint";
    public final String SETPOINTH = "SetpointH";
    public final String SETPOINTL = "SetpointL";
    public final String NULLZONE = "NullZone";
    public final String MOVETIME = "Movetime";
    public final String SUMMER = "Summer";
    private double Sim_setpoint = 20.0;
    private double Sim_setpointH = 35.0;
    private double Sim_setpointL = 15.0;
    private double Sim_moveTime = 180.0;
    private double Sim_nullZone = 3.0;
    private double Sim_summer = 0.0;
    private e_ValveStatus Sim_ValveStatus;
    GenericNode.SimTimer closingTimer;
    GenericNode.SimTimer openTimer;

    public C3PointCtrlNode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        this.blockType = CommonDefinitions.blockTypes.C3PointCtrl;
        this.addressSpace = 11;
        this.numberOfInputs = 0;
        this.CreateWidget();
        this.CreatePropertiesDialog();
        this.codici = new ArrayList();
        this.codici.add(0, "C3");
        this.codici.add(1, "OUT_OPEN");
        this.codici.add(2, "OUT_CLOSE");
        this.codici.add(3, "OUT_FullOPEN");
        this.codici.add(4, "OUT_FullCLOSE");
        this.codici.add(5, "Setpoint");
        this.codici.add(6, "SetpointH");
        this.codici.add(7, "SetpointL");
        this.codici.add(8, "Summer");
        this.codici.add(9, "Movetime");
        this.codici.add(10, "NullZone");
        this.setList(this.codici);
        this.cleanSimDialog();
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("3 Point");
        this.getScene().addNode(this);
        String pinLabel = "OPEN";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "CLOSE";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT2");
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "FULL Open";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT3");
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "FULL Closed";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT4");
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Ctrl IN";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "LM IN";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Setpoint";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Summer";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "SPH";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "SPL";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "MT";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "NZ";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new C3PointDialog(null, true, this);
        this.propertiesDialog.setResizable(false);
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        retVal = retVal + "19 " + this.getCommonData();
        retVal = retVal + this.setpoint + " " + this.setpointH + " " + this.setpointL;
        retVal = retVal + " " + Float.parseFloat(this.summer);
        retVal = retVal + " " + this.moveTime + " " + this.nullZone;
        return retVal;
    }

    private void setDialogFields() {
        ((C3PointDialog)this.propertiesDialog).txtSetpoint.setText(this.setpoint);
        ((C3PointDialog)this.propertiesDialog).txtSetpointH.setText(this.setpointH);
        ((C3PointDialog)this.propertiesDialog).txtSetpointL.setText(this.setpointL);
        if (this.summer.equals("1")) {
            ((C3PointDialog)this.propertiesDialog).checkSummer.setSelected(true);
        } else {
            ((C3PointDialog)this.propertiesDialog).checkSummer.setSelected(false);
        }
        ((C3PointDialog)this.propertiesDialog).txtMovetime.setText(this.moveTime);
        ((C3PointDialog)this.propertiesDialog).txtNullzone.setText(this.nullZone);
    }

    private void getDialogFields() {
        this.setpoint = ((C3PointDialog)this.propertiesDialog).txtSetpoint.getText();
        this.setpointH = ((C3PointDialog)this.propertiesDialog).txtSetpointH.getText();
        this.setpointL = ((C3PointDialog)this.propertiesDialog).txtSetpointL.getText();
        this.summer = this.boolToIntString(((C3PointDialog)this.propertiesDialog).checkSummer.isSelected());
        this.moveTime = ((C3PointDialog)this.propertiesDialog).txtMovetime.getText();
        this.nullZone = ((C3PointDialog)this.propertiesDialog).txtNullzone.getText();
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        this.requestData();
        ((C3PointDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((C3PointDialog)this.propertiesDialog).indexLabel.setVisible(false);
        this.setDialogFields();
        this.propertiesDialog.setModal(true);
        this.propertiesDialog.setVisible(true);
        if (((C3PointDialog)this.propertiesDialog).getReturnStatus() == 1) {
            if (!((C3PointDialog)this.propertiesDialog).checkFields()) {
                return;
            }
            this.getDialogFields();
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.scene.sceneChanged();
            if (this.kernel == null || !this.kernel.isConnected()) {
                this.propertiesDialog.setVisible(false);
                return;
            }
            if (this.kernel instanceof SerialKernel) {
                this.commandQueue.clear();
                int paramBaseAddr = 5;
                String msg = "<BL set " + this.addressList.get(paramBaseAddr++) + " " + ((C3PointDialog)this.propertiesDialog).txtSetpoint.getText() + " >";
                this.commandQueue.add(msg);
                msg = "<BL set " + this.addressList.get(paramBaseAddr++) + " " + ((C3PointDialog)this.propertiesDialog).txtSetpointH.getText() + " >";
                this.commandQueue.add(msg);
                msg = "<BL set " + this.addressList.get(paramBaseAddr++) + " " + ((C3PointDialog)this.propertiesDialog).txtSetpointL.getText() + " >";
                this.commandQueue.add(msg);
                msg = ((C3PointDialog)this.propertiesDialog).checkSummer.isSelected() ? "<BL set " + this.addressList.get(paramBaseAddr++) + " 1.0 >" : "<BL set " + this.addressList.get(paramBaseAddr++) + " 0.0 >";
                this.commandQueue.add(msg);
                msg = "<BL set " + this.addressList.get(paramBaseAddr++) + " " + ((C3PointDialog)this.propertiesDialog).txtMovetime.getText() + " >";
                this.commandQueue.add(msg);
                msg = "<BL set " + this.addressList.get(paramBaseAddr++) + " " + ((C3PointDialog)this.propertiesDialog).txtNullzone.getText() + " >";
                this.commandQueue.add(msg);
                this.sendMessageQueue(true);
            }
        }
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "Setpoint", this.setpoint);
        SceneSerializer.setAttribute(document, nodeElement, "SetpointH", this.setpointH);
        SceneSerializer.setAttribute(document, nodeElement, "SetpointL", this.setpointL);
        SceneSerializer.setAttribute(document, nodeElement, "NullZone", this.nullZone);
        SceneSerializer.setAttribute(document, nodeElement, "Movetime", this.moveTime);
        SceneSerializer.setAttribute(document, nodeElement, "Summer", this.summer);
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        this.setpoint = SceneSerializer.getAttributeValue(node, "Setpoint");
        this.setpointH = SceneSerializer.getAttributeValue(node, "SetpointH");
        this.setpointL = SceneSerializer.getAttributeValue(node, "SetpointL");
        this.nullZone = SceneSerializer.getAttributeValue(node, "NullZone");
        this.moveTime = SceneSerializer.getAttributeValue(node, "Movetime");
        this.summer = SceneSerializer.getAttributeValue(node, "Summer");
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
        } else {
            String value = "";
            int msgAddress = Integer.parseInt(cmd.getValue("ADDRESS"));
            value = cmd.getValue("TOKEN3");
            switch (msgAddress - (Integer)this.addressList.get(0) - 5) {
                case 0: {
                    ((C3PointDialog)this.propertiesDialog).txtSetpoint.setText(value);
                    this.setpoint = value;
                    break;
                }
                case 1: {
                    ((C3PointDialog)this.propertiesDialog).txtSetpointH.setText(value);
                    this.setpointH = value;
                    break;
                }
                case 2: {
                    ((C3PointDialog)this.propertiesDialog).txtSetpointL.setText(value);
                    this.setpointL = value;
                    break;
                }
                case 3: {
                    if ((double)Float.parseFloat(value) == 0.0) {
                        ((C3PointDialog)this.propertiesDialog).checkSummer.setSelected(false);
                    } else {
                        ((C3PointDialog)this.propertiesDialog).checkSummer.setSelected(true);
                    }
                    this.summer = value;
                    break;
                }
                case 4: {
                    ((C3PointDialog)this.propertiesDialog).txtMovetime.setText(value);
                    this.moveTime = value;
                    break;
                }
                case 5: {
                    ((C3PointDialog)this.propertiesDialog).txtNullzone.setText(value);
                    this.nullZone = value;
                    break;
                }
                case 6: {
                    int status = Integer.parseInt(value);
                    switch (status) {
                        case 0: {
                            ((C3PointDialog)this.propertiesDialog).txtStatus.setText("Opening");
                            break;
                        }
                        case 1: {
                            ((C3PointDialog)this.propertiesDialog).txtStatus.setText("Closing");
                            break;
                        }
                        case 2: {
                            ((C3PointDialog)this.propertiesDialog).txtStatus.setText("Full Open");
                            break;
                        }
                        case 3: {
                            ((C3PointDialog)this.propertiesDialog).txtStatus.setText("Full Closed");
                            break;
                        }
                        case 4: {
                            ((C3PointDialog)this.propertiesDialog).txtStatus.setText("Stopped");
                        }
                    }
                    break;
                }
            }
        }
        this.propertiesDialog.invalidate();
        return true;
    }

    public String getAddress() {
        String newAddress = ((C3PointDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    @Override
    public void setConnectionStatus(boolean isConnected) {
    }

    @Override
    public void initSimulation() {
        super.initSimulation();
        this.Sim_setpoint = Double.parseDouble(this.setpoint);
        this.Sim_setpointH = Double.parseDouble(this.setpointH);
        this.Sim_setpointL = Double.parseDouble(this.setpointL);
        this.Sim_nullZone = Double.parseDouble(this.nullZone);
        this.Sim_summer = Double.parseDouble(this.summer);
        this.Sim_moveTime = Double.parseDouble(this.moveTime);
        this.Sim_ValveStatus = e_ValveStatus.C3P_STOPPED;
        this.closingTimer = new GenericNode.SimTimer(this);
        this.openTimer = new GenericNode.SimTimer(this);
        this.Stop();
    }

    @Override
    public void simulate() {
        super.simulate();
        this.AcquireParamIn();
        if (this.isInputConnected(e_C3Inputs.C3P_LMD_IN.ordinal())) {
            this.UpdateLMDControl();
        } else {
            this.UpdateSimpleControl();
        }
        GenericNode.SimData out2 = (GenericNode.SimData)this.m_Data.get(2);
        GenericNode.SimData out3 = (GenericNode.SimData)this.m_Data.get(3);
        out3.isValid = true;
        out2.isValid = true;
        if (this.Sim_ValveStatus == e_ValveStatus.C3P_FULLOPEN) {
            out2.data = 1.0;
            out2.isValid = true;
            out3.data = 0.0;
            out3.isValid = true;
        } else if (this.Sim_ValveStatus == e_ValveStatus.C3P_FULLCLOSED) {
            out2.data = 0.0;
            out2.isValid = true;
            out3.data = 1.0;
            out3.isValid = true;
        } else {
            out2.data = 0.0;
            out2.isValid = true;
            out3.data = 0.0;
            out3.isValid = true;
        }
        this.m_Data.set(2, out2);
        this.m_Data.set(3, out3);
        this.updateSimOutputs();
        System.out.println(((GenericNode.SimData)this.m_Data.get((int)0)).data + "-" + ((GenericNode.SimData)this.m_Data.get((int)0)).isValid);
    }

    void AcquireParamIn() {
        if (this.isInputConnected(e_C3Inputs.C3P_SETP_IN.ordinal())) {
            this.Sim_setpoint = ((GenericNode.SimData)this.inputData.get((int)e_C3Inputs.C3P_SETP_IN.ordinal())).data;
        }
        if (this.isInputConnected(e_C3Inputs.C3P_SUMMER_IN.ordinal())) {
            this.Sim_summer = ((GenericNode.SimData)this.inputData.get((int)e_C3Inputs.C3P_SUMMER_IN.ordinal())).data;
        }
        if (this.isInputConnected(e_C3Inputs.C3P_SPH_IN.ordinal())) {
            this.Sim_setpointH = ((GenericNode.SimData)this.inputData.get((int)e_C3Inputs.C3P_SPH_IN.ordinal())).data;
        }
        if (this.isInputConnected(e_C3Inputs.C3P_SPL_IN.ordinal())) {
            this.Sim_setpointL = ((GenericNode.SimData)this.inputData.get((int)e_C3Inputs.C3P_SPL_IN.ordinal())).data;
        }
        if (this.isInputConnected(e_C3Inputs.C3P_MOVETIME_IN.ordinal())) {
            this.Sim_moveTime = ((GenericNode.SimData)this.inputData.get((int)e_C3Inputs.C3P_MOVETIME_IN.ordinal())).data;
        }
        if (this.isInputConnected(e_C3Inputs.C3P_NULLZONE_IN.ordinal())) {
            this.Sim_nullZone = ((GenericNode.SimData)this.inputData.get((int)e_C3Inputs.C3P_NULLZONE_IN.ordinal())).data;
        }
    }

    void UpdateSimpleControl() {
        double error;
        GenericNode.SimData input = (GenericNode.SimData)this.inputData.get(e_C3Inputs.C3P_CTRL_IN.ordinal());
        if (!input.connected || !input.isValid) {
            this.invalidateOutputs();
        }
        if ((error = this.GetError(input.data, this.Sim_setpoint, false)) > this.Sim_nullZone / 2.0) {
            this.Open();
        } else if (error < -this.Sim_nullZone / 2.0) {
            this.Close();
        } else {
            this.Stop();
        }
    }

    void UpdateLMDControl() {
        GenericNode.SimData inputDirect = (GenericNode.SimData)this.inputData.get(e_C3Inputs.C3P_CTRL_IN.ordinal());
        if (!inputDirect.connected || !inputDirect.isValid) {
            this.invalidateOutputs();
            return;
        }
        GenericNode.SimData inputLMD = (GenericNode.SimData)this.inputData.get(e_C3Inputs.C3P_LMD_IN.ordinal());
        if (!inputLMD.connected || !inputLMD.isValid) {
            this.invalidateOutputs();
            return;
        }
        double errorDirect = this.GetError(inputDirect.data, this.Sim_setpoint, false);
        double errorH = this.GetError(inputLMD.data, this.Sim_setpointH, true);
        double errorL = -1.0 * this.GetError(inputLMD.data, this.Sim_setpointL, true);
        if (errorH > 0.0 || errorL > 0.0) {
            if (this.Sim_summer != 0.0) {
                if (errorH > 0.0) {
                    this.Open();
                } else {
                    this.Close();
                }
            } else if (errorL > 0.0) {
                this.Open();
            } else {
                this.Close();
            }
        } else if (errorDirect > this.Sim_nullZone / 2.0) {
            this.Open();
        } else if (errorDirect < -this.Sim_nullZone / 2.0) {
            this.Close();
        } else {
            this.Stop();
        }
    }

    double GetError(double temp, double setpoint, boolean isLmd) {
        if (isLmd) {
            return temp - setpoint;
        }
        if (this.Sim_summer != 0.0) {
            return temp - setpoint;
        }
        return setpoint - temp;
    }

    void Close() {
        if (this.Sim_ValveStatus == e_ValveStatus.C3P_STOPPED || this.Sim_ValveStatus == e_ValveStatus.C3P_FULLOPEN) {
            GenericNode.SimData outClose = (GenericNode.SimData)this.m_Data.get(e_C3Outputs.C3P_CLOSE_OUT.ordinal());
            outClose.data = 1.0;
            outClose.isValid = true;
            this.closingTimer.setTimer((int)(this.Sim_moveTime * 1000.0));
            this.Sim_ValveStatus = e_ValveStatus.C3P_CLOSING;
            this.m_Data.set(e_C3Outputs.C3P_CLOSE_OUT.ordinal(), outClose);
        } else if (this.Sim_ValveStatus == e_ValveStatus.C3P_CLOSING || this.Sim_ValveStatus == e_ValveStatus.C3P_FULLCLOSED) {
            if (this.closingTimer.isTimerExpired()) {
                this.Stop();
                this.Sim_ValveStatus = e_ValveStatus.C3P_FULLCLOSED;
            }
        } else {
            this.Stop();
        }
    }

    void Open() {
        if (this.Sim_ValveStatus == e_ValveStatus.C3P_STOPPED || this.Sim_ValveStatus == e_ValveStatus.C3P_FULLCLOSED) {
            GenericNode.SimData outOpen = (GenericNode.SimData)this.m_Data.get(e_C3Outputs.C3P_OPEN_OUT.ordinal());
            GenericNode.SimData outClose = (GenericNode.SimData)this.m_Data.get(e_C3Outputs.C3P_CLOSE_OUT.ordinal());
            outOpen.data = 1.0;
            outOpen.isValid = true;
            this.openTimer.setTimer((int)(this.Sim_moveTime * 1000.0));
            this.Sim_ValveStatus = e_ValveStatus.C3P_OPENING;
            this.m_Data.set(e_C3Outputs.C3P_OPEN_OUT.ordinal(), outOpen);
            this.m_Data.set(e_C3Outputs.C3P_CLOSE_OUT.ordinal(), outClose);
        } else if (this.Sim_ValveStatus == e_ValveStatus.C3P_OPENING || this.Sim_ValveStatus == e_ValveStatus.C3P_FULLOPEN) {
            if (this.openTimer.isTimerExpired()) {
                this.Stop();
                this.Sim_ValveStatus = e_ValveStatus.C3P_FULLOPEN;
            }
        } else {
            this.Stop();
        }
    }

    void Stop() {
        GenericNode.SimData outOpen = (GenericNode.SimData)this.m_Data.get(e_C3Outputs.C3P_OPEN_OUT.ordinal());
        GenericNode.SimData outClose = (GenericNode.SimData)this.m_Data.get(e_C3Outputs.C3P_CLOSE_OUT.ordinal());
        this.Sim_ValveStatus = e_ValveStatus.C3P_STOPPED;
        outOpen.data = 0.0;
        outOpen.isValid = true;
        outClose.data = 0.0;
        outClose.isValid = true;
        this.m_Data.set(e_C3Outputs.C3P_OPEN_OUT.ordinal(), outOpen);
        this.m_Data.set(e_C3Outputs.C3P_CLOSE_OUT.ordinal(), outClose);
    }

    static enum e_ValveStatus {
        C3P_OPENING,
        C3P_CLOSING,
        C3P_FULLOPEN,
        C3P_FULLCLOSED,
        C3P_STOPPED;

    }

    static enum e_C3Outputs {
        C3P_OPEN_OUT,
        C3P_CLOSE_OUT,
        C3P_FULLOP_OUT,
        C3P_FULLCLOS_OUT;

    }

    static enum e_C3Inputs {
        C3P_CTRL_IN,
        C3P_LMD_IN,
        C3P_SETP_IN,
        C3P_SUMMER_IN,
        C3P_SPH_IN,
        C3P_SPL_IN,
        C3P_MOVETIME_IN,
        C3P_NULLZONE_IN;

    }
}

