/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import java.util.ArrayList;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.DeviceNode;
import nodes.devices.GenericNode;
import nodes.gui.GenericBlockDialog;
import nodes.gui.SimInputFrame;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class CheckCommNode
extends DeviceNode {
    private String value = "60.0";
    public static final String CHECKCOMM_ID = "45";

    public CheckCommNode(String id, String label, String UID, AFOGraphPinScene scene) {
        super(id, label, "CheckComm", scene);
        this.CreateWidget();
        this.blockType = CommonDefinitions.blockTypes.CheckComm;
        this.numberOfInputs = 0;
        this.addressSpace = 3;
        this.CreatePropertiesDialog();
        this.codici = new ArrayList();
        this.codici.add(0, "CheckComm");
        this.codici.add(1, "IO_CheckComm");
        this.codici.add(2, "Timeout_CheckComm");
        this.setList(this.codici);
        this.simDialog.tabbedPaneMain.remove(1);
        this.simDialog.tabbedPaneMain.setTitleAt(0, "Params");
    }

    public String getAddress() {
        String newAddress = ((GenericBlockDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("Check Comm");
        String pinLabel = "Comm OK";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.pinList.add(newPin);
        this.getScene().addNode(this);
        this.getScene().addPin(this, newPin);
        ((AFONodeWidget)this.widget).setSubType(this.getValue());
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        this.requestData();
        ((GenericBlockDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setText(this.value);
        ((GenericBlockDialog)this.propertiesDialog).indexLabel.setVisible(false);
        this.propertiesDialog.setModal(true);
        this.propertiesDialog.setVisible(true);
        if (((GenericBlockDialog)this.propertiesDialog).getReturnStatus() == 1) {
            if (!((GenericBlockDialog)this.propertiesDialog).fieldChanged) {
                return;
            }
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.propertiesDialog.setVisible(false);
            this.scene.sceneChanged();
            this.value = ((GenericBlockDialog)this.propertiesDialog).txtField1.getText();
            ((AFONodeWidget)this.widget).setSubType(this.value);
            if (this.kernel != null && this.kernel.isConnected()) {
                this.commandQueue.clear();
                float val = Float.parseFloat(this.value);
                String msg = "<BL set " + this.addressList.get(2) + " " + val + " >";
                this.commandQueue.add(msg);
                this.sendMessageQueue(true);
            }
        }
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new GenericBlockDialog(null, true, this);
        ((GenericBlockDialog)this.propertiesDialog).txtAddress.setText("NA");
        ((GenericBlockDialog)this.propertiesDialog).lblCombo.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).lblField1.setText("Timeout (sec):");
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setText(this.value);
        ((GenericBlockDialog)this.propertiesDialog).lblField2.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).txtField2.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).btnSendParam2.setVisible(false);
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        retVal = retVal + "45 " + this.getCommonData() + this.value;
        return retVal;
    }

    @Override
    public void setConnectionStatus(boolean isConnected) {
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
            String string = cmd.getValue("OUT1");
        } else if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(2)).toString())) {
            this.value = cmd.getValue("TOKEN3");
            ((GenericBlockDialog)this.propertiesDialog).txtField1.setText(this.value);
            ((AFONodeWidget)this.widget).setSubType(this.getValue());
        }
        return true;
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "Timeout", this.value);
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        this.value = SceneSerializer.getAttributeValue(node, "Timeout");
        ((AFONodeWidget)this.widget).setSubType(this.getValue());
    }

    @Override
    public void initSimulation() {
        super.initSimulation();
        this.simInputTimer = new GenericNode.SimTimer(this);
        this.simDialog.setTitle(this.deviceID);
        this.simDialog.comboWaveType.removeAllItems();
        this.simDialog.comboWaveType.addItem(SimInputFrame.SIM_IN_TYPES.Costant);
        this.simDialog.comboWaveType.addItem(SimInputFrame.SIM_IN_TYPES.Square);
    }

    @Override
    public void simulate() {
        super.simulate();
        double x = this.waveGenerator();
        GenericNode.SimData out = this.GetMData(0);
        out.data = x;
        out.isValid = true;
        this.SetMData(0, out);
        this.updateSimOutputs();
    }

    @Override
    public void showSimulationDialog() {
        super.showSimulationDialog();
    }

    @Override
    protected void simDialogClosed() {
        super.simDialogClosed();
    }
}

