/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.GenericNode;
import nodes.gui.GenericBlockDialog;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class CostantNode
extends GenericNode {
    private String value = "0.0";
    public static final String COSTANT_ID = "8";
    private Boolean persistentData = true;

    public CostantNode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        this.CreateWidget();
        this.blockType = CommonDefinitions.blockTypes.Costant;
        this.numberOfInputs = 0;
        this.addressSpace = 3;
        this.CreatePropertiesDialog();
        this.codici = new ArrayList();
        this.codici.add(0, "Costant");
        this.codici.add(1, "IO_Costant");
        this.setList(this.codici);
        this.simDialog.tabbedPaneMain.remove(1);
        this.simDialog.tabbedPaneMain.setTitleAt(0, "Params");
    }

    public String getAddress() {
        String newAddress = ((GenericBlockDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("Costant");
        String pinLabel = "OUT";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.pinList.add(newPin);
        this.getScene().addNode(this);
        this.getScene().addPin(this, newPin);
        ((AFONodeWidget)this.widget).setSubType(this.getValue());
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        Double fw = 10.0;
        if (this.kernel != null) {
            fw = this.kernel.getFirmwareVersionDouble();
        }
        if (fw >= 26.0) {
            this.requestData();
        } else {
            this.requestData(2);
        }
        ((GenericBlockDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setText(this.value);
        ((GenericBlockDialog)this.propertiesDialog).chk1.setSelected(this.persistentData);
        ((GenericBlockDialog)this.propertiesDialog).indexLabel.setVisible(false);
        this.propertiesDialog.setModal(true);
        this.propertiesDialog.setVisible(true);
        if (((GenericBlockDialog)this.propertiesDialog).getReturnStatus() == 1) {
            if (!((GenericBlockDialog)this.propertiesDialog).fieldChanged) {
                return;
            }
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.propertiesDialog.setVisible(false);
            this.scene.sceneChanged();
            this.value = ((GenericBlockDialog)this.propertiesDialog).txtField1.getText();
            this.persistentData = ((GenericBlockDialog)this.propertiesDialog).chk1.isSelected();
            ((AFONodeWidget)this.widget).setSubType(this.value);
            this.simInputAmplitude = this.value;
            if (this.kernel != null && this.kernel.isConnected()) {
                this.commandQueue.clear();
                String msg = "<BL set " + this.addressList.get(2) + " ";
                msg = this.persistentData != false ? msg + "1" : msg + "0";
                msg = msg + " >";
                this.commandQueue.add(msg);
                msg = "<BL set " + this.addressList.get(1) + " " + this.value + " >";
                this.commandQueue.add(msg);
                this.sendMessageQueue(true);
            }
        }
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new GenericBlockDialog(null, true, this);
        ((GenericBlockDialog)this.propertiesDialog).txtAddress.setText("NA");
        ((GenericBlockDialog)this.propertiesDialog).lblCombo.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).lblField1.setText("Value:");
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setText(this.value);
        ((GenericBlockDialog)this.propertiesDialog).lblField2.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).txtField2.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).btnSendParam2.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).chk1.setText("PersistentData");
        ((GenericBlockDialog)this.propertiesDialog).chk1.setVisible(true);
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        retVal = retVal + "8 " + this.getCommonData() + this.value + " ";
        retVal = this.persistentData != false ? retVal + "1.0" : retVal + "0.0";
        return retVal;
    }

    @Override
    public void setConnectionStatus(boolean isConnected) {
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
            String newLabel = cmd.getValue("OUT1");
            ((AFONodeWidget)this.widget).setSubType(newLabel);
        } else if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(1)).toString())) {
            this.value = cmd.getValue("TOKEN3");
            ((GenericBlockDialog)this.propertiesDialog).txtField1.setText(this.value);
        } else if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(2)).toString())) {
            String persistent = cmd.getValue("TOKEN3");
            try {
                double dVal = Double.parseDouble(persistent);
                this.persistentData = dVal != 0.0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
                ((GenericBlockDialog)this.propertiesDialog).chk1.setSelected(this.persistentData);
            }
            catch (Exception ex) {
                Logger.getLogger(CostantNode.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return true;
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "Costant", this.value);
        SceneSerializer.setAttribute(document, nodeElement, "PersistentData", this.persistentData.toString());
        this.serializeSimParams(document, nodeElement);
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        this.value = SceneSerializer.getAttributeValue(node, "Costant");
        if (this.value == null) {
            this.value = SceneSerializer.getAttributeValue(node, "mainVal");
        }
        try {
            String strVal = SceneSerializer.getAttributeValue(node, "PersistentData");
            this.persistentData = strVal == null ? Boolean.valueOf(true) : Boolean.valueOf(Boolean.parseBoolean(strVal));
        }
        catch (Exception ex) {
            this.persistentData = true;
        }
        ((AFONodeWidget)this.widget).setSubType(this.value);
        this.deserializeSimParam(node);
    }

    @Override
    public void initSimulation() {
        super.initSimulation();
        this.simInputTimer = new GenericNode.SimTimer(this);
        this.simInputAmplitude = this.value;
        this.simDialog.setTitle("Costant");
    }

    @Override
    public void simulate() {
        double x;
        super.simulate();
        GenericNode.SimData out = this.GetMData(0);
        out.data = x = this.waveGenerator();
        out.isValid = true;
        this.SetMData(0, out);
        this.updateSimOutputs();
    }

    @Override
    public void showSimulationDialog() {
        super.showSimulationDialog();
        this.simDialog.txtAmplitude.setText(this.value);
    }

    @Override
    protected void simDialogClosed() {
        super.simDialogClosed();
        this.value = this.simDialog.txtAmplitude.getText();
    }
}

