/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import Util.FieldChecker;
import VisiProg.AppOptions;
import connection.ICmd;
import connection.SerialKernel;
import connection.XMLCommands.UtilXML;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.GenericNode;
import nodes.gui.GenericBlockDialog;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class CounterNode
extends GenericNode
implements ActionListener {
    String amountToCount = "0";
    private static AppOptions options = new AppOptions();
    public static int COUNTER_NODE = 15;
    double actualCount = 0.0;
    double lastCountInputState = 0.0;

    public CounterNode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        this.CreateWidget();
        this.numberOfInputs = 3;
        this.addressSpace = 5;
        this.CreatePropertiesDialog();
        this.blockType = CommonDefinitions.blockTypes.Counter;
        options.LoadOptions();
        this.currentLocale = new Locale(CounterNode.options.language, CounterNode.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        this.codici = new ArrayList();
        this.codici.add(0, "IO_Counter");
        this.codici.add(1, "Count_Counter");
        this.codici.add(2, "OUT_Counter");
        this.codici.add(3, "Amount_Counter");
        this.codici.add(4, "Reset_Counter");
        this.setList(this.codici);
        this.cleanSimDialog();
    }

    public String getAddress() {
        String newAddress = ((GenericBlockDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("Counter");
        this.getScene().addNode(this);
        String pinLabel = "CNT";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        pinLabel = "OUT";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT2");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        pinLabel = "Count";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setPinIDString("IN1");
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Reset";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setPinIDString("IN2");
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Load";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setPinIDString("IN3");
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new GenericBlockDialog(null, true, this);
        ((GenericBlockDialog)this.propertiesDialog).txtAddress.setText("NA");
        ((GenericBlockDialog)this.propertiesDialog).lblCombo.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).lblField1.setText("Amount: ");
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setText(this.amountToCount);
        ((GenericBlockDialog)this.propertiesDialog).lblField2.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).txtField2.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).btnSendParam2.setText("Reset");
        ((GenericBlockDialog)this.propertiesDialog).btnSendParam2.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).btnSendParam2.addActionListener(this);
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        this.requestData();
        ((GenericBlockDialog)this.propertiesDialog).btnOk.addActionListener(this);
        ((GenericBlockDialog)this.propertiesDialog).btnCancel.addActionListener(this);
        ((GenericBlockDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setText(this.amountToCount);
        ((GenericBlockDialog)this.propertiesDialog).indexLabel.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).btnSendParam2.setEnabled(this.kernelConnected);
        this.propertiesDialog.setModal(true);
        this.propertiesDialog.setVisible(true);
        if (((GenericBlockDialog)this.propertiesDialog).getReturnStatus() == 1) {
            if (!FieldChecker.checkStringIsNumeric(((GenericBlockDialog)this.propertiesDialog).txtField1.getText(), "Valore Errato")) {
                JOptionPane.showMessageDialog(null, this.message.getString("errvalue"));
                return;
            }
            if (!((GenericBlockDialog)this.propertiesDialog).fieldChanged) {
                return;
            }
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.propertiesDialog.setVisible(false);
            this.scene.sceneChanged();
            this.amountToCount = ((GenericBlockDialog)this.propertiesDialog).txtField1.getText();
            if (this.kernelConnected) {
                this.commandQueue.clear();
                String msg = "";
                msg = msg + "<BL set " + this.addressList.get(3) + " " + ((GenericBlockDialog)this.propertiesDialog).txtField1.getText() + " >";
                this.commandQueue.add(msg);
                this.sendMessageQueue(true);
            }
        }
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        retVal = retVal + COUNTER_NODE + " " + this.getCommonData() + this.amountToCount;
        return retVal;
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "delay", this.amountToCount);
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        this.amountToCount = SceneSerializer.getAttributeValue(node, "delay");
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
        } else if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(3)).toString())) {
            this.amountToCount = cmd.getValue("TOKEN3");
            ((GenericBlockDialog)this.propertiesDialog).txtField1.setText(this.amountToCount);
            this.propertiesDialog.invalidate();
        }
        return true;
    }

    @Override
    public boolean parseBlockCmd(ICmd com) {
        if (UtilXML.cmpCmdValue(com, "ADDRESS", (Integer)this.addressList.get(0))) {
            if (com.containsAttribute("BLOCKEXEC")) {
                if (UtilXML.cmpCmdValue(com, "BLOCKEXEC", "Amount")) {
                    this.amountToCount = com.getValue("VAL");
                    ((GenericBlockDialog)this.propertiesDialog).txtField1.setText(this.amountToCount);
                }
            } else {
                return this.parseStandardBlockCmd(com);
            }
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(((GenericBlockDialog)this.propertiesDialog).btnSendParam2) && this.kernel instanceof SerialKernel) {
            String msg = "";
            this.commandQueue.clear();
            msg = msg + "<BL set " + this.addressList.get(4) + " 1.0 >";
            this.commandQueue.add(msg);
            this.sendMessageQueue(false);
        }
    }

    @Override
    public void setConnectionStatus(boolean isConnected) {
        ((GenericBlockDialog)this.propertiesDialog).btnSendParam2.setEnabled(isConnected);
    }

    @Override
    public void initSimulation() {
        super.initSimulation();
        this.registerArray.add(Double.parseDouble(this.amountToCount));
        this.actualCount = 0.0;
        this.lastCountInputState = 0.0;
        GenericNode.SimData out = this.GetMData(0);
        GenericNode.SimData out1 = this.GetMData(1);
        this.SetMData(0, out);
        this.SetMData(1, out1);
    }

    @Override
    public void simulate() {
        super.simulate();
        double reset = 0.0;
        GenericNode.SimData out = this.GetMData(0);
        GenericNode.SimData out1 = this.GetMData(1);
        GenericNode.SimData countInput = (GenericNode.SimData)this.inputData.get(e_CounterIN.COUNTER_IN_COUNT.ordinal());
        if (countInput.connected && !countInput.isValid) {
            this.invalidateOutputs();
            this.updateSimOutputs();
            return;
        }
        if (((GenericNode.SimData)this.inputData.get((int)e_CounterIN.COUNTER_IN_RESET.ordinal())).connected) {
            if (!((GenericNode.SimData)this.inputData.get((int)e_CounterIN.COUNTER_IN_RESET.ordinal())).isValid) {
                this.invalidateOutputs();
                this.updateSimOutputs();
                return;
            }
            reset = ((GenericNode.SimData)this.inputData.get((int)e_CounterIN.COUNTER_IN_RESET.ordinal())).data;
        }
        if (reset != 0.0) {
            this.actualCount = 0.0;
            out.data = 0.0;
            out.isValid = true;
            out1.data = 0.0;
            out1.isValid = true;
            if (((GenericNode.SimData)this.inputData.get((int)e_CounterIN.COUNTER_IN_LOAD.ordinal())).connected) {
                double param = ((GenericNode.SimData)this.inputData.get((int)e_CounterIN.COUNTER_IN_LOAD.ordinal())).data;
                if (!((GenericNode.SimData)this.inputData.get((int)e_CounterIN.COUNTER_IN_LOAD.ordinal())).isValid) {
                    this.invalidateOutputs();
                    this.updateSimOutputs();
                    return;
                }
                this.setParameter(0, param);
            }
        } else {
            if (countInput.data > 0.0 && this.lastCountInputState == 0.0) {
                this.actualCount += 1.0;
            }
            if ((int)this.GetParameter(0) == 0) {
                out1.data = 1.0;
                out1.isValid = true;
            } else if (this.actualCount != 0.0 && (int)this.actualCount % (int)this.GetParameter(0) == 0) {
                out1.data = 1.0;
                out1.isValid = true;
            }
            this.lastCountInputState = countInput.data;
        }
        out.data = this.actualCount;
        out.isValid = true;
        this.SetMData(0, out);
        this.SetMData(1, out1);
        this.updateSimOutputs();
    }

    static enum e_CounterIN {
        COUNTER_IN_COUNT,
        COUNTER_IN_RESET,
        COUNTER_IN_LOAD;

    }
}

