/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import VisiProg.AppOptions;
import connection.ICmd;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.devices.GenericNode;
import nodes.gui.GenericBlockDialog;
import org.netbeans.api.visual.widget.Widget;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class DewPoint
extends GenericNode {
    private AppOptions options = new AppOptions();
    public static final int Dew_ID = 31;
    static final double[][] psicroData = new double[][]{{10.5, 12.9, 14.9, 16.8, 18.4, 20.0, 21.4, 22.7, 23.9, 25.1, 26.2, 27.2, 28.2, 29.1}, {9.7, 12.0, 14.0, 15.9, 17.5, 19.0, 20.4, 21.7, 23.0, 24.1, 25.2, 26.2, 27.2, 28.1}, {8.8, 11.1, 13.1, 15.0, 16.6, 18.1, 19.5, 20.8, 22.0, 23.2, 24.2, 25.2, 26.2, 27.1}, {7.1, 9.4, 11.4, 13.2, 14.8, 16.3, 17.6, 18.9, 20.1, 21.2, 22.3, 23.3, 24.2, 25.1}, {6.2, 8.5, 10.5, 12.2, 13.9, 15.3, 16.7, 18.0, 19.1, 20.3, 21.3, 22.3, 23.2, 24.1}, {5.4, 7.6, 9.6, 11.3, 12.9, 14.4, 15.8, 17.0, 18.2, 19.3, 20.3, 21.3, 22.3, 23.1}, {4.5, 6.7, 8.7, 10.4, 12.0, 13.5, 14.8, 16.1, 17.2, 18.3, 19.4, 20.3, 21.3, 22.2}, {3.6, 5.9, 7.8, 9.5, 11.1, 12.5, 13.9, 15.1, 16.3, 17.4, 18.4, 19.4, 20.3, 21.2}, {2.8, 5.0, 6.9, 8.6, 10.2, 11.6, 12.9, 14.2, 15.3, 16.4, 17.4, 18.4, 19.3, 20.2}, {1.9, 4.1, 6.0, 7.7, 9.3, 10.7, 12.0, 13.2, 14.4, 15.4, 16.4, 17.4, 18.3, 19.2}, {1.0, 3.2, 5.1, 6.8, 8.3, 9.8, 11.1, 12.3, 13.4, 14.5, 15.5, 16.4, 17.3, 18.2}, {0.2, 2.3, 4.2, 5.9, 7.4, 8.8, 10.1, 11.3, 12.5, 13.5, 14.5, 15.4, 16.3, 17.2}, {-0.6, 1.4, 3.3, 5.0, 6.5, 7.9, 9.2, 10.4, 11.5, 12.5, 13.5, 14.5, 15.3, 16.2}, {-1.4, 0.5, 2.4, 4.1, 5.6, 7.0, 8.2, 9.4, 10.5, 11.6, 12.6, 13.5, 14.4, 15.2}, {-2.2, -0.3, 1.5, 3.2, 4.7, 6.1, 7.3, 8.5, 9.6, 10.6, 11.6, 12.5, 13.4, 14.2}, {-2.9, -1.0, 0.6, 2.3, 3.7, 5.1, 6.4, 7.5, 8.6, 9.6, 10.6, 11.5, 12.4, 13.2}, {-3.7, -1.9, -0.1, 1.3, 2.8, 4.2, 5.5, 6.6, 7.7, 8.7, 9.6, 10.5, 11.4, 12.2}, {-4.5, -2.6, -1.0, 0.4, 1.9, 3.2, 4.5, 5.7, 6.7, 7.7, 8.7, 9.6, 10.4, 11.2}, {-5.2, -3.4, -1.8, -0.4, 1.0, 2.3, 3.5, 4.7, 5.8, 6.7, 7.7, 8.6, 9.4, 10.2}, {-6.0, -4.2, -2.6, -1.2, 0.1, 1.4, 2.6, 3.7, 4.8, 5.8, 6.7, 7.6, 8.4, 9.2}};
    static final int minTemp = 10;
    static final int maxTemp = 30;
    static final int minHum = 30;
    static final int maxHum = 95;

    public DewPoint(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        this.blockType = CommonDefinitions.blockTypes.DewPoint;
        this.addressSpace = 2;
        this.codici = new ArrayList();
        this.codici.add(0, "DewPoint");
        this.codici.add(1, "OUT_DewPoint");
        this.setList(this.codici);
        this.numberOfInputs = 2;
        this.CreateWidget();
        this.CreatePropertiesDialog();
        this.cleanSimDialog();
    }

    public String getAddress() {
        String newAddress = ((GenericBlockDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        this.options.LoadOptions();
        this.currentLocale = new Locale(this.options.language, this.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        ((AFONodeWidget)this.widget).setName(this.message.getString("dewpoint"));
        this.getScene().addNode(this);
        String pinLabel = "T";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN1");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        pinLabel = "H";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN2");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        pinLabel = "DP";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new GenericBlockDialog(null, true, this);
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).lblCombo.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).lblField1.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).lblField2.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).txtField2.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).btnSendParam2.setVisible(false);
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        ((GenericBlockDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((GenericBlockDialog)this.propertiesDialog).indexLabel.setVisible(false);
        this.propertiesDialog.setVisible(true);
        if (((GenericBlockDialog)this.propertiesDialog).getReturnStatus() == 1) {
            if (!((GenericBlockDialog)this.propertiesDialog).fieldChanged) {
                return;
            }
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.propertiesDialog.setVisible(false);
        }
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        retVal = retVal + "31 " + this.getCommonData();
        return retVal;
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
        }
        return true;
    }

    @Override
    public void simulate() {
        super.simulate();
        GenericNode.SimData out = this.GetMData(0);
        if (((GenericNode.SimData)this.inputData.get((int)e_Inputs.DEW_IN_T.ordinal())).connected && ((GenericNode.SimData)this.inputData.get((int)e_Inputs.DEW_IN_H.ordinal())).connected) {
            double temp = ((GenericNode.SimData)this.inputData.get((int)e_Inputs.DEW_IN_T.ordinal())).data;
            double hum = ((GenericNode.SimData)this.inputData.get((int)e_Inputs.DEW_IN_H.ordinal())).data;
            out.data = this.CalcDewPoint(temp, hum);
            out.isValid = true;
        } else {
            out.data = -100.0;
            out.isValid = false;
        }
        this.SetMData(0, out);
        this.updateSimOutputs();
    }

    double CalcDewPoint(double airTemp, double airHum) {
        int row = 0;
        int column = 0;
        if ((int)airTemp <= 10) {
            row = 19;
        } else if ((int)airTemp >= 30) {
            row = 0;
        } else {
            for (row = 0; row < 20 && ((int)airTemp >= 30 - row || (int)airTemp < 30 - row - 1); ++row) {
            }
        }
        if (airHum <= 30.0) {
            column = 0;
        } else if (airHum >= 95.0) {
            column = 13;
        } else {
            for (column = 0; column < 14 && ((int)airHum < 30 + column * 5 || (int)airHum >= 30 + (column + 1) * 5); ++column) {
            }
        }
        return psicroData[row][column];
    }

    static enum e_Inputs {
        DEW_IN_T,
        DEW_IN_H;

    }
}

