/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import VisiProg.AppOptions;
import connection.ICmd;
import java.util.Locale;
import java.util.ResourceBundle;
import nodes.AFONodeWidget;
import nodes.BoardsTypesAndDescription;
import nodes.CommonDefinitions;
import nodes.Project;
import nodes.SceneSerializer;
import nodes.devices.DeviceNode;
import nodes.devices.GenericNode;
import nodes.gui.SimInputFrame;
import nodes.gui.SimplePropertiesDlg;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class DiDoNode
extends DeviceNode {
    private String typeName;
    public static final int DIGITAL_IN_ID = 3;
    public static final int DIGITAL_OUT_ID = 2;
    private AppOptions options = new AppOptions();
    public BoardsTypesAndDescription.BoardType boardtypeproj;
    private BoardsTypesAndDescription.BoardType boardType;
    private Boolean persistentData = false;
    private SimInputFrame.SIM_IN_TYPES simInputType1 = SimInputFrame.SIM_IN_TYPES.Costant;
    private String simInputPeriod1 = "60.0";
    private String simInputAmplitude1 = "1.0";
    private String simInputOffset1 = "0.0";

    public DiDoNode(String id, String label, String deviceID, AFOGraphPinScene scene, Project proj) {
        super(id, label, deviceID, scene);
        this.typeName = label;
        this.propertiesDialog = new SimplePropertiesDlg(null, true, deviceID, this);
        this.options.LoadOptions();
        this.currentLocale = new Locale(this.options.language, this.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.removeAllItems();
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.addItem(deviceID);
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.setSelectedIndex(0);
        this.boardtypeproj = proj.getBoardType();
        if (this.typeName.equals(CommonDefinitions.blockTypes.DigitalIN.toString())) {
            this.blockType = CommonDefinitions.blockTypes.DigitalIN;
            if (this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID9MX) || this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID9ST) || this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID6MX) || this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID6ST) || this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID9_2014) || this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID9_2014_DSP)) {
                this.numberOfInputs = 1;
                this.addressSpace = 4;
                ((SimplePropertiesDlg)this.propertiesDialog).chkBox.setVisible(true);
                ((SimplePropertiesDlg)this.propertiesDialog).chkBox.setText("Persistent Data");
                this.simDialog.tabbedPaneMain.setTitleAt(0, "Status");
                this.simDialog.tabbedPaneMain.setTitleAt(1, "Count");
            } else {
                this.simDialog.tabbedPaneMain.remove(1);
                this.simDialog.tabbedPaneMain.setTitleAt(0, "Params");
                this.numberOfInputs = 0;
                this.addressSpace = 2;
            }
            ((SimplePropertiesDlg)this.propertiesDialog).txtValue.setVisible(false);
            ((SimplePropertiesDlg)this.propertiesDialog).lblValue.setVisible(false);
            this.simDialog.comboWaveType.removeAllItems();
            this.simDialog.comboWaveType.addItem(SimInputFrame.SIM_IN_TYPES.Costant);
            this.simDialog.comboWaveType.addItem(SimInputFrame.SIM_IN_TYPES.Square);
        } else if (this.typeName.equals(CommonDefinitions.blockTypes.DigitalOUT.toString())) {
            this.blockType = CommonDefinitions.blockTypes.DigitalOUT;
            ((SimplePropertiesDlg)this.propertiesDialog).chkBox.setVisible(true);
            ((SimplePropertiesDlg)this.propertiesDialog).chkBox.setText("Manual operation");
            this.numberOfInputs = 1;
            this.addressSpace = 3;
            this.simDialog.tabbedPaneMain.removeAll();
        }
        this.CreateWidget();
    }

    public String getAddress() {
        String newAddress = ((SimplePropertiesDlg)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName(this.typeName);
        this.getScene().addNode(this);
        if (this.typeName.equals(CommonDefinitions.blockTypes.DigitalOUT.toString())) {
            String pinLabel = "OUT1";
            String pinID = "pin" + ++this.scene.pinIDCounter;
            AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
            newPin.setAsBusPin(false);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            newPin.setPinIDString("IN1");
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
        } else if (this.typeName.equals(CommonDefinitions.blockTypes.DigitalIN.toString())) {
            String pinLabel = "IN1";
            String pinID = "pin" + ++this.scene.pinIDCounter;
            AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
            newPin.setAsBusPin(false);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            newPin.setPinIDString("OUT1");
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
            if (this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID9MX) || this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID9ST) || this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID6MX) || this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID6ST) || this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID9_2014) || this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID9_2014_DSP)) {
                pinLabel = "Counter";
                pinID = "pin" + ++this.scene.pinIDCounter;
                newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
                newPin.setAsBusPin(false);
                newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
                newPin.setPinIDString("OUT2");
                this.pinList.add(newPin);
                this.getScene().addPin(this, newPin);
                pinLabel = "Reset";
                pinID = "pin" + ++this.scene.pinIDCounter;
                newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
                newPin.setAsBusPin(false);
                newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
                newPin.setPinIDString("IN1");
                this.pinList.add(newPin);
                this.getScene().addPin(this, newPin);
            }
        }
        ((AFONodeWidget)this.widget).setSubType(this.deviceID);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        Double fw = 10.0;
        if (this.typeName.equals(CommonDefinitions.blockTypes.DigitalIN.toString())) {
            if (this.kernel != null) {
                fw = this.kernel.getFirmwareVersionDouble();
            }
            if (fw >= 31.5) {
                this.requestData();
            } else {
                this.requestData(3);
            }
        } else {
            this.requestData();
        }
        if (this.typeName.equals(CommonDefinitions.blockTypes.DigitalIN.toString())) {
            ((SimplePropertiesDlg)this.propertiesDialog).chkBox.setSelected(this.persistentData);
        }
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.setSelectedItem(this.deviceID);
        ((SimplePropertiesDlg)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((SimplePropertiesDlg)this.propertiesDialog).indexLabel.setVisible(false);
        if (this.typeName.equals(CommonDefinitions.blockTypes.DigitalIN.toString())) {
            if (this.kernel != null && this.kernel.isConnected()) {
                ((SimplePropertiesDlg)this.propertiesDialog).chkBox.setEnabled(false);
            } else {
                ((SimplePropertiesDlg)this.propertiesDialog).chkBox.setEnabled(true);
            }
        }
        this.propertiesDialog.setVisible(true);
        if (((SimplePropertiesDlg)this.propertiesDialog).getReturnStatus() == 1 && ((SimplePropertiesDlg)this.propertiesDialog).fieldChanged) {
            this.scene.sceneChanged();
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.propertiesDialog.setVisible(false);
            if (this.typeName.equals(CommonDefinitions.blockTypes.DigitalIN.toString())) {
                this.persistentData = ((SimplePropertiesDlg)this.propertiesDialog).chkBox.isSelected();
            }
            if (this.kernel != null && this.kernel.isConnected()) {
                this.commandQueue.clear();
                int valInt = 0;
                String msg = "<BL set " + this.addressList.get(1) + " ";
                String val = ((SimplePropertiesDlg)this.propertiesDialog).txtValue.getText();
                valInt = (int)Float.parseFloat(val);
                msg = valInt == 0 ? msg + "0.0" : msg + "1.0";
                msg = msg + " >";
                this.commandQueue.add(msg);
                if (this.typeName.equals(CommonDefinitions.blockTypes.DigitalOUT.toString())) {
                    msg = "<BL set " + this.addressList.get(2) + " ";
                    msg = ((SimplePropertiesDlg)this.propertiesDialog).chkBox.isSelected() ? msg + "1.0" : msg + "0.0";
                    msg = msg + " >";
                    this.commandQueue.add(msg);
                }
                this.sendMessageQueue(true);
            }
        }
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "PersistentData", this.persistentData.toString());
        this.serializeSimParams(document, nodeElement);
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        this.deviceID = SceneSerializer.getAttributeValue(node, "driverID");
        ((AFONodeWidget)this.widget).setSubType(this.deviceID);
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.removeAllItems();
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.addItem(this.deviceID);
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.setSelectedIndex(0);
        try {
            String strVal = SceneSerializer.getAttributeValue(node, "PersistentData");
            this.persistentData = strVal == null ? Boolean.valueOf(false) : Boolean.valueOf(Boolean.parseBoolean(strVal));
        }
        catch (Exception ex) {
            this.persistentData = false;
        }
        this.deserializeSimParam(node);
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        retVal = this.typeName.equals(CommonDefinitions.blockTypes.DigitalIN.toString()) ? retVal + "3 " : retVal + "2 ";
        float num = Float.parseFloat(this.deviceID.substring(this.deviceID.length() - 1)) - 1.0f;
        retVal = retVal + this.getCommonData() + num + " ";
        retVal = this.persistentData != false ? retVal + "1.0" : retVal + "0.0";
        return retVal;
    }

    @Override
    public void setConnectionStatus(boolean isConnected) {
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        int msgAddr = 0;
        msgAddr = Integer.parseInt(cmd.getValue("ADDRESS"));
        if (msgAddr == (Integer)this.addressList.get(0)) {
            this.parseStandardBlockCmd(cmd);
            if (this.blockType.equals((Object)CommonDefinitions.blockTypes.DigitalOUT)) {
                String tempVal = cmd.getValue("OUT1");
                ((AFONodeWidget)this.widget).setSubType(this.deviceID + " -- Val: " + tempVal);
                this.scene.validate();
            }
        } else if (msgAddr == (Integer)this.addressList.get(1)) {
            ((SimplePropertiesDlg)this.propertiesDialog).txtValue.setText(cmd.getValue("TOKEN3"));
        } else if (msgAddr == (Integer)this.addressList.get(2)) {
            if (this.blockType.equals((Object)CommonDefinitions.blockTypes.DigitalOUT)) {
                Integer value = Integer.parseInt(cmd.getValue("TOKEN3"));
                ((SimplePropertiesDlg)this.propertiesDialog).chkBox.setSelected(value == 1);
            }
        } else if (msgAddr == (Integer)this.addressList.get(3)) {
            Integer value = Integer.parseInt(cmd.getValue("TOKEN3"));
            ((SimplePropertiesDlg)this.propertiesDialog).chkBox.setSelected(value == 1);
        }
        return true;
    }

    @Override
    public void initSimulation() {
        super.initSimulation();
        this.simInputTimer = new GenericNode.SimTimer(this);
    }

    @Override
    public void simulate() {
        super.simulate();
        if (this.blockType.equals((Object)CommonDefinitions.blockTypes.DigitalIN)) {
            if (this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID9MX) || this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID9ST) || this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID6MX) || this.boardtypeproj.equals((Object)BoardsTypesAndDescription.BoardType.mPID6ST)) {
                double inVal = 0.0;
                if (this.isInputConnected(0)) {
                    inVal = ((GenericNode.SimData)this.inputData.get((int)0)).data;
                }
                GenericNode.SimData out = this.GetMData(0);
                GenericNode.SimData out1 = this.GetMData(1);
                if (inVal != 0.0) {
                    out.data = 0.0;
                    out.isValid = true;
                    out1.data = 0.0;
                    out1.isValid = true;
                } else {
                    double x;
                    out.data = x = this.waveGenerator();
                    out.isValid = true;
                    out1.data = x = this.waveGenerator1();
                    out1.isValid = true;
                }
                this.SetMData(0, out);
                this.SetMData(1, out1);
            } else {
                double x;
                GenericNode.SimData out = this.GetMData(0);
                out.data = x = this.waveGenerator();
                out.isValid = true;
                this.SetMData(0, out);
            }
            this.updateSimOutputs();
        }
    }

    double waveGenerator1() {
        int nOfSines = 1;
        double x = 0.0;
        double period = Double.parseDouble(this.simInputPeriod1);
        if (this.simInputType1 == SimInputFrame.SIM_IN_TYPES.SawTooth1) {
            nOfSines = 50;
            double t = (double)this.simInputTimer.GetTimeElapsed() / 1000.0;
            for (int k = 1; k <= nOfSines; ++k) {
                x += Math.pow(-1.0, k + 1) * Math.sin(Math.toRadians((double)k * t * 360.0 / period)) / (double)k;
            }
            x = x * 2.0 / Math.PI;
            x = x * Double.parseDouble(this.simInputAmplitude1) + Double.parseDouble(this.simInputOffset1);
        } else if (this.simInputType1 == SimInputFrame.SIM_IN_TYPES.SawTooth2) {
            nOfSines = 50;
            double t = (double)this.simInputTimer.GetTimeElapsed() / 1000.0;
            for (int k = 1; k <= nOfSines; ++k) {
                x += Math.pow(-1.0, k + 1) * Math.sin(Math.toRadians((double)k * t * 360.0 / period)) / (double)k;
            }
            x = x * 2.0 / Math.PI;
            x = -1.0 * x * Double.parseDouble(this.simInputAmplitude1) + Double.parseDouble(this.simInputOffset1);
        } else if (this.simInputType1 == SimInputFrame.SIM_IN_TYPES.Sinusoidal) {
            double t = (double)this.simInputTimer.GetTimeElapsed() / 1000.0;
            x = Math.sin(Math.toRadians(t * 360.0 / period));
            x = x * Double.parseDouble(this.simInputAmplitude1) + Double.parseDouble(this.simInputOffset1);
        } else if (this.simInputType1 == SimInputFrame.SIM_IN_TYPES.Costant) {
            x = Double.parseDouble(this.simInputAmplitude1);
        } else if (this.simInputType1 == SimInputFrame.SIM_IN_TYPES.Triangle) {
            nOfSines = 25;
            double t = (double)this.simInputTimer.GetTimeElapsed() / 1000.0;
            for (int k = 0; k <= nOfSines; ++k) {
                x += Math.pow(-1.0, k) * Math.sin(Math.toRadians((double)(2 * k + 1) * t * 360.0 / period)) / Math.pow(2 * k + 1, 2.0);
            }
            x = x * 8.0 / Math.pow(Math.PI, 2.0);
            x = x * Double.parseDouble(this.simInputAmplitude1) + Double.parseDouble(this.simInputOffset1);
        } else if (this.simInputType1 == SimInputFrame.SIM_IN_TYPES.Square) {
            nOfSines = 50;
            double t = (double)this.simInputTimer.GetTimeElapsed() / 1000.0;
            for (int k = 1; k <= nOfSines; k += 2) {
                x += Math.sin(Math.toRadians((double)k * t * 360.0 / period)) / (double)k;
            }
            if (x > 0.75) {
                x = 1.0;
            } else if (x < -0.75) {
                x = -1.0;
            }
            x = x * Double.parseDouble(this.simInputAmplitude1) + Double.parseDouble(this.simInputOffset1);
        }
        return x;
    }

    @Override
    public void showSimulationDialog() {
        this.simDialog.setTitle(this.deviceID);
        this.simDialog.comboWaveType1.setSelectedItem((Object)this.simInputType1);
        this.simDialog.txtAmplitude1.setText(this.simInputAmplitude1);
        this.simDialog.txtOffset1.setText(this.simInputOffset1);
        this.simDialog.txtPeriod1.setText(this.simInputPeriod1);
        super.showSimulationDialog();
    }

    @Override
    protected void simDialogClosed() {
        if (this.blockType.equals((Object)CommonDefinitions.blockTypes.DigitalIN)) {
            super.simDialogClosed();
            this.simInputType1 = (SimInputFrame.SIM_IN_TYPES)((Object)this.simDialog.comboWaveType1.getSelectedItem());
            this.simInputAmplitude1 = this.simDialog.txtAmplitude1.getText();
            this.simInputOffset1 = this.simDialog.txtOffset1.getText();
            this.simInputPeriod1 = this.simDialog.txtPeriod1.getText();
        }
    }
}

