/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.table.DefaultTableModel;
import nodes.AFONodeWidget;
import nodes.BoardsTypesAndDescription;
import nodes.CommonDefinitions;
import nodes.Project;
import nodes.SceneSerializer;
import nodes.devices.DeviceNode;
import nodes.devices.GenericNode;
import nodes.devices.MonitorNode_2;
import nodes.gui.SimInputFrame;
import nodes.gui.SimMultiInputFrame;
import nodes.gui.SimplePropertiesDlg;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class DipSwitchNode
extends DeviceNode {
    private String type;
    public static final int DipSwitch_ID = 27;
    int rs485ReservedBits = 0;
    DefaultTableModel simTableModel;
    SimMultiInputFrame simMultiInFrame = new SimMultiInputFrame();

    public DipSwitchNode(String id, String label, String analogID, AFOGraphPinScene scene) {
        super(id, label, analogID, scene);
        this.type = label;
        this.propertiesDialog = new SimplePropertiesDlg(null, true, this.deviceID, this);
        ((SimplePropertiesDlg)this.propertiesDialog).jLabel1.setText("RS485 Bits:");
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.removeAllItems();
        for (int i = 0; i < 7; ++i) {
            ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.addItem("" + i);
        }
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.setSelectedIndex(0);
        ((SimplePropertiesDlg)this.propertiesDialog).txtValue.setVisible(false);
        ((SimplePropertiesDlg)this.propertiesDialog).lblValue.setVisible(false);
        this.blockType = CommonDefinitions.blockTypes.DipSwitch;
        this.numberOfInputs = 0;
        this.setConnectionStatus(false);
        this.createWidget();
        this.addressSpace = 8;
        this.codici = new ArrayList();
        this.codici.add(0, "DipSwitch");
        this.codici.add(1, "DS1");
        this.codici.add(2, "DS2");
        this.codici.add(3, "DS3");
        this.codici.add(4, "DS4");
        this.codici.add(5, "DS5");
        this.codici.add(6, "DS6");
        this.setList(this.codici);
        this.createSimTable();
        this.simMultiInFrame.btnExit.addActionListener(this);
    }

    private void createSimTable() {
        this.simTableModel = new DefaultTableModel(new Object[]{MonitorNode_2.simModelColumns.Label.toString(), MonitorNode_2.simModelColumns.Type.toString(), MonitorNode_2.simModelColumns.Amplitude.toString(), MonitorNode_2.simModelColumns.Offset.toString(), MonitorNode_2.simModelColumns.Period.toString(), MonitorNode_2.simModelColumns.PinID}, 0);
        for (int i = 0; i < 8; ++i) {
            this.simTableModel.addRow(new Object[]{"Bit" + (i + 1), "Costant", "1.0", "0.0", "60.0"});
        }
    }

    public void control() {
        if (this.getAddress().equals("")) {
            ((SimplePropertiesDlg)this.propertiesDialog).indexLabel.setVisible(false);
        }
        if (this.controlAddress(this.getAddress(), false).booleanValue()) {
            ((SimplePropertiesDlg)this.propertiesDialog).indexLabel.setVisible(true);
        } else {
            ((SimplePropertiesDlg)this.propertiesDialog).indexLabel.setVisible(false);
        }
    }

    @Override
    public void setProject(Project prj) {
        this.prj = prj;
        if (!prj.getBoardType().equals((Object)BoardsTypesAndDescription.BoardType.mPID4CLT)) {
            for (int i = 0; i < 2; ++i) {
                String pinLabel = "" + (i + 7);
                String pinID = "pin" + ++this.scene.pinIDCounter;
                AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
                newPin.setAsBusPin(false);
                newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
                newPin.setPinIDString("OUT" + (i + 7));
                this.pinList.add(newPin);
                newPin.setParentNode(this);
                this.getScene().addPin(this, newPin);
                this.setPinValue(newPin.getPinIDString(), "-100.0");
                ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.addItem("" + (i + 7));
            }
            this.codici.add(7, "DS7");
            this.codici.add(8, "DS8");
            this.codici.add(9, "RS485Bits");
            this.addressSpace = 10;
        } else {
            this.codici.add("RS485Bits");
        }
    }

    public String getAddress() {
        String newAddress = ((SimplePropertiesDlg)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void createWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName(this.type);
        this.getScene().addNode(this);
        this.deviceID = "";
        for (int i = 0; i < 6; ++i) {
            String pinLabel = "" + (i + 1);
            String pinID = "pin" + ++this.scene.pinIDCounter;
            AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
            newPin.setAsBusPin(false);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            newPin.setPinIDString("OUT" + (i + 1));
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
        }
        ((AFONodeWidget)this.widget).setSubType(this.deviceID);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.setSelectedIndex(this.rs485ReservedBits);
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.setEnabled(!this.kernelConnected);
        ((SimplePropertiesDlg)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((SimplePropertiesDlg)this.propertiesDialog).indexLabel.setVisible(false);
        this.propertiesDialog.setVisible(true);
        if (((SimplePropertiesDlg)this.propertiesDialog).getReturnStatus() == 1 && ((SimplePropertiesDlg)this.propertiesDialog).fieldChanged) {
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.propertiesDialog.setVisible(false);
            this.scene.sceneChanged();
            this.rs485ReservedBits = ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.getSelectedIndex();
        }
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        retVal = retVal + "27 " + this.getCommonData() + this.rs485ReservedBits;
        return retVal;
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        this.parseStandardBlockCmd(cmd);
        return true;
    }

    @Override
    public void setConnectionStatus(boolean isConnected) {
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "ReservedBits", "" + this.rs485ReservedBits);
        for (int i = 0; i < 8; ++i) {
            Element climaticElement = document.createElement("TableRow");
            SceneSerializer.setAttribute(document, climaticElement, "simType", this.simTableModel.getValueAt(i, 1).toString());
            SceneSerializer.setAttribute(document, climaticElement, "simAmplitude", this.simTableModel.getValueAt(i, 2).toString());
            SceneSerializer.setAttribute(document, climaticElement, "simOffset", this.simTableModel.getValueAt(i, 3).toString());
            SceneSerializer.setAttribute(document, climaticElement, "simPeriod", this.simTableModel.getValueAt(i, 4).toString());
            nodeElement.appendChild(climaticElement);
        }
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        this.deviceID = SceneSerializer.getAttributeValue(node, "driverID");
        ((AFONodeWidget)this.widget).setSubType(this.deviceID);
        this.rs485ReservedBits = Integer.parseInt(SceneSerializer.getAttributeValue(node, "ReservedBits"));
        DipSwitchNode.tableClear(this.simTableModel);
        int count = 1;
        for (Node element : SceneSerializer.getChildNode(node)) {
            if (!element.getNodeName().equals("TableRow")) continue;
            String myType = SceneSerializer.getAttributeValue(element, "simType");
            String amplitude = SceneSerializer.getAttributeValue(element, "simAmplitude");
            String offset = SceneSerializer.getAttributeValue(element, "simOffset");
            String period = SceneSerializer.getAttributeValue(element, "simPeriod");
            if (myType == null) {
                myType = SimInputFrame.SIM_IN_TYPES.Costant.toString();
            }
            if (amplitude == null) {
                amplitude = "1.0";
            }
            if (offset == null) {
                offset = "0.0";
            }
            if (period == null) {
                period = "60.0";
            }
            this.simTableModel.addRow(new Object[]{"Bit" + count, myType, amplitude, offset, period});
            ++count;
        }
        if (this.simTableModel.getRowCount() == 0) {
            this.createSimTable();
        }
    }

    @Override
    public void initSimulation() {
        super.initSimulation();
        this.simInputTimer = new GenericNode.SimTimer(this);
    }

    private SimInputFrame.SIM_IN_TYPES getTypeFromString(String str) {
        for (SimInputFrame.SIM_IN_TYPES sim : SimInputFrame.SIM_IN_TYPES.values()) {
            if (!sim.toString().equals(str)) continue;
            return sim;
        }
        return SimInputFrame.SIM_IN_TYPES.Costant;
    }

    @Override
    public void simulate() {
        super.simulate();
        int nOfBits = 0;
        nOfBits = this.prj.getBoardType().equals((Object)BoardsTypesAndDescription.BoardType.mPID4CLT) ? 6 : 8;
        for (int i = this.rs485ReservedBits; i < nOfBits; ++i) {
            SimInputFrame.SIM_IN_TYPES rowType = this.getTypeFromString(this.simTableModel.getValueAt(i, 1).toString());
            double amp = Double.parseDouble(this.simTableModel.getValueAt(i, 2).toString());
            double offset = Double.parseDouble(this.simTableModel.getValueAt(i, 3).toString());
            double period = Double.parseDouble(this.simTableModel.getValueAt(i, 4).toString());
            double x = this.waveGenerator(rowType, period, amp, offset);
            GenericNode.SimData out = this.GetMData(i);
            out.isValid = true;
            out.data = x;
            this.SetMData(i, out);
        }
        this.updateSimOutputs();
    }

    @Override
    public void showSimulationDialog() {
        this.simMultiInFrame.cleanTable();
        DefaultTableModel dialogTable = new DefaultTableModel(new Object[0][], new Object[]{"Label", "Type", "Amplitude", "Offset", "Period", "PinID"});
        this.simTableCopyToDialog(dialogTable, this.simTableModel);
        this.simMultiInFrame.table.setModel(dialogTable);
        this.simMultiInFrame.setupComboForDigital();
        this.simMultiInFrame.hideColumn(5);
        this.simMultiInFrame.setVisible(true);
    }

    @Override
    protected void simDialogClosed() {
        DefaultTableModel dialogTable = (DefaultTableModel)this.simMultiInFrame.table.getModel();
        this.simTableCopyFromDialog(this.simTableModel, dialogTable);
    }

    public static void tableClear(DefaultTableModel table) {
        while (table.getRowCount() > 0) {
            table.removeRow(0);
        }
    }

    public void simTableCopyToDialog(DefaultTableModel destTable, DefaultTableModel srcTable) {
        DipSwitchNode.tableClear(destTable);
        int nOfBits = 0;
        nOfBits = this.prj.getBoardType().equals((Object)BoardsTypesAndDescription.BoardType.mPID4CLT) ? 6 : 8;
        for (int i = this.rs485ReservedBits; i < nOfBits; ++i) {
            destTable.addRow(new Object[]{"Bit" + (i + 1), srcTable.getValueAt(i, 1), srcTable.getValueAt(i, 2), srcTable.getValueAt(i, 3), srcTable.getValueAt(i, 4), i});
        }
    }

    public void simTableCopyFromDialog(DefaultTableModel destTable, DefaultTableModel srcTable) {
        for (int i = 0; i < srcTable.getRowCount(); ++i) {
            int rowIndex = Integer.parseInt(srcTable.getValueAt(i, 5).toString());
            destTable.setValueAt(srcTable.getValueAt(i, 1), rowIndex, 1);
            destTable.setValueAt(srcTable.getValueAt(i, 2), rowIndex, 2);
            destTable.setValueAt(srcTable.getValueAt(i, 3), rowIndex, 3);
            destTable.setValueAt(srcTable.getValueAt(i, 4), rowIndex, 4);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.simMultiInFrame.btnExit)) {
            this.simDialogClosed();
        }
    }
}

