/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import java.util.ArrayList;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.devices.GenericNode;
import nodes.gui.GenericBlockDialog;
import org.netbeans.api.visual.widget.Widget;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class GateNode
extends GenericNode {
    public static final int GATE_ID = 16;
    GenericNode.SimTimer m_UpdateTimer;
    double m_LastInput1;
    double m_LastInput2;

    public GateNode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        this.blockType = CommonDefinitions.blockTypes.Gate;
        this.addressSpace = 3;
        this.numberOfInputs = 2;
        this.codici = new ArrayList();
        this.codici.add(0, "Gate");
        this.codici.add(1, "OUT_Q_Gate");
        this.codici.add(2, "OUT_QNe_Gate");
        this.setList(this.codici);
        this.CreateWidget();
        this.CreatePropertiesDialog();
        this.cleanSimDialog();
    }

    public String getAddress() {
        String newAddress = ((GenericBlockDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("FF JK");
        this.getScene().addNode(this);
        String pinLabel = "Q";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        pinLabel = "Q Neg";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT2");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        pinLabel = "J";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setPinIDString("IN1");
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "K";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setPinIDString("IN2");
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new GenericBlockDialog(null, true, this);
        ((GenericBlockDialog)this.propertiesDialog).txtAddress.setText("NA");
        for (CommonDefinitions.logicTypes myType : CommonDefinitions.logicTypes.values()) {
            ((GenericBlockDialog)this.propertiesDialog).comboSubType.addItem(myType.toString());
        }
        ((GenericBlockDialog)this.propertiesDialog).lblCombo.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).lblField1.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).lblField2.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).txtField2.setVisible(false);
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
        }
        return true;
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        ((GenericBlockDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((GenericBlockDialog)this.propertiesDialog).indexLabel.setVisible(false);
        this.propertiesDialog.setVisible(true);
        if (((GenericBlockDialog)this.propertiesDialog).getReturnStatus() == 1) {
            if (!((GenericBlockDialog)this.propertiesDialog).fieldChanged) {
                return;
            }
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.propertiesDialog.setVisible(false);
        }
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        retVal = retVal + "16 " + this.getCommonData();
        return retVal;
    }

    @Override
    public void initSimulation() {
        super.initSimulation();
        this.m_LastInput2 = -1.0;
        this.m_LastInput1 = -1.0;
        this.m_UpdateTimer = new GenericNode.SimTimer(this);
        this.m_UpdateTimer.setTimer(250);
        GenericNode.SimData out = this.GetMData(0);
        GenericNode.SimData out1 = this.GetMData(1);
        out.data = 0.0;
        out1.data = 0.0;
        this.SetMData(0, out);
        this.SetMData(1, out1);
        this.updateSimOutputs();
    }

    @Override
    public void simulate() {
        super.simulate();
        boolean inputChanged = false;
        double input1 = 0.0;
        double input2 = 0.0;
        GenericNode.SimData out = this.GetMData(0);
        GenericNode.SimData out1 = this.GetMData(1);
        if (!this.m_UpdateTimer.isTimerExpired()) {
            return;
        }
        try {
            input1 = this.GetInputData(0);
            input2 = this.GetInputData(1);
        }
        catch (Exception exception) {
            this.invalidateOutputs();
            this.updateSimOutputs();
            return;
        }
        if (this.m_LastInput1 != input1 || this.m_LastInput2 != input2) {
            inputChanged = true;
        }
        this.m_LastInput1 = input1;
        this.m_LastInput2 = input2;
        out1.isValid = true;
        out.isValid = true;
        if (input1 != 0.0 || input2 != 0.0) {
            if (input1 != 0.0 && input2 == 0.0) {
                out.data = 1.0;
                out1.data = 0.0;
            } else if (input1 == 0.0 && input2 != 0.0) {
                out.data = 0.0;
                out1.data = 1.0;
            } else if (input1 != 0.0 && input2 != 0.0) {
                out.data = out.data != 0.0 ? 0.0 : 1.0;
                out1.data = out1.data != 0.0 ? 0.0 : 1.0;
            }
        }
        this.SetMData(0, out);
        this.SetMData(1, out1);
        this.updateSimOutputs();
        if (inputChanged) {
            this.m_UpdateTimer.setTimer(250);
        }
    }
}

