/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import Util.ProgressBar;
import VisiProg.AppOptions;
import connection.ICmd;
import connection.IKernel;
import connection.IKernelEventListener;
import connection.KernelEvent;
import connection.SerialKernel;
import connection.XMLCommands.Cmd;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import nodes.AFOSystemManager;
import nodes.AfoDBDao;
import nodes.CommonDefinitions;
import nodes.MyGraphPinScene;
import nodes.Project;
import nodes.SceneSerializer;
import nodes.SingleValDataEntry;
import nodes.devices.ScopeNode;
import nodes.devices.SubSystemIONode;
import nodes.gui.SimInputFrame;
import org.jfree.data.time.Second;
import org.netbeans.api.visual.action.WidgetAction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOEdge;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFONode;
import sceneManager.AFOPin;
import sceneManager.TextEditorEvent;
import sceneManager.TextEditorEventListener;

public class GenericNode
extends AFONode
implements IKernelEventListener,
TextEditorEventListener,
ActionListener {
    protected int configSlotsUsed = 1;
    protected static final String deviceConfigFormat = "Device%02d=";
    private int iniFileBlockNumber;
    protected static final int MAX_NUM_INPUT_PIN = 66;
    protected static final int MAX_NUM_OUTPUT_PIN = 60;
    protected SerialKernel kernel;
    protected int numberOfInputs = 0;
    public boolean kernelConnected = false;
    protected ArrayList<String> commandQueue;
    protected Boolean sendingCommandQueue = false;
    protected Boolean closePropertiesDialogOnCommandQueueEmpty = true;
    protected final int MAX_MSG_SEND_RETRIES = 3;
    protected int msgSendRetries = 0;
    protected boolean collectPlantDataStatus = false;
    private ProgressBar bar = new ProgressBar(null, false);
    Locale currentLocale;
    private AppOptions options = new AppOptions();
    ResourceBundle message;
    private AFOSystemManager sysManager = null;
    private AfoDBDao database;
    public static final int MAX_DEVICE_ADDRESS_SPACE = 10;
    public static final int MAX_BLOCK_ADDRESS_SPACE = 25;
    public static final int MAX_BLOCK_ADDRESS_SPACE_MONITOR2 = 50;
    public ArrayList<String> codici;
    public Project prj;
    ArrayList<SimData> m_Data;
    ArrayList<SimData> inputData;
    ArrayList<Double> registerArray;
    protected SimInputFrame.SIM_IN_TYPES simInputType = SimInputFrame.SIM_IN_TYPES.Costant;
    protected String simInputPeriod = "60.0";
    protected String simInputAmplitude = "1.0";
    protected String simInputOffset = "0.0";
    protected double simStep = 0.0;
    protected SimTimer simInputTimer;
    protected final int SIM_INPUT_STEP_MS = 50;
    protected SimInputFrame simDialog;
    long actTimeMs;
    protected final double CLOCK_SECOND = 1000.0;

    public GenericNode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        this.addressSpace = 0;
        this.addressList = new ArrayList();
        this.commandQueue = new ArrayList();
        this.options.LoadOptions();
        this.currentLocale = new Locale(this.options.language, this.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        if (this.textEditor != null) {
            this.textEditor.addEventListener(this);
        }
        this.simDialog = new SimInputFrame();
        this.simDialog.btnExit.addActionListener(this);
        this.simDialog.setTitle(label);
        this.codici = new ArrayList();
    }

    public void setDatabase(AfoDBDao newDB) {
        this.database = newDB;
        this.addNodeToDB();
    }

    public Boolean controlAddress(String address, Boolean isMonitor) {
        if (this.addressList.isEmpty()) {
            return false;
        }
        if (this.addressList.isEmpty() || address.equals(((Integer)this.addressList.get(0)).toString())) {
            return false;
        }
        if (this.sysManager.existAddress(address, isMonitor)) {
            return true;
        }
        return false;
    }

    public void setSysManager(AFOSystemManager sysManager) {
        this.sysManager = sysManager;
    }

    protected void addNodeToDB() {
        if (this.database == null) {
            return;
        }
        try {
            if (this.addressList == null || this.addressList.isEmpty()) {
                return;
            }
            if (!this.database.existsDevice((Integer)this.addressList.get(0))) {
                this.database.saveDeviceRecord(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getConfigString(int deviceIndex) throws Exception {
        throw new Exception(this.message.getString("istclasse"));
    }

    public ArrayList<String> getList() {
        return this.codici;
    }

    public void setList(ArrayList<String> codici) {
        this.codici = codici;
    }

    public boolean parseCmd(ICmd com) {
        return false;
    }

    public void resetPinValues() {
        for (AFOPin checkedPin : this.pinList) {
            if (checkedPin.isBusPin() || checkedPin.getParentNode() instanceof SubSystemIONode) continue;
            this.setPinValue(checkedPin.getPinIDString(), "-100.0");
        }
    }

    @Override
    public CommonDefinitions.blockTypes getBlockType() {
        return this.blockType;
    }

    protected boolean isMsgForMe(ICmd com) {
        int msgAddr = 0;
        if (!com.containsAttribute("ADDRESS")) {
            return false;
        }
        msgAddr = Integer.parseInt(com.getValue("ADDRESS"));
        return msgAddr >= (Integer)this.addressList.get(0) && msgAddr < (Integer)this.addressList.get(0) + this.addressSpace;
    }

    protected boolean parseStandardBlockCmd(ICmd com) {
        try {
            String output;
            AFOPin pin;
            String tempVal;
            String input;
            int i;
            if (!this.isMsgForMe(com)) {
                return false;
            }
            for (i = 0; i < 66 && com.containsAttribute(input = "IN" + (i + 1)); ++i) {
                tempVal = com.getValue(input);
                this.setPinValue(input, tempVal);
                try {
                    pin = this.getPinByID(input);
                    if (pin == null) continue;
                    this.updateDB(Float.parseFloat(tempVal), 2, input);
                    continue;
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
            }
            for (i = 0; i < 60 && com.containsAttribute(output = "OUT" + (i + 1)); ++i) {
                tempVal = com.getValue(output);
                this.setPinValue(output, tempVal);
                try {
                    this.setTargetPinValue(output, tempVal);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                this.sendValueToChart(output, tempVal);
                try {
                    pin = this.getPinByID(output);
                    if (pin == null) continue;
                    this.updateDB(Float.parseFloat(tempVal), 3, output);
                    continue;
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
            }
            this.getScene().validate();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(null, this.message.getString("errinter"), this.message.getString("er"), 0);
            return false;
        }
    }

    public boolean parseBlockCmd(ICmd com) {
        if (this.blockType.equals((Object)CommonDefinitions.blockTypes.Subsystem) || this.blockType.equals((Object)CommonDefinitions.blockTypes.IN) || this.blockType.equals((Object)CommonDefinitions.blockTypes.OUT) || this.blockType.equals((Object)CommonDefinitions.blockTypes.Comment) || this.blockType.equals((Object)CommonDefinitions.blockTypes.Scope)) {
            return false;
        }
        return this.parseStandardBlockCmd(com);
    }

    protected AFOPin getPinByID(String pinIdx) {
        for (AFOPin pin : this.pinList) {
            if (!pin.getPinIDString().equals(pinIdx)) continue;
            return pin;
        }
        return null;
    }

    public void setPinValue(String pinIdx, String value) {
        try {
            this.getPinByID(pinIdx).setValue(value);
            this.getScene().validate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getPinValue(String pinIdx) {
        try {
            return this.getPinByID(pinIdx).getValue();
        }
        catch (Exception ex) {
            return "";
        }
    }

    @Override
    public List<Integer> getAddressList() {
        return this.addressList;
    }

    public void generateAddresses(Integer startAddress) {
        switch (this.blockType) {
            case Comment: {
                this.addressSpace = 0;
                return;
            }
        }
        try {
            int i;
            for (i = 0; i < this.getAddressSpace(); ++i) {
                this.addressList.add(new Integer(startAddress + i));
                if (i >= this.pinList.size()) continue;
                ((AFOPin)this.pinList.get((int)i)).pinAddress = startAddress + i;
            }
            if (this.pinList.size() > this.getAddressSpace() + 1) {
                for (i = this.getAddressSpace(); i < this.pinList.size(); ++i) {
                    if (((AFOPin)this.pinList.get(i)).isBusPin()) continue;
                    ((AFOPin)this.pinList.get((int)i)).pinAddress = ((AFOPin)this.pinList.get((int)(this.getAddressSpace() - 1))).pinAddress;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.addressList.add(new Integer(0));
        }
    }

    public int getConfigSlotsUsed() {
        return this.configSlotsUsed;
    }

    protected String boolToIntString(boolean val) {
        if (val) {
            return "1";
        }
        return "0";
    }

    protected boolean intStringToBool(String val) {
        return val.equalsIgnoreCase("1");
    }

    protected Integer boolToInteger(boolean val) {
        Integer retVal = val ? new Integer(1) : new Integer(0);
        return retVal;
    }

    protected String getCommonData() {
        int inputNumber = 1;
        boolean outputNumber = true;
        String retVal = "";
        retVal = retVal + Integer.toString((Integer)this.addressList.get(0)) + " " + this.numberOfInputs + " ";
        for (AFOPin pinExamined : this.getPinList()) {
            if (pinExamined.getPinType() == AFOPin.E_PinType.PIN_OUTPUT) continue;
            if (this.getScene().findPinEdges(pinExamined, true, true).size() == 0) {
                retVal = retVal + "0-0 ";
                continue;
            }
            if (pinExamined.getPinType() != AFOPin.E_PinType.PIN_INPUT) continue;
            retVal = retVal + this.getCommonInputData((MyGraphPinScene)this.scene, pinExamined, inputNumber);
            ++inputNumber;
        }
        return retVal;
    }

    public String getCommonInputData(MyGraphPinScene pinScene, AFOPin inputPin, int inputNumber) {
        String retVal = "";
        Object[] edgesArray = pinScene.findPinEdges(inputPin, false, true).toArray();
        if (edgesArray.length == 0) {
            JOptionPane.showMessageDialog(null, this.message.getString("erringress"));
            return inputNumber + "-" + "0";
        }
        AFOEdge edge = (AFOEdge)edgesArray[0];
        AFOPin sourcePin = (AFOPin)pinScene.getEdgeSource(edge);
        GenericNode sourceNode = (GenericNode)pinScene.getPinNode(sourcePin);
        if (sourceNode.getBlockType().equals((Object)CommonDefinitions.blockTypes.IN)) {
            Object[] edges = ((SubSystemIONode)sourceNode).getParentScene().findPinEdges(((SubSystemIONode)sourceNode).getParentPin(), false, true).toArray();
            if (edges.length == 0) {
                retVal = "0-0 ";
            } else {
                for (int i = 0; i < edges.length; ++i) {
                    AFOPin sourceParentPin = ((SubSystemIONode)sourceNode).getParentPin();
                    retVal = this.getCommonInputData(((SubSystemIONode)sourceNode).getParentScene(), sourceParentPin, inputNumber);
                }
            }
        } else if (sourceNode instanceof AFOSystemManager) {
            SubSystemIONode ioNode = ((AFOSystemManager)sourceNode).getPinChildNode(sourcePin);
            try {
                retVal = this.getCommonInputData((MyGraphPinScene)ioNode.getScene(), ioNode.getPinAt(0), inputNumber);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (sourceNode.getBlockType().ordinal() >= CommonDefinitions.blockTypes.IF.ordinal() || sourceNode.getBlockType().ordinal() <= CommonDefinitions.blockTypes.ModbusOUT.ordinal()) {
            int pinIndex = sourceNode.getOutputPinChannel(sourcePin);
            retVal = retVal + sourceNode.getAddressList().get(0) + "-" + pinIndex + " ";
        }
        return retVal;
    }

    private int getOutputPinChannel(AFOPin pin) {
        int channelNo = 0;
        for (AFOPin checkPin : this.pinList) {
            if (checkPin.equals(pin)) {
                return channelNo;
            }
            if (checkPin.getPinType() != AFOPin.E_PinType.PIN_OUTPUT) continue;
            ++channelNo;
        }
        return 0;
    }

    private List<Integer> getIOAddress(boolean isInput, SubSystemIONode ioNode) {
        ArrayList<Integer> retVal;
        block9: {
            retVal = new ArrayList<Integer>();
            try {
                Object[] edges = ioNode.getParentScene().findPinEdges(ioNode.getParentPin(), true, true).toArray();
                if (edges.length == 0) {
                    return retVal;
                }
                if (isInput) {
                    for (int i = 0; i < edges.length; ++i) {
                        AFOPin sourcePin = (AFOPin)ioNode.getParentScene().getEdgeSource((AFOEdge)edges[i]);
                        GenericNode sourceNode = (GenericNode)ioNode.getParentScene().getPinNode(sourcePin);
                        if (((AFONode)sourceNode).getBlockType().equals((Object)CommonDefinitions.blockTypes.IN)) {
                            if (this.getIOAddress(true, (SubSystemIONode)sourceNode).size() <= 0) continue;
                            retVal.add((int)this.getIOAddress(true, (SubSystemIONode)sourceNode).get(0));
                            continue;
                        }
                        retVal.add(new Integer(sourcePin.pinAddress));
                    }
                    break block9;
                }
                for (int i = 0; i < edges.length; ++i) {
                    AFOPin targetPin = (AFOPin)ioNode.getParentScene().getEdgeTarget((AFOEdge)edges[i]);
                    GenericNode targetNode = (GenericNode)ioNode.getParentScene().getPinNode(targetPin);
                    if (targetNode instanceof SubSystemIONode) {
                        List<Integer> subAddresses = this.getIOAddress(false, (SubSystemIONode)targetNode);
                        for (Integer subAddr : subAddresses) {
                            retVal.add(subAddr);
                        }
                        continue;
                    }
                    if (((AFONode)targetNode).getBlockType().ordinal() > CommonDefinitions.blockTypes.ModbusOUT.ordinal()) continue;
                    retVal.add(new Integer(targetPin.pinAddress));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retVal;
    }

    public int getIniFileBlockNumber() {
        return this.iniFileBlockNumber;
    }

    public void setIniFileBlockNumber(int iniFileBlockNumber) {
        this.iniFileBlockNumber = iniFileBlockNumber;
    }

    public void addKeyEventManager(WidgetAction.Adapter action) {
        this.widget.getActions().addAction((WidgetAction)action);
    }

    protected void setTargetPinValue(AFOPin sourcePin, String value) {
        try {
            if (this.scene.findPinEdges(sourcePin, true, false) == null) {
                return;
            }
            Object[] edgeArray = this.getScene().findPinEdges(sourcePin, true, false).toArray();
            for (int i = 0; i < edgeArray.length; ++i) {
                AFOPin targetPin = (AFOPin)this.getScene().getEdgeTarget((AFOEdge)edgeArray[i]);
                if (targetPin == null) continue;
                if (targetPin.getParentNode() instanceof AFOSystemManager) {
                    targetPin.setValue(value);
                    SubSystemIONode ioNode = ((AFOSystemManager)targetPin.getParentNode()).getPinChildNode(targetPin);
                    ioNode.setPinValue("IN1", value);
                    AFOPin trgPin = ioNode.getPinByID("IN1");
                    if (trgPin == null) {
                        return;
                    }
                    ioNode.setTargetPinValue(trgPin, value);
                    continue;
                }
                if (!(targetPin.getParentNode() instanceof SubSystemIONode)) continue;
                targetPin.setValue(value);
                AFOPin parentPin = ((SubSystemIONode)targetPin.getParentNode()).getParentPin();
                AFOSystemManager sm = (AFOSystemManager)parentPin.getParentNode();
                parentPin.setValue(value);
                sm.sendValueToChart(parentPin, value);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void setTargetPinValue(String pinIdx, String value) {
        for (AFOPin pin : this.pinList) {
            if (!pin.getPinIDString().equals(pinIdx)) continue;
            this.setTargetPinValue(pin, value);
            break;
        }
        this.getScene().validate();
    }

    public void setKernel(IKernel kernel) {
        if (kernel == null) {
            if (this.kernel != null) {
                this.kernel.removeKernelEventListener(this);
            }
            this.kernel = null;
        } else {
            this.kernel = (SerialKernel)kernel;
            this.kernel.addKernelEventListener(this);
        }
    }

    protected Cmd generateBasicNodeCommand() {
        Cmd com = new Cmd("DEVICE");
        com.putValue("COMMAND", "BlockCommand");
        com.putValue("ADDRESS", "100000");
        com.putValue("SUBADDR", ((Integer)this.addressList.get(0)).toString());
        return com;
    }

    public void setConnectionStatus(boolean isConnected) {
    }

    protected void sendCommand(Cmd com) {
        try {
            this.kernel.sendCommand(com.toString());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, this.message.getString("errinvio") + ex.toString());
            ex.printStackTrace();
        }
    }

    public void sendValueToChart(String pinIdx, String val) {
        try {
            AFOPin pin = this.getPinByID(pinIdx);
            Object[] edgesArray = this.scene.findPinEdges(pin, true, false).toArray();
            for (int i = 0; i < edgesArray.length; ++i) {
                AFOEdge edge = (AFOEdge)edgesArray[i];
                AFONode node = ((AFOPin)this.scene.getEdgeTarget(edge)).getParentNode();
                if (node instanceof ScopeNode) {
                    ((ScopeNode)node).addValue(val);
                    continue;
                }
                if (node instanceof SubSystemIONode) {
                    AFONode nd = ((SubSystemIONode)node).getParentPin().getParentNode();
                    for (AFOPin pn : ((GenericNode)nd).getPinList()) {
                        ((GenericNode)nd).sendValueToChart(pn.getPinIDString(), val);
                    }
                    continue;
                }
                if (!(node instanceof AFOSystemManager)) continue;
                AFOPin destPin = (AFOPin)this.scene.getEdgeTarget(edge);
                SubSystemIONode ioNode = ((AFOSystemManager)node).getPinChildNode(destPin);
                for (AFOPin pn : ioNode.getPinList()) {
                    ioNode.sendValueToChart(pn.getPinIDString(), val);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendValueToChart(AFOPin pin, String val) {
        try {
            List<AFONode> nodeList = this.scene.getNodesConnectedAtPin(pin);
            for (AFONode node : nodeList) {
                if (!(node instanceof ScopeNode)) continue;
                ((ScopeNode)node).addValue(val);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public int getAddressSpace() {
        return this.addressSpace;
    }

    public boolean execCommand(ICmd cmd) throws Exception {
        return false;
    }

    protected void regenerateAddressList(int addressBase) {
        this.addressList.clear();
        for (int i = 0; i < this.addressSpace; ++i) {
            this.addressList.add(addressBase + i);
        }
    }

    public void requestData() throws Exception {
        if (this.kernel != null && this.kernel.isConnected()) {
            if (!this.sendingCommandQueue.booleanValue()) {
                this.commandQueue.clear();
                for (int i = 1; i < this.addressSpace; ++i) {
                    String msg = "<BL get " + this.addressList.get(i) + " >";
                    this.commandQueue.add(msg);
                }
                this.sendMessageQueue(false);
            } else {
                JOptionPane.showMessageDialog(null, "Another Send is in progress", "Warning", 2);
            }
        }
    }

    public void requestData(int offset) throws Exception {
        if (this.kernel != null && this.kernel.isConnected()) {
            if (!this.sendingCommandQueue.booleanValue()) {
                this.commandQueue.clear();
                for (int i = 1; i < offset; ++i) {
                    String msg = "<BL get " + this.addressList.get(i) + " >";
                    this.commandQueue.add(msg);
                }
                this.sendMessageQueue(false);
            } else {
                JOptionPane.showMessageDialog(null, "Another Send is in progress", "Warning", 2);
            }
        }
    }

    public void updateBlockIO() throws Exception {
        if (this.kernel != null && this.kernel.isConnected()) {
            if (!this.sendingCommandQueue.booleanValue()) {
                this.commandQueue.clear();
                String msg = "<BL get " + this.addressList.get(0) + " >";
                this.commandQueue.add(msg);
                this.sendMessageQueue(false);
            } else {
                JOptionPane.showMessageDialog(null, "Another Send is in progress", "Warning", 2);
            }
        }
    }

    @Override
    public void kernelEventOccurred(KernelEvent evt) {
        if (evt.getEventType().equals("Kernel Disconnected")) {
            this.kernelConnected = false;
            this.setConnectionStatus(this.kernelConnected);
        } else if (evt.getEventType().equals("ETH Kernel Connected") || evt.getEventType().equals("Serial Kernel Connected")) {
            this.kernelConnected = true;
            this.msgSendRetries = 0;
            this.sendingCommandQueue = false;
            this.commandQueue.clear();
        } else if (evt.getEventType().equals("Command Executed") || evt.getEventType().equals("Valid Reply Received")) {
            if (this.sendingCommandQueue.booleanValue()) {
                System.out.println(this.addressList.size());
                System.out.println(this.commandQueue.size());
                System.out.println((this.addressList.size() - this.commandQueue.size()) * 100 / this.addressList.size());
                this.bar.setProgress((this.addressList.size() - (this.commandQueue.size() - 1)) * 100 / this.addressList.size());
                this.commandQueue.remove(0);
                if (this.commandQueue.size() > 0) {
                    String msg = this.commandQueue.get(0);
                    this.kernel.sendCommand(msg);
                } else {
                    if (this.closePropertiesDialogOnCommandQueueEmpty.booleanValue()) {
                        this.propertiesDialog.setVisible(false);
                    }
                    this.bar.setVisible(false);
                    this.sendingCommandQueue = false;
                    this.kernel.collectPlantData(this.collectPlantDataStatus);
                }
            }
        } else if ((evt.getEventType().equals("Timeout on command") || evt.getEventType().equals("Command Not Executed")) && this.sendingCommandQueue.booleanValue()) {
            if (this.msgSendRetries < 3) {
                ++this.msgSendRetries;
                String msg = this.commandQueue.get(0);
                this.kernel.sendCommand(msg);
            } else {
                JOptionPane.showMessageDialog(null, this.message.getString("errsend") + this.commandQueue.get(0), this.message.getString("er"), 0);
                this.msgSendRetries = 0;
                this.commandQueue.clear();
                this.sendingCommandQueue = false;
                this.bar.setVisible(false);
            }
        }
    }

    protected void sendMessageQueue(Boolean closePropertiesOnExit) {
        if (this.commandQueue.isEmpty()) {
            return;
        }
        boolean sendHash = false;
        for (String st : this.commandQueue) {
            if (!st.toLowerCase().contains("set")) continue;
            sendHash = true;
            break;
        }
        if (sendHash) {
            this.commandQueue.add(this.kernel.getHashCommand());
        }
        this.sendingCommandQueue = true;
        this.closePropertiesDialogOnCommandQueueEmpty = closePropertiesOnExit;
        this.msgSendRetries = 0;
        this.collectPlantDataStatus = this.kernel.getCollectStatus();
        this.kernel.collectPlantData(false);
        this.kernel.sendCommand(this.commandQueue.get(0));
        this.bar.setVisible(true);
        this.bar.setProgress(0);
        this.bar.setAlwaysOnTop(true);
    }

    public ProgressBar getProgressBar() {
        return this.bar;
    }

    protected void updateDB(float val, int tableIndex, String ioID) {
        if (this.database == null || !this.database.isDBEnabled()) {
            return;
        }
        try {
            Second now = new Second();
            Timestamp ts = new Timestamp(now.getFirstMillisecond());
            SingleValDataEntry entry = new SingleValDataEntry(0, (Integer)this.addressList.get(0), ioID, "", ts, val);
            this.database.saveSingleDataEntryRecord(entry, tableIndex);
        }
        catch (Exception ex) {
            System.out.println("ERRORE in aggiornamento DB\r\n" + ex.getMessage());
            ex.printStackTrace();
        }
    }

    @Override
    public void textEditorEventOccurred(TextEditorEvent evt) {
    }

    public String toString() {
        if (this.blockType == null) {
            return "";
        }
        if (this.blockType.equals((Object)CommonDefinitions.blockTypes.Subsystem) || this.blockType.equals((Object)CommonDefinitions.blockTypes.Scope) || this.blockType.equals((Object)CommonDefinitions.blockTypes.Comment) || this.blockType.equals((Object)CommonDefinitions.blockTypes.IN) || this.blockType.equals((Object)CommonDefinitions.blockTypes.OUT)) {
            return this.comment;
        }
        return ((Integer)this.addressList.get(0)).toString() + "-" + this.comment;
    }

    public void setActTime(long newTime) {
        this.actTimeMs = newTime;
    }

    public void showSimulationDialog() {
        if (this.simDialog != null) {
            this.simDialog.comboWaveType.setSelectedItem((Object)this.simInputType);
            this.simDialog.txtAmplitude.setText(this.simInputAmplitude);
            this.simDialog.txtOffset.setText(this.simInputOffset);
            this.simDialog.txtPeriod.setText(this.simInputPeriod);
            this.simDialog.setVisible(true);
        }
    }

    public void simulate() {
        this.updateSimInputs();
        String debug = "Inputs ";
        debug = debug + this.getAddressList().get(0) + " :";
        for (int i = 0; i < this.inputData.size(); ++i) {
            debug = debug + this.inputData.get((int)i).data + " ";
        }
        System.out.println(debug);
    }

    public SimData getSimOutput(int outputIdx) {
        if (outputIdx >= 0 && outputIdx < this.m_Data.size()) {
            return this.m_Data.get(outputIdx);
        }
        return new SimData();
    }

    protected void updateSimInputs() {
        int inputNumber = 1;
        Iterator<AFOPin> pinIt = this.getPinList().iterator();
        while (pinIt.hasNext()) {
            String connectionInfo = "";
            AFOPin pinExamined = pinIt.next();
            if (pinExamined.getPinType() == AFOPin.E_PinType.PIN_OUTPUT) continue;
            if (this.getScene().findPinEdges(pinExamined, true, true).isEmpty()) {
                connectionInfo = connectionInfo + "0-0 ";
                ++inputNumber;
            } else if (pinExamined.getPinType() == AFOPin.E_PinType.PIN_INPUT) {
                connectionInfo = connectionInfo + this.getCommonInputData((MyGraphPinScene)this.scene, pinExamined, inputNumber);
                ++inputNumber;
            }
            if (connectionInfo.length() == 0 || connectionInfo.equals("0-0 ")) {
                this.inputData.set(inputNumber - 2, new SimData());
                continue;
            }
            try {
                StringTokenizer tok = new StringTokenizer(connectionInfo.substring(0, connectionInfo.length() - 1), "-");
                String sourceAddr = tok.nextToken();
                String sourcePin = tok.nextToken();
                AFONode node = this.sysManager.getProject().getBlockByAddress(Integer.parseInt(sourceAddr));
                if (node != null && node instanceof GenericNode) {
                    SimData newdata = ((GenericNode)node).getSimOutput(Integer.parseInt(sourcePin));
                    this.inputData.set(inputNumber - 2, newdata);
                    newdata.connected = true;
                } else {
                    this.inputData.set(inputNumber - 2, new SimData());
                }
                pinExamined.setValue("" + this.inputData.get((int)(inputNumber - 2)).data);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected boolean isInputConnected(int inputNumber) {
        if (inputNumber < this.inputData.size()) {
            return this.inputData.get((int)inputNumber).connected;
        }
        return false;
    }

    protected void updateSimOutputs() {
        int outNumber = 0;
        for (AFOPin pinExamined : this.getPinList()) {
            if (pinExamined.getPinType() != AFOPin.E_PinType.PIN_OUTPUT) continue;
            String output = "OUT" + (outNumber + 1);
            this.setPinValue(output, "" + this.m_Data.get((int)outNumber).data);
            try {
                this.setTargetPinValue(output, "" + this.m_Data.get((int)outNumber).data);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.sendValueToChart(output, "" + this.m_Data.get((int)outNumber).data);
            ++outNumber;
        }
        this.widget.getScene().validate();
    }

    protected void updateSingleOutput(AFOPin pin, SimData value) {
        int outNumber = 0;
        for (AFOPin pinExamined : this.getPinList()) {
            if (pinExamined.getPinType() != AFOPin.E_PinType.PIN_OUTPUT) continue;
            if (pinExamined.getPinIDString().equals(pin.getPinIDString())) {
                this.m_Data.get((int)outNumber).data = value.data;
                this.m_Data.get((int)outNumber).isValid = value.isValid;
                this.setPinValue(pin.getPinIDString(), "" + this.m_Data.get((int)outNumber).data);
                try {
                    this.setTargetPinValue(pin.getPinIDString(), "" + this.m_Data.get((int)outNumber).data);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                this.sendValueToChart(pin.getPinIDString(), "" + this.m_Data.get((int)outNumber).data);
            }
            ++outNumber;
        }
    }

    public void initSimulation() {
        int i;
        this.m_Data = new ArrayList();
        for (i = 0; i < this.getNofOutputPins(); ++i) {
            this.m_Data.add(new SimData());
        }
        this.inputData = new ArrayList();
        for (i = 0; i < this.getNofInputPins(); ++i) {
            this.inputData.add(new SimData());
        }
        this.registerArray = new ArrayList();
        this.actTimeMs = 0L;
    }

    protected double GetParameter(int index) {
        if (index < this.registerArray.size()) {
            return this.registerArray.get(index);
        }
        return -100.0;
    }

    protected void setParameter(int index, double value) {
        if (index < this.registerArray.size()) {
            this.registerArray.set(index, value);
        }
    }

    protected SimData GetMData(int index) {
        if (index < this.m_Data.size()) {
            return this.m_Data.get(index);
        }
        return new SimData();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.simDialog.btnExit)) {
            this.simDialogClosed();
        }
    }

    public void setProject(Project prj) {
        this.prj = prj;
    }

    protected void invalidateOutputs() {
        for (int i = 0; i < this.m_Data.size(); ++i) {
            this.m_Data.set(i, new SimData());
        }
    }

    protected void SetMData(int index, SimData data) {
        if (index < this.m_Data.size()) {
            this.m_Data.set(index, data);
        }
    }

    protected double GetInputData(int index) throws Exception {
        return this.inputData.get((int)index).data;
    }

    protected boolean intToBool(int bool) {
        return bool != 0;
    }

    protected boolean doubleToBool(Double bool) {
        return bool != 0.0;
    }

    protected double boolToDouble(Boolean bool) {
        if (bool.booleanValue()) {
            return 1.0;
        }
        return 0.0;
    }

    protected Element serializeSimParams(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "simInputType", this.simInputType.toString());
        SceneSerializer.setAttribute(document, nodeElement, "simInputPeriod", this.simInputPeriod);
        SceneSerializer.setAttribute(document, nodeElement, "simInputAmplitude", this.simInputAmplitude);
        SceneSerializer.setAttribute(document, nodeElement, "simInputOffset", this.simInputOffset);
        return nodeElement;
    }

    protected void deserializeSimParam(Node node) throws Exception {
        String param = SceneSerializer.getAttributeValue(node, "simInputType");
        if (param != null) {
            for (SimInputFrame.SIM_IN_TYPES it : SimInputFrame.SIM_IN_TYPES.values()) {
                if (!it.toString().equals(param)) continue;
                this.simInputType = it;
                break;
            }
        }
        if ((param = SceneSerializer.getAttributeValue(node, "simInputPeriod")) != null) {
            this.simInputPeriod = param;
        }
        if ((param = SceneSerializer.getAttributeValue(node, "simInputAmplitude")) != null) {
            this.simInputAmplitude = param;
        }
        if ((param = SceneSerializer.getAttributeValue(node, "simInputOffset")) != null) {
            this.simInputOffset = param;
        }
    }

    protected double waveGenerator(SimInputFrame.SIM_IN_TYPES type, double period, double amplitude, double offset) {
        int nOfSines = 1;
        double x = 0.0;
        if (type == SimInputFrame.SIM_IN_TYPES.SawTooth1) {
            nOfSines = 50;
            double t = (double)this.simInputTimer.GetTimeElapsed() / 1000.0;
            for (int k = 1; k <= nOfSines; ++k) {
                x += Math.pow(-1.0, k + 1) * Math.sin(Math.toRadians((double)k * t * 360.0 / period)) / (double)k;
            }
            x = x * 2.0 / Math.PI;
            x = x * amplitude + offset;
        } else if (type == SimInputFrame.SIM_IN_TYPES.SawTooth2) {
            nOfSines = 50;
            double t = (double)this.simInputTimer.GetTimeElapsed() / 1000.0;
            for (int k = 1; k <= nOfSines; ++k) {
                x += Math.pow(-1.0, k + 1) * Math.sin(Math.toRadians((double)k * t * 360.0 / period)) / (double)k;
            }
            x = x * 2.0 / Math.PI;
            x = -1.0 * x * amplitude + offset;
        } else if (type == SimInputFrame.SIM_IN_TYPES.Sinusoidal) {
            double t = (double)this.simInputTimer.GetTimeElapsed() / 1000.0;
            x = Math.sin(Math.toRadians(t * 360.0 / period));
            x = x * amplitude + offset;
        } else if (type == SimInputFrame.SIM_IN_TYPES.Costant) {
            x = amplitude;
        } else if (type == SimInputFrame.SIM_IN_TYPES.Triangle) {
            nOfSines = 25;
            double t = (double)this.simInputTimer.GetTimeElapsed() / 1000.0;
            for (int k = 0; k <= nOfSines; ++k) {
                x += Math.pow(-1.0, k) * Math.sin(Math.toRadians((double)(2 * k + 1) * t * 360.0 / period)) / Math.pow(2 * k + 1, 2.0);
            }
            x = x * 8.0 / Math.pow(Math.PI, 2.0);
            x = x * amplitude + offset;
        } else if (type == SimInputFrame.SIM_IN_TYPES.Square) {
            nOfSines = 50;
            double t = (double)this.simInputTimer.GetTimeElapsed() / 1000.0;
            for (int k = 1; k <= nOfSines; k += 2) {
                x += Math.sin(Math.toRadians((double)k * t * 360.0 / period)) / (double)k;
            }
            if (x > 0.75) {
                x = 1.0;
            } else if (x < -0.75) {
                x = -1.0;
            }
            x = x * amplitude + offset;
        }
        return x;
    }

    protected double waveGenerator() {
        double period = Double.parseDouble(this.simInputPeriod);
        double amplitude = Double.parseDouble(this.simInputAmplitude);
        double offset = Double.parseDouble(this.simInputOffset);
        return this.waveGenerator(this.simInputType, period, amplitude, offset);
    }

    protected void simDialogClosed() {
        this.simInputType = (SimInputFrame.SIM_IN_TYPES)((Object)this.simDialog.comboWaveType.getSelectedItem());
        this.simInputAmplitude = this.simDialog.txtAmplitude.getText();
        this.simInputOffset = this.simDialog.txtOffset.getText();
        this.simInputPeriod = this.simDialog.txtPeriod.getText();
    }

    protected void cleanSimDialog() {
        try {
            this.simDialog.tabbedPaneMain.removeAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected class SimTimer {
        private int timeoutMs = 0;
        private long startTime = 0L;

        public void setTimer(int timeoutMs) {
            this.timeoutMs = timeoutMs;
            this.startTime = GenericNode.this.actTimeMs;
        }

        public boolean isTimerStarted() {
            return this.startTime != 0L;
        }

        public boolean isTimerExpired() {
            long actTime = GenericNode.this.actTimeMs;
            return actTime > this.startTime + (long)this.timeoutMs;
        }

        long GetTimeElapsed() {
            long actTime = GenericNode.this.actTimeMs;
            long timeElapsed = actTime - this.startTime;
            return timeElapsed;
        }
    }

    protected class SimData {
        public double data = -100.0;
        public boolean isValid = false;
        public boolean connected = false;

        public SimData() {
        }

        public SimData(double data, boolean valid) {
            this.data = data;
            this.isValid = valid;
        }
    }
}

