/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import Util.FieldChecker;
import connection.ICmd;
import connection.SerialKernel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.GenericNode;
import nodes.gui.HystersisDialog;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class HysteresisNode
extends GenericNode
implements ActionListener {
    private String bandAmplitude = "1.0";
    private String setpoint = "20.0";
    private String minOutput = "0.0";
    private String maxOutput = "1.0";
    public static final int HYSTERESIS_NODE = 14;
    boolean m_StateValid = false;

    public HysteresisNode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        this.numberOfInputs = 0;
        this.CreateWidget();
        this.addressSpace = 6;
        this.blockType = CommonDefinitions.blockTypes.Hysteresys;
        this.CreatePropertiesDialog();
        this.codici = new ArrayList();
        this.codici.add(0, "Hysteresys");
        this.codici.add(1, "OUT_Hysteresis");
        this.codici.add(2, "Amplitude");
        this.codici.add(3, "SetPoint_Hyst");
        this.codici.add(4, "minOutput_Hysteresis");
        this.codici.add(5, "maxOutput_Hysteresis");
        this.setList(this.codici);
        this.cleanSimDialog();
    }

    public String getAddress() {
        String newAddress = ((HystersisDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("Hysteresis");
        String pinLabel = "OUT";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.pinList.add(newPin);
        this.getScene().addNode(this);
        this.getScene().addPin(this, newPin);
        pinLabel = "IN";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Setpoint";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Min";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Max";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Bnd";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ((AFONodeWidget)this.widget).setSubType("SP:" + this.setpoint + " Bnd:" + this.bandAmplitude);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new HystersisDialog(null, true, this);
        ((HystersisDialog)this.propertiesDialog).btnSend.setVisible(false);
        ((HystersisDialog)this.propertiesDialog).btnOk.addActionListener(this);
        ((HystersisDialog)this.propertiesDialog).btnCancel.addActionListener(this);
    }

    private void setDialogFields() {
        ((HystersisDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((HystersisDialog)this.propertiesDialog).txtSetpoint.setText(this.setpoint);
        ((HystersisDialog)this.propertiesDialog).txtAmplitude.setText(this.bandAmplitude);
        ((HystersisDialog)this.propertiesDialog).txtMaxOut.setText(this.maxOutput);
        ((HystersisDialog)this.propertiesDialog).txtMinOut.setText(this.minOutput);
    }

    private void getDialogFields() {
        this.setpoint = ((HystersisDialog)this.propertiesDialog).txtSetpoint.getText();
        this.bandAmplitude = ((HystersisDialog)this.propertiesDialog).txtAmplitude.getText();
        this.minOutput = ((HystersisDialog)this.propertiesDialog).txtMinOut.getText();
        this.maxOutput = ((HystersisDialog)this.propertiesDialog).txtMaxOut.getText();
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        this.requestData();
        this.setDialogFields();
        ((HystersisDialog)this.propertiesDialog).indexLabel.setVisible(false);
        this.propertiesDialog.setModal(true);
        this.propertiesDialog.setVisible(true);
        if (((HystersisDialog)this.propertiesDialog).getReturnStatus() == 1 && ((HystersisDialog)this.propertiesDialog).fieldChanged) {
            this.scene.sceneChanged();
            this.getDialogFields();
            ((AFONodeWidget)this.widget).setSubType("SP:" + this.setpoint + " Bnd:" + this.bandAmplitude);
        }
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "BandAmplitude", this.bandAmplitude);
        SceneSerializer.setAttribute(document, nodeElement, "Setpoint", this.setpoint);
        SceneSerializer.setAttribute(document, nodeElement, "MinOutput", this.minOutput);
        SceneSerializer.setAttribute(document, nodeElement, "MaxOutput", this.maxOutput);
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        this.setpoint = SceneSerializer.getAttributeValue(node, "Setpoint");
        this.bandAmplitude = SceneSerializer.getAttributeValue(node, "BandAmplitude");
        this.minOutput = SceneSerializer.getAttributeValue(node, "MinOutput");
        this.maxOutput = SceneSerializer.getAttributeValue(node, "MaxOutput");
        ((AFONodeWidget)this.widget).setSubType("SP:" + this.setpoint + " Bnd:" + this.bandAmplitude);
    }

    public String getBandAmplitude() {
        return this.bandAmplitude;
    }

    public void setBandAmplitude(String bandAmplitude) {
        this.bandAmplitude = bandAmplitude;
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        retVal = retVal + "14 " + this.getCommonData() + this.bandAmplitude + " " + this.setpoint + " " + this.minOutput + " " + this.maxOutput;
        return retVal;
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
        } else {
            if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(2)).toString())) {
                this.bandAmplitude = cmd.getValue("TOKEN3");
                ((HystersisDialog)this.propertiesDialog).txtAmplitude.setText(this.bandAmplitude);
                ((AFONodeWidget)this.widget).setSubType("SP:" + this.setpoint + " Bnd:" + this.bandAmplitude);
            } else if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(3)).toString())) {
                this.setpoint = cmd.getValue("TOKEN3");
                ((HystersisDialog)this.propertiesDialog).txtSetpoint.setText(this.setpoint);
                ((AFONodeWidget)this.widget).setSubType("SP:" + this.setpoint + " Bnd:" + this.bandAmplitude);
            } else if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(4)).toString())) {
                this.minOutput = cmd.getValue("TOKEN3");
                ((HystersisDialog)this.propertiesDialog).txtMinOut.setText(this.minOutput);
            } else if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(5)).toString())) {
                this.maxOutput = cmd.getValue("TOKEN3");
                ((HystersisDialog)this.propertiesDialog).txtMaxOut.setText(this.maxOutput);
            }
            this.propertiesDialog.invalidate();
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block8: {
            block7: {
                if (!e.getSource().equals(((HystersisDialog)this.propertiesDialog).btnOk)) break block7;
                if (!(FieldChecker.checkStringIsNumeric(((HystersisDialog)this.propertiesDialog).txtSetpoint.getText(), "Setpoint Errato") && FieldChecker.checkStringIsNumeric(((HystersisDialog)this.propertiesDialog).txtAmplitude.getText(), "Delta Errato") && FieldChecker.checkStringIsNumeric(((HystersisDialog)this.propertiesDialog).txtMinOut.getText(), "Min Errato") && FieldChecker.checkStringIsNumeric(((HystersisDialog)this.propertiesDialog).txtMaxOut.getText(), "Max Errato"))) {
                    return;
                }
                if (!e.getSource().equals(((HystersisDialog)this.propertiesDialog).btnOk)) break block8;
                if (((HystersisDialog)this.propertiesDialog).indexLabel.isVisible()) {
                    JOptionPane.showMessageDialog(null, "L'indirizzo inserito \u00e8 gi\u00e0 in uso!");
                    return;
                }
                this.addressList.clear();
                for (int i = 0; i < this.addressSpace; ++i) {
                    this.addressList.add(Integer.parseInt(this.getAddress()) + i);
                }
                this.addressList.size();
                this.propertiesDialog.setVisible(false);
                if (!this.kernelConnected) break block8;
                String msg = "";
                this.commandQueue.clear();
                msg = "<BL set " + this.addressList.get(2) + " " + ((HystersisDialog)this.propertiesDialog).txtAmplitude.getText() + " >";
                this.commandQueue.add(msg);
                msg = "<BL set " + this.addressList.get(3) + " " + ((HystersisDialog)this.propertiesDialog).txtSetpoint.getText() + " >";
                this.commandQueue.add(msg);
                msg = "<BL set " + this.addressList.get(4) + " " + ((HystersisDialog)this.propertiesDialog).txtMinOut.getText() + " >";
                this.commandQueue.add(msg);
                msg = "<BL set " + this.addressList.get(5) + " " + ((HystersisDialog)this.propertiesDialog).txtMaxOut.getText() + " >";
                this.commandQueue.add(msg);
                this.sendMessageQueue(true);
                break block8;
            }
            if (e.getSource().equals(((HystersisDialog)this.propertiesDialog).btnCancel)) {
                this.propertiesDialog.setVisible(false);
            } else if (e.getSource().equals(((HystersisDialog)this.propertiesDialog).btnRead) && this.kernel instanceof SerialKernel) {
                String msg = "";
                for (int i = 1; i < this.addressSpace; ++i) {
                    msg = "<BL get " + this.addressList.get(i) + " >";
                    this.kernel.sendCommand(msg);
                }
            }
        }
    }

    @Override
    public void setConnectionStatus(boolean isConnected) {
        ((HystersisDialog)this.propertiesDialog).btnRead.setEnabled(isConnected);
        ((HystersisDialog)this.propertiesDialog).btnSend.setEnabled(isConnected);
    }

    @Override
    public void initSimulation() {
        super.initSimulation();
        this.m_StateValid = false;
    }

    @Override
    public void simulate() {
        super.simulate();
        double dbandAmplitude = 1.0;
        double dsetpoint = 20.0;
        double dminOutput = 0.0;
        double dmaxOutput = 1.0;
        dsetpoint = ((GenericNode.SimData)this.inputData.get((int)1)).isValid ? ((GenericNode.SimData)this.inputData.get((int)1)).data : Double.parseDouble(this.setpoint);
        dminOutput = ((GenericNode.SimData)this.inputData.get((int)2)).isValid ? ((GenericNode.SimData)this.inputData.get((int)2)).data : Double.parseDouble(this.minOutput);
        dmaxOutput = ((GenericNode.SimData)this.inputData.get((int)3)).isValid ? ((GenericNode.SimData)this.inputData.get((int)3)).data : Double.parseDouble(this.maxOutput);
        dbandAmplitude = ((GenericNode.SimData)this.inputData.get((int)4)).isValid ? ((GenericNode.SimData)this.inputData.get((int)4)).data : Double.parseDouble(this.bandAmplitude);
        if (!((GenericNode.SimData)this.inputData.get((int)0)).isValid) {
            this.m_Data.set(0, new GenericNode.SimData());
        } else {
            double val = ((GenericNode.SimData)this.inputData.get((int)0)).data;
            if (val < dsetpoint - dbandAmplitude / 2.0) {
                this.m_StateValid = true;
                this.m_Data.set(0, new GenericNode.SimData(dminOutput, true));
            } else if (val > dsetpoint + dbandAmplitude / 2.0) {
                this.m_StateValid = true;
                this.m_Data.set(0, new GenericNode.SimData(dmaxOutput, true));
            } else if (!this.m_StateValid) {
                this.m_StateValid = true;
                this.m_Data.set(0, new GenericNode.SimData(dminOutput, true));
            }
        }
        this.updateSimOutputs();
        System.out.println(((GenericNode.SimData)this.m_Data.get((int)0)).data + "-" + ((GenericNode.SimData)this.m_Data.get((int)0)).isValid);
    }
}

