/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import Util.FieldChecker;
import connection.ICmd;
import connection.SerialKernel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.GenericNode;
import nodes.gui.HysteresisDialog2;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class HysteresisNode2
extends GenericNode
implements ActionListener {
    private String setpoint = "20.0";
    private String minOutput = "0.0";
    private String maxOutput = "1.0";
    private String bandPlus = "1.0";
    private String bandMinus = "1.0";
    private Boolean invertLevels = false;
    public static final int HYSTERESIS2_NODE = 47;
    boolean m_StateIsValid;

    public HysteresisNode2(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        this.numberOfInputs = 0;
        this.CreateWidget();
        this.addressSpace = 8;
        this.blockType = CommonDefinitions.blockTypes.Hysteresys2;
        this.CreatePropertiesDialog();
        this.codici = new ArrayList();
        this.codici.add("Hysteresys");
        this.codici.add("OUT_Hysteresis");
        this.codici.add("SetPoint_Hyst");
        this.codici.add("minOutput_Hysteresis");
        this.codici.add("maxOutput_Hysteresis");
        this.codici.add("BandPlus_Hysteresis");
        this.codici.add("BandMinus_Hysteresis");
        this.codici.add("InvertLevels_Hysteresis");
        this.setList(this.codici);
        this.cleanSimDialog();
    }

    public String getAddress() {
        String newAddress = ((HysteresisDialog2)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("Hysteresis 2");
        String pinLabel = "OUT";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.pinList.add(newPin);
        this.getScene().addNode(this);
        this.getScene().addPin(this, newPin);
        pinLabel = "IN";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Setpoint";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Min";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Max";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Bnd+";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Bnd-";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Invert";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ((AFONodeWidget)this.widget).setSubType("SP:" + this.setpoint + " Bnd+:" + this.bandPlus + " Bnd-:" + this.bandMinus);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new HysteresisDialog2(null, true, this);
        ((HysteresisDialog2)this.propertiesDialog).btnSend.setVisible(false);
        ((HysteresisDialog2)this.propertiesDialog).btnOk.addActionListener(this);
        ((HysteresisDialog2)this.propertiesDialog).btnCancel.addActionListener(this);
    }

    private void setDialogFields() {
        ((HysteresisDialog2)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((HysteresisDialog2)this.propertiesDialog).txtSetpoint.setText(this.setpoint);
        ((HysteresisDialog2)this.propertiesDialog).txtBandPlus.setText(this.bandPlus);
        ((HysteresisDialog2)this.propertiesDialog).txtBandMinus.setText(this.bandMinus);
        ((HysteresisDialog2)this.propertiesDialog).txtMaxOut.setText(this.maxOutput);
        ((HysteresisDialog2)this.propertiesDialog).txtMinOut.setText(this.minOutput);
        ((HysteresisDialog2)this.propertiesDialog).checkInvertLevels.setSelected(this.invertLevels);
    }

    private void getDialogFields() {
        this.setpoint = ((HysteresisDialog2)this.propertiesDialog).txtSetpoint.getText();
        this.bandPlus = ((HysteresisDialog2)this.propertiesDialog).txtBandPlus.getText();
        this.bandMinus = ((HysteresisDialog2)this.propertiesDialog).txtBandMinus.getText();
        this.minOutput = ((HysteresisDialog2)this.propertiesDialog).txtMinOut.getText();
        this.maxOutput = ((HysteresisDialog2)this.propertiesDialog).txtMaxOut.getText();
        this.invertLevels = ((HysteresisDialog2)this.propertiesDialog).checkInvertLevels.isSelected();
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        this.requestData();
        this.setDialogFields();
        ((HysteresisDialog2)this.propertiesDialog).indexLabel.setVisible(false);
        this.propertiesDialog.setModal(true);
        this.propertiesDialog.setVisible(true);
        if (((HysteresisDialog2)this.propertiesDialog).getReturnStatus() == 1 && ((HysteresisDialog2)this.propertiesDialog).fieldChanged) {
            this.scene.sceneChanged();
            this.getDialogFields();
            ((AFONodeWidget)this.widget).setSubType("SP:" + this.setpoint + " Bnd+:" + this.bandPlus + " Bnd-:" + this.bandMinus);
            if (this.kernel != null && this.kernel.isConnected()) {
                if (!this.sendingCommandQueue.booleanValue()) {
                    this.commandQueue.clear();
                    int offset = 2;
                    String msg = "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " " + this.setpoint + " >";
                    this.commandQueue.add(msg);
                    msg = "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " " + this.minOutput + " >";
                    this.commandQueue.add(msg);
                    msg = "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " " + this.maxOutput + " >";
                    this.commandQueue.add(msg);
                    msg = "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " " + this.bandPlus + " >";
                    this.commandQueue.add(msg);
                    msg = "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " " + this.bandMinus + " >";
                    this.commandQueue.add(msg);
                    msg = this.invertLevels != false ? "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " 1.0 >" : "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " 0.0 >";
                    this.commandQueue.add(msg);
                    this.sendMessageQueue(true);
                } else {
                    JOptionPane.showMessageDialog(null, "Another Send is in progress", "Warning", 2);
                }
            }
        }
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "BandPlus", this.bandPlus);
        SceneSerializer.setAttribute(document, nodeElement, "BandMinus", this.bandMinus);
        SceneSerializer.setAttribute(document, nodeElement, "Setpoint", this.setpoint);
        SceneSerializer.setAttribute(document, nodeElement, "MinOutput", this.minOutput);
        SceneSerializer.setAttribute(document, nodeElement, "MaxOutput", this.maxOutput);
        SceneSerializer.setAttribute(document, nodeElement, "InvertLevels", this.invertLevels.toString());
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        this.setpoint = SceneSerializer.getAttributeValue(node, "Setpoint");
        this.bandPlus = SceneSerializer.getAttributeValue(node, "BandPlus");
        this.bandMinus = SceneSerializer.getAttributeValue(node, "BandMinus");
        this.minOutput = SceneSerializer.getAttributeValue(node, "MinOutput");
        this.maxOutput = SceneSerializer.getAttributeValue(node, "MaxOutput");
        try {
            this.invertLevels = Boolean.parseBoolean(SceneSerializer.getAttributeValue(node, "InvertLevels"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((AFONodeWidget)this.widget).setSubType("SP:" + this.setpoint + " Bnd+:" + this.bandPlus + " Bnd-:" + this.bandMinus);
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        retVal = retVal + "47 " + this.getCommonData() + this.setpoint + " " + this.minOutput + " " + this.maxOutput + " " + this.bandPlus + " " + this.bandMinus;
        retVal = this.invertLevels != false ? retVal + " 1" : retVal + " 0";
        return retVal;
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
        } else {
            if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(2)).toString())) {
                this.setpoint = cmd.getValue("TOKEN3");
                ((HysteresisDialog2)this.propertiesDialog).txtSetpoint.setText(this.setpoint);
                ((AFONodeWidget)this.widget).setSubType("SP:" + this.setpoint + " Bnd+:" + this.bandPlus + " Bnd-:" + this.bandMinus);
            } else if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(3)).toString())) {
                this.minOutput = cmd.getValue("TOKEN3");
                ((HysteresisDialog2)this.propertiesDialog).txtMinOut.setText(this.minOutput);
            } else if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(4)).toString())) {
                this.maxOutput = cmd.getValue("TOKEN3");
                ((HysteresisDialog2)this.propertiesDialog).txtMaxOut.setText(this.maxOutput);
            } else if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(5)).toString())) {
                this.bandPlus = cmd.getValue("TOKEN3");
                ((HysteresisDialog2)this.propertiesDialog).txtBandPlus.setText(this.bandPlus);
                ((AFONodeWidget)this.widget).setSubType("SP:" + this.setpoint + " Bnd+:" + this.bandPlus + " Bnd-:" + this.bandMinus);
            } else if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(6)).toString())) {
                this.bandMinus = cmd.getValue("TOKEN3");
                ((HysteresisDialog2)this.propertiesDialog).txtBandMinus.setText(this.bandMinus);
                ((AFONodeWidget)this.widget).setSubType("SP:" + this.setpoint + " Bnd+:" + this.bandPlus + " Bnd-:" + this.bandMinus);
            } else if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(7)).toString())) {
                this.invertLevels = Double.parseDouble(cmd.getValue("TOKEN3")) != 0.0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
                ((HysteresisDialog2)this.propertiesDialog).checkInvertLevels.setSelected(this.invertLevels);
            }
            this.propertiesDialog.invalidate();
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(((HysteresisDialog2)this.propertiesDialog).btnOk)) {
            if (!(FieldChecker.checkStringIsNumeric(((HysteresisDialog2)this.propertiesDialog).txtSetpoint.getText(), "Setpoint Errato") && FieldChecker.checkStringIsNumeric(((HysteresisDialog2)this.propertiesDialog).txtBandPlus.getText(), "Band+ Errato") && FieldChecker.checkStringIsNumeric(((HysteresisDialog2)this.propertiesDialog).txtBandMinus.getText(), "Band- Errato") && FieldChecker.checkStringIsNumeric(((HysteresisDialog2)this.propertiesDialog).txtMinOut.getText(), "Min Errato") && FieldChecker.checkStringIsNumeric(((HysteresisDialog2)this.propertiesDialog).txtMaxOut.getText(), "Max Errato"))) {
                return;
            }
            if (e.getSource().equals(((HysteresisDialog2)this.propertiesDialog).btnOk)) {
                if (((HysteresisDialog2)this.propertiesDialog).indexLabel.isVisible()) {
                    JOptionPane.showMessageDialog(null, "L'indirizzo inserito \u00e8 gi\u00e0 in uso!");
                    return;
                }
                this.addressList.clear();
                for (int i = 0; i < this.addressSpace; ++i) {
                    this.addressList.add(Integer.parseInt(this.getAddress()) + i);
                }
                this.addressList.size();
                this.propertiesDialog.setVisible(false);
            }
        } else if (e.getSource().equals(((HysteresisDialog2)this.propertiesDialog).btnCancel)) {
            this.propertiesDialog.setVisible(false);
        } else if (e.getSource().equals(((HysteresisDialog2)this.propertiesDialog).btnRead) && this.kernel instanceof SerialKernel) {
            String msg = "";
            for (int i = 1; i < this.addressSpace; ++i) {
                msg = "<BL get " + this.addressList.get(i) + " >";
                this.kernel.sendCommand(msg);
            }
        }
    }

    @Override
    public void setConnectionStatus(boolean isConnected) {
        ((HysteresisDialog2)this.propertiesDialog).btnRead.setEnabled(isConnected);
        ((HysteresisDialog2)this.propertiesDialog).btnSend.setEnabled(isConnected);
    }

    void AcquireParamIn() {
        Double param = 0.0;
        for (int i = 1; i < e_HystParams.PARAM_NUMTOT.ordinal() + 1; ++i) {
            try {
                if (!this.isInputConnected(i)) continue;
                param = this.GetInputData(i);
                this.setParameter(i - 1, param);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void initSimulation() {
        super.initSimulation();
        this.registerArray.clear();
        this.registerArray.add(Double.parseDouble(this.setpoint));
        this.registerArray.add(Double.parseDouble(this.minOutput));
        this.registerArray.add(Double.parseDouble(this.maxOutput));
        this.registerArray.add(Double.parseDouble(this.bandPlus));
        this.registerArray.add(Double.parseDouble(this.bandMinus));
        if (this.invertLevels.booleanValue()) {
            this.registerArray.add(1.0);
        } else {
            this.registerArray.add(0.0);
        }
    }

    @Override
    public void simulate() {
        super.simulate();
        double in1 = 0.0;
        GenericNode.SimData out = this.GetMData(0);
        this.AcquireParamIn();
        if (this.isInputConnected(1)) {
            double param = 0.0;
            try {
                param = this.GetInputData(1);
                this.setParameter(e_HystParams.PARAM_SETP.ordinal(), param);
            }
            catch (Exception ex) {
                out.isValid = false;
                out.data = -100.0;
                this.updateSimOutputs();
                return;
            }
        }
        try {
            in1 = this.GetInputData(0);
        }
        catch (Exception ex) {
            out.isValid = false;
            out.data = -100.0;
            return;
        }
        out.isValid = true;
        if (in1 < this.GetParameter(e_HystParams.PARAM_SETP.ordinal()) - this.GetParameter(e_HystParams.PARAM_BAND_MINUS.ordinal())) {
            out.data = this.GetParameter(e_HystParams.PARAM_INVERT_LEVELS.ordinal()) != 0.0 ? this.GetParameter(e_HystParams.PARAM_MAXOUT.ordinal()) : this.GetParameter(e_HystParams.PARAM_MINOUT.ordinal());
        } else if (in1 > this.GetParameter(e_HystParams.PARAM_SETP.ordinal()) + this.GetParameter(e_HystParams.PARAM_BAND_PLUS.ordinal())) {
            out.data = this.GetParameter(e_HystParams.PARAM_INVERT_LEVELS.ordinal()) != 0.0 ? this.GetParameter(e_HystParams.PARAM_MINOUT.ordinal()) : this.GetParameter(e_HystParams.PARAM_MAXOUT.ordinal());
        } else if (!this.m_StateIsValid) {
            out.data = this.GetParameter(e_HystParams.PARAM_MINOUT.ordinal());
            this.m_StateIsValid = true;
        }
        this.SetMData(0, out);
        this.updateSimOutputs();
    }

    static enum e_HystParams {
        PARAM_SETP,
        PARAM_MINOUT,
        PARAM_MAXOUT,
        PARAM_BAND_PLUS,
        PARAM_BAND_MINUS,
        PARAM_INVERT_LEVELS,
        PARAM_NUMTOT;

    }
}

