/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import java.util.ArrayList;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.GenericNode;
import nodes.gui.GenericBlockDialog;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class IFNode
extends GenericNode {
    String implicitOperand = "0.0";
    public static final int IF_ID = 7;

    public IFNode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        this.subType = CommonDefinitions.subBlockTypes.IF_EQ;
        for (CommonDefinitions.subBlockTypes mytype : CommonDefinitions.subBlockTypes.values()) {
            if (!mytype.toString().equals(label)) continue;
            this.subType = mytype;
            break;
        }
        this.CreateWidget();
        this.blockType = CommonDefinitions.blockTypes.IF;
        this.addressSpace = 3;
        this.numberOfInputs = 2;
        this.codici = new ArrayList();
        this.codici.add(0, "IF");
        this.codici.add(1, "OUT_IFNode");
        this.setList(this.codici);
        this.CreatePropertiesDialog();
        this.cleanSimDialog();
    }

    public String getAddress() {
        String newAddress = ((GenericBlockDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        this.parseStandardBlockCmd(cmd);
        AFOPin pin = this.getPinByID("IN2");
        if (this.scene.findPinEdges(pin, false, true).isEmpty()) {
            ((AFONodeWidget)this.widget).setSubType(CommonDefinitions.subBlockStrings[this.subType.ordinal()] + " " + this.implicitOperand);
        } else {
            ((AFONodeWidget)this.widget).setSubType(CommonDefinitions.subBlockStrings[this.subType.ordinal()] + " " + pin.getValue().substring(1, pin.getValue().length()));
        }
        return true;
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("IF");
        this.getScene().addNode(this);
        String pinLabel = "OUT";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        pinLabel = "IN1";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setPinIDString("IN1");
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        pinLabel = "IN2";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setPinIDString("IN2");
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        ((AFONodeWidget)this.widget).setSubType(CommonDefinitions.subBlockStrings[this.subType.ordinal()]);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new GenericBlockDialog(null, true, this);
        ((GenericBlockDialog)this.propertiesDialog).txtAddress.setText("NA");
        for (CommonDefinitions.ifTypes myType : CommonDefinitions.ifTypes.values()) {
            ((GenericBlockDialog)this.propertiesDialog).comboSubType.addItem(CommonDefinitions.ifStrings[myType.ordinal()]);
        }
        ((GenericBlockDialog)this.propertiesDialog).lblCombo.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).lblField1.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).lblField1.setText("Implicit Operand:");
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).lblField2.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).txtField2.setVisible(false);
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        ((GenericBlockDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.setSelectedItem(((AFONodeWidget)this.widget).getSubType());
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.setEnabled(!this.kernelConnected);
        ((GenericBlockDialog)this.propertiesDialog).indexLabel.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setText(this.implicitOperand);
        this.requestData();
        this.propertiesDialog.setModal(true);
        this.propertiesDialog.setVisible(true);
        if (((GenericBlockDialog)this.propertiesDialog).getReturnStatus() == 1) {
            if (!((GenericBlockDialog)this.propertiesDialog).fieldChanged) {
                return;
            }
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.propertiesDialog.setVisible(false);
            this.scene.sceneChanged();
            this.implicitOperand = ((GenericBlockDialog)this.propertiesDialog).txtField1.getText();
            if (this.kernel != null && this.kernel.isConnected()) {
                this.commandQueue.clear();
                String msg = "<BL set " + this.addressList.get(2) + " " + this.implicitOperand + " >";
                this.commandQueue.add(msg);
                this.sendMessageQueue(true);
            }
            String newType = ((GenericBlockDialog)this.propertiesDialog).comboSubType.getSelectedItem().toString();
            for (CommonDefinitions.subBlockTypes mytype : CommonDefinitions.subBlockTypes.values()) {
                if (!CommonDefinitions.subBlockStrings[mytype.ordinal()].equals(newType)) continue;
                this.subType = mytype;
                break;
            }
            ((AFONodeWidget)this.widget).setSubType(CommonDefinitions.subBlockStrings[this.subType.ordinal()]);
            AFOPin pin = this.getPinByID("IN2");
            if (this.scene.findPinEdges(pin, false, true).isEmpty()) {
                ((AFONodeWidget)this.widget).setSubType(CommonDefinitions.subBlockStrings[this.subType.ordinal()] + " " + this.implicitOperand);
            }
        }
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        float type = Float.parseFloat("" + this.subType.ordinal());
        retVal = retVal + "7 " + this.getCommonData() + type + " " + this.implicitOperand;
        return retVal;
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "ImplicitOperand", this.implicitOperand);
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        this.implicitOperand = SceneSerializer.getAttributeValue(node, "ImplicitOperand");
        if (this.implicitOperand == null) {
            this.implicitOperand = "0.0";
        }
        ((AFONodeWidget)this.widget).setSubType(CommonDefinitions.subBlockStrings[this.subType.ordinal()] + " " + this.implicitOperand);
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.setSelectedItem(CommonDefinitions.subBlockStrings[this.subType.ordinal()]);
    }

    @Override
    public void initSimulation() {
        super.initSimulation();
        this.registerArray.add(Double.parseDouble(this.implicitOperand));
    }

    @Override
    public void simulate() {
        super.simulate();
        double in1 = 0.0;
        double in2 = 0.0;
        GenericNode.SimData out = this.GetMData(0);
        try {
            in1 = this.GetInputData(0);
        }
        catch (Exception ex) {
            this.invalidateOutputs();
            this.updateSimOutputs();
            return;
        }
        if (!this.isInputConnected(1)) {
            in2 = this.GetParameter(0);
        } else {
            try {
                in2 = this.GetInputData(1);
            }
            catch (Exception ex) {
                in2 = this.GetParameter(0);
            }
        }
        out.isValid = true;
        out.data = 0.0;
        switch (this.subType) {
            case IF_EQ: {
                if (in1 != in2) break;
                out.data = 1.0;
                break;
            }
            case IF_GET: {
                if (!(in1 >= in2)) break;
                out.data = 1.0;
                break;
            }
            case IF_GT: {
                if (!(in1 > in2)) break;
                out.data = 1.0;
                break;
            }
            case IF_LET: {
                if (!(in1 <= in2)) break;
                out.data = 1.0;
                break;
            }
            case IF_LT: {
                if (!(in1 < in2)) break;
                out.data = 1.0;
                break;
            }
            case IF_NE: {
                if (in1 == in2) break;
                out.data = 1.0;
                break;
            }
            default: {
                out.data = -100.0;
                out.isValid = false;
            }
        }
        this.SetMData(0, out);
        this.updateSimOutputs();
    }
}

