/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import java.util.ArrayList;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.DeviceNode;
import nodes.gui.ImodbusDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;

public class IModbusNode
extends DeviceNode {
    private String value = "0.0";
    public static final String IMODBUS_ID = "38";
    private int interfacePort = 2;
    private int slaveAddress = 247;
    private int numSplit = 64;
    private int scanrate = 1000;

    public IModbusNode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, "--", scene);
        this.CreateWidget();
        this.blockType = CommonDefinitions.blockTypes.IModbus;
        this.numberOfInputs = 0;
        this.addressSpace = 705;
        this.CreatePropertiesDialog();
        this.codici = new ArrayList();
        this.codici.add(0, "IModbus");
        this.codici.add(1, "IO_IModbus");
        this.setList(this.codici);
    }

    public String getAddress() {
        String newAddress = ((ImodbusDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("IModbus");
        this.getScene().addNode(this);
        ((AFONodeWidget)this.widget).setSubType("");
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        ((ImodbusDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((ImodbusDialog)this.propertiesDialog).spnrAddress.setValue(this.slaveAddress);
        ((ImodbusDialog)this.propertiesDialog).spnrNumSplit.setValue(this.numSplit);
        ((ImodbusDialog)this.propertiesDialog).comboPort.setSelectedItem(this.interfacePort - 1);
        ((ImodbusDialog)this.propertiesDialog).spnrScanInterval.setValue(this.scanrate);
        ((ImodbusDialog)this.propertiesDialog).fieldChanged = false;
        this.propertiesDialog.setModal(true);
        this.propertiesDialog.setVisible(true);
        if (((ImodbusDialog)this.propertiesDialog).retVal.equals("Ok")) {
            if (!((ImodbusDialog)this.propertiesDialog).fieldChanged) {
                return;
            }
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.propertiesDialog.setVisible(false);
            this.scene.sceneChanged();
            this.slaveAddress = Integer.parseInt(((ImodbusDialog)this.propertiesDialog).spnrAddress.getValue().toString());
            this.numSplit = Integer.parseInt(((ImodbusDialog)this.propertiesDialog).spnrNumSplit.getValue().toString());
            this.interfacePort = ((ImodbusDialog)this.propertiesDialog).comboPort.getSelectedIndex() + 1;
            this.scanrate = Integer.parseInt(((ImodbusDialog)this.propertiesDialog).spnrScanInterval.getValue().toString());
        }
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new ImodbusDialog(null, true, this);
        ((ImodbusDialog)this.propertiesDialog).lblAddressError.setVisible(false);
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        retVal = retVal + "38 " + this.getCommonData();
        retVal = retVal + this.interfacePort + " " + this.slaveAddress + " 3 1 0 " + this.numSplit + " " + this.scanrate;
        return retVal;
    }

    @Override
    public void setConnectionStatus(boolean isConnected) {
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
            String newLabel = cmd.getValue("OUT1");
            ((AFONodeWidget)this.widget).setSubType(newLabel);
        } else if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(1)).toString())) {
            this.value = cmd.getValue("TOKEN3");
            ((ImodbusDialog)this.propertiesDialog).txtAddress.setText(this.value);
        }
        return true;
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "Port", "" + this.interfacePort);
        SceneSerializer.setAttribute(document, nodeElement, "SlaveAddress", "" + this.slaveAddress);
        SceneSerializer.setAttribute(document, nodeElement, "NumSplit", "" + this.numSplit);
        SceneSerializer.setAttribute(document, nodeElement, "ScanRate", "" + this.scanrate);
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        try {
            this.slaveAddress = Integer.parseInt(SceneSerializer.getAttributeValue(node, "SlaveAddress"));
        }
        catch (NumberFormatException ex) {
            this.slaveAddress = 247;
        }
        try {
            this.numSplit = Integer.parseInt(SceneSerializer.getAttributeValue(node, "NumSplit"));
        }
        catch (NumberFormatException ex) {
            this.numSplit = 64;
        }
        try {
            this.interfacePort = Integer.parseInt(SceneSerializer.getAttributeValue(node, "Port"));
        }
        catch (NumberFormatException ex) {
            this.interfacePort = 2;
        }
        try {
            this.scanrate = Integer.parseInt(SceneSerializer.getAttributeValue(node, "ScanRate"));
        }
        catch (NumberFormatException ex) {
            this.interfacePort = 1000;
        }
    }
}

