/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import connection.SerialKernel;
import connection.XMLCommands.UtilXML;
import javax.swing.JOptionPane;
import nodes.AFONodeWidget;
import nodes.BoardsTypesAndDescription;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.DeviceNode;
import nodes.gui.SimplePropertiesDlg;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class LedNode
extends DeviceNode {
    private String typeName;
    public static final int Led_ID = 33;

    public LedNode(String id, String label, String deviceID, AFOGraphPinScene scene) {
        super(id, label, deviceID, scene);
        this.typeName = label;
        this.propertiesDialog = new SimplePropertiesDlg(null, true, deviceID, this);
        this.blockType = CommonDefinitions.blockTypes.Led;
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.removeAllItems();
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.addItem(deviceID);
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.setSelectedIndex(0);
        this.numberOfInputs = 1;
        this.addressSpace = 2;
        this.CreateWidget();
        this.simDialog.tabbedPaneMain.removeAll();
    }

    public String getAddress() {
        String newAddress = ((SimplePropertiesDlg)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName(this.typeName);
        this.getScene().addNode(this);
        String pinLabel = "L";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN1");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        ((AFONodeWidget)this.widget).setSubType(this.deviceID);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.setSelectedItem(this.deviceID);
        ((SimplePropertiesDlg)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((SimplePropertiesDlg)this.propertiesDialog).indexLabel.setVisible(false);
        this.propertiesDialog.setVisible(true);
        if (((SimplePropertiesDlg)this.propertiesDialog).getReturnStatus() == 1) {
            if (((SimplePropertiesDlg)this.propertiesDialog).indexLabel.isVisible()) {
                JOptionPane.showMessageDialog(null, "L'indirizzo inserito \u00e8 gi\u00e0 in uso!");
                return;
            }
            if (((SimplePropertiesDlg)this.propertiesDialog).fieldChanged) {
                this.scene.sceneChanged();
                this.addressList.clear();
                for (int i = 0; i < this.addressSpace; ++i) {
                    this.addressList.add(Integer.parseInt(this.getAddress()) + i);
                }
                this.addressList.size();
                this.propertiesDialog.setVisible(false);
                if (this.kernel != null && this.kernel instanceof SerialKernel) {
                    this.commandQueue.clear();
                    int valInt = 0;
                    String msg = "<BL set " + this.addressList.get(1) + " ";
                    String val = ((SimplePropertiesDlg)this.propertiesDialog).txtValue.getText();
                    valInt = (int)Float.parseFloat(val);
                    msg = valInt == 0 ? msg + "0.0" : msg + "1.0";
                    msg = msg + " >";
                    this.commandQueue.add(msg);
                    this.sendMessageQueue(true);
                }
            }
        }
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        this.deviceID = SceneSerializer.getAttributeValue(node, "driverID");
        ((AFONodeWidget)this.widget).setSubType(this.deviceID);
        this.propertiesDialog = new SimplePropertiesDlg(null, true, this.deviceID, this);
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.removeAllItems();
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.addItem(this.deviceID);
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.setSelectedIndex(0);
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        retVal = retVal + "33 ";
        retVal = retVal + this.getCommonData();
        float num = Float.parseFloat(this.deviceID.substring(this.deviceID.length() - 1));
        BoardsTypesAndDescription.BoardType board = this.prj.getBoardType();
        if (board.equals((Object)BoardsTypesAndDescription.BoardType.mPID2NTHR) || board.equals((Object)BoardsTypesAndDescription.BoardType.mPID2NTR)) {
            num -= 1.0f;
        }
        retVal = retVal + num;
        return retVal;
    }

    @Override
    public boolean parseCmd(ICmd com) {
        if (UtilXML.cmpCmdValue(com, "ADDRESS", (Integer)this.addressList.get(0))) {
            AFOPin pin = (AFOPin)this.pinList.get(0);
            String tempVal = com.getValue("BUTTON");
            pin.getPinNameWidget().setLabel("(" + tempVal + ")" + "IN");
            this.getScene().validate();
            return true;
        }
        return false;
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        this.parseStandardBlockCmd(cmd);
        return true;
    }

    @Override
    public void setConnectionStatus(boolean isConnected) {
    }
}

