/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import Util.FieldChecker;
import connection.ICmd;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.DeviceNode;
import nodes.gui.LoggerDialog;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class LoggerNode
extends DeviceNode
implements ActionListener {
    Integer nOfInputs = 1;
    Integer saveInterval = 60;
    Integer dataType = 0;
    boolean saveOnEEprom = true;
    String separator = ",";
    String sdFileName = "NA";
    boolean uploadToFTP = true;
    String ftpAddress = "127.0.0.1";
    String ftpUserName = "anonymous";
    String ftpPassword = "anon@doe.com";
    Integer ftpUploadInterval = 24;
    String ftpRemoteFileName = "NA";
    Integer ftpTimeStamp = 0;
    private static final String RESET_INDEXES = "ResetIndexes";
    private static final String CHANGE_FTP_ACCESS = "ChangeFTPAccess";
    private static final String UPLOAD_FTP_DATA = "UploadFTPData";
    private static final String CHANGE_UPLOAD_INTERVAL = "ChangeeFTPUPload";
    private static final String CHANGE_TIMESTAMP = "FTPChangeTimestamp";
    private static final String CHANGE_LOG_INTERVAL = "ChangeLogInterval";
    public static final int LOGGER_ID = 40;

    public LoggerNode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, "Logger", scene);
        this.numberOfInputs = 1;
        this.CreateWidget();
        this.blockType = CommonDefinitions.blockTypes.Logger;
        this.addressSpace = 16;
        this.codici = new ArrayList();
        this.codici.add("LoggerNode");
        this.codici.add("LoggerNode_R");
        this.setList(this.codici);
        this.CreatePropertiesDialog();
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("Logger");
        this.getScene().addNode(this);
        String pinLabel = "SEND";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        pinLabel = "LOG";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT2");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        pinLabel = "ERR";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT2");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        this.createPins();
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    public void createPins() {
        for (AFOPin pin : this.pinList) {
            this.scene.removePinWithEdges(pin);
        }
        ((AFONodeWidget)this.widget).clearPins();
        ((AFONodeWidget)this.widget).getModuleINPinNames().removeChildren();
        ((AFONodeWidget)this.widget).getModuleOUTPinNames().removeChildren();
        this.pinList.clear();
        this.numberOfInputs = 0;
        this.addIOPin(false, "SEND", 1);
        this.addIOPin(false, "LOG", 2);
        this.addIOPin(false, "ERR", 3);
        boolean nOfOut = true;
        for (int i = 0; i < this.nOfInputs; ++i) {
            ++this.numberOfInputs;
            this.addIOPin(true, "IN" + (i + 1), this.numberOfInputs);
        }
        for (AFOPin pin : this.pinList) {
            pin.setParentNode(this);
        }
        this.scene.revalidate();
    }

    private AFOPin addIOPin(boolean isInput, String label, int number) {
        AFOPin newPin;
        String pinLabel = label;
        if (isInput) {
            String pinID = "pin" + ++this.scene.pinIDCounter;
            newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
            newPin.setAsBusPin(false);
            newPin.setParentNode(this);
            newPin.setPinIDString("IN" + number);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
        } else {
            String pinID = "pin" + ++this.scene.pinIDCounter;
            newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
            newPin.setAsBusPin(false);
            newPin.setParentNode(this);
            newPin.setPinIDString("OUT" + number);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
        }
        return newPin;
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new LoggerDialog(null, true, this);
        ((LoggerDialog)this.propertiesDialog).txtAddress.setText("NA");
        ((LoggerDialog)this.propertiesDialog).setTitle("Logger Properties");
        ((LoggerDialog)this.propertiesDialog).btnReset.addActionListener(this);
        ((LoggerDialog)this.propertiesDialog).btnReset.setActionCommand(RESET_INDEXES);
        ((LoggerDialog)this.propertiesDialog).btnChangeFTPData.addActionListener(this);
        ((LoggerDialog)this.propertiesDialog).btnChangeFTPData.setActionCommand(CHANGE_FTP_ACCESS);
        ((LoggerDialog)this.propertiesDialog).btnChangeFTPInterval.addActionListener(this);
        ((LoggerDialog)this.propertiesDialog).btnChangeFTPInterval.setActionCommand(CHANGE_UPLOAD_INTERVAL);
        ((LoggerDialog)this.propertiesDialog).btnUploadNow.addActionListener(this);
        ((LoggerDialog)this.propertiesDialog).btnUploadNow.setActionCommand(UPLOAD_FTP_DATA);
        ((LoggerDialog)this.propertiesDialog).btnChangeTimestamp.addActionListener(this);
        ((LoggerDialog)this.propertiesDialog).btnChangeTimestamp.setActionCommand(CHANGE_TIMESTAMP);
        ((LoggerDialog)this.propertiesDialog).btnChangeLogInterval.addActionListener(this);
        ((LoggerDialog)this.propertiesDialog).btnChangeLogInterval.setActionCommand(CHANGE_LOG_INTERVAL);
    }

    private void getDialogFields() {
        this.nOfInputs = Integer.parseInt(((LoggerDialog)this.propertiesDialog).spnrNofInputs.getValue().toString());
        this.saveInterval = Integer.parseInt(((LoggerDialog)this.propertiesDialog).spnrSaveInterval.getValue().toString());
        this.dataType = ((LoggerDialog)this.propertiesDialog).radioBtnShortValues.isSelected() ? Integer.valueOf(0) : Integer.valueOf(1);
        this.saveOnEEprom = ((LoggerDialog)this.propertiesDialog).chkSaveOnEEprom.isSelected();
        this.separator = ((LoggerDialog)this.propertiesDialog).comboFileSeparator.getSelectedItem().toString();
        this.sdFileName = ((LoggerDialog)this.propertiesDialog).txtSDFileName.getText();
        this.uploadToFTP = ((LoggerDialog)this.propertiesDialog).chkUploadDataToFTP.isSelected();
        this.ftpAddress = ((LoggerDialog)this.propertiesDialog).txtFTPAddress.getText();
        this.ftpUserName = ((LoggerDialog)this.propertiesDialog).txtFTPUserName.getText();
        this.ftpPassword = ((LoggerDialog)this.propertiesDialog).txtFTPPAssword.getText();
        this.ftpUploadInterval = Integer.parseInt(((LoggerDialog)this.propertiesDialog).spnrFTPUploadInterval.getValue().toString());
        this.ftpRemoteFileName = ((LoggerDialog)this.propertiesDialog).txtFTPFileName.getText();
        this.ftpTimeStamp = ((LoggerDialog)this.propertiesDialog).comboTimestamp.getSelectedIndex();
    }

    private void setDialogFields() {
        ((LoggerDialog)this.propertiesDialog).spnrNofInputs.setValue(this.nOfInputs);
        ((LoggerDialog)this.propertiesDialog).spnrSaveInterval.setValue(this.saveInterval);
        ((LoggerDialog)this.propertiesDialog).chkSaveOnEEprom.setSelected(this.saveOnEEprom);
        ((LoggerDialog)this.propertiesDialog).comboFileSeparator.setSelectedItem(this.separator);
        ((LoggerDialog)this.propertiesDialog).txtSDFileName.setText(this.sdFileName);
        ((LoggerDialog)this.propertiesDialog).chkUploadDataToFTP.setSelected(this.uploadToFTP);
        ((LoggerDialog)this.propertiesDialog).txtFTPAddress.setText(this.ftpAddress);
        ((LoggerDialog)this.propertiesDialog).txtFTPUserName.setText(this.ftpUserName);
        ((LoggerDialog)this.propertiesDialog).txtFTPPAssword.setText(this.ftpPassword);
        ((LoggerDialog)this.propertiesDialog).spnrFTPUploadInterval.setValue(this.ftpUploadInterval);
        ((LoggerDialog)this.propertiesDialog).txtFTPFileName.setText(this.ftpRemoteFileName);
        ((LoggerDialog)this.propertiesDialog).comboTimestamp.setSelectedIndex(this.ftpTimeStamp);
    }

    public String getAddress() {
        String newAddress = ((LoggerDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        this.requestData();
        this.setDialogFields();
        ((LoggerDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        this.setupDialogButtons();
        this.propertiesDialog.setModal(true);
        this.propertiesDialog.setVisible(true);
        if (((LoggerDialog)this.propertiesDialog).getReturnStatus() == 1) {
            if (!((LoggerDialog)this.propertiesDialog).fieldChanged) {
                return;
            }
            this.getDialogFields();
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.scene.sceneChanged();
            int newNIns = (int)Float.parseFloat(((LoggerDialog)this.propertiesDialog).spnrNofInputs.getValue().toString());
            if (newNIns >= 1 && newNIns != this.numberOfInputs) {
                this.numberOfInputs = newNIns;
                this.createPins();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object[] myOptions = new Object[]{this.message.getString("yes"), this.message.getString("no")};
        if (this.kernel != null && this.kernel.isConnected()) {
            if (this.sendingCommandQueue.booleanValue()) {
                JOptionPane.showMessageDialog(null, this.message.getString("SendInProgressError"), this.message.getString("er"), 2);
                return;
            }
        } else {
            this.setupDialogButtons();
            return;
        }
        if (e.getActionCommand().equals(RESET_INDEXES)) {
            if (JOptionPane.showOptionDialog(null, this.message.getString("sicuro"), this.message.getString("er"), 0, 2, null, myOptions, myOptions[0]) == 1) {
                return;
            }
            this.commandQueue.clear();
            String msg = "<BL set " + ((Integer)this.addressList.get(0) + e_LoggerRegisters.LOG_REG_RESET_INDEXES.ordinal()) + " 1 >";
            this.commandQueue.add(msg);
            this.sendMessageQueue(false);
        } else if (e.getActionCommand().equals(CHANGE_FTP_ACCESS)) {
            this.commandQueue.clear();
            this.uploadToFTP = ((LoggerDialog)this.propertiesDialog).chkUploadDataToFTP.isSelected();
            String msg = "<BL set " + ((Integer)this.addressList.get(0) + e_LoggerRegisters.LOG_REG_SENDFTP.ordinal());
            msg = this.uploadToFTP ? msg + " 1 " : msg + " 0 ";
            msg = msg + " >";
            this.commandQueue.add(msg);
            if (((LoggerDialog)this.propertiesDialog).chkUploadDataToFTP.isSelected()) {
                if (!FieldChecker.isValidIP(((LoggerDialog)this.propertiesDialog).txtFTPAddress.getText(), this.message.getString("errIPAddr"))) {
                    this.commandQueue.clear();
                    return;
                }
                this.ftpAddress = ((LoggerDialog)this.propertiesDialog).txtFTPAddress.getText();
                msg = "<BL set " + ((Integer)this.addressList.get(0) + e_LoggerRegisters.LOG_REG_FTPADDR.ordinal()) + " " + this.ftpAddress + " >";
                this.commandQueue.add(msg);
                this.ftpUserName = ((LoggerDialog)this.propertiesDialog).txtFTPUserName.getText();
                msg = "<BL set " + ((Integer)this.addressList.get(0) + e_LoggerRegisters.LOG_REG_FTPUSERNAME.ordinal()) + " " + this.ftpUserName + " >";
                this.commandQueue.add(msg);
                this.ftpPassword = ((LoggerDialog)this.propertiesDialog).txtFTPPAssword.getText();
                msg = "<BL set " + ((Integer)this.addressList.get(0) + e_LoggerRegisters.LOG_REG_FTPPASS.ordinal()) + " " + this.ftpPassword + " >";
                this.commandQueue.add(msg);
            }
            this.sendMessageQueue(false);
        } else if (e.getActionCommand().equals(CHANGE_UPLOAD_INTERVAL)) {
            this.ftpUploadInterval = Integer.parseInt(((LoggerDialog)this.propertiesDialog).spnrFTPUploadInterval.getValue().toString());
            this.commandQueue.clear();
            String msg = "<BL set " + ((Integer)this.addressList.get(0) + e_LoggerRegisters.LOG_REG_FTPSENDINTERVAL.ordinal()) + " " + this.ftpUploadInterval + " >";
            this.commandQueue.add(msg);
            this.sendMessageQueue(false);
        } else if (e.getActionCommand().equals(CHANGE_TIMESTAMP)) {
            this.ftpTimeStamp = ((LoggerDialog)this.propertiesDialog).comboTimestamp.getSelectedIndex();
            this.ftpRemoteFileName = ((LoggerDialog)this.propertiesDialog).txtFTPFileName.getText();
            this.commandQueue.clear();
            String[] tokArray = this.ftpRemoteFileName.split("/");
            String msg = "<BL set " + ((Integer)this.addressList.get(0) + e_LoggerRegisters.LOG_REG_FTPFILENAME.ordinal());
            for (String st : tokArray) {
                msg = msg + " " + st;
            }
            msg = msg + " >";
            this.commandQueue.add(msg);
            msg = "<BL set " + ((Integer)this.addressList.get(0) + e_LoggerRegisters.LOG_REG_FTPTIMESTAMP.ordinal()) + " " + this.ftpTimeStamp + " >";
            this.commandQueue.add(msg);
            this.sendMessageQueue(false);
        } else if (e.getActionCommand().equals(UPLOAD_FTP_DATA)) {
            this.commandQueue.clear();
            String msg = "<BL set " + ((Integer)this.addressList.get(0) + e_LoggerRegisters.LOG_REG_SENDNOW.ordinal()) + " 1 >";
            this.commandQueue.add(msg);
            this.sendMessageQueue(false);
        } else if (e.getActionCommand().equals(CHANGE_LOG_INTERVAL)) {
            this.saveInterval = Integer.parseInt(((LoggerDialog)this.propertiesDialog).spnrSaveInterval.getValue().toString());
            this.commandQueue.clear();
            String msg = "<BL set " + ((Integer)this.addressList.get(0) + e_LoggerRegisters.LOG_REG_SAVEINTERVAL.ordinal()) + " " + this.saveInterval + " >";
            this.commandQueue.add(msg);
            this.sendMessageQueue(false);
        }
    }

    private void setupDialogButtons() {
        ((LoggerDialog)this.propertiesDialog).btnOk.setEnabled(!this.kernelConnected);
        ((LoggerDialog)this.propertiesDialog).btnChangeLogInterval.setEnabled(this.kernelConnected);
        ((LoggerDialog)this.propertiesDialog).btnReset.setEnabled(this.kernelConnected);
        ((LoggerDialog)this.propertiesDialog).spnrNofInputs.setEnabled(!this.kernelConnected);
        if (this.uploadToFTP) {
            ((LoggerDialog)this.propertiesDialog).btnChangeFTPData.setEnabled(this.kernelConnected);
            ((LoggerDialog)this.propertiesDialog).btnChangeFTPInterval.setEnabled(this.kernelConnected);
            ((LoggerDialog)this.propertiesDialog).btnChangeTimestamp.setEnabled(this.kernelConnected);
            ((LoggerDialog)this.propertiesDialog).btnUploadNow.setEnabled(this.kernelConnected);
            ((LoggerDialog)this.propertiesDialog).spnrFTPUploadInterval.setEnabled(true);
        } else {
            ((LoggerDialog)this.propertiesDialog).btnChangeFTPData.setEnabled(false);
            ((LoggerDialog)this.propertiesDialog).btnChangeFTPInterval.setEnabled(false);
            ((LoggerDialog)this.propertiesDialog).btnChangeTimestamp.setEnabled(false);
            ((LoggerDialog)this.propertiesDialog).btnUploadNow.setEnabled(false);
            ((LoggerDialog)this.propertiesDialog).spnrFTPUploadInterval.setEnabled(false);
        }
        ((LoggerDialog)this.propertiesDialog).chkSaveOnEEprom.setEnabled(!this.kernelConnected);
        ((LoggerDialog)this.propertiesDialog).comboFileSeparator.setEnabled(!this.kernelConnected);
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "subType", this.subType.toString());
        SceneSerializer.setAttribute(document, nodeElement, "NofInputs", "" + this.nOfInputs);
        SceneSerializer.setAttribute(document, nodeElement, "SaveInterval", "" + this.saveInterval);
        SceneSerializer.setAttribute(document, nodeElement, "DataType", "" + this.dataType);
        SceneSerializer.setAttribute(document, nodeElement, "SaveOnEEPROM", "" + this.saveOnEEprom);
        SceneSerializer.setAttribute(document, nodeElement, "Separator", this.separator);
        SceneSerializer.setAttribute(document, nodeElement, "Filename", this.sdFileName);
        SceneSerializer.setAttribute(document, nodeElement, "UploadToFTP", "" + this.uploadToFTP);
        SceneSerializer.setAttribute(document, nodeElement, "FTPAddress", this.ftpAddress);
        SceneSerializer.setAttribute(document, nodeElement, "FTPUser", this.ftpUserName);
        SceneSerializer.setAttribute(document, nodeElement, "FTPPass", this.ftpPassword);
        SceneSerializer.setAttribute(document, nodeElement, "FTPUpload", "" + this.ftpUploadInterval);
        SceneSerializer.setAttribute(document, nodeElement, "FTPRemoteFileName", this.ftpRemoteFileName);
        SceneSerializer.setAttribute(document, nodeElement, "FTPTimestamp", "" + this.ftpTimeStamp);
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        this.nOfInputs = Integer.parseInt(SceneSerializer.getAttributeValue(node, "NofInputs"));
        this.saveInterval = Integer.parseInt(SceneSerializer.getAttributeValue(node, "SaveInterval"));
        this.dataType = Integer.parseInt(SceneSerializer.getAttributeValue(node, "DataType"));
        this.saveOnEEprom = Boolean.parseBoolean(SceneSerializer.getAttributeValue(node, "SaveOnEEPROM"));
        this.separator = SceneSerializer.getAttributeValue(node, "Separator");
        this.sdFileName = SceneSerializer.getAttributeValue(node, "Filename");
        this.uploadToFTP = Boolean.parseBoolean(SceneSerializer.getAttributeValue(node, "UploadToFTP"));
        this.ftpAddress = SceneSerializer.getAttributeValue(node, "FTPAddress");
        this.ftpUserName = SceneSerializer.getAttributeValue(node, "FTPUser");
        this.ftpPassword = SceneSerializer.getAttributeValue(node, "FTPPass");
        this.ftpUploadInterval = Integer.parseInt(SceneSerializer.getAttributeValue(node, "FTPUpload"));
        this.ftpRemoteFileName = SceneSerializer.getAttributeValue(node, "FTPRemoteFileName");
        this.ftpTimeStamp = Integer.parseInt(SceneSerializer.getAttributeValue(node, "FTPTimestamp"));
        if (this.nOfInputs >= 1 && this.nOfInputs != this.numberOfInputs) {
            this.numberOfInputs = this.nOfInputs;
            this.createPins();
        }
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
        } else {
            String value = "";
            int msgAddress = Integer.parseInt(cmd.getValue("ADDRESS"));
            value = cmd.getValue("TOKEN3");
            switch (msgAddress - (Integer)this.addressList.get(0) - 3) {
                case 0: {
                    try {
                        this.saveInterval = (int)Double.parseDouble(value);
                    }
                    catch (NumberFormatException ex) {
                        System.out.println(((Integer)this.addressList.get(0)).toString() + "-- Parse Error:" + value);
                    }
                    break;
                }
                case 1: {
                    try {
                        this.dataType = (int)Double.parseDouble(value);
                        ((LoggerDialog)this.propertiesDialog).radioBtnShortValues.setSelected(this.dataType == 0);
                        ((LoggerDialog)this.propertiesDialog).radioBtnFloatValues.setSelected(this.dataType == 1);
                    }
                    catch (NumberFormatException ex) {
                        System.out.println(((Integer)this.addressList.get(0)).toString() + "/" + msgAddress + " -- Parse Error:" + value);
                    }
                    break;
                }
                case 2: {
                    try {
                        double doubleVal = Double.parseDouble(value);
                        if (doubleVal == 1.0) {
                            this.saveOnEEprom = true;
                            break;
                        }
                        this.saveOnEEprom = false;
                    }
                    catch (NumberFormatException ex) {
                        System.out.println(((Integer)this.addressList.get(0)).toString() + "-- Parse Error:" + value);
                    }
                    break;
                }
                case 3: {
                    try {
                        this.separator = value;
                    }
                    catch (NumberFormatException ex) {
                        System.out.println(((Integer)this.addressList.get(0)).toString() + "-- Parse Error:" + value);
                    }
                    break;
                }
                case 4: {
                    this.sdFileName = value;
                    break;
                }
                case 5: {
                    double doubleVal = Double.parseDouble(value);
                    if (doubleVal == 1.0) {
                        this.uploadToFTP = true;
                        break;
                    }
                    this.uploadToFTP = false;
                    break;
                }
                case 6: {
                    this.ftpAddress = value;
                    break;
                }
                case 7: {
                    try {
                        this.ftpUploadInterval = (int)Double.parseDouble(value);
                    }
                    catch (NumberFormatException ex) {
                        System.out.println(((Integer)this.addressList.get(0)).toString() + "-- Parse Error:" + value);
                    }
                    break;
                }
                case 8: {
                    this.ftpUserName = value;
                    break;
                }
                case 9: {
                    String fileName = value;
                    for (int i = 4; i < cmd.getNofTokens(); ++i) {
                        value = cmd.getValue("TOKEN" + i);
                        fileName = fileName + "/" + value;
                    }
                    this.ftpRemoteFileName = fileName;
                    break;
                }
                case 10: {
                    this.ftpPassword = value;
                    break;
                }
                case 11: {
                    try {
                        this.ftpTimeStamp = (int)Double.parseDouble(value);
                        break;
                    }
                    catch (NumberFormatException ex) {
                        System.out.println(((Integer)this.addressList.get(0)).toString() + "-- Parse Error:" + value);
                    }
                }
            }
            this.setDialogFields();
        }
        this.propertiesDialog.invalidate();
        return true;
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        retVal = retVal + "40 " + this.getCommonData();
        return retVal;
    }

    public String getVarConfiguration() {
        String config = "";
        String msg = "<BL set " + ((Integer)this.addressList.get(0) + e_LoggerRegisters.LOG_REG_RESET_INDEXES.ordinal()) + " 1 >";
        config = msg + "\r\n";
        msg = "<BL set " + ((Integer)this.addressList.get(0) + e_LoggerRegisters.LOG_REG_DATATYPE.ordinal()) + " " + this.dataType + " >";
        config = msg + "\r\n";
        msg = "<BL set " + ((Integer)this.addressList.get(0) + e_LoggerRegisters.LOG_REG_SENDFTP.ordinal());
        msg = this.uploadToFTP ? msg + " 1 " : msg + " 0 ";
        msg = msg + " >";
        config = config + msg + "\r\n";
        msg = "<BL set " + ((Integer)this.addressList.get(0) + e_LoggerRegisters.LOG_REG_SEPARATOR.ordinal()) + " " + this.separator + " >";
        config = config + msg + "\r\n";
        if (((LoggerDialog)this.propertiesDialog).chkUploadDataToFTP.isSelected()) {
            msg = "<BL set " + ((Integer)this.addressList.get(0) + e_LoggerRegisters.LOG_REG_FTPADDR.ordinal()) + " " + this.ftpAddress + " >";
            config = config + msg + "\r\n";
            msg = "<BL set " + ((Integer)this.addressList.get(0) + e_LoggerRegisters.LOG_REG_FTPUSERNAME.ordinal()) + " " + this.ftpUserName + " >";
            config = config + msg + "\r\n";
            msg = "<BL set " + ((Integer)this.addressList.get(0) + e_LoggerRegisters.LOG_REG_FTPPASS.ordinal()) + " " + this.ftpPassword + " >";
            config = config + msg + "\r\n";
        }
        msg = "<BL set " + ((Integer)this.addressList.get(0) + e_LoggerRegisters.LOG_REG_FTPSENDINTERVAL.ordinal()) + " " + this.ftpUploadInterval + " >";
        config = config + msg + "\r\n";
        String[] tokArray = this.ftpRemoteFileName.split("/");
        msg = "<BL set " + ((Integer)this.addressList.get(0) + e_LoggerRegisters.LOG_REG_FTPFILENAME.ordinal());
        for (String st : tokArray) {
            msg = msg + " " + st;
        }
        msg = msg + " >";
        config = config + msg + "\r\n";
        msg = "<BL set " + ((Integer)this.addressList.get(0) + e_LoggerRegisters.LOG_REG_FTPTIMESTAMP.ordinal()) + " " + this.ftpTimeStamp + " >";
        config = config + msg + "\r\n";
        msg = "<BL set " + ((Integer)this.addressList.get(0) + e_LoggerRegisters.LOG_REG_SAVEINTERVAL.ordinal()) + " " + this.saveInterval + " >";
        config = config + msg + "\r\n";
        return config;
    }

    static enum e_LoggerRegisters {
        LOG_REG_RESERVED,
        LOG_REG_OUT1,
        LOG_REG_OUT2,
        LOG_REG_SAVEINTERVAL,
        LOG_REG_DATATYPE,
        LOG_REG_SAVELOCATION,
        LOG_REG_SEPARATOR,
        LOG_REG_SDFILENAME,
        LOG_REG_SENDFTP,
        LOG_REG_FTPADDR,
        LOG_REG_FTPSENDINTERVAL,
        LOG_REG_FTPUSERNAME,
        LOG_REG_FTPFILENAME,
        LOG_REG_FTPPASS,
        LOG_REG_FTPTIMESTAMP,
        LOG_REG_RESET_INDEXES,
        LOG_REG_SENDNOW;

    }
}

