/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.GenericNode;
import nodes.gui.GenericBlockDialog;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOEdge;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class LogicNode
extends GenericNode {
    public static final int LOGIC_ID = 9;

    public LogicNode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        for (CommonDefinitions.subBlockTypes mytype : CommonDefinitions.subBlockTypes.values()) {
            if (!mytype.toString().equals(label)) continue;
            this.subType = mytype;
        }
        this.addressSpace = 2;
        this.codici = new ArrayList();
        this.codici.add("Logic");
        this.codici.add("OUT_Logic");
        this.setList(this.codici);
        this.numberOfInputs = this.subType == CommonDefinitions.subBlockTypes.NOT ? 1 : 2;
        this.CreateWidget();
        this.blockType = CommonDefinitions.blockTypes.Logic;
        this.CreatePropertiesDialog();
        this.cleanSimDialog();
    }

    public String getAddress() {
        String newAddress = ((GenericBlockDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("Logic");
        String pinLabel = "OUT";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.pinList.add(newPin);
        this.getScene().addNode(this);
        this.getScene().addPin(this, newPin);
        this.createInputPins();
        ((AFONodeWidget)this.widget).setSubType(this.subType.toString());
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    private void createInputPins() {
        int i;
        for (AFOPin pin : this.pinList) {
            if (!pin.getPinType().equals((Object)AFOPin.E_PinType.PIN_INPUT)) continue;
            ArrayList edgeList = (ArrayList)this.scene.findPinEdges(pin, false, true);
            for (AFOEdge edge : edgeList) {
                this.scene.removeEdge(edge);
            }
        }
        ((AFONodeWidget)this.widget).clearInputPins();
        ((AFONodeWidget)this.widget).getModuleINPinNames().removeChildren();
        for (i = 0; i < this.pinList.size(); ++i) {
            if (!((AFOPin)this.pinList.get(i)).getPinType().equals((Object)AFOPin.E_PinType.PIN_INPUT)) continue;
            this.pinList.remove(i);
            --i;
        }
        for (i = 1; i <= this.numberOfInputs; ++i) {
            String pinLabel = "IN" + i;
            String pinID = "pin" + ++this.scene.pinIDCounter;
            AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
            newPin.setAsBusPin(false);
            newPin.setPinIDString("IN" + i);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
        }
        for (AFOPin pin : this.pinList) {
            pin.setParentNode(this);
        }
        this.resetPinValues();
        this.scene.validate();
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new GenericBlockDialog(null, true, this);
        ((GenericBlockDialog)this.propertiesDialog).txtAddress.setText("NA");
        for (CommonDefinitions.logicTypes myType : CommonDefinitions.logicTypes.values()) {
            ((GenericBlockDialog)this.propertiesDialog).comboSubType.addItem(myType.toString());
        }
        ((GenericBlockDialog)this.propertiesDialog).lblCombo.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).lblField1.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).lblField2.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).lblField2.setText("Number of Inputs :");
        ((GenericBlockDialog)this.propertiesDialog).txtField2.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).txtField2.getDocument().addDocumentListener(new FieldChangeListener());
        ((GenericBlockDialog)this.propertiesDialog).btnSendParam2.setVisible(false);
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        ((GenericBlockDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.setSelectedItem(this.subType.toString());
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.setEnabled(!this.kernelConnected);
        ((GenericBlockDialog)this.propertiesDialog).indexLabel.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).txtField2.setText("" + this.numberOfInputs);
        if (this.subType.equals((Object)CommonDefinitions.subBlockTypes.NOT)) {
            ((GenericBlockDialog)this.propertiesDialog).txtField2.setEnabled(false);
        } else {
            ((GenericBlockDialog)this.propertiesDialog).txtField2.setEnabled(true);
        }
        ((GenericBlockDialog)this.propertiesDialog).btnOk.setEnabled(!this.kernelConnected);
        this.propertiesDialog.setModal(true);
        this.propertiesDialog.setVisible(true);
        if (((GenericBlockDialog)this.propertiesDialog).getReturnStatus() == 1) {
            int newNIns;
            if (!((GenericBlockDialog)this.propertiesDialog).fieldChanged) {
                return;
            }
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.propertiesDialog.setVisible(false);
            this.scene.sceneChanged();
            String newType = ((GenericBlockDialog)this.propertiesDialog).comboSubType.getSelectedItem().toString();
            for (CommonDefinitions.subBlockTypes mytype : CommonDefinitions.subBlockTypes.values()) {
                if (!mytype.toString().equals(newType)) continue;
                this.subType = mytype;
                break;
            }
            if (this.subType.equals((Object)CommonDefinitions.subBlockTypes.NOT)) {
                newNIns = 1;
            } else {
                newNIns = (int)Float.parseFloat(((GenericBlockDialog)this.propertiesDialog).txtField2.getText());
                if (newNIns == 1) {
                    ++newNIns;
                }
            }
            if (newNIns > 0 && newNIns != this.numberOfInputs) {
                this.numberOfInputs = newNIns;
                this.createInputPins();
            }
            ((AFONodeWidget)this.widget).setSubType(this.subType.toString());
        }
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        float type = Float.parseFloat("" + ((double)(this.subType.ordinal() - CommonDefinitions.subBlockTypes.AND.ordinal()) + 1.0));
        retVal = retVal + "9 " + this.getCommonData() + type;
        return retVal;
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        this.parseStandardBlockCmd(cmd);
        return true;
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "subType", this.subType.toString());
        SceneSerializer.setAttribute(document, nodeElement, "NOfInputs", "" + this.numberOfInputs);
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        this.numberOfInputs = -1;
        String nOfInputs = SceneSerializer.getAttributeValue(node, "NOfInputs");
        if (nOfInputs == null) {
            this.numberOfInputs = 2;
        }
        if (this.subType == CommonDefinitions.subBlockTypes.NOT) {
            this.numberOfInputs = 1;
        } else if (this.numberOfInputs == -1) {
            this.numberOfInputs = Integer.parseInt(nOfInputs);
        }
        this.createInputPins();
    }

    @Override
    public void initSimulation() {
        super.initSimulation();
    }

    @Override
    public void simulate() {
        super.simulate();
        double inVal = 0.0;
        GenericNode.SimData out = this.GetMData(0);
        try {
            inVal = this.GetInputData(0);
            out.isValid = true;
        }
        catch (Exception ex) {
            out.isValid = false;
            out.data = -100.0;
            this.updateSimOutputs();
            return;
        }
        if (this.subType == CommonDefinitions.subBlockTypes.NOT) {
            out.data = inVal != 0.0 ? 0.0 : 1.0;
            this.SetMData(0, out);
            this.updateSimOutputs();
            return;
        }
        out.data = inVal;
        block12: for (int i = 1; i < this.inputData.size(); ++i) {
            try {
                inVal = this.GetInputData(i);
                out.isValid = true;
            }
            catch (Exception ex) {
                out.isValid = false;
                out.data = -100.0;
                this.updateSimOutputs();
                return;
            }
            switch (this.subType) {
                case AND: {
                    out.data = this.boolToDouble(this.doubleToBool(out.data) && this.doubleToBool(inVal));
                    continue block12;
                }
                case OR: {
                    out.data = this.boolToDouble(this.doubleToBool(out.data) || this.doubleToBool(inVal));
                    continue block12;
                }
                case XOR: {
                    out.data = this.boolToDouble(this.doubleToBool(out.data) && !this.doubleToBool(inVal) || !this.doubleToBool(out.data) && this.doubleToBool(inVal));
                    continue block12;
                }
                case NAND: {
                    out.data = this.boolToDouble(!this.doubleToBool(out.data) || !this.doubleToBool(inVal));
                    continue block12;
                }
                case NOR: {
                    out.data = this.boolToDouble(!this.doubleToBool(out.data) && !this.doubleToBool(inVal));
                    continue block12;
                }
                case XNOR: {
                    out.data = this.boolToDouble(!(this.doubleToBool(out.data) && !this.doubleToBool(inVal) || !this.doubleToBool(out.data) && this.doubleToBool(inVal)));
                    continue block12;
                }
                default: {
                    out.data = -100.0;
                    out.isValid = false;
                }
            }
        }
        this.SetMData(0, out);
        this.updateSimOutputs();
    }

    class FieldChangeListener
    implements DocumentListener {
        private int MAX_INPUTS = 8;

        FieldChangeListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.control();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        public void control() {
            int nOfIn = 0;
            try {
                nOfIn = (int)Float.parseFloat(((GenericBlockDialog)((LogicNode)LogicNode.this).propertiesDialog).txtField2.getText());
                if (LogicNode.this.subType == CommonDefinitions.subBlockTypes.NOT ? nOfIn > this.MAX_INPUTS || nOfIn < 1 : nOfIn > this.MAX_INPUTS || nOfIn < 2) {
                    throw new Exception("Max Num Inputs");
                }
                ((GenericBlockDialog)((LogicNode)LogicNode.this).propertiesDialog).btnOk.setEnabled(true);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Errore nel campo Numero Ingressi", "Errore", 0);
                ((GenericBlockDialog)((LogicNode)LogicNode.this).propertiesDialog).btnOk.setEnabled(false);
            }
        }
    }
}

