/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import VisiProg.AppOptions;
import connection.ICmd;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import nodes.AFONodeWidget;
import nodes.BoardsTypesAndDescription;
import nodes.CommonDefinitions;
import nodes.Project;
import nodes.SceneSerializer;
import nodes.devices.DeviceNode;
import nodes.devices.GenericNode;
import nodes.gui.ModbusStationDialog;
import nodes.gui.MyComboBoxEditor;
import nodes.gui.ScalingPanel;
import nodes.gui.SimInputFrame;
import nodes.gui.SimMultiInputFrame;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class ModbusStation
extends DeviceNode
implements ActionListener {
    private DefaultTableModel tableModel;
    private String typeName;
    private static AppOptions options = new AppOptions();
    private int interfaceID = 2;
    private int scalingtype;
    public BoardsTypesAndDescription.BoardType boardtypeproj;
    public ScalingPanel panel;
    private BoardsTypesAndDescription.BoardType boardType;
    private String transformType = "0.0";
    private static final String TRANSFORM_FLOAT = "0.0";
    private String decimalPlaces = "1.0";
    private String minRawVal = "0";
    private String minScaledVal = "0";
    private String maxRawVal = "65535";
    private String maxScaledVal = "65535.0";
    private String commIntervalMs = "5000";
    public final String[] modBusFunctions = new String[]{"01 - Read Coil", "02 - Read Discrete", "03 - Read Holding", "04 - Read Input", "05 - Force Single Coil", "06 - Preset Single Register"};
    public static final int ModbusStation = 39;
    SimMultiInputFrame simMultiInFrame = new SimMultiInputFrame();

    public ModbusStation(String id, String label, AFOGraphPinScene scene, Project proj) {
        super(id, label, "Modbus Station", scene);
        this.typeName = label;
        this.blockType = CommonDefinitions.blockTypes.ModbusStation;
        this.numberOfInputs = 0;
        this.tableModel = new DefaultTableModel(new Object[0][], new String[]{"Slave Addr.", "Register Start  Addr.", "Function", "N Of Registers", "Comment", "SimType", "SimAmplitude", "SimOffset", "SimPeriod"}){
            Class[] types;
            {
                this.types = new Class[]{Integer.class, Integer.class, String.class, Integer.class, String.class, String.class, String.class, String.class, String.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        };
        this.setConnectionStatus(false);
        this.createWidget();
        this.CreatePropertiesDialog();
        this.CreatePanelDialog();
        ((ModbusStationDialog)this.propertiesDialog).btnScaling.addActionListener(this);
        this.boardtypeproj = proj.getBoardType();
        if (BoardsTypesAndDescription.boardNOfSerialPorts[this.boardtypeproj.ordinal()] == 1) {
            ((ModbusStationDialog)this.propertiesDialog).comboPort.removeItemAt(1);
            ((ModbusStationDialog)this.propertiesDialog).comboPort.setSelectedIndex(0);
        } else if (BoardsTypesAndDescription.boardNOfSerialPorts[this.boardtypeproj.ordinal()] == 3) {
            ((ModbusStationDialog)this.propertiesDialog).comboPort.addItem("RS3");
        }
        this.addressSpace = 50;
        this.codici = new ArrayList();
        this.codici.add("ModbusStation");
        this.codici.add("ModbusPort");
        this.codici.add("SlaveRegister");
        this.codici.add("ScalingType");
        this.codici.add("DecimalNumber");
        this.codici.add("MinRawValue");
        this.codici.add("MinScaleValue");
        this.codici.add("MaxRawValue");
        this.codici.add("MaxScaleValue");
        this.setList(this.codici);
        this.clearTableModel(this.tableModel);
        this.simMultiInFrame.btnExit.addActionListener(this);
    }

    @Override
    public ArrayList<String> getList() {
        this.codici.clear();
        this.codici.add("ModbusStation");
        this.codici.add("NofReg");
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            Integer function = Integer.parseInt(this.tableModel.getValueAt(i, 2).toString().substring(0, 2));
            if (function >= 5) continue;
            int nOfRegs = Integer.parseInt(this.tableModel.getValueAt(i, 3).toString());
            for (int j = 0; j < nOfRegs; ++j) {
                this.codici.add(this.tableModel.getValueAt(i, 4).toString());
            }
        }
        return this.codici;
    }

    public String getAddress() {
        String newAddress = ((ModbusStationDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        int i;
        if (BoardsTypesAndDescription.boardNOfSerialPorts[this.boardtypeproj.ordinal()] == 1) {
            this.interfaceID = 1;
        }
        this.setDialogFields();
        ((ModbusStationDialog)this.propertiesDialog).enableFields(!this.kernelConnected);
        ((ModbusStationDialog)this.propertiesDialog).fieldChanged = false;
        ((ModbusStationDialog)this.propertiesDialog).indexLabel.setVisible(false);
        DefaultTableModel dialogTable = new DefaultTableModel(new Object[0][], new String[]{"Slave Addr.", "Register Start  Addr.", "Function", "N Of Registers", "Comment", "SimType", "SimAmplitude", "SimOffset", "SimPeriod"}){
            Class[] types;
            {
                this.types = new Class[]{Integer.class, Integer.class, String.class, Integer.class, String.class, String.class, String.class, String.class, String.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        };
        nodes.devices.ModbusStation.tableCopy(dialogTable, this.tableModel);
        ((ModbusStationDialog)this.propertiesDialog).table.setModel(dialogTable);
        for (i = 0; i < ((ModbusStationDialog)this.propertiesDialog).table.getRowCount(); ++i) {
            int vColIndex = 2;
            TableColumn col = ((ModbusStationDialog)this.propertiesDialog).table.getColumnModel().getColumn(vColIndex);
            MyComboBoxEditor combo = new MyComboBoxEditor(this.modBusFunctions);
            col.setCellEditor(combo);
        }
        ((ModbusStationDialog)this.propertiesDialog).comboPort.setEnabled(!this.kernelConnected);
        ((ModbusStationDialog)this.propertiesDialog).table.setEnabled(!this.kernelConnected);
        ((ModbusStationDialog)this.propertiesDialog).btnScaling.setEnabled(!this.kernelConnected);
        ((ModbusStationDialog)this.propertiesDialog).btnOk.setEnabled(!this.kernelConnected);
        ((ModbusStationDialog)this.propertiesDialog).txtUpdateInterval.setEnabled(!this.kernelConnected);
        ((ModbusStationDialog)this.propertiesDialog).fieldChanged = false;
        ((ModbusStationDialog)this.propertiesDialog).showDialog();
        if (((ModbusStationDialog)this.propertiesDialog).getReturnStatus() == 1) {
            if (!((ModbusStationDialog)this.propertiesDialog).getDataChanged()) {
                return;
            }
            this.scene.sceneChanged();
            this.addressList.clear();
            for (i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.getDialogFields();
            dialogTable = (DefaultTableModel)((ModbusStationDialog)this.propertiesDialog).table.getModel();
            boolean deleteEdges = true;
            if (this.tableModel.getRowCount() == dialogTable.getRowCount()) {
                deleteEdges = false;
                block2: for (int i2 = 0; i2 < this.tableModel.getRowCount(); ++i2) {
                    for (int j = 2; j < 4; ++j) {
                        if (!this.tableModel.getValueAt(i2, j).toString().equals(dialogTable.getValueAt(i2, j).toString())) {
                            deleteEdges = true;
                            continue block2;
                        }
                        if (Integer.parseInt(this.tableModel.getValueAt(i2, 3).toString()) <= 1) continue;
                        deleteEdges = true;
                        continue block2;
                    }
                }
            }
            nodes.devices.ModbusStation.tableCopy(this.tableModel, dialogTable);
            if (deleteEdges) {
                this.createPins();
            } else {
                this.updatePins();
            }
        }
    }

    private void updatePins() {
        if (this.tableModel.getRowCount() != 0) {
            int j = 0;
            int i = 0;
            while (i < this.tableModel.getRowCount()) {
                AFOPin pin = this.getPinAt(j);
                LabelWidget lblWdg = pin.getPinNameWidget();
                if (pin.getPinIDString().equalsIgnoreCase("out1")) {
                    pin = this.getPinAt(++j);
                    lblWdg = pin.getPinNameWidget();
                }
                lblWdg.setLabel(this.tableModel.getValueAt(i, 4).toString());
                ++i;
                ++j;
            }
        }
        this.scene.revalidate();
        boolean nOfOut = false;
        this.codici = new ArrayList();
        this.codici.add("ModbusStation");
        this.codici.add("ModbusPort");
        this.codici.add("ScalingType");
        this.codici.add("DecimalNumber");
        this.codici.add("MinRawValue");
        this.codici.add("MinScaleValue");
        this.codici.add("MaxRawValue");
        this.codici.add("MaxScaleValue");
        int numin = 0;
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            Integer function = Integer.parseInt(this.tableModel.getValueAt(i, 2).toString().substring(0, 2));
            if (function < 5) {
                Integer nOfRegs = Integer.parseInt(this.tableModel.getValueAt(i, 2).toString().substring(0, 2));
                for (int j = 0; j < nOfRegs; ++j) {
                    this.codici.add(Integer.toString(Integer.parseInt(this.tableModel.getValueAt(i, 1).toString()) + j));
                }
                continue;
            }
            ++numin;
        }
        this.setList(this.codici);
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        retVal = retVal + "39 " + this.getCommonData();
        retVal = retVal + (((AFONodeWidget)this.widget).getModuleOUTPinNames().getChildren().size() - 1) + " ";
        retVal = retVal + this.interfaceID + " ";
        retVal = retVal + this.transformType;
        retVal = retVal + " " + this.decimalPlaces + " " + this.minRawVal + " " + this.minScaledVal + " " + this.maxRawVal;
        retVal = retVal + " " + this.maxScaledVal + " " + this.commIntervalMs;
        return retVal;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(((ModbusStationDialog)this.propertiesDialog).btnOk)) {
            if (((ModbusStationDialog)this.propertiesDialog).indexLabel.isVisible()) {
                JOptionPane.showMessageDialog(null, "L'indirizzo inserito \u00e8 gi\u00e0 in uso!");
                return;
            }
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.propertiesDialog.setVisible(false);
        } else if (e.getSource().equals(((ModbusStationDialog)this.propertiesDialog).btnCancel)) {
            this.propertiesDialog.setVisible(false);
        } else if (e.getSource().equals(((ModbusStationDialog)this.propertiesDialog).btnScaling)) {
            this.panel.setVisible(true);
            if (this.panel.returnStatus == 1) {
                ((ModbusStationDialog)this.propertiesDialog).fieldChanged = true;
            }
        } else if (e.getSource().equals(this.simMultiInFrame.btnExit)) {
            this.simDialogClosed();
        }
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        this.parseStandardBlockCmd(cmd);
        return true;
    }

    private void createPins() {
        for (AFOPin pin : this.pinList) {
            this.scene.removePinWithEdges(pin);
        }
        ((AFONodeWidget)this.widget).clearPins();
        ((AFONodeWidget)this.widget).getModuleINPinNames().removeChildren();
        ((AFONodeWidget)this.widget).getModuleOUTPinNames().removeChildren();
        this.pinList.clear();
        this.numberOfInputs = 0;
        this.addIOPin(false, "N. Reg OK", 1);
        int nOfOut = 1;
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            Integer function = Integer.parseInt(this.tableModel.getValueAt(i, 2).toString().substring(0, 2));
            if (function < 5) {
                Integer nOfRegs = Integer.parseInt(this.tableModel.getValueAt(i, 3).toString());
                for (int j = 0; j < nOfRegs; ++j) {
                    String pinLabel = this.tableModel.getValueAt(i, 4).toString();
                    this.addIOPin(false, "" + pinLabel, ++nOfOut);
                }
                continue;
            }
            ++this.numberOfInputs;
            this.addIOPin(true, this.tableModel.getValueAt(i, 4).toString(), this.numberOfInputs);
        }
        this.codici = new ArrayList();
        this.codici.add("ModbusStation");
        this.codici.add("ModbusPort");
        this.codici.add("SlaveAddress");
        this.codici.add("SlaveRegister");
        this.codici.add("ScalingType");
        this.codici.add("DecimalNumber");
        this.codici.add("MinRawValue");
        this.codici.add("MinScaleValue");
        this.codici.add("MaxRawValue");
        this.codici.add("MaxScaleValue");
        int numin = 0;
        int numout = 0;
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            Integer function = Integer.parseInt(this.tableModel.getValueAt(i, 2).toString().substring(0, 2));
            if (function > 4) {
                ++numin;
                continue;
            }
            ++numout;
            this.codici.add(this.tableModel.getValueAt(i, 1).toString());
        }
        this.setList(this.codici);
        System.out.println(this.codici);
        for (AFOPin pin : this.pinList) {
            pin.setParentNode(this);
        }
        this.scene.revalidate();
    }

    private AFOPin addIOPin(boolean isInput, String label, int number) {
        AFOPin newPin;
        String pinLabel = label;
        if (isInput) {
            String pinID = "pin" + ++this.scene.pinIDCounter;
            newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
            newPin.setAsBusPin(false);
            newPin.setParentNode(this);
            newPin.setPinIDString("IN" + number);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
        } else {
            String pinID = "pin" + ++this.scene.pinIDCounter;
            newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
            newPin.setAsBusPin(false);
            newPin.setParentNode(this);
            newPin.setPinIDString("OUT" + number);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
        }
        return newPin;
    }

    public static void tableClear(DefaultTableModel table) {
        while (table.getRowCount() > 0) {
            table.removeRow(0);
        }
    }

    public static void tableCopy(DefaultTableModel destTable, DefaultTableModel srcTable) {
        nodes.devices.ModbusStation.tableClear(destTable);
        for (int i = 0; i < srcTable.getRowCount(); ++i) {
            destTable.addRow(new Object[]{srcTable.getValueAt(i, 0), srcTable.getValueAt(i, 1), srcTable.getValueAt(i, 2), srcTable.getValueAt(i, 3), srcTable.getValueAt(i, 4), srcTable.getValueAt(i, 5), srcTable.getValueAt(i, 6), srcTable.getValueAt(i, 7), srcTable.getValueAt(i, 8)});
        }
    }

    private void clearTableModel(DefaultTableModel model) {
        while (model.getRowCount() > 0) {
            model.removeRow(0);
        }
    }

    private void createWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName(this.typeName);
        this.getScene().addNode(this);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
        this.getScene().revalidate();
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new ModbusStationDialog(null, true, this);
    }

    private void CreatePanelDialog() {
        this.panel = new ScalingPanel(null, true);
    }

    private void setDialogFields() {
        ((ModbusStationDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((ModbusStationDialog)this.propertiesDialog).txtUpdateInterval.setText(this.commIntervalMs);
        ((ModbusStationDialog)this.propertiesDialog).comboPort.setSelectedIndex(this.interfaceID - 1);
        this.panel.comboScalingType.setSelectedIndex((int)Float.parseFloat(this.transformType));
        this.panel.spnrDecimalPlaces.setValue((int)Float.parseFloat(this.decimalPlaces));
        this.panel.txtMinRaw.setText(this.minRawVal);
        this.panel.txtMinScaled.setText(this.minScaledVal);
        this.panel.txtMaxRaw.setText(this.maxRawVal);
        this.panel.txtMaxScaled.setText(this.maxScaledVal);
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "NofRows", "" + this.tableModel.getRowCount());
        SceneSerializer.setAttribute(document, nodeElement, "InterfaceID", "" + this.interfaceID);
        SceneSerializer.setAttribute(document, nodeElement, "ScalingType", this.transformType);
        SceneSerializer.setAttribute(document, nodeElement, "NofDecimals", this.decimalPlaces);
        SceneSerializer.setAttribute(document, nodeElement, "MinRaw", this.minRawVal);
        SceneSerializer.setAttribute(document, nodeElement, "MinScaled", this.minScaledVal);
        SceneSerializer.setAttribute(document, nodeElement, "MaxRaw", this.maxRawVal);
        SceneSerializer.setAttribute(document, nodeElement, "MaxScaled", this.maxScaledVal);
        SceneSerializer.setAttribute(document, nodeElement, "CommIntervalMs", this.commIntervalMs);
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            Element climaticElement = document.createElement("TableRow");
            SceneSerializer.setAttribute(document, climaticElement, "SlaveAddr", this.tableModel.getValueAt(i, 0).toString());
            SceneSerializer.setAttribute(document, climaticElement, "Address", this.tableModel.getValueAt(i, 1).toString());
            SceneSerializer.setAttribute(document, climaticElement, "Function", this.tableModel.getValueAt(i, 2).toString());
            SceneSerializer.setAttribute(document, climaticElement, "nOfRegs", this.tableModel.getValueAt(i, 3).toString());
            SceneSerializer.setAttribute(document, climaticElement, "simType", this.tableModel.getValueAt(i, 5).toString());
            SceneSerializer.setAttribute(document, climaticElement, "simAmplitude", this.tableModel.getValueAt(i, 6).toString());
            SceneSerializer.setAttribute(document, climaticElement, "simOffset", this.tableModel.getValueAt(i, 7).toString());
            SceneSerializer.setAttribute(document, climaticElement, "simPeriod", this.tableModel.getValueAt(i, 8).toString());
            String commento = this.tableModel.getValueAt(i, 4).toString();
            if (commento == null) {
                commento = "-";
            }
            SceneSerializer.setAttribute(document, climaticElement, "Comment", commento);
            nodeElement.appendChild(climaticElement);
        }
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        int row = 0;
        this.clearTableModel(this.tableModel);
        this.interfaceID = Integer.parseInt(SceneSerializer.getAttributeValue(node, "InterfaceID"));
        if (BoardsTypesAndDescription.boardNOfSerialPorts[this.boardtypeproj.ordinal()] == 1) {
            this.interfaceID = 1;
        } else if (BoardsTypesAndDescription.boardNOfSerialPorts[this.boardtypeproj.ordinal()] == 2 && this.interfaceID > 2) {
            this.interfaceID = 2;
        }
        this.transformType = SceneSerializer.getAttributeValue(node, "ScalingType");
        this.decimalPlaces = SceneSerializer.getAttributeValue(node, "NofDecimals");
        this.minRawVal = SceneSerializer.getAttributeValue(node, "MinRaw");
        this.minScaledVal = SceneSerializer.getAttributeValue(node, "MinScaled");
        this.maxRawVal = SceneSerializer.getAttributeValue(node, "MaxRaw");
        this.maxScaledVal = SceneSerializer.getAttributeValue(node, "MaxScaled");
        this.commIntervalMs = SceneSerializer.getAttributeValue(node, "CommIntervalMs");
        if (this.commIntervalMs == null) {
            this.commIntervalMs = "5000";
        }
        for (Node element : SceneSerializer.getChildNode(node)) {
            if (!element.getNodeName().equals("TableRow")) continue;
            String slaveAddr = SceneSerializer.getAttributeValue(element, "SlaveAddr");
            if (slaveAddr == null) {
                slaveAddr = "1";
            }
            String addr = SceneSerializer.getAttributeValue(element, "Address");
            String inout = SceneSerializer.getAttributeValue(element, "Function");
            String register = SceneSerializer.getAttributeValue(element, "nOfRegs");
            String commento = SceneSerializer.getAttributeValue(element, "Comment");
            if (commento == null) {
                commento = addr + "-" + register;
            }
            String type = SceneSerializer.getAttributeValue(element, "simType");
            String amplitude = SceneSerializer.getAttributeValue(element, "simAmplitude");
            String offset = SceneSerializer.getAttributeValue(element, "simOffset");
            String period = SceneSerializer.getAttributeValue(element, "simPeriod");
            if (type == null) {
                type = SimInputFrame.SIM_IN_TYPES.Costant.toString();
            }
            if (amplitude == null) {
                amplitude = "1.0";
            }
            if (offset == null) {
                offset = TRANSFORM_FLOAT;
            }
            if (period == null) {
                period = "60.0";
            }
            this.tableModel.addRow(new Object[]{slaveAddr, addr, inout, register, commento, type, amplitude, offset, period});
            ++row;
        }
        this.propertiesDialog.validate();
        this.createPins();
    }

    private void getDialogFields() {
        ModbusStationDialog dlg = (ModbusStationDialog)this.propertiesDialog;
        this.interfaceID = dlg.comboPort.getSelectedIndex() + 1;
        this.commIntervalMs = dlg.txtUpdateInterval.getText();
        this.minRawVal = "" + this.panel.txtMinRaw.getText();
        this.minScaledVal = "" + this.panel.txtMinScaled.getText();
        this.maxRawVal = "" + this.panel.txtMaxRaw.getText();
        this.maxScaledVal = "" + this.panel.txtMaxScaled.getText();
        this.transformType = "" + (float)this.panel.comboScalingType.getSelectedIndex();
        this.decimalPlaces = "" + (float)Integer.parseInt(this.panel.spnrDecimalPlaces.getValue().toString());
    }

    protected void sort(DefaultTableModel model) {
        for (int i = 1; i < model.getRowCount(); ++i) {
            for (int j = i; j > 0 && this.compare(model, j - 1, j) > 0; --j) {
                model.moveRow(j, j, j - 1);
            }
        }
    }

    protected int compare(DefaultTableModel model, int i, int j) {
        String s1 = model.getValueAt(i, 2).toString().substring(0, 2);
        String s2 = model.getValueAt(j, 2).toString().substring(0, 2);
        return s2.compareTo(s1);
    }

    public String getVarConfiguration() {
        String retVal = "";
        DefaultTableModel tableClone = new DefaultTableModel(new Object[0][], new String[]{"Slave Addr.", "Register Start  Addr.", "Function", "N Of Registers", "Comment"}){
            Class[] types;
            {
                this.types = new Class[]{Integer.class, Integer.class, String.class, Integer.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        };
        nodes.devices.ModbusStation.tableCopy(tableClone, this.tableModel);
        this.sort(tableClone);
        for (int i = 0; i < tableClone.getRowCount(); ++i) {
            retVal = retVal + "<BL set ";
            retVal = retVal + this.addressList.get(0) + " ";
            retVal = retVal + tableClone.getValueAt(i, 0).toString() + " ";
            retVal = retVal + tableClone.getValueAt(i, 1).toString() + " ";
            Integer function = Integer.parseInt(tableClone.getValueAt(i, 2).toString().substring(0, 2));
            retVal = retVal + function.toString() + " ";
            retVal = retVal + tableClone.getValueAt(i, 3).toString() + " ";
            retVal = retVal + ">\r\n";
        }
        return retVal;
    }

    @Override
    public void initSimulation() {
        super.initSimulation();
        this.simInputTimer = new GenericNode.SimTimer();
    }

    private SimInputFrame.SIM_IN_TYPES getTypeFromString(String str) {
        for (SimInputFrame.SIM_IN_TYPES sim : SimInputFrame.SIM_IN_TYPES.values()) {
            if (!sim.toString().equals(str)) continue;
            return sim;
        }
        return SimInputFrame.SIM_IN_TYPES.Costant;
    }

    @Override
    public void simulate() {
        GenericNode.SimData out;
        super.simulate();
        int outIndex = 1;
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            Integer function = Integer.parseInt(this.tableModel.getValueAt(i, 2).toString().substring(0, 2));
            if (function >= 5) continue;
            SimInputFrame.SIM_IN_TYPES rowType = this.getTypeFromString(this.tableModel.getValueAt(i, 5).toString());
            double amp = Double.parseDouble(this.tableModel.getValueAt(i, 6).toString());
            double offset = Double.parseDouble(this.tableModel.getValueAt(i, 7).toString());
            double period = Double.parseDouble(this.tableModel.getValueAt(i, 8).toString());
            double x = this.waveGenerator(rowType, period, amp, offset);
            out = this.GetMData(outIndex);
            out.isValid = true;
            out.data = x;
            this.SetMData(outIndex, out);
            ++outIndex;
        }
        out = this.GetMData(0);
        out.isValid = true;
        out.data = outIndex - 1;
        this.updateSimOutputs();
    }

    @Override
    public void showSimulationDialog() {
        this.simMultiInFrame.cleanTable();
        DefaultTableModel dialogTable = new DefaultTableModel(new Object[0][], new Object[]{"Label", "Type", "Amplitude", "Offset", "Period", "PinID"});
        this.simTableCopyToDialog(dialogTable, this.tableModel);
        this.simMultiInFrame.table.setModel(dialogTable);
        this.simMultiInFrame.setupCombo();
        this.simMultiInFrame.hideColumn(5);
        this.simMultiInFrame.setVisible(true);
    }

    @Override
    protected void simDialogClosed() {
        DefaultTableModel dialogTable = (DefaultTableModel)this.simMultiInFrame.table.getModel();
        this.simTableCopyFromDialog(this.tableModel, dialogTable);
    }

    public void simTableCopyToDialog(DefaultTableModel destTable, DefaultTableModel srcTable) {
        nodes.devices.ModbusStation.tableClear(destTable);
        for (int i = 0; i < srcTable.getRowCount(); ++i) {
            Integer function = Integer.parseInt(this.tableModel.getValueAt(i, 2).toString().substring(0, 2));
            if (function >= 5) continue;
            destTable.addRow(new Object[]{srcTable.getValueAt(i, 4), srcTable.getValueAt(i, 5), srcTable.getValueAt(i, 6), srcTable.getValueAt(i, 7), srcTable.getValueAt(i, 8), i});
        }
    }

    public void simTableCopyFromDialog(DefaultTableModel destTable, DefaultTableModel srcTable) {
        for (int i = 0; i < srcTable.getRowCount(); ++i) {
            int rowIndex = Integer.parseInt(srcTable.getValueAt(i, 5).toString());
            destTable.setValueAt(srcTable.getValueAt(i, 1), rowIndex, 5);
            destTable.setValueAt(srcTable.getValueAt(i, 2), rowIndex, 6);
            destTable.setValueAt(srcTable.getValueAt(i, 3), rowIndex, 7);
            destTable.setValueAt(srcTable.getValueAt(i, 4), rowIndex, 8);
        }
    }
}

