/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import nodes.AFONodeWidget;
import nodes.BoardsTypesAndDescription;
import nodes.CommonDefinitions;
import nodes.Project;
import nodes.SceneSerializer;
import nodes.devices.DeviceNode;
import nodes.devices.GenericNode;
import nodes.gui.MonitorDialog;
import nodes.gui.MyComboBoxEditor;
import nodes.gui.SimInputFrame;
import nodes.gui.SimMultiInputFrame;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class MonitorNode
extends DeviceNode
implements ActionListener {
    private DefaultTableModel tableModel;
    private DefaultTableModel simTableModel;
    private final String type;
    private String displayAddress = "1";
    private String displayPort = "2";
    public BoardsTypesAndDescription.BoardType boardtypeproj;
    private BoardsTypesAndDescription.BoardType boardType;
    int NUM_DEFAULT_OUT_PINS;
    int nOfOut = this.NUM_DEFAULT_OUT_PINS = 4;
    private int pinListStandardSize;
    public static final int Monitor_ID = 32;
    SimMultiInputFrame simMultiInFrame = new SimMultiInputFrame();

    public MonitorNode(String id, String label, String UID, AFOGraphPinScene scene, Project proj) {
        super(id, label, "Monitor", scene);
        this.type = label;
        this.blockType = CommonDefinitions.blockTypes.Monitor;
        this.numberOfInputs = 0;
        this.tableModel = new DefaultTableModel(new Object[]{modelColumns.Label.toString(), modelColumns.Scale.toString(), modelColumns.Address.toString(), modelColumns.Min.toString(), modelColumns.Max.toString(), modelColumns.Step.toString(), modelColumns.PinID}, 0);
        this.simTableModel = new DefaultTableModel(new Object[]{simModelColumns.Label.toString(), simModelColumns.Type.toString(), simModelColumns.Amplitude.toString(), simModelColumns.Offset.toString(), simModelColumns.Period.toString(), simModelColumns.PinID}, 0);
        this.createWidget();
        this.createPropertiesDialog();
        this.boardtypeproj = proj.getBoardType();
        this.addressSpace = 5;
        this.codici = new ArrayList();
        this.codici.add("Monitor");
        this.codici.add("ON_Monitor");
        this.codici.add("Summer_Monitor");
        this.codici.add("AUTOMATICO_Monitor");
        this.codici.add("Setpoint_Monitor");
        this.setList(this.codici);
        this.clearTableModel(this.tableModel);
        this.clearTableModel(this.simTableModel);
        for (AFOPin pinExamined : this.getPinList()) {
            if (pinExamined.getPinType() != AFOPin.E_PinType.PIN_OUTPUT) continue;
            this.simTableModel.addRow(new Object[]{pinExamined.getLabel(), SimInputFrame.SIM_IN_TYPES.Costant.toString(), "1.0", "1.0", "1.0", null});
        }
        this.simMultiInFrame.btnExit.addActionListener(this);
    }

    public String getAddress() {
        String newAddress = ((MonitorDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void createWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName(this.type);
        this.getScene().addNode(this);
        ((AFONodeWidget)this.widget).setSubType(this.displayAddress);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
        this.createPins();
        this.scene.validate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.simMultiInFrame.btnExit)) {
            this.simDialogClosed();
        }
    }

    private void createPropertiesDialog() {
        this.propertiesDialog = new MonitorDialog(null, true, this.type, this);
    }

    public static void tableClear(DefaultTableModel table) {
        while (table.getRowCount() > 0) {
            table.removeRow(0);
        }
    }

    public static void tableCopy(DefaultTableModel destTable, DefaultTableModel srcTable) {
        MonitorNode.tableClear(destTable);
        for (int i = 0; i < srcTable.getRowCount(); ++i) {
            destTable.addRow(new Object[]{srcTable.getValueAt(i, 0), srcTable.getValueAt(i, 1), srcTable.getValueAt(i, 2), srcTable.getValueAt(i, 3), srcTable.getValueAt(i, 4), srcTable.getValueAt(i, 5), srcTable.getValueAt(i, 6)});
        }
    }

    public void simTableCopy(DefaultTableModel destTable, DefaultTableModel srcTable) {
        MonitorNode.tableClear(destTable);
        for (int i = 0; i < srcTable.getRowCount(); ++i) {
            destTable.addRow(new Object[]{srcTable.getValueAt(i, 0), srcTable.getValueAt(i, 1), srcTable.getValueAt(i, 2), srcTable.getValueAt(i, 3), srcTable.getValueAt(i, 4), srcTable.getValueAt(i, 5)});
        }
    }

    @Override
    public void setConnectionStatus(boolean isConnected) {
        MonitorDialog dlg = (MonitorDialog)this.propertiesDialog;
        dlg.btnGiu.setEnabled(!isConnected);
        dlg.btnSu.setEnabled(!isConnected);
        dlg.btnInsert.setEnabled(!isConnected);
        dlg.table.setEnabled(!isConnected);
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        int i;
        ((MonitorDialog)this.propertiesDialog).disableListeners();
        ((MonitorDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((MonitorDialog)this.propertiesDialog).comboPort.setSelectedIndex(Integer.parseInt(this.displayPort) - 1);
        if (BoardsTypesAndDescription.boardNOfSerialPorts[this.boardtypeproj.ordinal()] == 1) {
            ((MonitorDialog)this.propertiesDialog).comboPort.removeItemAt(1);
            ((MonitorDialog)this.propertiesDialog).comboPort.setSelectedIndex(0);
            this.displayPort = "1";
        } else {
            ((MonitorDialog)this.propertiesDialog).comboPort.setSelectedIndex(Integer.parseInt(this.displayPort) - 1);
        }
        ((MonitorDialog)this.propertiesDialog).txtDisplayAddress.setText(this.displayAddress);
        ((MonitorDialog)this.propertiesDialog).indexLabel.setVisible(false);
        DefaultTableModel dialogTable = new DefaultTableModel(new Object[]{modelColumns.Label.toString(), modelColumns.Scale.toString(), modelColumns.Address.toString(), modelColumns.Min.toString(), modelColumns.Max.toString(), modelColumns.Step.toString(), modelColumns.PinID}, 0);
        MonitorNode.tableCopy(dialogTable, this.tableModel);
        ((MonitorDialog)this.propertiesDialog).table.setModel(dialogTable);
        for (i = 0; i < ((MonitorDialog)this.propertiesDialog).table.getRowCount(); ++i) {
            String[] values = new String[]{"1", "10", "100"};
            int vColIndex = 1;
            TableColumn col = ((MonitorDialog)this.propertiesDialog).table.getColumnModel().getColumn(vColIndex);
            MyComboBoxEditor combo = new MyComboBoxEditor(values);
            col.setCellEditor(combo);
        }
        ((MonitorDialog)this.propertiesDialog).comboPort.setEnabled(!this.kernelConnected);
        ((MonitorDialog)this.propertiesDialog).txtDisplayAddress.setEnabled(!this.kernelConnected);
        ((MonitorDialog)this.propertiesDialog).table.setEnabled(!this.kernelConnected);
        ((MonitorDialog)this.propertiesDialog).btnOk.setEnabled(!this.kernelConnected);
        ((MonitorDialog)this.propertiesDialog).btnDeleteRow.setEnabled(!this.kernelConnected);
        ((MonitorDialog)this.propertiesDialog).btnInsert.setEnabled(!this.kernelConnected);
        ((MonitorDialog)this.propertiesDialog).btnSu.setEnabled(!this.kernelConnected);
        ((MonitorDialog)this.propertiesDialog).btnGiu.setEnabled(!this.kernelConnected);
        ((MonitorDialog)this.propertiesDialog).showDialog();
        if (((MonitorDialog)this.propertiesDialog).getReturnStatus() == 1) {
            if (!((MonitorDialog)this.propertiesDialog).getDataChanged()) {
                return;
            }
            this.scene.sceneChanged();
            this.addressList.clear();
            for (i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.displayAddress = ((MonitorDialog)this.propertiesDialog).txtDisplayAddress.getText();
            ((AFONodeWidget)this.widget).setSubType(this.displayAddress);
            this.displayPort = "" + (((MonitorDialog)this.propertiesDialog).comboPort.getSelectedIndex() + 1);
            dialogTable = (DefaultTableModel)((MonitorDialog)this.propertiesDialog).table.getModel();
            if (this.tableModel.getRowCount() > dialogTable.getRowCount()) {
                for (i = 0; i < this.tableModel.getRowCount(); ++i) {
                    if (this.findRowIndexFromPin(dialogTable, (AFOPin)this.tableModel.getValueAt(i, 6)) >= 0) continue;
                    AFOPin pin = (AFOPin)this.tableModel.getValueAt(i, 6);
                    ((AFONodeWidget)this.widget).removePin(pin);
                    this.tableModel.removeRow(i);
                    this.pinList.remove(pin);
                    this.scene.validate();
                }
            }
            for (i = 0; i < dialogTable.getRowCount(); ++i) {
                AFOPin newPin;
                int rowIndex = this.findRowIndexFromPin(this.tableModel, (AFOPin)dialogTable.getValueAt(i, 6));
                if (rowIndex == -1) {
                    if (i >= this.tableModel.getRowCount()) {
                        this.tableModel.addRow(dialogTable.getDataVector().get(i));
                    } else {
                        this.tableModel.insertRow(i, dialogTable.getDataVector().get(i));
                    }
                    this.addPinFromDialogRow(dialogTable, i);
                    continue;
                }
                if (Double.parseDouble(this.tableModel.getValueAt(rowIndex, 5).toString()) == 0.0 && Double.parseDouble(dialogTable.getValueAt(i, 5).toString()) != 0.0 || Double.parseDouble(this.tableModel.getValueAt(rowIndex, 5).toString()) != 0.0 && Double.parseDouble(dialogTable.getValueAt(i, 5).toString()) == 0.0) {
                    this.tableModel.removeRow(rowIndex);
                    this.tableModel.insertRow(i, dialogTable.getDataVector().get(i));
                    AFOPin pin = (AFOPin)this.tableModel.getValueAt(i, 6);
                    ((AFONodeWidget)this.widget).removePin(pin);
                    int pinIndex = this.pinList.indexOf(pin);
                    this.pinList.remove(pinIndex);
                    this.scene.validate();
                    newPin = this.addPinFromDialogRow(dialogTable, i);
                    this.pinList.remove(newPin);
                    this.pinList.add(i + this.pinListStandardSize, newPin);
                    this.scene.validate();
                    this.tableModel.setValueAt(newPin, i, 6);
                    continue;
                }
                this.tableModel.removeRow(rowIndex);
                this.tableModel.insertRow(i, dialogTable.getDataVector().get(i));
                newPin = (AFOPin)dialogTable.getValueAt(i, 6);
                this.pinList.remove(rowIndex + this.pinListStandardSize);
                this.pinList.add(i + this.pinListStandardSize, newPin);
            }
            this.checkSimTable();
        }
    }

    private int findSimRowIndexFromPin(DefaultTableModel table, AFOPin pin) {
        int retVal = -1;
        try {
            for (int i = this.NUM_DEFAULT_OUT_PINS; i < table.getRowCount(); ++i) {
                AFOPin myPin = (AFOPin)table.getValueAt(i, simModelColumns.PinID.ordinal());
                if (!myPin.equals(pin)) continue;
                retVal = i;
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return retVal;
    }

    private void checkSimTable() {
        int rowCount = this.simTableModel.getRowCount();
        for (int i = this.NUM_DEFAULT_OUT_PINS; i < rowCount; ++i) {
            if (this.findRowIndexFromPin(this.tableModel, (AFOPin)this.simTableModel.getValueAt(i, simModelColumns.PinID.ordinal())) >= 0) continue;
            this.simTableModel.removeRow(i);
            --rowCount;
            --i;
        }
        int count = 0;
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            if (Double.parseDouble(this.tableModel.getValueAt(i, modelColumns.Step.ordinal()).toString()) == 0.0) continue;
            int rowIndex = this.findSimRowIndexFromPin(this.simTableModel, (AFOPin)this.tableModel.getValueAt(i, modelColumns.PinID.ordinal()));
            if (rowIndex == -1) {
                String label = this.tableModel.getDataVector().elementAt(i).elementAt(0).toString();
                if (count + this.NUM_DEFAULT_OUT_PINS >= this.simTableModel.getRowCount()) {
                    this.simTableModel.addRow(new Object[]{label, "Costant", "0.0", "1.0", "1.0", this.tableModel.getDataVector().elementAt(i).elementAt(modelColumns.PinID.ordinal())});
                } else {
                    this.simTableModel.insertRow(count + this.NUM_DEFAULT_OUT_PINS, new Object[]{label, "Costant", "0.0", "1.0", "1.0", this.tableModel.getDataVector().elementAt(i).elementAt(modelColumns.PinID.ordinal())});
                }
            } else if (Double.parseDouble(this.tableModel.getValueAt(i, modelColumns.Step.ordinal()).toString()) == 0.0) {
                this.simTableModel.removeRow(rowIndex);
            } else {
                Vector row = this.simTableModel.getDataVector().elementAt(rowIndex);
                this.simTableModel.removeRow(rowIndex);
                if (count + this.NUM_DEFAULT_OUT_PINS >= this.simTableModel.getRowCount()) {
                    this.simTableModel.addRow(row);
                } else {
                    this.simTableModel.insertRow(count + this.NUM_DEFAULT_OUT_PINS, row);
                }
            }
            ++count;
        }
    }

    private AFOPin addPinFromDialogRow(DefaultTableModel dialogModel, int row) {
        AFOPin newPin;
        if (this.tableModel.getValueAt(row, 5) == null || (double)Float.parseFloat(this.tableModel.getValueAt(row, 5).toString()) == 0.0) {
            ++this.numberOfInputs;
            newPin = this.addIOPin(true, this.tableModel.getValueAt(row, 0).toString(), this.numberOfInputs);
        } else {
            ++this.nOfOut;
            newPin = this.addIOPin(false, this.tableModel.getValueAt(row, 0).toString(), this.nOfOut);
        }
        this.tableModel.setValueAt(newPin, row, 6);
        return newPin;
    }

    private int findRowIndexFromPin(DefaultTableModel table, AFOPin pin) {
        int retVal = -1;
        try {
            for (int i = 0; i < table.getRowCount(); ++i) {
                if (!table.getValueAt(i, 6).equals(pin)) continue;
                retVal = i;
                break;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return retVal;
    }

    private void createPins() {
        for (AFOPin pin : this.pinList) {
            this.scene.removePinWithEdges(pin);
        }
        ((AFONodeWidget)this.widget).clearPins();
        ((AFONodeWidget)this.widget).getModuleINPinNames().removeChildren();
        ((AFONodeWidget)this.widget).getModuleOUTPinNames().removeChildren();
        this.pinList.clear();
        this.addStandardPins();
        this.nOfOut = ((AFONodeWidget)this.widget).getOutputs().getChildren().size();
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            AFOPin newPin;
            if (this.tableModel.getValueAt(i, 5) == null || (double)Float.parseFloat(this.tableModel.getValueAt(i, 5).toString()) == 0.0) {
                ++this.numberOfInputs;
                newPin = this.addIOPin(true, this.tableModel.getValueAt(i, 0).toString(), this.numberOfInputs);
            } else {
                ++this.nOfOut;
                newPin = this.addIOPin(false, this.tableModel.getValueAt(i, 0).toString(), this.nOfOut);
            }
            this.tableModel.setValueAt(newPin, i, 6);
        }
        this.codici = new ArrayList();
        this.codici.add("Monitor");
        this.codici.add("ON_Monitor");
        this.codici.add("Summer_Monitor");
        this.codici.add("AUTOMATICO_Monitor");
        this.codici.add("Setpoint_Monitor");
        int numin = 0;
        int numout = 0;
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            if (this.tableModel.getValueAt(i, 5) == null || this.tableModel.getValueAt(i, 5).toString().equals("0")) {
                ++numin;
                continue;
            }
            ++numout;
            this.codici.add((String)this.tableModel.getValueAt(i, 0));
        }
        this.setList(this.codici);
        System.out.println(this.codici);
        for (AFOPin pin : this.pinList) {
            pin.setParentNode(this);
        }
        this.scene.revalidate();
    }

    private void clearTableModel(DefaultTableModel model) {
        while (model.getRowCount() > 0) {
            model.removeRow(0);
        }
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        DefaultTableModel model = (DefaultTableModel)((MonitorDialog)this.propertiesDialog).table.getModel();
        retVal = retVal + "32 " + this.getCommonData();
        retVal = retVal + ((AFONodeWidget)this.widget).getModuleOUTPinNames().getChildren().size();
        retVal = retVal + " " + this.displayAddress + " " + this.displayPort;
        return retVal;
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        Element climaticElement;
        int i;
        SceneSerializer.setAttribute(document, nodeElement, "MonitorID", this.displayAddress);
        SceneSerializer.setAttribute(document, nodeElement, "MonitorPort", this.displayPort);
        SceneSerializer.setAttribute(document, nodeElement, "NofRows", "" + this.tableModel.getRowCount());
        for (i = 0; i < this.tableModel.getRowCount(); ++i) {
            climaticElement = document.createElement("TableRow");
            SceneSerializer.setAttribute(document, climaticElement, "Stringa", this.tableModel.getValueAt(i, 0).toString());
            SceneSerializer.setAttribute(document, climaticElement, "Scala", this.tableModel.getValueAt(i, 1).toString());
            SceneSerializer.setAttribute(document, climaticElement, "Indirizzo", this.tableModel.getValueAt(i, 2).toString());
            SceneSerializer.setAttribute(document, climaticElement, "Min", this.tableModel.getValueAt(i, 3).toString());
            SceneSerializer.setAttribute(document, climaticElement, "Max", this.tableModel.getValueAt(i, 4).toString());
            if (this.tableModel.getValueAt(i, 5) != null) {
                SceneSerializer.setAttribute(document, climaticElement, "Step", this.tableModel.getValueAt(i, 5).toString());
            } else {
                SceneSerializer.setAttribute(document, climaticElement, "Step", "0");
            }
            nodeElement.appendChild(climaticElement);
        }
        SceneSerializer.setAttribute(document, nodeElement, "SimNofRows", "" + this.simTableModel.getRowCount());
        for (i = 0; i < this.simTableModel.getRowCount(); ++i) {
            climaticElement = document.createElement("SimTableRow");
            for (simModelColumns lbl : simModelColumns.values()) {
                String val = " ";
                if (this.simTableModel.getValueAt(i, lbl.ordinal()) != null) {
                    val = this.simTableModel.getValueAt(i, lbl.ordinal()).toString();
                }
                SceneSerializer.setAttribute(document, climaticElement, lbl.toString(), val);
            }
            nodeElement.appendChild(climaticElement);
        }
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        int row = 0;
        this.clearTableModel(this.tableModel);
        this.displayAddress = SceneSerializer.getAttributeValue(node, "MonitorID");
        this.displayPort = SceneSerializer.getAttributeValue(node, "MonitorPort");
        if (this.displayPort == null) {
            this.displayPort = "2";
        }
        for (Node element : SceneSerializer.getChildNode(node)) {
            if (!element.getNodeName().equals("TableRow")) continue;
            String stringa = SceneSerializer.getAttributeValue(element, "Stringa");
            String scale = SceneSerializer.getAttributeValue(element, "Scala");
            String indirizzo = SceneSerializer.getAttributeValue(element, "Indirizzo");
            String min = SceneSerializer.getAttributeValue(element, "Min");
            String max = SceneSerializer.getAttributeValue(element, "Max");
            String step = SceneSerializer.getAttributeValue(element, "Step");
            this.tableModel.addRow((Object[])new Object[0][]);
            this.tableModel.setValueAt(stringa, row, 0);
            this.tableModel.setValueAt(scale, row, 1);
            this.tableModel.setValueAt(indirizzo, row, 2);
            this.tableModel.setValueAt(min, row, 3);
            this.tableModel.setValueAt(max, row, 4);
            this.tableModel.setValueAt(step, row, 5);
            ++row;
        }
        this.propertiesDialog.validate();
        this.createPins();
        this.checkSimTable();
        row = 0;
        for (Node element : SceneSerializer.getChildNode(node)) {
            if (!element.getNodeName().equals("SimTableRow")) continue;
            String nome = SceneSerializer.getAttributeValue(element, simModelColumns.Label.toString());
            String amplitude = SceneSerializer.getAttributeValue(element, simModelColumns.Amplitude.toString());
            String offset = SceneSerializer.getAttributeValue(element, simModelColumns.Offset.toString());
            String period = SceneSerializer.getAttributeValue(element, simModelColumns.Period.toString());
            String varType = SceneSerializer.getAttributeValue(element, simModelColumns.Type.toString());
            this.simTableModel.setValueAt(varType, row, simModelColumns.Type.ordinal());
            this.simTableModel.setValueAt(amplitude, row, simModelColumns.Amplitude.ordinal());
            this.simTableModel.setValueAt(offset, row, simModelColumns.Offset.ordinal());
            this.simTableModel.setValueAt(period, row, simModelColumns.Period.ordinal());
            ++row;
        }
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        this.parseStandardBlockCmd(cmd);
        return true;
    }

    private void addStandardPins() {
        int pinCount = 1;
        String pinLabel = "On";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Summer";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Auto";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Setpoint";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        this.numberOfInputs = 0;
        this.pinListStandardSize = this.pinList.toArray().length;
    }

    private AFOPin addIOPin(boolean isInput, String label, int number) {
        AFOPin newPin;
        String pinLabel = label;
        if (isInput) {
            String pinID = "pin" + ++this.scene.pinIDCounter;
            newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
            newPin.setAsBusPin(false);
            newPin.setParentNode(this);
            newPin.setPinIDString("IN" + number);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
        } else {
            String pinID = "pin" + ++this.scene.pinIDCounter;
            newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
            newPin.setAsBusPin(false);
            newPin.setParentNode(this);
            newPin.setPinIDString("OUT" + number);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
        }
        return newPin;
    }

    public String getVarConfiguration() {
        String retVal = "";
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            retVal = retVal + "<BL mobDSP ";
            retVal = retVal + this.addressList.get(0);
            retVal = retVal + " set " + (i + 1) + " ";
            String val = this.tableModel.getValueAt(i, 0).toString();
            val = val.replace(' ', '_');
            retVal = retVal + val + " ";
            int scale = Integer.parseInt(this.tableModel.getValueAt(i, 1).toString());
            double valFloat = 0.0;
            int valInt = 0;
            val = this.tableModel.getValueAt(i, 1).toString();
            retVal = retVal + val + " ";
            val = this.tableModel.getValueAt(i, 2).toString();
            retVal = retVal + val + " ";
            valInt = Integer.parseInt(this.tableModel.getValueAt(i, 3).toString());
            retVal = retVal + (valInt *= scale);
            retVal = retVal + " ";
            valInt = Integer.parseInt(this.tableModel.getValueAt(i, 4).toString());
            retVal = retVal + (valInt *= scale);
            retVal = retVal + " ";
            val = this.tableModel.getValueAt(i, 5).toString();
            retVal = retVal + val + " ";
            retVal = retVal + ">\r\n";
        }
        return retVal;
    }

    private void updatePins() {
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            AFOPin pin = this.getPinAt(i + 4);
            LabelWidget lblWdg = pin.getPinNameWidget();
            lblWdg.setLabel(this.tableModel.getValueAt(i, 0).toString());
        }
        this.scene.revalidate();
        int nOfOut = 0;
        this.codici = new ArrayList();
        this.codici.add(0, "Monitor");
        this.codici.add(1, "Monitor_1");
        this.codici.add(2, "ON_Monitor");
        this.codici.add(3, "Summer_Monitor");
        this.codici.add(4, "AUTOMATICO_Monitor");
        this.codici.add(5, "Setpoint_Monitor");
        int numin = 0;
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            if (this.tableModel.getValueAt(i, 3) == null || (double)Float.parseFloat(this.tableModel.getValueAt(i, 3).toString()) == 0.0) {
                ++numin;
                continue;
            }
            ++nOfOut;
            this.codici.add(2 + i, (String)this.tableModel.getValueAt(i, 0));
        }
        this.setList(this.codici);
        System.out.println(this.codici);
    }

    @Override
    public void initSimulation() {
        super.initSimulation();
        this.simInputTimer = new GenericNode.SimTimer();
    }

    private SimInputFrame.SIM_IN_TYPES getTypeFromString(String str) {
        for (SimInputFrame.SIM_IN_TYPES sim : SimInputFrame.SIM_IN_TYPES.values()) {
            if (!sim.toString().equals(str)) continue;
            return sim;
        }
        return SimInputFrame.SIM_IN_TYPES.Costant;
    }

    @Override
    public void simulate() {
        super.simulate();
        for (int i = 0; i < this.simTableModel.getRowCount(); ++i) {
            SimInputFrame.SIM_IN_TYPES rowType = this.getTypeFromString(this.simTableModel.getValueAt(i, simModelColumns.Type.ordinal()).toString());
            double amp = Double.parseDouble(this.simTableModel.getValueAt(i, simModelColumns.Amplitude.ordinal()).toString());
            double offset = Double.parseDouble(this.simTableModel.getValueAt(i, simModelColumns.Offset.ordinal()).toString());
            double period = Double.parseDouble(this.simTableModel.getValueAt(i, simModelColumns.Period.ordinal()).toString());
            double x = this.waveGenerator(rowType, period, amp, offset);
            if (i < this.NUM_DEFAULT_OUT_PINS) {
                GenericNode.SimData data = this.GetMData(i);
                data.data = x;
                data.isValid = true;
                this.updateSimOutputs();
                continue;
            }
            AFOPin output = (AFOPin)this.simTableModel.getValueAt(i, simModelColumns.PinID.ordinal());
            this.updateSingleOutput(output, new GenericNode.SimData(x, true));
        }
    }

    @Override
    public void showSimulationDialog() {
        this.simMultiInFrame.cleanTable();
        DefaultTableModel dialogTable = new DefaultTableModel(new Object[0][], new Object[]{"Label", "Type", "Amplitude", "Offset", "Period", "PinID"});
        this.simTableCopy(dialogTable, this.simTableModel);
        this.simMultiInFrame.table.setModel(dialogTable);
        this.simMultiInFrame.setupCombo();
        this.simMultiInFrame.hideColumn(simModelColumns.PinID.ordinal());
        this.simMultiInFrame.setVisible(true);
    }

    @Override
    protected void simDialogClosed() {
        DefaultTableModel dialogTable = (DefaultTableModel)this.simMultiInFrame.table.getModel();
        this.simTableCopy(this.simTableModel, dialogTable);
    }

    public static enum modelColumns {
        Label,
        Scale,
        Address,
        Min,
        Max,
        Step,
        PinID;

    }

    public static enum simModelColumns {
        Label,
        Type,
        Amplitude,
        Offset,
        Period,
        PinID;

    }
}

