/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import nodes.AFONodeWidget;
import nodes.BoardsTypesAndDescription;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.CostantNode;
import nodes.devices.DeviceNode;
import nodes.devices.GenericNode;
import nodes.gui.MonitorDialog_2;
import nodes.gui.SimInputFrame;
import nodes.gui.SimMultiInputFrame;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class MonitorNode_2
extends DeviceNode
implements ActionListener {
    private BoardsTypesAndDescription.BoardType boardType;
    private DefaultTableModel tableModel;
    private DefaultTableModel simTableModel;
    private final String type;
    private Boolean manageStates = true;
    private Boolean usePassword = true;
    Integer password = 0;
    int nOfOut = 4;
    private String[][] crono_labels = new String[][]{{"Crono1", "Chrono1"}, {"Crono2", "Chrono2"}, {"Crono3", "Chrono3"}, {"Crono4", "Chrono4"}};
    private String[][] levels = new String[][]{{"0", "100", "0.5", "5", "16", "20", "35", "30", "26"}, {"0", "100", "0.5", "5", "16", "20", "35", "30", "26"}, {"0", "100", "0.5", "5", "16", "20", "35", "30", "26"}, {"0", "100", "0.5", "5", "16", "20", "35", "30", "26"}};
    String[] labels = new String[]{"Min", "Max", "Step", "L1Winter", "L2Winter", "L3Winter", "L1Summer", "L2Summer", "L3Summer"};
    private Integer defaultLanguage = 0;
    public static final int MPID4_MAX_NUM_VAR = 50;
    public static final int MPID3_MAX_NUM_VAR = 50;
    public int NUM_DEFAULT_OUT_PINS = 0;
    private int pinListStandardSize;
    public static final int Monitor_2_ID = 36;
    SimMultiInputFrame simMultiInFrame = new SimMultiInputFrame();

    public MonitorNode_2(String id, String label, String UID, AFOGraphPinScene scene, BoardsTypesAndDescription.BoardType board) {
        super(id, label, "Monitor_2", scene);
        this.type = label;
        this.boardType = board;
        this.blockType = CommonDefinitions.blockTypes.Monitor_2;
        this.numberOfInputs = 3;
        this.tableModel = new DefaultTableModel(new Object[]{modelColumns.Label.toString(), modelColumns.Label_2.toString(), modelColumns.Min.toString(), modelColumns.Max.toString(), modelColumns.Step.toString(), modelColumns.Default.toString(), modelColumns.Tipo.toString(), modelColumns.PinID}, 0);
        this.simTableModel = new DefaultTableModel(new Object[]{simModelColumns.Label.toString(), simModelColumns.Type.toString(), simModelColumns.Amplitude.toString(), simModelColumns.Offset.toString(), simModelColumns.Period.toString(), simModelColumns.PinID}, 0);
        this.createWidget();
        this.createPropertiesDialog();
        this.addressSpace = 100;
        this.codici = new ArrayList();
        this.codici.add(0, "Display");
        this.codici.add(1, "Display");
        this.codici.add(2, "ON_Display");
        this.codici.add(3, "Summer_Display");
        this.codici.add(4, "AUTOMATICO_Display");
        this.codici.add(5, "Setpoint_Display");
        this.setList(this.codici);
        System.out.print("nOfOut: " + this.nOfOut + "as " + this.addressSpace + " ");
        this.clearTableModel(this.tableModel);
        this.clearTableModel(this.simTableModel);
        for (AFOPin pinExamined : this.getPinList()) {
            if (pinExamined.getPinType() != AFOPin.E_PinType.PIN_OUTPUT) continue;
            this.simTableModel.addRow(new Object[]{pinExamined.getLabel(), SimInputFrame.SIM_IN_TYPES.Costant.toString(), "1.0", "1.0", "1.0", null});
        }
        this.simMultiInFrame.btnExit.addActionListener(this);
    }

    public void control() {
        if (this.getAddress().equals("")) {
            ((MonitorDialog_2)this.propertiesDialog).indexLabel.setVisible(false);
        }
        if (this.controlAddress(this.getAddress(), true).booleanValue()) {
            ((MonitorDialog_2)this.propertiesDialog).indexLabel.setVisible(true);
        } else {
            ((MonitorDialog_2)this.propertiesDialog).indexLabel.setVisible(false);
        }
    }

    public String getAddress() {
        String newAddress = ((MonitorDialog_2)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void addStandardPins() {
        this.NUM_DEFAULT_OUT_PINS = 0;
        int pinCount = 1;
        String pinLabel = "On";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ++this.NUM_DEFAULT_OUT_PINS;
        pinLabel = "Summer";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ++this.NUM_DEFAULT_OUT_PINS;
        pinLabel = "Auto";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ++this.NUM_DEFAULT_OUT_PINS;
        pinLabel = "Ch SP";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ++this.NUM_DEFAULT_OUT_PINS;
        pinLabel = "Ch SP 2";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ++this.NUM_DEFAULT_OUT_PINS;
        pinLabel = "On Ch 2";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ++this.NUM_DEFAULT_OUT_PINS;
        pinLabel = "Ch SP 3";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ++this.NUM_DEFAULT_OUT_PINS;
        pinLabel = "On Ch 3";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ++this.NUM_DEFAULT_OUT_PINS;
        pinLabel = "Ch SP 4";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ++this.NUM_DEFAULT_OUT_PINS;
        pinLabel = "On Ch 4";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ++this.NUM_DEFAULT_OUT_PINS;
        pinCount = 1;
        pinLabel = "L1 Ch1";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "L2 Ch1";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "L3 Ch1";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "L1 Ch2";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "L2 Ch2";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "L3 Ch2";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "L1 Ch3";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "L2 Ch3";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "L3 Ch3";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "L1 Ch4";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "L2 Ch4";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "L3 Ch4";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "On";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Summer";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Auto";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Warning";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        this.numberOfInputs = pinCount - 1;
        this.pinListStandardSize = this.pinList.toArray().length;
    }

    private void createWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("Display");
        this.getScene().addNode(this);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
        this.addStandardPins();
        this.getScene().revalidate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(((MonitorDialog_2)this.propertiesDialog).btnOk)) {
            if (((MonitorDialog_2)this.propertiesDialog).indexLabel.isVisible()) {
                JOptionPane.showMessageDialog(null, "L'indirizzo inserito \u00e8 gi\u00e0 in uso!");
                return;
            }
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.propertiesDialog.setVisible(false);
        } else if (e.getSource().equals(((MonitorDialog_2)this.propertiesDialog).btnCancel)) {
            this.propertiesDialog.setVisible(false);
        } else if (e.getSource().equals(this.simMultiInFrame.btnExit)) {
            this.simDialogClosed();
        }
    }

    private void createPropertiesDialog() {
        this.propertiesDialog = new MonitorDialog_2(null, true, this.type, this);
        ((MonitorDialog_2)this.propertiesDialog).board = this.boardType;
    }

    public static void tableClear(DefaultTableModel table) {
        while (table.getRowCount() > 0) {
            table.removeRow(0);
        }
    }

    public void simTableCopy(DefaultTableModel destTable, DefaultTableModel srcTable) {
        MonitorNode_2.tableClear(destTable);
        for (int i = 0; i < srcTable.getRowCount(); ++i) {
            destTable.addRow(new Object[]{srcTable.getValueAt(i, 0), srcTable.getValueAt(i, 1), srcTable.getValueAt(i, 2), srcTable.getValueAt(i, 3), srcTable.getValueAt(i, 4), srcTable.getValueAt(i, 5)});
        }
    }

    public static void tableCopy(DefaultTableModel destTable, DefaultTableModel srcTable) {
        MonitorNode_2.tableClear(destTable);
        for (int i = 0; i < srcTable.getRowCount(); ++i) {
            destTable.addRow(new Object[]{srcTable.getValueAt(i, 0), srcTable.getValueAt(i, 1), srcTable.getValueAt(i, 2), srcTable.getValueAt(i, 3), srcTable.getValueAt(i, 4), srcTable.getValueAt(i, 5), srcTable.getValueAt(i, 6), srcTable.getValueAt(i, 7)});
        }
    }

    @Override
    public void setConnectionStatus(boolean isConnected) {
        MonitorDialog_2 dlg = (MonitorDialog_2)this.propertiesDialog;
        dlg.btnGiu.setEnabled(!isConnected);
        dlg.btnSu.setEnabled(!isConnected);
        dlg.btnInsert.setEnabled(!isConnected);
        dlg.table.setEnabled(!isConnected);
    }

    void getNewPasswordFromDialog() {
        this.usePassword = ((MonitorDialog_2)this.propertiesDialog).chkUsePassword.isSelected();
        if (this.usePassword.booleanValue()) {
            Integer pass1 = 0;
            Integer pass2 = 0;
            Integer pass3 = 0;
            Integer pass4 = 0;
            Integer pass5 = 0;
            Integer pass6 = 0;
            pass1 = ((MonitorDialog_2)this.propertiesDialog).comboPwd1.getSelectedIndex();
            pass2 = ((MonitorDialog_2)this.propertiesDialog).comboPwd2.getSelectedIndex();
            pass3 = ((MonitorDialog_2)this.propertiesDialog).comboPwd3.getSelectedIndex();
            pass4 = ((MonitorDialog_2)this.propertiesDialog).comboPwd4.getSelectedIndex();
            pass5 = ((MonitorDialog_2)this.propertiesDialog).comboPwd5.getSelectedIndex();
            pass6 = ((MonitorDialog_2)this.propertiesDialog).comboPwd6.getSelectedIndex();
            this.password = 0;
            this.password = pass1 | pass2 << 2 | pass3 << 4 | pass4 << 6 | pass5 << 8 | pass6 << 10;
        }
    }

    void getCronoLabelsFromDialog() {
        for (int i = 0; i < 4; ++i) {
            this.crono_labels[i][0] = ((MonitorDialog_2)this.propertiesDialog).pnlChronoArray[i].txtLang1.getText();
            this.crono_labels[i][1] = ((MonitorDialog_2)this.propertiesDialog).pnlChronoArray[i].txtLang2.getText();
        }
    }

    void getCronoLevelsFromDialog() {
        for (int i = 0; i < 4; ++i) {
            this.levels[i][0] = ((MonitorDialog_2)this.propertiesDialog).pnlChronoArray[i].txtMin.getText();
            this.levels[i][1] = ((MonitorDialog_2)this.propertiesDialog).pnlChronoArray[i].txtMax.getText();
            this.levels[i][2] = ((MonitorDialog_2)this.propertiesDialog).pnlChronoArray[i].txtStep.getText();
            this.levels[i][3] = ((MonitorDialog_2)this.propertiesDialog).pnlChronoArray[i].txtL1Winter.getText();
            this.levels[i][4] = ((MonitorDialog_2)this.propertiesDialog).pnlChronoArray[i].txtL2Winter.getText();
            this.levels[i][5] = ((MonitorDialog_2)this.propertiesDialog).pnlChronoArray[i].txtL3Winter.getText();
            this.levels[i][6] = ((MonitorDialog_2)this.propertiesDialog).pnlChronoArray[i].txtL1Summer.getText();
            this.levels[i][7] = ((MonitorDialog_2)this.propertiesDialog).pnlChronoArray[i].txtL2Summer.getText();
            this.levels[i][8] = ((MonitorDialog_2)this.propertiesDialog).pnlChronoArray[i].txtL3Summer.getText();
        }
    }

    void setComboPassword() {
        ((MonitorDialog_2)this.propertiesDialog).chkUsePassword.setSelected(this.usePassword);
        Integer pass1 = 0;
        Integer pass2 = 0;
        Integer pass3 = 0;
        Integer pass4 = 0;
        Integer pass5 = 0;
        Integer pass6 = 0;
        pass1 = (this.password & 3) >> 0;
        pass2 = (this.password & 0xC) >> 2;
        pass3 = (this.password & 0x30) >> 4;
        pass4 = (this.password & 0xC0) >> 6;
        pass5 = (this.password & 0x300) >> 8;
        pass6 = (this.password & 0xC00) >> 10;
        ((MonitorDialog_2)this.propertiesDialog).comboPwd1.setSelectedIndex(pass1);
        ((MonitorDialog_2)this.propertiesDialog).comboPwd2.setSelectedIndex(pass2);
        ((MonitorDialog_2)this.propertiesDialog).comboPwd3.setSelectedIndex(pass3);
        ((MonitorDialog_2)this.propertiesDialog).comboPwd4.setSelectedIndex(pass4);
        ((MonitorDialog_2)this.propertiesDialog).comboPwd5.setSelectedIndex(pass5);
        ((MonitorDialog_2)this.propertiesDialog).comboPwd6.setSelectedIndex(pass6);
    }

    void updateNumberOfIO(AFOPin pin) {
        if (pin.getPinType().equals((Object)AFOPin.E_PinType.PIN_INPUT)) {
            --this.numberOfInputs;
        } else {
            --this.nOfOut;
        }
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        int i;
        ((MonitorDialog_2)this.propertiesDialog).disableListeners();
        ((MonitorDialog_2)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        DefaultTableModel dialogTable = new DefaultTableModel(new Object[0][], new Object[]{"Label", "Label 2", "Min", "Max", "Step", "Default", "Tipo", "PinID"});
        MonitorNode_2.tableCopy(dialogTable, this.tableModel);
        ((MonitorDialog_2)this.propertiesDialog).table.setModel(dialogTable);
        for (i = 0; i < ((MonitorDialog_2)this.propertiesDialog).table.getRowCount(); ++i) {
            JComboBox<String> typeCombo = new JComboBox<String>();
            typeCombo.addItem("Normal");
            typeCombo.addItem("Config");
            typeCombo.addItem("Reserved");
            typeCombo.addItem("NormDiff");
            typeCombo.addItem("ConfigDiff");
            typeCombo.addItem("ResDiff");
            TableColumn col = ((MonitorDialog_2)this.propertiesDialog).table.getColumnModel().getColumn(modelColumns.Tipo.ordinal());
            col.setCellEditor(new DefaultCellEditor(typeCombo));
        }
        ((MonitorDialog_2)this.propertiesDialog).chkUseStates.setEnabled(!this.kernelConnected);
        ((MonitorDialog_2)this.propertiesDialog).chkUseStates.setSelected(this.manageStates);
        ((MonitorDialog_2)this.propertiesDialog).chkUsePassword.setSelected(this.usePassword);
        this.setComboPassword();
        ((MonitorDialog_2)this.propertiesDialog).table.setEnabled(!this.kernelConnected);
        ((MonitorDialog_2)this.propertiesDialog).btnOk.setEnabled(!this.kernelConnected);
        ((MonitorDialog_2)this.propertiesDialog).indexLabel.setVisible(false);
        for (i = 0; i < 4; ++i) {
            ((MonitorDialog_2)this.propertiesDialog).pnlChronoArray[i].txtLang1.setText(this.crono_labels[i][0]);
            ((MonitorDialog_2)this.propertiesDialog).pnlChronoArray[i].txtLang1.setEnabled(!this.kernelConnected);
            ((MonitorDialog_2)this.propertiesDialog).pnlChronoArray[i].txtLang2.setText(this.crono_labels[i][1]);
            ((MonitorDialog_2)this.propertiesDialog).pnlChronoArray[i].txtLang2.setEnabled(!this.kernelConnected);
        }
        for (i = 0; i < 4; ++i) {
            ((MonitorDialog_2)this.propertiesDialog).pnlChronoArray[i].txtMin.setText(this.levels[i][0]);
            ((MonitorDialog_2)this.propertiesDialog).pnlChronoArray[i].txtMax.setText(this.levels[i][1]);
            ((MonitorDialog_2)this.propertiesDialog).pnlChronoArray[i].txtStep.setText(this.levels[i][2]);
            ((MonitorDialog_2)this.propertiesDialog).pnlChronoArray[i].txtL1Winter.setText(this.levels[i][3]);
            ((MonitorDialog_2)this.propertiesDialog).pnlChronoArray[i].txtL2Winter.setText(this.levels[i][4]);
            ((MonitorDialog_2)this.propertiesDialog).pnlChronoArray[i].txtL3Winter.setText(this.levels[i][5]);
            ((MonitorDialog_2)this.propertiesDialog).pnlChronoArray[i].txtL1Summer.setText(this.levels[i][6]);
            ((MonitorDialog_2)this.propertiesDialog).pnlChronoArray[i].txtL2Summer.setText(this.levels[i][7]);
            ((MonitorDialog_2)this.propertiesDialog).pnlChronoArray[i].txtL3Summer.setText(this.levels[i][8]);
        }
        ((MonitorDialog_2)this.propertiesDialog).comboLanguage.setSelectedIndex(this.defaultLanguage);
        ((MonitorDialog_2)this.propertiesDialog).showDialog();
        if (((MonitorDialog_2)this.propertiesDialog).getReturnStatus() == 1) {
            int i2;
            if (!((MonitorDialog_2)this.propertiesDialog).getDataChanged()) {
                return;
            }
            this.scene.sceneChanged();
            this.manageStates = ((MonitorDialog_2)this.propertiesDialog).chkUseStates.isSelected();
            this.getNewPasswordFromDialog();
            this.getCronoLabelsFromDialog();
            this.getCronoLevelsFromDialog();
            dialogTable = (DefaultTableModel)((MonitorDialog_2)this.propertiesDialog).table.getModel();
            this.defaultLanguage = ((MonitorDialog_2)this.propertiesDialog).comboLanguage.getSelectedIndex();
            this.sort(dialogTable);
            int rowCount = this.tableModel.getRowCount();
            for (i2 = 0; i2 < rowCount; ++i2) {
                if (this.findRowIndexFromPin(dialogTable, (AFOPin)this.tableModel.getValueAt(i2, modelColumns.PinID.ordinal())) >= 0) continue;
                AFOPin pin = (AFOPin)this.tableModel.getValueAt(i2, modelColumns.PinID.ordinal());
                ((AFONodeWidget)this.widget).removePin(pin);
                this.updateNumberOfIO(pin);
                this.tableModel.removeRow(i2);
                this.pinList.remove(pin);
                this.scene.validate();
                --rowCount;
                --i2;
            }
            for (i2 = 0; i2 < dialogTable.getRowCount(); ++i2) {
                AFOPin newPin;
                int rowIndex = this.findRowIndexFromPin(this.tableModel, (AFOPin)dialogTable.getValueAt(i2, modelColumns.PinID.ordinal()));
                if (rowIndex == -1) {
                    if (i2 >= this.tableModel.getRowCount()) {
                        this.tableModel.addRow(dialogTable.getDataVector().get(i2));
                    } else {
                        this.tableModel.insertRow(i2, dialogTable.getDataVector().get(i2));
                    }
                    this.addPinFromDialogRow(dialogTable, i2);
                    continue;
                }
                if (Double.parseDouble(this.tableModel.getValueAt(rowIndex, modelColumns.Step.ordinal()).toString()) == 0.0 && Double.parseDouble(dialogTable.getValueAt(i2, modelColumns.Step.ordinal()).toString()) != 0.0 || Double.parseDouble(this.tableModel.getValueAt(rowIndex, modelColumns.Step.ordinal()).toString()) != 0.0 && Double.parseDouble(dialogTable.getValueAt(i2, modelColumns.Step.ordinal()).toString()) == 0.0) {
                    this.tableModel.removeRow(rowIndex);
                    this.tableModel.insertRow(i2, dialogTable.getDataVector().get(i2));
                    AFOPin pin = (AFOPin)this.tableModel.getValueAt(i2, modelColumns.PinID.ordinal());
                    ((AFONodeWidget)this.widget).removePin(pin);
                    this.updateNumberOfIO(pin);
                    int pinIndex = this.pinList.indexOf(pin);
                    this.pinList.remove(pinIndex);
                    this.scene.validate();
                    newPin = this.addPinFromDialogRow(dialogTable, i2);
                    this.pinList.remove(newPin);
                    this.pinList.add(i2 + this.pinListStandardSize, newPin);
                    this.scene.validate();
                    this.tableModel.setValueAt(newPin, i2, modelColumns.PinID.ordinal());
                    continue;
                }
                this.tableModel.removeRow(rowIndex);
                this.tableModel.insertRow(i2, dialogTable.getDataVector().get(i2));
                newPin = (AFOPin)dialogTable.getValueAt(i2, modelColumns.PinID.ordinal());
                newPin.setLabel((String)this.tableModel.getValueAt(i2, 0));
                this.pinList.remove(rowIndex + this.pinListStandardSize);
                this.pinList.add(i2 + this.pinListStandardSize, newPin);
                newPin.getPinNameWidget().setLabel(newPin.getLabel());
            }
            this.sort(this.tableModel);
            this.checkSimTable();
        }
    }

    private void checkSimTable() {
        int rowCount = this.simTableModel.getRowCount();
        for (int i = this.NUM_DEFAULT_OUT_PINS; i < rowCount; ++i) {
            if (this.findRowIndexFromPin(this.tableModel, (AFOPin)this.simTableModel.getValueAt(i, simModelColumns.PinID.ordinal())) >= 0) continue;
            this.simTableModel.removeRow(i);
            --rowCount;
            --i;
        }
        int count = 0;
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            if (Double.parseDouble(this.tableModel.getValueAt(i, modelColumns.Step.ordinal()).toString()) == 0.0) continue;
            int rowIndex = this.findSimRowIndexFromPin(this.simTableModel, (AFOPin)this.tableModel.getValueAt(i, modelColumns.PinID.ordinal()));
            if (rowIndex == -1) {
                String label = this.tableModel.getDataVector().elementAt(i).elementAt(0).toString();
                if (count + this.NUM_DEFAULT_OUT_PINS >= this.simTableModel.getRowCount()) {
                    this.simTableModel.addRow(new Object[]{label, "Costant", "0.0", "1.0", "1.0", this.tableModel.getDataVector().elementAt(i).elementAt(modelColumns.PinID.ordinal())});
                } else {
                    this.simTableModel.insertRow(count + this.NUM_DEFAULT_OUT_PINS, new Object[]{label, "Costant", "0.0", "1.0", "1.0", this.tableModel.getDataVector().elementAt(i).elementAt(modelColumns.PinID.ordinal())});
                }
            } else if (Double.parseDouble(this.tableModel.getValueAt(i, modelColumns.Step.ordinal()).toString()) == 0.0) {
                this.simTableModel.removeRow(rowIndex);
            } else {
                Vector row = this.simTableModel.getDataVector().elementAt(rowIndex);
                this.simTableModel.removeRow(rowIndex);
                if (count + this.NUM_DEFAULT_OUT_PINS >= this.simTableModel.getRowCount()) {
                    this.simTableModel.addRow(row);
                } else {
                    this.simTableModel.insertRow(count + this.NUM_DEFAULT_OUT_PINS, row);
                }
            }
            ++count;
        }
    }

    private int findRowIndexFromPin(DefaultTableModel table, AFOPin pin) {
        int retVal = -1;
        try {
            for (int i = 0; i < table.getRowCount(); ++i) {
                AFOPin tablePin = (AFOPin)table.getValueAt(i, modelColumns.PinID.ordinal());
                if (tablePin == null || pin == null || !tablePin.equals(pin)) continue;
                retVal = i;
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return retVal;
    }

    private int findSimRowIndexFromPin(DefaultTableModel table, AFOPin pin) {
        int retVal = -1;
        try {
            for (int i = this.NUM_DEFAULT_OUT_PINS; i < table.getRowCount(); ++i) {
                AFOPin myPin = (AFOPin)table.getValueAt(i, simModelColumns.PinID.ordinal());
                if (!myPin.equals(pin)) continue;
                retVal = i;
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return retVal;
    }

    private AFOPin addPinFromDialogRow(DefaultTableModel dialogModel, int row) {
        AFOPin newPin;
        if (this.tableModel.getValueAt(row, modelColumns.Step.ordinal()) == null || (double)Float.parseFloat(this.tableModel.getValueAt(row, modelColumns.Step.ordinal()).toString()) == 0.0) {
            ++this.numberOfInputs;
            newPin = this.addIOPin(true, this.tableModel.getValueAt(row, 0).toString(), this.numberOfInputs);
            this.pinList.remove(this.pinList.size() - 1);
            this.pinList.add(row + this.pinListStandardSize, newPin);
        } else {
            ++this.nOfOut;
            newPin = this.addIOPin(false, this.tableModel.getValueAt(row, 0).toString(), this.nOfOut);
        }
        this.tableModel.setValueAt(newPin, row, modelColumns.PinID.ordinal());
        return newPin;
    }

    private void createPins() {
        for (AFOPin pin : this.pinList) {
            this.scene.removePinWithEdges(pin);
        }
        ((AFONodeWidget)this.widget).clearPins();
        ((AFONodeWidget)this.widget).getModuleINPinNames().removeChildren();
        ((AFONodeWidget)this.widget).getModuleOUTPinNames().removeChildren();
        this.pinList.clear();
        this.addStandardPins();
        this.nOfOut = ((AFONodeWidget)this.widget).getOutputs().getChildren().size();
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            AFOPin newPin;
            if (this.tableModel.getValueAt(i, modelColumns.Step.ordinal()) == null || (double)Float.parseFloat(this.tableModel.getValueAt(i, modelColumns.Step.ordinal()).toString()) == 0.0) {
                ++this.numberOfInputs;
                newPin = this.addIOPin(true, this.tableModel.getValueAt(i, 0).toString(), this.numberOfInputs);
            } else {
                ++this.nOfOut;
                newPin = this.addIOPin(false, this.tableModel.getValueAt(i, 0).toString(), this.nOfOut);
            }
            this.tableModel.setValueAt(newPin, i, modelColumns.PinID.ordinal());
        }
        this.codici = new ArrayList();
        this.codici.add("Monitor");
        this.codici.add("Monitor_1");
        this.codici.add("ON_Monitor");
        this.codici.add("Summer_Monitor");
        this.codici.add("AUTOMATICO_Monitor");
        this.codici.add("Setpoint_Monitor");
        int numin = 0;
        int numout = 0;
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            if (this.tableModel.getValueAt(i, modelColumns.Step.ordinal()) == null || (double)Float.parseFloat(this.tableModel.getValueAt(i, modelColumns.Step.ordinal()).toString()) == 0.0) {
                ++numin;
                continue;
            }
            ++numout;
            this.codici.add((String)this.tableModel.getValueAt(i, 0));
        }
        this.setList(this.codici);
        System.out.println(this.codici);
        for (AFOPin pin : this.pinList) {
            pin.setParentNode(this);
        }
        this.scene.revalidate();
    }

    private void clearTableModel(DefaultTableModel model) {
        while (model.getRowCount() > 0) {
            model.removeRow(0);
        }
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        DefaultTableModel model = (DefaultTableModel)((MonitorDialog_2)this.propertiesDialog).table.getModel();
        retVal = retVal + "36 " + this.getCommonData();
        retVal = retVal + ((AFONodeWidget)this.widget).getModuleOUTPinNames().getChildren().size();
        retVal = this.manageStates != false ? retVal + " 1.0" : retVal + " 0.0";
        retVal = this.usePassword != false ? retVal + " 1.0" : retVal + " 0.0";
        return retVal;
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        String val;
        Element climaticElement;
        int i;
        SceneSerializer.setAttribute(document, nodeElement, "States", this.manageStates.toString());
        SceneSerializer.setAttribute(document, nodeElement, "UsePassword", this.usePassword.toString());
        SceneSerializer.setAttribute(document, nodeElement, "Password", this.password.toString());
        SceneSerializer.setAttribute(document, nodeElement, "DefaultLanguage", this.defaultLanguage.toString());
        for (i = 0; i < 4; ++i) {
            Element cronoElement = document.createElement("Crono_" + (i + 1));
            SceneSerializer.setAttribute(document, cronoElement, "CronoLabel_1", this.crono_labels[i][0]);
            SceneSerializer.setAttribute(document, cronoElement, "CronoLabel_2", this.crono_labels[i][1]);
            for (int j = 0; j < this.labels.length; ++j) {
                SceneSerializer.setAttribute(document, cronoElement, this.labels[j], this.levels[i][j]);
            }
            nodeElement.appendChild(cronoElement);
        }
        SceneSerializer.setAttribute(document, nodeElement, "NofRows", "" + this.tableModel.getRowCount());
        for (i = 0; i < this.tableModel.getRowCount(); ++i) {
            climaticElement = document.createElement("TableRow");
            for (modelColumns modelColumns2 : modelColumns.values()) {
                val = " ";
                if (this.tableModel.getValueAt(i, modelColumns2.ordinal()) != null) {
                    val = this.tableModel.getValueAt(i, modelColumns2.ordinal()).toString();
                }
                SceneSerializer.setAttribute(document, climaticElement, modelColumns2.toString(), val);
            }
            nodeElement.appendChild(climaticElement);
        }
        SceneSerializer.setAttribute(document, nodeElement, "SimNofRows", "" + this.simTableModel.getRowCount());
        for (i = 0; i < this.simTableModel.getRowCount(); ++i) {
            climaticElement = document.createElement("SimTableRow");
            for (simModelColumns simModelColumns2 : simModelColumns.values()) {
                val = " ";
                if (this.simTableModel.getValueAt(i, simModelColumns2.ordinal()) != null) {
                    val = this.simTableModel.getValueAt(i, simModelColumns2.ordinal()).toString();
                }
                SceneSerializer.setAttribute(document, climaticElement, simModelColumns2.toString(), val);
            }
            nodeElement.appendChild(climaticElement);
        }
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        int row = 0;
        this.clearTableModel(this.tableModel);
        this.manageStates = Boolean.parseBoolean(SceneSerializer.getAttributeValue(node, "States"));
        String passwordStr = SceneSerializer.getAttributeValue(node, "UsePassword");
        if (passwordStr != null) {
            this.usePassword = Boolean.parseBoolean(passwordStr);
        }
        if ((passwordStr = SceneSerializer.getAttributeValue(node, "Password")) != null) {
            try {
                this.password = Integer.parseInt(passwordStr);
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
        }
        String defLanguage = SceneSerializer.getAttributeValue(node, "DefaultLanguage");
        try {
            this.defaultLanguage = Integer.parseInt(defLanguage);
        }
        catch (NumberFormatException ex) {
            Logger.getLogger(CostantNode.class.getName()).log(Level.SEVERE, null, ex);
            this.defaultLanguage = 0;
        }
        for (Node element : SceneSerializer.getChildNode(node)) {
            if (element.getNodeName().equals("TableRow")) {
                String varType;
                String nome2;
                String nome = SceneSerializer.getAttributeValue(element, "Nome");
                if (nome == null) {
                    nome = SceneSerializer.getAttributeValue(element, modelColumns.Label.toString());
                    nome2 = SceneSerializer.getAttributeValue(element, modelColumns.Label_2.toString());
                } else {
                    nome2 = " ";
                }
                String min = SceneSerializer.getAttributeValue(element, "Min");
                String max = SceneSerializer.getAttributeValue(element, "Max");
                String step = SceneSerializer.getAttributeValue(element, "Step");
                String defVal = SceneSerializer.getAttributeValue(element, "Default");
                if (defVal == null) {
                    defVal = min;
                }
                if ((varType = SceneSerializer.getAttributeValue(element, modelColumns.Tipo.toString())) == null) {
                    varType = "Normal";
                }
                this.tableModel.addRow(new Object[]{nome, nome2, min, max, step, defVal, varType});
                ++row;
                continue;
            }
            if (!element.getNodeName().contains("Crono_")) continue;
            int cronoIndex = Integer.parseInt(element.getNodeName().substring(6)) - 1;
            String str = SceneSerializer.getAttributeValue(element, "CronoLabel_1");
            if (str != null) {
                this.crono_labels[cronoIndex][0] = str;
            }
            if ((str = SceneSerializer.getAttributeValue(element, "CronoLabel_2")) != null) {
                this.crono_labels[cronoIndex][1] = str;
            }
            for (int i = 0; i < this.labels.length; ++i) {
                this.levels[cronoIndex][i] = SceneSerializer.getAttributeValue(element, this.labels[i]);
            }
            if (this.levels[cronoIndex][0] == null) {
                this.levels[cronoIndex][0] = "0";
            }
            if (this.levels[cronoIndex][1] == null) {
                this.levels[cronoIndex][1] = "100";
            }
            if (this.levels[cronoIndex][2] == null) {
                this.levels[cronoIndex][2] = "0.5";
            }
            if (this.levels[cronoIndex][3] == null) {
                this.levels[cronoIndex][3] = "5";
            }
            if (this.levels[cronoIndex][4] == null) {
                this.levels[cronoIndex][4] = "16";
            }
            if (this.levels[cronoIndex][5] == null) {
                this.levels[cronoIndex][5] = "20";
            }
            if (this.levels[cronoIndex][6] == null) {
                this.levels[cronoIndex][6] = "35";
            }
            if (this.levels[cronoIndex][7] == null) {
                this.levels[cronoIndex][7] = "30";
            }
            if (this.levels[cronoIndex][8] != null) continue;
            this.levels[cronoIndex][8] = "26";
        }
        this.propertiesDialog.validate();
        this.createPins();
        this.checkSimTable();
        row = 0;
        for (Node element : SceneSerializer.getChildNode(node)) {
            if (!element.getNodeName().equals("SimTableRow")) continue;
            String nome = SceneSerializer.getAttributeValue(element, simModelColumns.Label.toString());
            String amplitude = SceneSerializer.getAttributeValue(element, simModelColumns.Amplitude.toString());
            String offset = SceneSerializer.getAttributeValue(element, simModelColumns.Offset.toString());
            String period = SceneSerializer.getAttributeValue(element, simModelColumns.Period.toString());
            String varType = SceneSerializer.getAttributeValue(element, simModelColumns.Type.toString());
            this.simTableModel.setValueAt(varType, row, simModelColumns.Type.ordinal());
            this.simTableModel.setValueAt(amplitude, row, simModelColumns.Amplitude.ordinal());
            this.simTableModel.setValueAt(offset, row, simModelColumns.Offset.ordinal());
            this.simTableModel.setValueAt(period, row, simModelColumns.Period.ordinal());
            ++row;
        }
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
        } else {
            String value = "";
            int msgAddress = Integer.parseInt(cmd.getValue("ADDRESS")) - (Integer)this.addressList.get(0) - 1;
            value = cmd.getValue("TOKEN3");
            if (msgAddress < this.getNofOutputPins()) {
                String output = "OUT" + (msgAddress + 1);
                this.setPinValue(output, value);
                try {
                    this.setTargetPinValue(output, value);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                this.sendValueToChart(output, value);
                try {
                    AFOPin pin = this.getPinByID(output);
                    if (pin != null) {
                        this.updateDB(Float.parseFloat(value), 3, output);
                    }
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return true;
    }

    private void reassignPinID() {
        int inNumber = 1;
        int outNumber = 1;
        for (AFOPin pin : this.pinList) {
            if (pin.getPinType().equals((Object)AFOPin.E_PinType.PIN_INPUT)) {
                pin.setPinIDString("IN" + inNumber++);
                continue;
            }
            pin.setPinIDString("OUT" + outNumber++);
        }
    }

    private AFOPin addIOPin(boolean isInput, String label, int pinIDNumber) {
        AFOPin newPin;
        String pinLabel = label;
        if (isInput) {
            String pinID = "pin" + ++this.scene.pinIDCounter;
            newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
            newPin.setAsBusPin(false);
            newPin.setParentNode(this);
            newPin.setPinIDString("IN" + pinIDNumber);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
        } else {
            String pinID = "pin" + ++this.scene.pinIDCounter;
            newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
            newPin.setAsBusPin(false);
            newPin.setParentNode(this);
            newPin.setPinIDString("OUT" + pinIDNumber);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
        }
        this.reassignPinID();
        return newPin;
    }

    protected void sort(DefaultTableModel model) {
        for (int i = 1; i < model.getRowCount(); ++i) {
            for (int j = i; j > 0 && this.compare(model, j - 1, j) > 0; --j) {
                model.moveRow(j, j, j - 1);
            }
        }
    }

    protected int compare(DefaultTableModel model, int i, int j) {
        String s1 = model.getValueAt(i, modelColumns.Tipo.ordinal()).toString();
        if (s1.equals("Normal")) {
            s1 = "1";
        } else if (s1.equals("Config")) {
            s1 = "2";
        } else if (s1.equals("Reserved")) {
            s1 = "3";
        } else if (s1.equals("NormDiff")) {
            s1 = "1";
        } else if (s1.equals("ConfigDiff")) {
            s1 = "2";
        } else if (s1.equals("ResDiff")) {
            s1 = "3";
        }
        String s2 = model.getValueAt(j, modelColumns.Tipo.ordinal()).toString();
        if (s2.equals("Normal")) {
            s2 = "1";
        } else if (s2.equals("Config")) {
            s2 = "2";
        } else if (s2.equals("Reserved")) {
            s2 = "3";
        } else if (s2.equals("NormDiff")) {
            s2 = "1";
        } else if (s2.equals("ConfigDiff")) {
            s2 = "2";
        } else if (s2.equals("ResDiff")) {
            s2 = "3";
        }
        return s1.compareTo(s2);
    }

    public String getVarConfiguration() {
        String retVal = "";
        Integer nOfinChannel = 16;
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            Integer num;
            retVal = retVal + "<BL set ";
            retVal = retVal + this.addressList.get(0) + " ";
            String val = this.tableModel.getValueAt(i, modelColumns.Label.ordinal()).toString();
            val = val.replace(' ', '_');
            retVal = retVal + val + " ";
            for (int j = modelColumns.Min.ordinal(); j < modelColumns.Default.ordinal() + 1; ++j) {
                val = this.tableModel.getValueAt(i, j).toString();
                num = (int)(Double.parseDouble(val) * 10.0);
                retVal = retVal + num.toString() + " ";
            }
            String varType = this.tableModel.getValueAt(i, modelColumns.Tipo.ordinal()).toString();
            if (varType.equals("Normal")) {
                retVal = retVal + "0 ";
            } else if (varType.equals("Config")) {
                retVal = retVal + "1 ";
            } else if (varType.equals("Reserved")) {
                retVal = retVal + "2 ";
            } else if (varType.equals("NormDiff")) {
                retVal = retVal + "4 ";
            } else if (varType.equals("ConfigDiff")) {
                retVal = retVal + "5 ";
            } else if (varType.equals("ResDiff")) {
                retVal = retVal + "6 ";
            }
            if (Double.parseDouble(this.tableModel.getValueAt(i, modelColumns.Step.ordinal()).toString()) == 0.0) {
                num = nOfinChannel;
                Integer n = nOfinChannel = Integer.valueOf(nOfinChannel + 1);
                retVal = retVal + nOfinChannel.toString() + " ";
            } else {
                retVal = retVal + "-1 ";
            }
            val = this.tableModel.getValueAt(i, modelColumns.Label_2.ordinal()).toString();
            val = val.replace(' ', '_');
            retVal = retVal + " " + val + " ";
            retVal = retVal + ">\r\n";
        }
        if (this.usePassword.booleanValue()) {
            retVal = retVal + "<BL set ";
            retVal = this.boardType.equals((Object)BoardsTypesAndDescription.BoardType.mPID4DSP) ? retVal + ((Integer)this.addressList.get(0) + 50 + 1) + " " : retVal + ((Integer)this.addressList.get(0) + 50 + 1) + " ";
            retVal = retVal + this.password;
            retVal = retVal + ">\r\n";
        }
        double fw = 10.0;
        if (this.kernel != null) {
            fw = this.kernel.getFirmwareVersionDouble();
        }
        if (fw >= 26.0 || this.kernel == null) {
            String val;
            int i;
            int baseAddr = this.boardType.equals((Object)BoardsTypesAndDescription.BoardType.mPID4DSP) ? (Integer)this.addressList.get(0) + 50 + 1 : (Integer)this.addressList.get(0) + 50 + 1;
            for (i = 0; i < 4; ++i) {
                retVal = retVal + "<BL set ";
                retVal = retVal + ++baseAddr + " ";
                val = this.crono_labels[i][0];
                val = val.replace(' ', '_');
                retVal = retVal + val;
                retVal = retVal + ">\r\n";
            }
            for (i = 0; i < 4; ++i) {
                retVal = retVal + "<BL set ";
                retVal = retVal + ++baseAddr + " ";
                val = this.crono_labels[i][1];
                val = val.replace(' ', '_');
                retVal = retVal + val;
                retVal = retVal + ">\r\n";
            }
            retVal = retVal + "<BL set ";
            retVal = this.boardType.equals((Object)BoardsTypesAndDescription.BoardType.mPID4DSP) ? retVal + ((Integer)this.addressList.get(0) + 60) + " " : retVal + ((Integer)this.addressList.get(0) + 60) + " ";
            retVal = retVal + this.defaultLanguage + " ";
            retVal = retVal + ">\r\n";
            if (fw >= 30.3 || this.kernel == null) {
                baseAddr = this.boardType.equals((Object)BoardsTypesAndDescription.BoardType.mPID4DSP) ? (Integer)this.addressList.get(0) + 61 : (Integer)this.addressList.get(0) + 61;
                for (i = 0; i < 4; ++i) {
                    retVal = retVal + "<BL set " + baseAddr++ + " ";
                    for (int j = 0; j < this.levels[0].length; ++j) {
                        retVal = retVal + this.levels[i][j] + " ";
                    }
                    retVal = retVal + ">\r\n";
                }
            }
        }
        return retVal;
    }

    @Override
    public void initSimulation() {
        super.initSimulation();
        this.simInputTimer = new GenericNode.SimTimer();
    }

    private SimInputFrame.SIM_IN_TYPES getTypeFromString(String str) {
        for (SimInputFrame.SIM_IN_TYPES sim : SimInputFrame.SIM_IN_TYPES.values()) {
            if (!sim.toString().equals(str)) continue;
            return sim;
        }
        return SimInputFrame.SIM_IN_TYPES.Costant;
    }

    @Override
    public void simulate() {
        super.simulate();
        for (int i = 0; i < this.simTableModel.getRowCount(); ++i) {
            SimInputFrame.SIM_IN_TYPES rowType = this.getTypeFromString(this.simTableModel.getValueAt(i, simModelColumns.Type.ordinal()).toString());
            double amp = Double.parseDouble(this.simTableModel.getValueAt(i, simModelColumns.Amplitude.ordinal()).toString());
            double offset = Double.parseDouble(this.simTableModel.getValueAt(i, simModelColumns.Offset.ordinal()).toString());
            double period = Double.parseDouble(this.simTableModel.getValueAt(i, simModelColumns.Period.ordinal()).toString());
            double x = this.waveGenerator(rowType, period, amp, offset);
            if (i < this.NUM_DEFAULT_OUT_PINS) {
                GenericNode.SimData data = this.GetMData(i);
                data.data = x;
                data.isValid = true;
                this.updateSimOutputs();
                continue;
            }
            AFOPin output = (AFOPin)this.simTableModel.getValueAt(i, simModelColumns.PinID.ordinal());
            this.updateSingleOutput(output, new GenericNode.SimData(x, true));
        }
    }

    @Override
    public void showSimulationDialog() {
        this.simMultiInFrame.cleanTable();
        DefaultTableModel dialogTable = new DefaultTableModel(new Object[0][], new Object[]{"Label", "Type", "Amplitude", "Offset", "Period", "PinID"});
        this.simTableCopy(dialogTable, this.simTableModel);
        this.simMultiInFrame.table.setModel(dialogTable);
        this.simMultiInFrame.setupCombo();
        this.simMultiInFrame.hideColumn(simModelColumns.PinID.ordinal());
        this.simMultiInFrame.setVisible(true);
    }

    @Override
    protected void simDialogClosed() {
        DefaultTableModel dialogTable = (DefaultTableModel)this.simMultiInFrame.table.getModel();
        this.simTableCopy(this.simTableModel, dialogTable);
    }

    public static enum simModelColumns {
        Label,
        Type,
        Amplitude,
        Offset,
        Period,
        PinID;

    }

    public static enum modelColumns {
        Label,
        Label_2,
        Min,
        Max,
        Step,
        Default,
        Tipo,
        PinID;

    }
}

