/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import nodes.AFONodeWidget;
import nodes.BoardsTypesAndDescription;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.DeviceNode;
import nodes.devices.GenericNode;
import nodes.devices.Monitor_4.Monitor4BaseItem;
import nodes.devices.Monitor_4.Monitor4MenuItem;
import nodes.devices.Monitor_4.Monitor4VariableItem;
import nodes.gui.Monitor_4.MonitorDialog_4;
import nodes.gui.SimInputFrame;
import nodes.gui.SimMultiInputFrame;
import org.netbeans.api.visual.widget.Widget;
import org.openide.util.Exceptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class MonitorNode_4
extends DeviceNode
implements ActionListener {
    private int NUM_DEFAULT_OUT_PINS = 0;
    private int NUM_DEFAULT_IN_PINS = 0;
    private BoardsTypesAndDescription.BoardType boardType;
    private final String type;
    Integer password = 0;
    int nOfOut = 12;
    private int menuID = 3;
    private int parentMenuID = 0;
    Integer nOfinChannel = 1;
    DefaultTreeModel menuModel;
    private String[][] crono_labels = new String[][]{{"Crono1", "Chrono1"}, {"Crono2", "Chrono2"}, {"Crono3", "Chrono3"}, {"Crono4", "Chrono4"}};
    private String[][] levels = new String[][]{{"0", "100", "0.5", "5", "16", "20", "35", "30", "26"}, {"0", "100", "0.5", "5", "16", "20", "35", "30", "26"}, {"0", "100", "0.5", "5", "16", "20", "35", "30", "26"}, {"0", "100", "0.5", "5", "16", "20", "35", "30", "26"}};
    String[] labels = new String[]{"Min", "Max", "Step", "L1Winter", "L2Winter", "L3Winter", "L1Summer", "L2Summer", "L3Summer"};
    private Integer defaultLanguage = 0;
    private int FIRST_MENU_ID = 2;
    public static final Integer MPID4_MAX_NUM_VAR = 64;
    public static final Integer MPID4_MAX_NUM_MENU = 10;
    public static final Integer MPID4_MAX_MENU_ITEM = 16;
    public static final Integer MPID9_MAX_NUM_VAR = 64;
    public static final Integer MPID9_MAX_NUM_MENU = 10;
    public static final Integer MPID9_MAX_MENU_ITEM = 16;
    private DefaultTableModel simTableModel;
    public static final int MAX_LABEL_LEN = 11;
    public static final int Monitor_4_ID = 52;
    SimMultiInputFrame simMultiInFrame = new SimMultiInputFrame();

    public MonitorNode_4(String id, String label, String UID, AFOGraphPinScene scene, BoardsTypesAndDescription.BoardType board) {
        super(id, label, "Monitor_2", scene);
        this.type = label;
        this.boardType = board;
        this.blockType = CommonDefinitions.blockTypes.Monitor_4;
        this.numberOfInputs = 3;
        this.createWidget();
        this.createPropertiesDialog();
        this.menuModel = this.copyTree(((MonitorDialog_4)this.propertiesDialog).getTreeModel());
        this.addressSpace = 100;
        this.simTableModel = new DefaultTableModel(new Object[]{simModelColumns.Label.toString(), simModelColumns.Type.toString(), simModelColumns.Amplitude.toString(), simModelColumns.Offset.toString(), simModelColumns.Period.toString(), simModelColumns.PinID}, 0);
        for (AFOPin pinExamined : this.getPinList()) {
            if (pinExamined.getPinType() != AFOPin.E_PinType.PIN_OUTPUT) continue;
            this.simTableModel.addRow(new Object[]{pinExamined.getLabel(), SimInputFrame.SIM_IN_TYPES.Costant.toString(), "1.0", "1.0", "1.0", null});
        }
        this.simMultiInFrame.btnExit.addActionListener(this);
    }

    private DefaultTreeModel copyTree(DefaultTreeModel origin) {
        DefaultMutableTreeNode rootCopy = this.copyNode((DefaultMutableTreeNode)origin.getRoot());
        DefaultTreeModel modelCopy = new DefaultTreeModel(rootCopy);
        return modelCopy;
    }

    private DefaultMutableTreeNode copyNode(DefaultMutableTreeNode OriginNode) {
        Monitor4BaseItem base = (Monitor4BaseItem)OriginNode.getUserObject();
        DefaultMutableTreeNode Copy = new DefaultMutableTreeNode();
        if (base instanceof Monitor4MenuItem) {
            Monitor4MenuItem mnu = (Monitor4MenuItem)base;
            Monitor4MenuItem mnuClone = new Monitor4MenuItem(base.label[0], base.label[1]);
            mnuClone.passwordProtected = mnu.passwordProtected;
            Copy.setUserObject(mnuClone);
        } else {
            Monitor4VariableItem var = (Monitor4VariableItem)base;
            Monitor4VariableItem varClone = new Monitor4VariableItem(base.label[0], base.label[1]);
            varClone.defVal = var.defVal;
            varClone.maxVal = var.maxVal;
            varClone.minVal = var.minVal;
            varClone.pin = var.pin;
            varClone.pinNumber = var.pinNumber;
            varClone.step = var.step;
            varClone.channel = var.channel;
            Copy.setUserObject(varClone);
        }
        if (OriginNode.isLeaf()) {
            return Copy;
        }
        int cc = OriginNode.getChildCount();
        for (int i = 0; i < cc; ++i) {
            Copy.add(this.copyNode((DefaultMutableTreeNode)OriginNode.getChildAt(i)));
        }
        return Copy;
    }

    public void control() {
        if (this.getAddress().equals("")) {
            ((MonitorDialog_4)this.propertiesDialog).indexLabel.setVisible(false);
        }
        if (this.controlAddress(this.getAddress(), true).booleanValue()) {
            ((MonitorDialog_4)this.propertiesDialog).indexLabel.setVisible(true);
        } else {
            ((MonitorDialog_4)this.propertiesDialog).indexLabel.setVisible(false);
        }
    }

    public String getAddress() {
        String newAddress = ((MonitorDialog_4)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void addStandardPins() {
        this.NUM_DEFAULT_OUT_PINS = 0;
        int pinCount = 1;
        String pinLabel = "On Ch1";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ++this.NUM_DEFAULT_OUT_PINS;
        pinLabel = "Ch SP 1";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ++this.NUM_DEFAULT_OUT_PINS;
        pinLabel = "Summer1";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ++this.NUM_DEFAULT_OUT_PINS;
        pinLabel = "On Ch 2";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ++this.NUM_DEFAULT_OUT_PINS;
        pinLabel = "Ch SP 2";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ++this.NUM_DEFAULT_OUT_PINS;
        pinLabel = "Summer2";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ++this.NUM_DEFAULT_OUT_PINS;
        pinLabel = "On Ch 3";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ++this.NUM_DEFAULT_OUT_PINS;
        pinLabel = "Ch SP 3";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ++this.NUM_DEFAULT_OUT_PINS;
        pinLabel = "Summer3";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ++this.NUM_DEFAULT_OUT_PINS;
        pinLabel = "On Ch 4";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ++this.NUM_DEFAULT_OUT_PINS;
        pinLabel = "Ch SP 4";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ++this.NUM_DEFAULT_OUT_PINS;
        pinLabel = "Summer4";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ++this.NUM_DEFAULT_OUT_PINS;
        pinCount = 1;
        pinLabel = "Warning";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN" + pinCount++);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ++this.NUM_DEFAULT_IN_PINS;
        this.numberOfInputs = this.NUM_DEFAULT_IN_PINS;
    }

    private void createWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("Display");
        this.getScene().addNode(this);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
        this.addStandardPins();
        this.getScene().revalidate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(((MonitorDialog_4)this.propertiesDialog).btnOK)) {
            if (((MonitorDialog_4)this.propertiesDialog).indexLabel.isVisible()) {
                JOptionPane.showMessageDialog(null, "L'indirizzo inserito \u00e8 gi\u00e0 in uso!");
                return;
            }
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.propertiesDialog.setVisible(false);
        } else if (e.getSource().equals(((MonitorDialog_4)this.propertiesDialog).btnCancel)) {
            this.propertiesDialog.setVisible(false);
        } else if (e.getSource().equals(this.simMultiInFrame.btnExit)) {
            this.simDialogClosed();
        }
    }

    private void createPropertiesDialog() {
        this.propertiesDialog = new MonitorDialog_4(null, true);
    }

    public static void tableClear(DefaultTableModel table) {
        while (table.getRowCount() > 0) {
            table.removeRow(0);
        }
    }

    public void simTableCopy(DefaultTableModel destTable, DefaultTableModel srcTable) {
        MonitorNode_4.tableClear(destTable);
        for (int i = 0; i < srcTable.getRowCount(); ++i) {
            destTable.addRow(new Object[]{srcTable.getValueAt(i, 0), srcTable.getValueAt(i, 1), srcTable.getValueAt(i, 2), srcTable.getValueAt(i, 3), srcTable.getValueAt(i, 4), srcTable.getValueAt(i, 5)});
        }
    }

    @Override
    public void setConnectionStatus(boolean isConnected) {
        MonitorDialog_4 dlg = (MonitorDialog_4)this.propertiesDialog;
    }

    void getNewPasswordFromDialog() {
        Integer pass1 = 0;
        Integer pass2 = 0;
        Integer pass3 = 0;
        Integer pass4 = 0;
        Integer pass5 = 0;
        Integer pass6 = 0;
        pass1 = ((MonitorDialog_4)this.propertiesDialog).comboPwd1.getSelectedIndex();
        pass2 = ((MonitorDialog_4)this.propertiesDialog).comboPwd2.getSelectedIndex();
        pass3 = ((MonitorDialog_4)this.propertiesDialog).comboPwd3.getSelectedIndex();
        pass4 = ((MonitorDialog_4)this.propertiesDialog).comboPwd4.getSelectedIndex();
        pass5 = ((MonitorDialog_4)this.propertiesDialog).comboPwd5.getSelectedIndex();
        pass6 = ((MonitorDialog_4)this.propertiesDialog).comboPwd6.getSelectedIndex();
        this.password = 0;
        this.password = pass1 | pass2 << 2 | pass3 << 4 | pass4 << 6 | pass5 << 8 | pass6 << 10;
    }

    void getCronoLabelsFromDialog() {
        for (int i = 0; i < 4; ++i) {
            this.crono_labels[i][0] = ((MonitorDialog_4)this.propertiesDialog).pnlChronoArray[i].txtLang1.getText();
            this.crono_labels[i][1] = ((MonitorDialog_4)this.propertiesDialog).pnlChronoArray[i].txtLang2.getText();
        }
    }

    void getCronoLevelsFromDialog() {
        for (int i = 0; i < 4; ++i) {
            this.levels[i][0] = ((MonitorDialog_4)this.propertiesDialog).pnlChronoArray[i].txtMin.getText();
            this.levels[i][1] = ((MonitorDialog_4)this.propertiesDialog).pnlChronoArray[i].txtMax.getText();
            this.levels[i][2] = ((MonitorDialog_4)this.propertiesDialog).pnlChronoArray[i].txtStep.getText();
            this.levels[i][3] = ((MonitorDialog_4)this.propertiesDialog).pnlChronoArray[i].txtL1Winter.getText();
            this.levels[i][4] = ((MonitorDialog_4)this.propertiesDialog).pnlChronoArray[i].txtL2Winter.getText();
            this.levels[i][5] = ((MonitorDialog_4)this.propertiesDialog).pnlChronoArray[i].txtL3Winter.getText();
            this.levels[i][6] = ((MonitorDialog_4)this.propertiesDialog).pnlChronoArray[i].txtL1Summer.getText();
            this.levels[i][7] = ((MonitorDialog_4)this.propertiesDialog).pnlChronoArray[i].txtL2Summer.getText();
            this.levels[i][8] = ((MonitorDialog_4)this.propertiesDialog).pnlChronoArray[i].txtL3Summer.getText();
        }
    }

    void setComboPassword() {
        Integer pass1 = 0;
        Integer pass2 = 0;
        Integer pass3 = 0;
        Integer pass4 = 0;
        Integer pass5 = 0;
        Integer pass6 = 0;
        pass1 = (this.password & 3) >> 0;
        pass2 = (this.password & 0xC) >> 2;
        pass3 = (this.password & 0x30) >> 4;
        pass4 = (this.password & 0xC0) >> 6;
        pass5 = (this.password & 0x300) >> 8;
        pass6 = (this.password & 0xC00) >> 10;
        ((MonitorDialog_4)this.propertiesDialog).comboPwd1.setSelectedIndex(pass1);
        ((MonitorDialog_4)this.propertiesDialog).comboPwd2.setSelectedIndex(pass2);
        ((MonitorDialog_4)this.propertiesDialog).comboPwd3.setSelectedIndex(pass3);
        ((MonitorDialog_4)this.propertiesDialog).comboPwd4.setSelectedIndex(pass4);
        ((MonitorDialog_4)this.propertiesDialog).comboPwd5.setSelectedIndex(pass5);
        ((MonitorDialog_4)this.propertiesDialog).comboPwd6.setSelectedIndex(pass6);
    }

    void updateNumberOfIO(AFOPin pin) {
        if (pin.getPinType().equals((Object)AFOPin.E_PinType.PIN_INPUT)) {
            --this.numberOfInputs;
        } else {
            --this.nOfOut;
        }
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        int i;
        ((MonitorDialog_4)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        this.setComboPassword();
        DefaultTreeModel dialogTree = this.copyTree(this.menuModel);
        ((MonitorDialog_4)this.propertiesDialog).setTreeModel(dialogTree);
        ((MonitorDialog_4)this.propertiesDialog).btnOK.setEnabled(!this.kernelConnected);
        ((MonitorDialog_4)this.propertiesDialog).indexLabel.setVisible(false);
        for (i = 0; i < 4; ++i) {
            ((MonitorDialog_4)this.propertiesDialog).pnlChronoArray[i].txtLang1.setText(this.crono_labels[i][0]);
            ((MonitorDialog_4)this.propertiesDialog).pnlChronoArray[i].txtLang1.setEnabled(!this.kernelConnected);
            ((MonitorDialog_4)this.propertiesDialog).pnlChronoArray[i].txtLang2.setText(this.crono_labels[i][1]);
            ((MonitorDialog_4)this.propertiesDialog).pnlChronoArray[i].txtLang2.setEnabled(!this.kernelConnected);
        }
        for (i = 0; i < 4; ++i) {
            ((MonitorDialog_4)this.propertiesDialog).pnlChronoArray[i].txtMin.setText(this.levels[i][0]);
            ((MonitorDialog_4)this.propertiesDialog).pnlChronoArray[i].txtMax.setText(this.levels[i][1]);
            ((MonitorDialog_4)this.propertiesDialog).pnlChronoArray[i].txtStep.setText(this.levels[i][2]);
            ((MonitorDialog_4)this.propertiesDialog).pnlChronoArray[i].txtL1Winter.setText(this.levels[i][3]);
            ((MonitorDialog_4)this.propertiesDialog).pnlChronoArray[i].txtL2Winter.setText(this.levels[i][4]);
            ((MonitorDialog_4)this.propertiesDialog).pnlChronoArray[i].txtL3Winter.setText(this.levels[i][5]);
            ((MonitorDialog_4)this.propertiesDialog).pnlChronoArray[i].txtL1Summer.setText(this.levels[i][6]);
            ((MonitorDialog_4)this.propertiesDialog).pnlChronoArray[i].txtL2Summer.setText(this.levels[i][7]);
            ((MonitorDialog_4)this.propertiesDialog).pnlChronoArray[i].txtL3Summer.setText(this.levels[i][8]);
        }
        ((MonitorDialog_4)this.propertiesDialog).setVisible(true);
        if (((MonitorDialog_4)this.propertiesDialog).getReturnStatus() == 1) {
            if (!((MonitorDialog_4)this.propertiesDialog).getDataChanged()) {
                return;
            }
            this.scene.sceneChanged();
            this.getNewPasswordFromDialog();
            this.getCronoLabelsFromDialog();
            this.getCronoLevelsFromDialog();
            this.menuModel = this.copyTree(((MonitorDialog_4)this.propertiesDialog).getTreeModel());
            this.checkPins();
            this.checkSimTable();
        }
    }

    private void checkSimTable() {
        int rowCount = this.simTableModel.getRowCount();
        for (int i = this.NUM_DEFAULT_OUT_PINS; i < rowCount; ++i) {
            if (this.findTreeNodeFromPin((DefaultMutableTreeNode)this.menuModel.getRoot(), (AFOPin)this.simTableModel.getValueAt(i, simModelColumns.PinID.ordinal())) != null) continue;
            this.simTableModel.removeRow(i);
            --rowCount;
            --i;
        }
        ArrayList<Monitor4VariableItem> leafList = this.getItemLeafList((DefaultMutableTreeNode)this.menuModel.getRoot());
        int count = 0;
        for (int i = 0; i < leafList.size(); ++i) {
            if (Double.parseDouble(leafList.get((int)i).step) == 0.0) continue;
            int rowIndex = this.findSimRowIndexFromPin(this.simTableModel, leafList.get((int)i).pin);
            if (rowIndex == -1) {
                String myLabel = leafList.get((int)i).label[0];
                if (count + this.NUM_DEFAULT_OUT_PINS >= this.simTableModel.getRowCount()) {
                    this.simTableModel.addRow(new Object[]{myLabel, "Costant", "0.0", "1.0", "1.0", leafList.get((int)i).pin});
                } else {
                    this.simTableModel.insertRow(count + this.NUM_DEFAULT_OUT_PINS, new Object[]{myLabel, "Costant", "0.0", "1.0", "1.0", leafList.get((int)i).pin});
                }
            } else if (Double.parseDouble(leafList.get((int)i).step) == 0.0) {
                this.simTableModel.removeRow(rowIndex);
            } else {
                Vector row = this.simTableModel.getDataVector().elementAt(rowIndex);
                this.simTableModel.removeRow(rowIndex);
                if (count + this.NUM_DEFAULT_OUT_PINS >= this.simTableModel.getRowCount()) {
                    this.simTableModel.addRow(row);
                } else {
                    this.simTableModel.insertRow(count + this.NUM_DEFAULT_OUT_PINS, row);
                }
            }
            ++count;
        }
    }

    private int findSimRowIndexFromPin(DefaultTableModel table, AFOPin pin) {
        int retVal = -1;
        try {
            for (int i = this.NUM_DEFAULT_OUT_PINS; i < table.getRowCount(); ++i) {
                AFOPin myPin = (AFOPin)table.getValueAt(i, simModelColumns.PinID.ordinal());
                if (!myPin.equals(pin)) continue;
                retVal = i;
                break;
            }
        }
        catch (Exception ex) {
            Logger.getLogger(MonitorNode_4.class.getName()).log(Level.SEVERE, ex.getStackTrace().toString());
        }
        return retVal;
    }

    private DefaultMutableTreeNode findTreeNodeFromPin(DefaultMutableTreeNode parentNode, AFOPin pin) {
        DefaultMutableTreeNode retVal = null;
        try {
            for (int i = 0; i < parentNode.getChildCount(); ++i) {
                AFOPin checkPin;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)parentNode.getChildAt(i);
                Monitor4BaseItem.monitor4Types nodeType = ((Monitor4BaseItem)node.getUserObject()).getType();
                if (nodeType.equals((Object)Monitor4BaseItem.monitor4Types.Menu)) {
                    retVal = this.findTreeNodeFromPin(node, pin);
                    if (retVal == null) continue;
                    return retVal;
                }
                if (!nodeType.equals((Object)Monitor4BaseItem.monitor4Types.Variable) || (checkPin = ((Monitor4VariableItem)node.getUserObject()).pin) == null || !checkPin.equals(pin)) continue;
                return node;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return retVal;
    }

    private AFOPin addPinFromVar(Monitor4VariableItem var, int position) {
        AFOPin newPin = null;
        ArrayList<DefaultMutableTreeNode> leafList = this.getLeafList((DefaultMutableTreeNode)this.menuModel.getRoot());
        for (DefaultMutableTreeNode nd : leafList) {
            if (!((Monitor4VariableItem)nd.getUserObject()).equals(var)) continue;
            newPin = this.addPinFromNode(nd, position);
        }
        return newPin;
    }

    private AFOPin addPinFromNode(DefaultMutableTreeNode node, int position) {
        double varStep;
        AFOPin newPin = new AFOPin(this.id, this.label, AFOPin.E_PinType.PIN_INPUT);
        Monitor4VariableItem var = (Monitor4VariableItem)node.getUserObject();
        Object parentNode = null;
        String parentLabel = "";
        try {
            TreeNode[] path = this.menuModel.getPathToRoot(node);
            for (int i = 1; i < path.length; ++i) {
                DefaultMutableTreeNode pp = (DefaultMutableTreeNode)path[i];
                Monitor4BaseItem it = (Monitor4BaseItem)pp.getUserObject();
                parentLabel = parentLabel + "/" + it.label[0];
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if ((varStep = Double.parseDouble(var.step)) == 0.0) {
            ++this.numberOfInputs;
            newPin = this.addIOPin(true, parentLabel, this.numberOfInputs);
            var.channel = this.numberOfInputs - 1;
        } else {
            ++this.nOfOut;
            newPin = this.addIOPin(false, parentLabel, this.nOfOut);
            var.channel = this.nOfOut - 1;
        }
        var.pin = newPin;
        return newPin;
    }

    private ArrayList<Monitor4VariableItem> getItemLeafList(DefaultMutableTreeNode parentNode) {
        ArrayList<Monitor4VariableItem> retVal = new ArrayList<Monitor4VariableItem>();
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)parentNode.getChildAt(i);
            Monitor4BaseItem.monitor4Types nodeType = ((Monitor4BaseItem)node.getUserObject()).getType();
            if (nodeType.equals((Object)Monitor4BaseItem.monitor4Types.Menu)) {
                retVal.addAll(this.getItemLeafList(node));
                continue;
            }
            if (!nodeType.equals((Object)Monitor4BaseItem.monitor4Types.Variable)) continue;
            retVal.add((Monitor4VariableItem)node.getUserObject());
        }
        return retVal;
    }

    private ArrayList<DefaultMutableTreeNode> getLeafList(DefaultMutableTreeNode parentNode) {
        ArrayList<DefaultMutableTreeNode> retVal = new ArrayList<DefaultMutableTreeNode>();
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)parentNode.getChildAt(i);
            Monitor4BaseItem.monitor4Types nodeType = ((Monitor4BaseItem)node.getUserObject()).getType();
            if (nodeType.equals((Object)Monitor4BaseItem.monitor4Types.Menu)) {
                retVal.addAll(this.getLeafList(node));
                continue;
            }
            if (!nodeType.equals((Object)Monitor4BaseItem.monitor4Types.Variable)) continue;
            retVal.add(node);
        }
        return retVal;
    }

    private void exploreTreeNode(DefaultMutableTreeNode parentNode) throws Exception {
    }

    private void checkPins() {
        AFOPin newPin;
        for (int i = this.NUM_DEFAULT_IN_PINS + this.NUM_DEFAULT_OUT_PINS; i < this.pinList.size(); ++i) {
            newPin = (AFOPin)this.pinList.get(i);
            if (this.findTreeNodeFromPin((DefaultMutableTreeNode)this.menuModel.getRoot(), newPin) != null) continue;
            ((AFONodeWidget)this.widget).removePin(newPin);
            this.updateNumberOfIO(newPin);
            this.pinList.remove(newPin);
            --i;
            this.scene.validate();
        }
        try {
            ArrayList<Monitor4VariableItem> varList = this.getItemLeafList((DefaultMutableTreeNode)this.menuModel.getRoot());
            for (int i = 0; i < varList.size(); ++i) {
                Monitor4VariableItem var = varList.get(i);
                double varStep = Double.parseDouble(var.step);
                if (var.pin == null) {
                    this.addPinFromVar(var, i);
                    continue;
                }
                if ((varStep == 0.0 || !var.pin.getPinType().equals((Object)AFOPin.E_PinType.PIN_INPUT)) && (varStep != 0.0 || !var.pin.getPinType().equals((Object)AFOPin.E_PinType.PIN_OUTPUT))) continue;
                AFOPin pin = var.pin;
                ((AFONodeWidget)this.widget).removePin(pin);
                this.updateNumberOfIO(pin);
                int pinIndex = this.pinList.indexOf(pin);
                this.pinList.remove(pinIndex);
                this.scene.validate();
                newPin = this.addPinFromVar(var, i);
                this.pinList.remove(newPin);
                this.pinList.add(i + (this.NUM_DEFAULT_IN_PINS + this.NUM_DEFAULT_OUT_PINS), newPin);
                this.scene.validate();
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.scene.validate();
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        retVal = retVal + "52 " + this.getCommonData();
        retVal = retVal + ((AFONodeWidget)this.widget).getModuleOUTPinNames().getChildren().size();
        return retVal;
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        int i;
        Element menuNode = document.createElement("MainMenu");
        this.serializeTreeNode(document, menuNode, (DefaultMutableTreeNode)this.menuModel.getRoot());
        nodeElement.appendChild(menuNode);
        SceneSerializer.setAttribute(document, nodeElement, "Password", this.password.toString());
        for (i = 0; i < 4; ++i) {
            Element cronoElement = document.createElement("Crono_" + (i + 1));
            SceneSerializer.setAttribute(document, cronoElement, "CronoLabel_1", this.crono_labels[i][0]);
            SceneSerializer.setAttribute(document, cronoElement, "CronoLabel_2", this.crono_labels[i][1]);
            for (int j = 0; j < this.labels.length; ++j) {
                SceneSerializer.setAttribute(document, cronoElement, this.labels[j], this.levels[i][j]);
            }
            nodeElement.appendChild(cronoElement);
        }
        SceneSerializer.setAttribute(document, nodeElement, "SimNofRows", "" + this.simTableModel.getRowCount());
        for (i = 0; i < this.simTableModel.getRowCount(); ++i) {
            Element climaticElement = document.createElement("SimTableRow");
            for (simModelColumns lbl : simModelColumns.values()) {
                String val = " ";
                if (this.simTableModel.getValueAt(i, lbl.ordinal()) != null) {
                    val = this.simTableModel.getValueAt(i, lbl.ordinal()).toString();
                }
                SceneSerializer.setAttribute(document, climaticElement, lbl.toString(), val);
            }
            nodeElement.appendChild(climaticElement);
        }
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        for (Node element : SceneSerializer.getChildNode(node)) {
            if (element.getNodeName().equals("MainMenu")) {
                ((DefaultMutableTreeNode)this.menuModel.getRoot()).removeAllChildren();
                this.deserializeTree(element, (DefaultMutableTreeNode)this.menuModel.getRoot());
                this.menuModel.reload();
                ArrayList<Monitor4VariableItem> leafList = this.getItemLeafList((DefaultMutableTreeNode)this.menuModel.getRoot());
                Collections.sort(leafList, new CustomComparator());
                for (Monitor4VariableItem var : leafList) {
                    this.addPinFromVar(var, var.pinNumber);
                }
                continue;
            }
            if (!element.getNodeName().contains("Crono_")) continue;
            int cronoIndex = Integer.parseInt(element.getNodeName().substring(6)) - 1;
            String str = SceneSerializer.getAttributeValue(element, "CronoLabel_1");
            if (str != null) {
                this.crono_labels[cronoIndex][0] = str;
            }
            if ((str = SceneSerializer.getAttributeValue(element, "CronoLabel_2")) != null) {
                this.crono_labels[cronoIndex][1] = str;
            }
            for (int i = 0; i < this.labels.length; ++i) {
                this.levels[cronoIndex][i] = SceneSerializer.getAttributeValue(element, this.labels[i]);
            }
            if (this.levels[cronoIndex][0] == null) {
                this.levels[cronoIndex][0] = "0";
            }
            if (this.levels[cronoIndex][1] == null) {
                this.levels[cronoIndex][1] = "100";
            }
            if (this.levels[cronoIndex][2] == null) {
                this.levels[cronoIndex][2] = "0.5";
            }
            if (this.levels[cronoIndex][3] == null) {
                this.levels[cronoIndex][3] = "5";
            }
            if (this.levels[cronoIndex][4] == null) {
                this.levels[cronoIndex][4] = "16";
            }
            if (this.levels[cronoIndex][5] == null) {
                this.levels[cronoIndex][5] = "20";
            }
            if (this.levels[cronoIndex][6] == null) {
                this.levels[cronoIndex][6] = "35";
            }
            if (this.levels[cronoIndex][7] == null) {
                this.levels[cronoIndex][7] = "30";
            }
            if (this.levels[cronoIndex][8] != null) continue;
            this.levels[cronoIndex][8] = "26";
        }
        String passwordStr = SceneSerializer.getAttributeValue(node, "Password");
        if (passwordStr != null) {
            try {
                this.password = Integer.parseInt(passwordStr);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        this.propertiesDialog.validate();
        this.checkSimTable();
        int row = 0;
        for (Node element : SceneSerializer.getChildNode(node)) {
            if (!element.getNodeName().equals("SimTableRow")) continue;
            String nome = SceneSerializer.getAttributeValue(element, simModelColumns.Label.toString());
            String amplitude = SceneSerializer.getAttributeValue(element, simModelColumns.Amplitude.toString());
            String offset = SceneSerializer.getAttributeValue(element, simModelColumns.Offset.toString());
            String period = SceneSerializer.getAttributeValue(element, simModelColumns.Period.toString());
            String varType = SceneSerializer.getAttributeValue(element, simModelColumns.Type.toString());
            this.simTableModel.setValueAt(varType, row, simModelColumns.Type.ordinal());
            this.simTableModel.setValueAt(amplitude, row, simModelColumns.Amplitude.ordinal());
            this.simTableModel.setValueAt(offset, row, simModelColumns.Offset.ordinal());
            this.simTableModel.setValueAt(period, row, simModelColumns.Period.ordinal());
            ++row;
        }
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
        } else {
            String value = "";
            int msgAddress = Integer.parseInt(cmd.getValue("ADDRESS")) - (Integer)this.addressList.get(0) - 1;
            value = cmd.getValue("TOKEN3");
            if (msgAddress < this.getNofOutputPins()) {
                String output = "OUT" + (msgAddress + 1);
                this.setPinValue(output, value);
                try {
                    this.setTargetPinValue(output, value);
                }
                catch (Exception ex) {
                    Logger.getLogger(MonitorNode_4.class.getName()).log(Level.SEVERE, ex.getStackTrace().toString());
                }
                this.sendValueToChart(output, value);
                try {
                    AFOPin pin = this.getPinByID(output);
                    if (pin != null) {
                        this.updateDB(Float.parseFloat(value), 3, output);
                    }
                }
                catch (NumberFormatException ex) {
                    Logger.getLogger(MonitorNode_4.class.getName()).log(Level.SEVERE, ex.getStackTrace().toString());
                }
            }
        }
        return true;
    }

    private void reassignPinID() {
        int inNumber = 1;
        int outNumber = 1;
        for (AFOPin pin : this.pinList) {
            if (pin.getPinType().equals((Object)AFOPin.E_PinType.PIN_INPUT)) {
                pin.setPinIDString("IN" + inNumber++);
                continue;
            }
            pin.setPinIDString("OUT" + outNumber++);
        }
    }

    private AFOPin addIOPin(boolean isInput, String label, int pinIDNumber) {
        AFOPin newPin;
        String pinLabel = label;
        if (isInput) {
            String pinID = "pin" + ++this.scene.pinIDCounter;
            newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
            newPin.setAsBusPin(false);
            newPin.setParentNode(this);
            newPin.setPinIDString("IN" + pinIDNumber);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
        } else {
            String pinID = "pin" + ++this.scene.pinIDCounter;
            newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
            newPin.setAsBusPin(false);
            newPin.setParentNode(this);
            newPin.setPinIDString("OUT" + pinIDNumber);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            this.pinList.add(newPin);
            this.getScene().addPin(this, newPin);
        }
        this.reassignPinID();
        return newPin;
    }

    private String getNodeConfigString(DefaultMutableTreeNode parentNode) {
        String retVal = "";
        int myMenuID = this.menuID;
        int myParentID = this.parentMenuID;
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)parentNode.getChildAt(i);
            Monitor4BaseItem.monitor4Types nodeType = ((Monitor4BaseItem)node.getUserObject()).getType();
            if (nodeType.equals((Object)Monitor4BaseItem.monitor4Types.Menu)) {
                ++this.menuID;
                retVal = retVal + "<BL set " + this.addressList.get(0) + " 1 " + ((Monitor4BaseItem)node.getUserObject()).label[0].replace(' ', '_') + " " + ((Monitor4BaseItem)node.getUserObject()).label[1].replace(' ', '_') + " " + this.menuID + " " + myParentID + " ";
                retVal = ((Monitor4MenuItem)node.getUserObject()).passwordProtected ? retVal + "1 " : retVal + "0 ";
                retVal = retVal + ">\r\n";
                this.parentMenuID = this.menuID;
                retVal = retVal + this.getNodeConfigString(node);
                this.parentMenuID = myParentID;
                continue;
            }
            if (!nodeType.equals((Object)Monitor4BaseItem.monitor4Types.Variable)) continue;
            Monitor4VariableItem var = (Monitor4VariableItem)node.getUserObject();
            retVal = retVal + "<BL set " + this.addressList.get(0) + " 0 " + var.label[0].replace(' ', '_') + " " + var.minVal + " " + var.maxVal + " " + var.step + " " + var.defVal + " " + var.varType + " ";
            retVal = retVal + "" + var.channel + " ";
            retVal = retVal + var.label[1].replace(' ', '_') + " ";
            retVal = parentNode.isRoot() ? retVal + "0" : retVal + "" + myMenuID;
            retVal = retVal + " >\r\n";
        }
        return retVal;
    }

    public String getVarConfiguration() {
        String val;
        int i;
        String retVal = "";
        this.menuID = this.FIRST_MENU_ID;
        this.parentMenuID = 0;
        this.nOfinChannel = 0;
        retVal = this.getNodeConfigString((DefaultMutableTreeNode)this.menuModel.getRoot());
        retVal = retVal + "<BL set ";
        retVal = this.boardType.equals((Object)BoardsTypesAndDescription.BoardType.mPID4DSP_2014_1) || this.boardType.equals((Object)BoardsTypesAndDescription.BoardType.mPID4DSP_2014_2) ? retVal + ((Integer)this.addressList.get(0) + MPID4_MAX_NUM_VAR + 1) + " " : retVal + ((Integer)this.addressList.get(0) + MPID9_MAX_NUM_VAR + 1) + " ";
        retVal = retVal + this.password;
        retVal = retVal + ">\r\n";
        int baseAddr = this.boardType.equals((Object)BoardsTypesAndDescription.BoardType.mPID4DSP_2014_1) || this.boardType.equals((Object)BoardsTypesAndDescription.BoardType.mPID4DSP_2014_2) ? (Integer)this.addressList.get(0) + MPID4_MAX_NUM_VAR + 1 : (Integer)this.addressList.get(0) + MPID9_MAX_NUM_VAR + 1;
        for (i = 0; i < 4; ++i) {
            retVal = retVal + "<BL set ";
            retVal = retVal + ++baseAddr + " ";
            val = this.crono_labels[i][0];
            val = val.replace(' ', '_');
            retVal = retVal + val;
            retVal = retVal + ">\r\n";
        }
        for (i = 0; i < 4; ++i) {
            retVal = retVal + "<BL set ";
            retVal = retVal + ++baseAddr + " ";
            val = this.crono_labels[i][1];
            val = val.replace(' ', '_');
            retVal = retVal + val;
            retVal = retVal + ">\r\n";
        }
        retVal = retVal + "<BL set ";
        retVal = this.boardType.equals((Object)BoardsTypesAndDescription.BoardType.mPID4DSP_2014_1) || this.boardType.equals((Object)BoardsTypesAndDescription.BoardType.mPID4DSP_2014_2) ? retVal + ++baseAddr + " " : retVal + ++baseAddr + " ";
        retVal = retVal + this.defaultLanguage + " ";
        retVal = retVal + ">\r\n";
        if (this.boardType.equals((Object)BoardsTypesAndDescription.BoardType.mPID4DSP_2014_1) || this.boardType.equals((Object)BoardsTypesAndDescription.BoardType.mPID4DSP_2014_2)) {
            // empty if block
        }
        for (i = 0; i < 4; ++i) {
            retVal = retVal + "<BL set " + ++baseAddr + " ";
            for (int j = 0; j < this.levels[0].length; ++j) {
                retVal = retVal + this.levels[i][j] + " ";
            }
            retVal = retVal + ">\r\n";
        }
        return retVal;
    }

    @Override
    public void initSimulation() {
        super.initSimulation();
        this.simInputTimer = new GenericNode.SimTimer();
    }

    private SimInputFrame.SIM_IN_TYPES getTypeFromString(String str) {
        for (SimInputFrame.SIM_IN_TYPES sim : SimInputFrame.SIM_IN_TYPES.values()) {
            if (!sim.toString().equals(str)) continue;
            return sim;
        }
        return SimInputFrame.SIM_IN_TYPES.Costant;
    }

    @Override
    public void simulate() {
        super.simulate();
        for (int i = 0; i < this.simTableModel.getRowCount(); ++i) {
            SimInputFrame.SIM_IN_TYPES rowType = this.getTypeFromString(this.simTableModel.getValueAt(i, simModelColumns.Type.ordinal()).toString());
            double amp = Double.parseDouble(this.simTableModel.getValueAt(i, simModelColumns.Amplitude.ordinal()).toString());
            double offset = Double.parseDouble(this.simTableModel.getValueAt(i, simModelColumns.Offset.ordinal()).toString());
            double period = Double.parseDouble(this.simTableModel.getValueAt(i, simModelColumns.Period.ordinal()).toString());
            double x = this.waveGenerator(rowType, period, amp, offset);
            if (i < this.NUM_DEFAULT_OUT_PINS) {
                GenericNode.SimData data = this.GetMData(i);
                data.data = x;
                data.isValid = true;
                this.updateSimOutputs();
                continue;
            }
            AFOPin output = (AFOPin)this.simTableModel.getValueAt(i, simModelColumns.PinID.ordinal());
            this.updateSingleOutput(output, new GenericNode.SimData(x, true));
        }
    }

    @Override
    public void showSimulationDialog() {
        this.simMultiInFrame.cleanTable();
        DefaultTableModel dialogTable = new DefaultTableModel(new Object[0][], new Object[]{"Label", "Type", "Amplitude", "Offset", "Period", "PinID"});
        this.simTableCopy(dialogTable, this.simTableModel);
        this.simMultiInFrame.table.setModel(dialogTable);
        this.simMultiInFrame.setupCombo();
        this.simMultiInFrame.hideColumn(simModelColumns.PinID.ordinal());
        this.simMultiInFrame.setVisible(true);
    }

    @Override
    protected void simDialogClosed() {
        DefaultTableModel dialogTable = (DefaultTableModel)this.simMultiInFrame.table.getModel();
        this.simTableCopy(this.simTableModel, dialogTable);
    }

    private void serializeTreeNode(Document doc, Element xmlNode, DefaultMutableTreeNode treeNode) {
        int childCount = treeNode.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            Element varXML;
            Monitor4BaseItem var;
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)treeNode.getChildAt(i);
            Monitor4BaseItem item = (Monitor4BaseItem)child.getUserObject();
            if (item.getType().equals((Object)Monitor4BaseItem.monitor4Types.Variable)) {
                var = (Monitor4VariableItem)item;
                varXML = doc.createElement("Var");
                SceneSerializer.setAttribute(doc, varXML, "Label", var.label[0]);
                SceneSerializer.setAttribute(doc, varXML, "Label2", var.label[1]);
                SceneSerializer.setAttribute(doc, varXML, "MaxVal", var.maxVal);
                SceneSerializer.setAttribute(doc, varXML, "MinVal", var.minVal);
                SceneSerializer.setAttribute(doc, varXML, "Default", var.defVal);
                SceneSerializer.setAttribute(doc, varXML, "Step", var.step);
                SceneSerializer.setAttribute(doc, varXML, "pinID", "" + this.pinList.indexOf(var.pin));
                xmlNode.appendChild(varXML);
                continue;
            }
            if (!item.getType().equals((Object)Monitor4BaseItem.monitor4Types.Menu)) continue;
            var = (Monitor4MenuItem)item;
            varXML = doc.createElement("Menu");
            SceneSerializer.setAttribute(doc, varXML, "Label", ((Monitor4MenuItem)var).label[0]);
            SceneSerializer.setAttribute(doc, varXML, "Label2", ((Monitor4MenuItem)var).label[1]);
            if (((Monitor4MenuItem)item).passwordProtected) {
                SceneSerializer.setAttribute(doc, varXML, "Password", "1");
            } else {
                SceneSerializer.setAttribute(doc, varXML, "Password", "0");
            }
            this.serializeTreeNode(doc, varXML, child);
            xmlNode.appendChild(varXML);
        }
    }

    private void deserializeTree(Node xmlNode, DefaultMutableTreeNode treeNode) {
        for (Node element : SceneSerializer.getChildNode(xmlNode)) {
            Monitor4BaseItem var;
            if (element.getNodeName().equals("Var")) {
                var = new Monitor4VariableItem();
                var.label[0] = SceneSerializer.getAttributeValue(element, "Label");
                var.label[1] = SceneSerializer.getAttributeValue(element, "Label2");
                var.maxVal = SceneSerializer.getAttributeValue(element, "MaxVal");
                var.minVal = SceneSerializer.getAttributeValue(element, "MinVal");
                var.defVal = SceneSerializer.getAttributeValue(element, "Default");
                var.step = SceneSerializer.getAttributeValue(element, "Step");
                var.pinNumber = Integer.parseInt(SceneSerializer.getAttributeValue(element, "pinID"));
                treeNode.add(new DefaultMutableTreeNode(var));
                continue;
            }
            if (!element.getNodeName().equals("Menu")) continue;
            var = new Monitor4MenuItem();
            ((Monitor4MenuItem)var).label[0] = SceneSerializer.getAttributeValue(element, "Label");
            ((Monitor4MenuItem)var).label[1] = SceneSerializer.getAttributeValue(element, "Label2");
            DefaultMutableTreeNode menuNode = new DefaultMutableTreeNode(var);
            try {
                ((Monitor4MenuItem)var).passwordProtected = SceneSerializer.getAttributeValue(element, "Password").equals("1");
            }
            catch (Exception ex) {
                ((Monitor4MenuItem)var).passwordProtected = false;
            }
            this.deserializeTree(element, menuNode);
            treeNode.add(menuNode);
        }
    }

    private class CustomComparator
    implements Comparator<Monitor4VariableItem> {
        private CustomComparator() {
        }

        @Override
        public int compare(Monitor4VariableItem o1, Monitor4VariableItem o2) {
            if (o1.pinNumber < o2.pinNumber) {
                return -1;
            }
            if (o1.pinNumber == o2.pinNumber) {
                return 0;
            }
            return 1;
        }
    }

    public static enum simModelColumns {
        Label,
        Type,
        Amplitude,
        Offset,
        Period,
        PinID;

    }
}

