/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import VisiProg.AppOptions;
import connection.ICmd;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.GenericNode;
import nodes.gui.DelayDialog;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class MovingAverageNode
extends GenericNode {
    private String nOfSamples = "30";
    private String sampleTime = "250";
    private String defaultValue = "0.0";
    private static AppOptions options = new AppOptions();
    public static final int MOVING_AVERAGE_ID = 49;
    GenericNode.SimTimer m_SampleTimer;
    ArrayList<Double> m_SampledDataVector;
    static final int AVMEAN_MAX_SAMPLES = 64;

    public MovingAverageNode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        this.blockType = CommonDefinitions.blockTypes.MovingAverage;
        this.addressSpace = 5;
        this.numberOfInputs = 3;
        this.CreatePropertiesDialog();
        options.LoadOptions();
        this.currentLocale = new Locale(MovingAverageNode.options.language, MovingAverageNode.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        this.codici = new ArrayList();
        this.codici.add(0, "MovingAverage");
        this.codici.add(1, "OUT_MovingAcerage");
        this.codici.add(2, "NumberOfSamples");
        this.codici.add(3, "SampleTime");
        this.setList(this.codici);
        this.CreateWidget();
        this.cleanSimDialog();
    }

    public String getAddress() {
        String newAddress = ((DelayDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("Moving Average");
        this.getScene().addNode(this);
        String pinLabel = "OUT";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        pinLabel = "In";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setPinIDString("IN1");
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        pinLabel = "SampleTime";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setPinIDString("IN2");
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        pinLabel = "Samples";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setPinIDString("IN3");
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        ((AFONodeWidget)this.widget).setSubType(this.nOfSamples + ":" + this.sampleTime + " ms");
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new DelayDialog(null, true, this);
        options.LoadOptions();
        this.currentLocale = new Locale(MovingAverageNode.options.language, MovingAverageNode.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        ((DelayDialog)this.propertiesDialog).lblRit.setText("Number of Samples: ");
        ((DelayDialog)this.propertiesDialog).spnrDelay.setValue(Integer.parseInt(this.nOfSamples));
        ((DelayDialog)this.propertiesDialog).comboTimeBase.setVisible(false);
        ((DelayDialog)this.propertiesDialog).lblDefVal.setText("Sample Time (ms): ");
        ((DelayDialog)this.propertiesDialog).txtDefVal.setText(this.sampleTime);
        ((DelayDialog)this.propertiesDialog).jLabel2.setVisible(true);
        ((DelayDialog)this.propertiesDialog).txtExtraDef.setVisible(true);
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        this.requestData();
        ((DelayDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((DelayDialog)this.propertiesDialog).spnrDelay.setValue(Integer.parseInt(this.nOfSamples));
        ((DelayDialog)this.propertiesDialog).txtDefVal.setText(this.sampleTime);
        ((DelayDialog)this.propertiesDialog).indexLabel.setVisible(false);
        ((DelayDialog)this.propertiesDialog).txtExtraDef.setText(this.defaultValue);
        ((DelayDialog)this.propertiesDialog).showDialog();
        if (((DelayDialog)this.propertiesDialog).getReturnStatus() == 1) {
            if (!((DelayDialog)this.propertiesDialog).fieldChanged) {
                return;
            }
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.propertiesDialog.setVisible(false);
            this.nOfSamples = ((DelayDialog)this.propertiesDialog).spnrDelay.getValue().toString();
            this.scene.validate();
            this.sampleTime = ((DelayDialog)this.propertiesDialog).txtDefVal.getText();
            this.defaultValue = ((DelayDialog)this.propertiesDialog).txtExtraDef.getText();
            ((AFONodeWidget)this.widget).setSubType(this.nOfSamples + ":" + this.sampleTime + " ms");
            if (this.kernel != null && this.kernel.isConnected()) {
                this.commandQueue.clear();
                String msg = "<BL set " + this.addressList.get(2) + " " + Float.parseFloat(this.nOfSamples) + " >";
                this.commandQueue.add(msg);
                msg = "<BL set " + this.addressList.get(3) + " " + Float.parseFloat(this.sampleTime) + " >";
                this.commandQueue.add(msg);
                msg = "<BL set " + this.addressList.get(4) + " " + Float.parseFloat(this.defaultValue) + " >";
                this.commandQueue.add(msg);
                this.sendMessageQueue(true);
            } else {
                this.scene.sceneChanged();
            }
        }
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        float type = Float.parseFloat(this.nOfSamples);
        retVal = retVal + "49 " + this.getCommonData();
        retVal = retVal + this.nOfSamples + " " + this.sampleTime + " " + this.defaultValue;
        return retVal;
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "nOfSamples", this.nOfSamples);
        SceneSerializer.setAttribute(document, nodeElement, "sampleTime", this.sampleTime);
        SceneSerializer.setAttribute(document, nodeElement, "DefaultValue", this.defaultValue);
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        try {
            this.nOfSamples = SceneSerializer.getAttributeValue(node, "nOfSamples");
            this.sampleTime = SceneSerializer.getAttributeValue(node, "sampleTime");
            this.defaultValue = SceneSerializer.getAttributeValue(node, "DefaultValue");
        }
        catch (Exception ex) {
            this.nOfSamples = "10";
            this.sampleTime = "100";
            this.defaultValue = "0.0";
            ex.printStackTrace();
        }
        if (this.nOfSamples == null) {
            this.nOfSamples = "10";
        }
        if (this.sampleTime == null) {
            this.sampleTime = "100";
        }
        if (this.defaultValue == null) {
            this.defaultValue = "0.0";
        }
        ((AFONodeWidget)this.widget).setSubType(this.nOfSamples + ":" + this.sampleTime + " ms");
        this.scene.validate();
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
        } else if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(2)).toString())) {
            int delay = (int)Float.parseFloat(cmd.getValue("TOKEN3"));
            this.nOfSamples = "" + delay;
            ((AFONodeWidget)this.widget).setSubType(this.nOfSamples + ":" + this.sampleTime + " ms");
            ((DelayDialog)this.propertiesDialog).spnrDelay.setValue(Integer.parseInt(this.nOfSamples));
        } else if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(3)).toString())) {
            this.sampleTime = cmd.getValue("TOKEN3");
            ((DelayDialog)this.propertiesDialog).txtDefVal.setText(this.sampleTime);
            ((DelayDialog)this.propertiesDialog).validate();
            ((AFONodeWidget)this.widget).setSubType(this.nOfSamples + ":" + this.sampleTime + " ms");
        } else if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(4)).toString())) {
            this.defaultValue = cmd.getValue("TOKEN3");
            ((DelayDialog)this.propertiesDialog).txtExtraDef.setText(this.defaultValue);
            ((DelayDialog)this.propertiesDialog).validate();
        }
        return true;
    }

    @Override
    public void initSimulation() {
        super.initSimulation();
        this.m_SampledDataVector = new ArrayList();
        this.m_SampleTimer = new GenericNode.SimTimer();
        this.m_SampleTimer.setTimer(1);
        this.registerArray.add(Double.parseDouble(this.nOfSamples));
        this.registerArray.add(Double.parseDouble(this.sampleTime));
        this.registerArray.add(Double.parseDouble(this.defaultValue));
    }

    @Override
    public void simulate() {
        super.simulate();
        double data = -100.0;
        GenericNode.SimData out = this.GetMData(0);
        if (this.m_SampleTimer.isTimerExpired()) {
            if (this.isInputConnected(0)) {
                try {
                    data = this.GetInputData(0);
                }
                catch (Exception ex) {
                    this.invalidateOutputs();
                    this.updateSimOutputs();
                    return;
                }
            }
            if (this.isInputConnected(2)) {
                double newNOfSamples = 10.0;
                try {
                    newNOfSamples = this.GetInputData(2);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (newNOfSamples > 64.0 || newNOfSamples < 1.0) {
                    newNOfSamples = 64.0;
                }
                this.setParameter(e_Param.AVMEAN_SAMPLES.ordinal(), newNOfSamples);
            }
            if ((double)this.m_SampledDataVector.size() < this.GetParameter(e_Param.AVMEAN_SAMPLES.ordinal())) {
                this.m_SampledDataVector.add(data);
            } else if ((double)this.m_SampledDataVector.size() >= this.GetParameter(e_Param.AVMEAN_SAMPLES.ordinal())) {
                while ((double)this.m_SampledDataVector.size() > this.GetParameter(e_Param.AVMEAN_SAMPLES.ordinal()) - 1.0) {
                    try {
                        this.m_SampledDataVector.remove(this.m_SampledDataVector.size() - 1);
                    }
                    catch (Exception ex) {}
                }
                this.m_SampledDataVector.add(0, data);
            }
            out.isValid = true;
            data = 0.0;
            for (int i = 0; i < this.m_SampledDataVector.size(); ++i) {
                data += this.m_SampledDataVector.get(i).doubleValue();
            }
            out.data = this.m_SampledDataVector.size() > 0 && (double)this.m_SampledDataVector.size() == this.GetParameter(e_Param.AVMEAN_SAMPLES.ordinal()) ? data / (double)this.m_SampledDataVector.size() : this.GetParameter(e_Param.AVMEAN_DEFAULT.ordinal());
            this.m_SampleTimer.setTimer((int)this.GetParameter(e_Param.AVMEAN_INTERVAL.ordinal()));
        }
        if (this.isInputConnected(1)) {
            double newSampleTime = 1.0;
            try {
                newSampleTime = this.GetInputData(1);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (newSampleTime != this.GetParameter(e_Param.AVMEAN_INTERVAL.ordinal())) {
                this.setParameter(e_Param.AVMEAN_INTERVAL.ordinal(), newSampleTime);
                this.m_SampleTimer.setTimer((int)this.GetParameter(e_Param.AVMEAN_INTERVAL.ordinal()));
            }
        }
        this.SetMData(0, out);
        this.updateSimOutputs();
    }

    static enum e_Param {
        AVMEAN_SAMPLES,
        AVMEAN_INTERVAL,
        AVMEAN_DEFAULT,
        AVMEAN_NOFPARAM;

    }
}

