/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import nodes.AFONodeWidget;
import nodes.BoardsTypesAndDescription;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.DeviceNode;
import nodes.devices.GenericNode;
import nodes.gui.SimplePropertiesDlg;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class NTCNode
extends DeviceNode
implements ActionListener {
    private String type;
    public static final int NTC_ID = 29;
    private String betaFactor = "3900";
    private String compensation = "0.0";
    private boolean betaReadOnly = false;
    private Boolean isDigitalInput = false;
    private BoardsTypesAndDescription.BoardType boardType;

    public NTCNode(String id, String label, String analogID, AFOGraphPinScene scene, BoardsTypesAndDescription.BoardType board) {
        super(id, label, analogID, scene);
        this.type = label;
        this.boardType = board;
        this.propertiesDialog = new SimplePropertiesDlg(null, true, this.deviceID, this);
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.removeAllItems();
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.addItem(this.deviceID);
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.setSelectedIndex(0);
        ((SimplePropertiesDlg)this.propertiesDialog).txtValue.setVisible(false);
        ((SimplePropertiesDlg)this.propertiesDialog).lblValue.setVisible(false);
        ((SimplePropertiesDlg)this.propertiesDialog).lblValue.setVisible(false);
        if (board.equals((Object)BoardsTypesAndDescription.BoardType.mPID4CLT)) {
            ((SimplePropertiesDlg)this.propertiesDialog).chkBox.setVisible(true);
            ((SimplePropertiesDlg)this.propertiesDialog).chkBox.setText("Use as Digital Input");
        }
        ((SimplePropertiesDlg)this.propertiesDialog).jLabel3.setText("Beta Factor:");
        ((SimplePropertiesDlg)this.propertiesDialog).jLabel3.setVisible(true);
        ((SimplePropertiesDlg)this.propertiesDialog).jLabel5.setText("Compensation :");
        ((SimplePropertiesDlg)this.propertiesDialog).jLabel5.setVisible(true);
        ((SimplePropertiesDlg)this.propertiesDialog).txtMinOut.setText(this.betaFactor);
        ((SimplePropertiesDlg)this.propertiesDialog).txtMinOut.setVisible(true);
        ((SimplePropertiesDlg)this.propertiesDialog).txtMaxOut.setText(this.compensation);
        ((SimplePropertiesDlg)this.propertiesDialog).txtMaxOut.setVisible(true);
        this.blockType = CommonDefinitions.blockTypes.NTC;
        this.numberOfInputs = 0;
        this.setConnectionStatus(false);
        this.createWidget();
        this.addressSpace = 4;
        this.codici = new ArrayList();
        this.codici.add(0, "NTC");
        this.codici.add(1, "NTC");
        this.setList(this.codici);
        this.simDialog.tabbedPaneMain.remove(1);
        this.simDialog.tabbedPaneMain.setTitleAt(0, "Params");
    }

    public String getAddress() {
        String newAddress = ((SimplePropertiesDlg)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void createWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName(this.type);
        this.getScene().addNode(this);
        String pinLabel = "T";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        ((AFONodeWidget)this.widget).setSubType(this.deviceID);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        this.requestData();
        ((SimplePropertiesDlg)this.propertiesDialog).btnOk.addActionListener(this);
        ((SimplePropertiesDlg)this.propertiesDialog).btnCancel.addActionListener(this);
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.setSelectedItem(this.deviceID);
        ((SimplePropertiesDlg)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((SimplePropertiesDlg)this.propertiesDialog).indexLabel.setVisible(false);
        int num = Integer.parseInt(this.deviceID.substring(4));
        if (num == 3) {
            this.betaReadOnly = true;
        }
        ((SimplePropertiesDlg)this.propertiesDialog).txtMinOut.setText(this.betaFactor);
        ((SimplePropertiesDlg)this.propertiesDialog).txtMinOut.setEditable(!this.betaReadOnly);
        ((SimplePropertiesDlg)this.propertiesDialog).txtMaxOut.setText(this.compensation);
        ((SimplePropertiesDlg)this.propertiesDialog).chkBox.setSelected(this.isDigitalInput);
        this.propertiesDialog.setVisible(true);
        if (((SimplePropertiesDlg)this.propertiesDialog).getReturnStatus() == 1) {
            this.propertiesDialog.setVisible(false);
            this.betaFactor = ((SimplePropertiesDlg)this.propertiesDialog).txtMinOut.getText();
            this.compensation = ((SimplePropertiesDlg)this.propertiesDialog).txtMaxOut.getText();
            this.isDigitalInput = ((SimplePropertiesDlg)this.propertiesDialog).chkBox.isSelected();
            this.scene.sceneChanged();
            if (this.kernel != null && this.kernel.isConnected()) {
                if (!this.sendingCommandQueue.booleanValue()) {
                    this.commandQueue.clear();
                    int offset = 2;
                    String msg = "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " " + this.betaFactor + " >";
                    this.commandQueue.add(msg);
                    msg = "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " " + this.compensation + " >";
                    this.commandQueue.add(msg);
                    this.sendMessageQueue(true);
                } else {
                    JOptionPane.showMessageDialog(null, "Another Send is in progress", "Warning", 2);
                }
            }
        }
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        int num = Integer.parseInt(this.deviceID.substring(4)) - 1;
        retVal = retVal + "29 " + this.getCommonData() + num + " " + this.betaFactor + " " + this.compensation;
        return retVal;
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
        } else {
            String value = "";
            int msgAddress = Integer.parseInt(cmd.getValue("ADDRESS"));
            value = cmd.getValue("TOKEN3");
            switch (msgAddress - (Integer)this.addressList.get(0) - 2) {
                case 0: {
                    ((SimplePropertiesDlg)this.propertiesDialog).txtMinOut.setText(value);
                    this.betaFactor = value;
                    break;
                }
                case 1: {
                    ((SimplePropertiesDlg)this.propertiesDialog).txtMaxOut.setText(value);
                    this.compensation = value;
                }
            }
        }
        this.propertiesDialog.invalidate();
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(((SimplePropertiesDlg)this.propertiesDialog).btnOk)) {
            if (((SimplePropertiesDlg)this.propertiesDialog).fieldChanged) {
                this.addressList.clear();
                for (int i = 0; i < this.addressSpace; ++i) {
                    this.addressList.add(Integer.parseInt(this.getAddress()) + i);
                }
                this.addressList.size();
            }
            this.propertiesDialog.setVisible(false);
        } else if (e.getSource().equals(((SimplePropertiesDlg)this.propertiesDialog).btnCancel)) {
            this.propertiesDialog.setVisible(false);
        } else if (e.getSource().equals(this.simDialog.btnExit)) {
            this.simDialogClosed();
        }
    }

    @Override
    public void setConnectionStatus(boolean isConnected) {
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "Beta", this.betaFactor);
        SceneSerializer.setAttribute(document, nodeElement, "Compensation", this.compensation);
        SceneSerializer.setAttribute(document, nodeElement, "DigitalIN", this.isDigitalInput.toString());
        this.serializeSimParams(document, nodeElement);
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        String digIn;
        this.deviceID = SceneSerializer.getAttributeValue(node, "driverID");
        ((AFONodeWidget)this.widget).setSubType(this.deviceID);
        this.betaFactor = SceneSerializer.getAttributeValue(node, "Beta");
        if (this.betaFactor == null) {
            this.betaFactor = "3900";
        }
        this.compensation = SceneSerializer.getAttributeValue(node, "Compensation");
        if (this.compensation == null) {
            this.compensation = "0.0";
        }
        this.isDigitalInput = (digIn = SceneSerializer.getAttributeValue(node, "DigitalIN")) == null ? Boolean.valueOf(false) : Boolean.valueOf(Boolean.parseBoolean(digIn));
        this.deserializeSimParam(node);
    }

    @Override
    public void initSimulation() {
        super.initSimulation();
        this.simInputTimer = new GenericNode.SimTimer();
        this.simDialog.setTitle(this.deviceID);
    }

    @Override
    public void simulate() {
        double x;
        super.simulate();
        GenericNode.SimData out = this.GetMData(0);
        out.data = x = this.waveGenerator();
        out.isValid = true;
        this.SetMData(0, out);
        this.updateSimOutputs();
    }

    @Override
    public void showSimulationDialog() {
        super.showSimulationDialog();
    }

    @Override
    protected void simDialogClosed() {
        super.simDialogClosed();
    }
}

