/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import VisiProg.AppOptions;
import connection.ICmd;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.GenericNode;
import nodes.gui.PidPropertiesDialog;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class PIDNode
extends GenericNode {
    public String[] pidParameters = new String[]{"30.0", "0.05", "0.0", "10.0", "1.0", "0.0"};
    public String[] pidSetpoint = new String[]{"20.0", "35.0", "15.0"};
    private static AppOptions options = new AppOptions();
    boolean isSummer = false;
    private boolean force10VoltOut = true;
    private int scaleFactorIndex = 0;
    private static final String PID_SETPOINT = "setpoint";
    private static final String PID_SETPOINTH = "setpointh";
    private static final String PID_SETPOINTL = "setpointl";
    private static final String PID_KP = "kp";
    private static final String PID_KI = "ki";
    private static final String PID_KD = "kd";
    private static final String PID_KP2 = "kp2";
    private static final String PID_KI2 = "ki2";
    private static final String PID_KD2 = "kd2";
    private static final String PID_SUMMER = "summer";
    private static final String PID_FORCE10VOUT = "force10VOut";
    private static final String PID_SCALEFACTOR = "scaleFactor";
    public static final int PID_ID = 11;
    static final double PID_MAX_OUTPUT = 1000.0;
    static final int PID_RUN_INTERVAL_MS = 150;
    final int PID1 = 0;
    final int PID2 = 1;
    final int PID3 = 2;
    double[] m_IntegralState = new double[]{0.0, 0.0, 0.0};
    double[] m_DerivativeState = new double[]{0.0, 0.0, 0.0};
    double[] m_MaxIntegralError = new double[]{1000.0, 1000.0, 1000.0};
    double m_ScaleFactor;
    static final double[] scaleArray = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0};
    GenericNode.SimTimer m_RunInterval;

    public PIDNode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        this.blockType = CommonDefinitions.blockTypes.PID;
        this.subType = CommonDefinitions.subBlockTypes.PID_LIMIT;
        options.LoadOptions();
        this.currentLocale = new Locale(PIDNode.options.language, PIDNode.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        this.addressSpace = 14;
        this.numberOfInputs = 0;
        this.CreateWidget();
        this.CreatePropertiesDialog();
        this.codici = new ArrayList();
        this.codici.add(0, "PID");
        this.codici.add(1, "OUT_PID");
        this.codici.add(2, "SetPoint_PID");
        this.codici.add(3, "SetpointH_PID");
        this.codici.add(4, "SetpointL_PID");
        this.codici.add(5, "Summer_PID");
        this.codici.add(6, "Kp_diretto");
        this.codici.add(7, "Ti_diretto");
        this.codici.add(8, "Td_diretto");
        this.codici.add(9, "Kp_limite");
        this.codici.add(10, "Ti_limite");
        this.codici.add(11, "Td_limite");
        this.codici.add(12, "Forzatura0_10V");
        this.codici.add(13, "Scala Parametri");
        this.setList(this.codici);
        this.cleanSimDialog();
    }

    public String getAddress() {
        String newAddress = ((PidPropertiesDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("PID Limit");
        this.getScene().addNode(this);
        String pinLabel = "OUT";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Ctrl IN";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "LM IN";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Setpoint";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Summer";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "SPH";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "SPL";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Kp1";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "KI1";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "KD1";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Kp2";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "KI2";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "KD2";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "EN";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "RESET";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new PidPropertiesDialog(null, true, this);
        ((PidPropertiesDialog)this.propertiesDialog).txtAddress.setText("NA");
        ((PidPropertiesDialog)this.propertiesDialog).setTitle("PID Properties");
    }

    private void setDialogFields() {
        ((PidPropertiesDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((PidPropertiesDialog)this.propertiesDialog).txtKP1.setText(this.pidParameters[0]);
        ((PidPropertiesDialog)this.propertiesDialog).txtTI1.setText(this.pidParameters[1]);
        ((PidPropertiesDialog)this.propertiesDialog).txtTD1.setText(this.pidParameters[2]);
        ((PidPropertiesDialog)this.propertiesDialog).txtKP2.setText(this.pidParameters[3]);
        ((PidPropertiesDialog)this.propertiesDialog).txtTI2.setText(this.pidParameters[4]);
        ((PidPropertiesDialog)this.propertiesDialog).txtTD2.setText(this.pidParameters[5]);
        ((PidPropertiesDialog)this.propertiesDialog).txtSetpoint.setText(this.pidSetpoint[0]);
        ((PidPropertiesDialog)this.propertiesDialog).txtSetpointH.setText(this.pidSetpoint[1]);
        ((PidPropertiesDialog)this.propertiesDialog).txtSetpointL.setText(this.pidSetpoint[2]);
        ((PidPropertiesDialog)this.propertiesDialog).checkSummer.setSelected(this.isSummer);
        ((PidPropertiesDialog)this.propertiesDialog).checkForce10VoltOut.setSelected(this.force10VoltOut);
        ((PidPropertiesDialog)this.propertiesDialog).comboScaleFactor.setSelectedIndex(this.scaleFactorIndex);
    }

    private void getDialogFields() {
        this.pidParameters[0] = ((PidPropertiesDialog)this.propertiesDialog).txtKP1.getText();
        this.pidParameters[1] = ((PidPropertiesDialog)this.propertiesDialog).txtTI1.getText();
        this.pidParameters[2] = ((PidPropertiesDialog)this.propertiesDialog).txtTD2.getText();
        this.pidParameters[3] = ((PidPropertiesDialog)this.propertiesDialog).txtKP2.getText();
        this.pidParameters[4] = ((PidPropertiesDialog)this.propertiesDialog).txtTI2.getText();
        this.pidParameters[5] = ((PidPropertiesDialog)this.propertiesDialog).txtTD2.getText();
        this.pidSetpoint[0] = ((PidPropertiesDialog)this.propertiesDialog).txtSetpoint.getText();
        this.pidSetpoint[1] = ((PidPropertiesDialog)this.propertiesDialog).txtSetpointH.getText();
        this.pidSetpoint[2] = ((PidPropertiesDialog)this.propertiesDialog).txtSetpointL.getText();
        this.isSummer = ((PidPropertiesDialog)this.propertiesDialog).checkSummer.isSelected();
        this.force10VoltOut = ((PidPropertiesDialog)this.propertiesDialog).checkForce10VoltOut.isSelected();
        this.scaleFactorIndex = ((PidPropertiesDialog)this.propertiesDialog).comboScaleFactor.getSelectedIndex();
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        this.requestData();
        this.setDialogFields();
        ((PidPropertiesDialog)this.propertiesDialog).indexLabel.setVisible(false);
        this.propertiesDialog.setModal(true);
        this.propertiesDialog.setVisible(true);
        if (((PidPropertiesDialog)this.propertiesDialog).getReturnStatus() == 1) {
            if (!((PidPropertiesDialog)this.propertiesDialog).fieldChanged) {
                return;
            }
            this.getDialogFields();
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.scene.sceneChanged();
            if (this.kernel != null && this.kernel.isConnected()) {
                if (!this.sendingCommandQueue.booleanValue()) {
                    this.commandQueue.clear();
                    int offset = 2;
                    String msg = "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " " + ((PidPropertiesDialog)this.propertiesDialog).txtSetpoint.getText() + " >";
                    this.commandQueue.add(msg);
                    msg = "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " " + ((PidPropertiesDialog)this.propertiesDialog).txtSetpointH.getText() + " >";
                    this.commandQueue.add(msg);
                    msg = "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " " + ((PidPropertiesDialog)this.propertiesDialog).txtSetpointL.getText() + " >";
                    this.commandQueue.add(msg);
                    msg = ((PidPropertiesDialog)this.propertiesDialog).checkSummer.isSelected() ? "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " 1.0 >" : "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " 0.0 >";
                    this.commandQueue.add(msg);
                    msg = "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " " + ((PidPropertiesDialog)this.propertiesDialog).txtKP1.getText() + " >";
                    this.commandQueue.add(msg);
                    msg = "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " " + ((PidPropertiesDialog)this.propertiesDialog).txtTI1.getText() + " >";
                    this.commandQueue.add(msg);
                    msg = "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " " + ((PidPropertiesDialog)this.propertiesDialog).txtTD1.getText() + " >";
                    this.commandQueue.add(msg);
                    msg = "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " " + ((PidPropertiesDialog)this.propertiesDialog).txtKP2.getText() + " >";
                    this.commandQueue.add(msg);
                    msg = "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " " + ((PidPropertiesDialog)this.propertiesDialog).txtTI2.getText() + " >";
                    this.commandQueue.add(msg);
                    msg = "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " " + ((PidPropertiesDialog)this.propertiesDialog).txtTD2.getText() + " >";
                    this.commandQueue.add(msg);
                    msg = ((PidPropertiesDialog)this.propertiesDialog).checkForce10VoltOut.isSelected() ? "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " 1.0 >" : "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " 0.0 >";
                    this.commandQueue.add(msg);
                    msg = "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " " + ((PidPropertiesDialog)this.propertiesDialog).comboScaleFactor.getSelectedIndex() + " >";
                    this.commandQueue.add(msg);
                    this.sendMessageQueue(true);
                } else {
                    JOptionPane.showMessageDialog(null, "Another Send is in progress", "Warning", 2);
                }
            }
        }
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "subType", this.subType.toString());
        SceneSerializer.setAttribute(document, nodeElement, PID_SETPOINT, this.pidSetpoint[0]);
        SceneSerializer.setAttribute(document, nodeElement, PID_SETPOINTH, this.pidSetpoint[1]);
        SceneSerializer.setAttribute(document, nodeElement, PID_SETPOINTL, this.pidSetpoint[2]);
        SceneSerializer.setAttribute(document, nodeElement, PID_KP, this.pidParameters[0]);
        SceneSerializer.setAttribute(document, nodeElement, PID_KI, this.pidParameters[1]);
        SceneSerializer.setAttribute(document, nodeElement, PID_KD, this.pidParameters[2]);
        SceneSerializer.setAttribute(document, nodeElement, PID_KP2, this.pidParameters[3]);
        SceneSerializer.setAttribute(document, nodeElement, PID_KI2, this.pidParameters[4]);
        SceneSerializer.setAttribute(document, nodeElement, PID_KD2, this.pidParameters[5]);
        SceneSerializer.setAttribute(document, nodeElement, PID_SUMMER, Boolean.toString(this.isSummer));
        SceneSerializer.setAttribute(document, nodeElement, PID_FORCE10VOUT, Boolean.toString(this.force10VoltOut));
        SceneSerializer.setAttribute(document, nodeElement, PID_SCALEFACTOR, Integer.toString(this.scaleFactorIndex));
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        this.pidSetpoint[0] = SceneSerializer.getAttributeValue(node, PID_SETPOINT);
        this.pidSetpoint[1] = SceneSerializer.getAttributeValue(node, PID_SETPOINTH);
        this.pidSetpoint[2] = SceneSerializer.getAttributeValue(node, PID_SETPOINTL);
        this.pidParameters[0] = SceneSerializer.getAttributeValue(node, PID_KP);
        this.pidParameters[1] = SceneSerializer.getAttributeValue(node, PID_KI);
        this.pidParameters[2] = SceneSerializer.getAttributeValue(node, PID_KD);
        this.pidParameters[3] = SceneSerializer.getAttributeValue(node, PID_KP2);
        this.pidParameters[4] = SceneSerializer.getAttributeValue(node, PID_KI2);
        this.pidParameters[5] = SceneSerializer.getAttributeValue(node, PID_KD2);
        this.isSummer = Boolean.parseBoolean(SceneSerializer.getAttributeValue(node, PID_SUMMER));
        try {
            this.force10VoltOut = Boolean.parseBoolean(SceneSerializer.getAttributeValue(node, PID_FORCE10VOUT));
        }
        catch (Exception ex) {
            this.force10VoltOut = true;
        }
        try {
            this.scaleFactorIndex = Integer.parseInt(SceneSerializer.getAttributeValue(node, PID_SCALEFACTOR));
        }
        catch (Exception ex) {
            this.scaleFactorIndex = 0;
        }
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        float type = Float.parseFloat(" " + ((double)(this.subType.ordinal() - CommonDefinitions.subBlockTypes.PID_PF.ordinal()) + 1.0));
        retVal = retVal + "11 " + this.getCommonData() + " ";
        retVal = retVal + this.pidSetpoint[0] + " " + this.pidSetpoint[1] + " " + this.pidSetpoint[2];
        retVal = retVal + " " + (float)this.boolToInteger(this.isSummer).intValue();
        retVal = retVal + " " + this.pidParameters[0] + " " + this.pidParameters[1] + " " + this.pidParameters[2];
        retVal = retVal + " " + this.pidParameters[3] + " " + this.pidParameters[4] + " " + this.pidParameters[5];
        retVal = retVal + " " + (float)this.boolToInteger(this.force10VoltOut).intValue();
        retVal = retVal + " " + (float)this.scaleFactorIndex;
        return retVal;
    }

    @Override
    public void setConnectionStatus(boolean isConnected) {
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
        } else {
            String value = "";
            int msgAddress = Integer.parseInt(cmd.getValue("ADDRESS"));
            value = cmd.getValue("TOKEN3");
            switch (msgAddress - (Integer)this.addressList.get(0) - 2) {
                case 0: {
                    ((PidPropertiesDialog)this.propertiesDialog).txtSetpoint.setText(value);
                    this.pidSetpoint[0] = value;
                    break;
                }
                case 1: {
                    ((PidPropertiesDialog)this.propertiesDialog).txtSetpointH.setText(value);
                    this.pidSetpoint[1] = value;
                    break;
                }
                case 2: {
                    ((PidPropertiesDialog)this.propertiesDialog).txtSetpointL.setText(value);
                    this.pidSetpoint[2] = value;
                    break;
                }
                case 3: {
                    if ((double)Float.parseFloat(value) == 0.0) {
                        ((PidPropertiesDialog)this.propertiesDialog).checkSummer.setSelected(false);
                        this.isSummer = false;
                        break;
                    }
                    ((PidPropertiesDialog)this.propertiesDialog).checkSummer.setSelected(true);
                    this.isSummer = true;
                    break;
                }
                case 4: {
                    ((PidPropertiesDialog)this.propertiesDialog).txtKP1.setText(value);
                    this.pidParameters[0] = value;
                    break;
                }
                case 5: {
                    ((PidPropertiesDialog)this.propertiesDialog).txtTI1.setText(value);
                    this.pidParameters[1] = value;
                    break;
                }
                case 6: {
                    ((PidPropertiesDialog)this.propertiesDialog).txtTD1.setText(value);
                    this.pidParameters[2] = value;
                    break;
                }
                case 7: {
                    ((PidPropertiesDialog)this.propertiesDialog).txtKP2.setText(value);
                    this.pidParameters[3] = value;
                    break;
                }
                case 8: {
                    ((PidPropertiesDialog)this.propertiesDialog).txtTI2.setText(value);
                    this.pidParameters[4] = value;
                    break;
                }
                case 9: {
                    ((PidPropertiesDialog)this.propertiesDialog).txtTD2.setText(value);
                    this.pidParameters[5] = value;
                    break;
                }
                case 10: {
                    if ((double)Float.parseFloat(value) == 0.0) {
                        ((PidPropertiesDialog)this.propertiesDialog).checkForce10VoltOut.setSelected(false);
                        this.force10VoltOut = false;
                        break;
                    }
                    ((PidPropertiesDialog)this.propertiesDialog).checkForce10VoltOut.setSelected(true);
                    this.force10VoltOut = true;
                    break;
                }
                case 11: {
                    try {
                        int selIndex = (int)Float.parseFloat(value);
                        ((PidPropertiesDialog)this.propertiesDialog).comboScaleFactor.setSelectedIndex(selIndex);
                        break;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        this.propertiesDialog.invalidate();
        return true;
    }

    @Override
    public void initSimulation() {
        super.initSimulation();
        this.registerArray.add(Double.parseDouble(this.pidSetpoint[0]));
        this.registerArray.add(Double.parseDouble(this.pidSetpoint[1]));
        this.registerArray.add(Double.parseDouble(this.pidSetpoint[2]));
        this.registerArray.add(this.boolToDouble(this.isSummer));
        this.registerArray.add(Double.parseDouble(this.pidParameters[0]));
        this.registerArray.add(Double.parseDouble(this.pidParameters[1]));
        this.registerArray.add(Double.parseDouble(this.pidParameters[2]));
        this.registerArray.add(Double.parseDouble(this.pidParameters[3]));
        this.registerArray.add(Double.parseDouble(this.pidParameters[4]));
        this.registerArray.add(Double.parseDouble(this.pidParameters[5]));
        this.registerArray.add(this.boolToDouble(this.force10VoltOut));
        this.registerArray.add(Double.valueOf(this.scaleFactorIndex));
        for (int i = 0; i < 3; ++i) {
            this.m_IntegralState[i] = 0.0;
            this.m_DerivativeState[i] = 0.0;
        }
        this.SetupInternals();
        this.m_RunInterval = new GenericNode.SimTimer();
    }

    void AcquireParamIn() {
        Double param = 0.0;
        try {
            param = ((GenericNode.SimData)this.inputData.get((int)e_PID_INPUTS.PID_IN_SPH.ordinal())).connected ? Double.valueOf(this.GetInputData(e_PID_INPUTS.PID_IN_SPH.ordinal())) : Double.valueOf(Double.parseDouble(this.pidSetpoint[1]));
            this.setParameter(e_PID_PARAMS.PID_PARAM_SPH.ordinal(), param);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            param = ((GenericNode.SimData)this.inputData.get((int)e_PID_INPUTS.PID_IN_SPL.ordinal())).connected ? Double.valueOf(this.GetInputData(e_PID_INPUTS.PID_IN_SPL.ordinal())) : Double.valueOf(Double.parseDouble(this.pidSetpoint[2]));
            this.setParameter(e_PID_PARAMS.PID_PARAM_SPL.ordinal(), param);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            param = ((GenericNode.SimData)this.inputData.get((int)e_PID_INPUTS.PID_IN_KP1.ordinal())).connected ? Double.valueOf(this.GetInputData(e_PID_INPUTS.PID_IN_KP1.ordinal())) : Double.valueOf(Double.parseDouble(this.pidParameters[0]));
            this.setParameter(e_PID_PARAMS.PID_PARAM_KP1.ordinal(), param);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            param = ((GenericNode.SimData)this.inputData.get((int)e_PID_INPUTS.PID_IN_KI1.ordinal())).connected ? Double.valueOf(this.GetInputData(e_PID_INPUTS.PID_IN_KI1.ordinal())) : Double.valueOf(Double.parseDouble(this.pidParameters[1]));
            this.setParameter(e_PID_PARAMS.PID_PARAM_TI1.ordinal(), param);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            param = ((GenericNode.SimData)this.inputData.get((int)e_PID_INPUTS.PID_IN_KD1.ordinal())).connected ? Double.valueOf(this.GetInputData(e_PID_INPUTS.PID_IN_KD1.ordinal())) : Double.valueOf(Double.parseDouble(this.pidParameters[2]));
            this.setParameter(e_PID_PARAMS.PID_PARAM_TD1.ordinal(), param);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            param = ((GenericNode.SimData)this.inputData.get((int)e_PID_INPUTS.PID_IN_KP2.ordinal())).connected ? Double.valueOf(this.GetInputData(e_PID_INPUTS.PID_IN_KP2.ordinal())) : Double.valueOf(Double.parseDouble(this.pidParameters[3]));
            this.setParameter(e_PID_PARAMS.PID_PARAM_KP2.ordinal(), param);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            param = ((GenericNode.SimData)this.inputData.get((int)e_PID_INPUTS.PID_IN_KI2.ordinal())).connected ? Double.valueOf(this.GetInputData(e_PID_INPUTS.PID_IN_KI2.ordinal())) : Double.valueOf(Double.parseDouble(this.pidParameters[4]));
            this.setParameter(e_PID_PARAMS.PID_PARAM_TI2.ordinal(), param);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            param = ((GenericNode.SimData)this.inputData.get((int)e_PID_INPUTS.PID_IN_KD2.ordinal())).connected ? Double.valueOf(this.GetInputData(e_PID_INPUTS.PID_IN_KD2.ordinal())) : Double.valueOf(Double.parseDouble(this.pidParameters[5]));
            this.setParameter(e_PID_PARAMS.PID_PARAM_TD2.ordinal(), param);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.SetupInternals();
    }

    void SetupInternals() {
        this.m_ScaleFactor = 1.0;
        if (this.GetParameter(e_PID_PARAMS.PID_PARAM_SCALEFACTOR.ordinal()) < 0.0 || this.GetParameter(e_PID_PARAMS.PID_PARAM_SCALEFACTOR.ordinal()) >= (double)e_PID_SCALE.PID_NUM_SCALE.ordinal()) {
            this.m_ScaleFactor = 1.0;
        } else {
            int index = (int)this.GetParameter(e_PID_PARAMS.PID_PARAM_SCALEFACTOR.ordinal());
            this.m_ScaleFactor = scaleArray[index];
        }
        this.m_MaxIntegralError[0] = this.GetParameter(e_PID_PARAMS.PID_PARAM_TI1.ordinal()) > 0.0 ? 1000.0 / (this.GetParameter(e_PID_PARAMS.PID_PARAM_TI1.ordinal()) / this.m_ScaleFactor) : 1000.0;
        if (this.GetParameter(e_PID_PARAMS.PID_PARAM_TI2.ordinal()) > 0.0) {
            this.m_MaxIntegralError[1] = 1000.0 / (this.GetParameter(e_PID_PARAMS.PID_PARAM_TI2.ordinal()) / this.m_ScaleFactor);
            this.m_MaxIntegralError[2] = 1000.0 / (this.GetParameter(e_PID_PARAMS.PID_PARAM_TI2.ordinal()) / this.m_ScaleFactor);
        } else {
            this.m_MaxIntegralError[1] = 1000.0;
            this.m_MaxIntegralError[2] = 1000.0;
        }
    }

    @Override
    public void simulate() {
        super.simulate();
        double performUpdate = 1.0;
        this.GetSummer();
        this.GetSetpoint();
        if (!this.m_RunInterval.isTimerExpired()) {
            return;
        }
        GenericNode.SimData out = this.GetMData(0);
        this.m_RunInterval.setTimer(150);
        if (this.isInputConnected(e_PID_INPUTS.PID_IN_RESET.ordinal())) {
            Double val = 0.0;
            try {
                val = this.GetInputData(e_PID_INPUTS.PID_IN_RESET.ordinal());
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (val != 0.0) {
                this.m_IntegralState[0] = 0.0;
                this.m_IntegralState[1] = 0.0;
                this.m_IntegralState[2] = 0.0;
                out.isValid = true;
                out.data = 0.0;
                this.SetMData(0, out);
                this.updateSimOutputs();
                return;
            }
        }
        if (this.isInputConnected(e_PID_INPUTS.PID_IN_EN.ordinal())) {
            try {
                performUpdate = this.GetInputData(e_PID_INPUTS.PID_IN_EN.ordinal());
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (performUpdate == 0.0) {
                if (out.data < 0.0) {
                    out.data = 0.0;
                }
                out.isValid = true;
                this.SetMData(0, out);
                this.updateSimOutputs();
                return;
            }
        }
        this.AcquireParamIn();
        if (this.isInputConnected(e_PID_INPUTS.PID_IN_LMD.ordinal())) {
            this.UpdateLMDControl();
        } else {
            this.UpdateSimpleControl();
        }
        this.updateSimOutputs();
    }

    void GetSetpoint() {
        double newSP = 0.0;
        try {
            newSP = ((GenericNode.SimData)this.inputData.get((int)e_PID_INPUTS.PID_IN_SP.ordinal())).connected ? this.GetInputData(e_PID_INPUTS.PID_IN_SP.ordinal()) : Double.parseDouble(this.pidSetpoint[0]);
            this.setParameter(e_PID_PARAMS.PID_PARAM_SP.ordinal(), newSP);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void UpdateSimpleControl() {
        Double controlVar = 0.0;
        Double error1 = 0.0;
        Double pid1_Output = 0.0;
        GenericNode.SimData out = this.GetMData(0);
        try {
            controlVar = this.GetInputData(e_PID_INPUTS.PID_IN_CTRL.ordinal());
        }
        catch (Exception ex) {
            this.invalidateOutputs();
            this.updateSimOutputs();
            return;
        }
        error1 = this.GetParameter(e_PID_PARAMS.PID_PARAM_SUMMER.ordinal()) != 0.0 ? Double.valueOf(controlVar - this.GetParameter(e_PID_PARAMS.PID_PARAM_SP.ordinal())) : Double.valueOf(this.GetParameter(e_PID_PARAMS.PID_PARAM_SP.ordinal()) - controlVar);
        pid1_Output = this.GetParameter(e_PID_PARAMS.PID_PARAM_KP1.ordinal()) / this.m_ScaleFactor * error1 + this.GetParameter(e_PID_PARAMS.PID_PARAM_TI1.ordinal()) / this.m_ScaleFactor * this.Integrate(0, error1) + this.GetParameter(e_PID_PARAMS.PID_PARAM_TD1.ordinal()) / this.m_ScaleFactor * this.Derivate(0, error1);
        if (pid1_Output > 1000.0) {
            pid1_Output = 1000.0;
        } else if (pid1_Output < 0.0) {
            pid1_Output = 0.0;
        }
        if (this.GetParameter(e_PID_PARAMS.PID_PARAM_FORCE10V.ordinal()) != 0.0) {
            pid1_Output = pid1_Output / 100.0;
        }
        out.data = pid1_Output;
        out.isValid = true;
        this.SetMData(0, out);
    }

    void UpdateLMDControl() {
        Double controlVar = 0.0;
        Double error1 = 0.0;
        Double limitVar = 0.0;
        Double error2 = 0.0;
        Double error3 = 0.0;
        Double pid1_Output = 0.0;
        Double pid2_Output = 0.0;
        Double pid3_Output = 0.0;
        GenericNode.SimData out = this.GetMData(0);
        try {
            controlVar = this.GetInputData(e_PID_INPUTS.PID_IN_CTRL.ordinal());
        }
        catch (Exception ex) {
            this.invalidateOutputs();
            this.updateSimOutputs();
            return;
        }
        error1 = this.GetParameter(e_PID_PARAMS.PID_PARAM_SUMMER.ordinal()) != 0.0 ? Double.valueOf(controlVar - this.GetParameter(e_PID_PARAMS.PID_PARAM_SP.ordinal())) : Double.valueOf(this.GetParameter(e_PID_PARAMS.PID_PARAM_SP.ordinal()) - controlVar);
        pid1_Output = this.GetParameter(e_PID_PARAMS.PID_PARAM_KP1.ordinal()) / this.m_ScaleFactor * error1 + this.GetParameter(e_PID_PARAMS.PID_PARAM_TI1.ordinal()) / this.m_ScaleFactor * this.Integrate(0, error1) + this.GetParameter(e_PID_PARAMS.PID_PARAM_TD1.ordinal()) / this.m_ScaleFactor * this.Derivate(0, error1);
        if (pid1_Output > 1000.0) {
            pid1_Output = 1000.0;
        } else if (pid1_Output < 0.0) {
            pid1_Output = 0.0;
        }
        try {
            limitVar = this.GetInputData(e_PID_INPUTS.PID_IN_LMD.ordinal());
        }
        catch (Exception ex) {
            this.invalidateOutputs();
            this.updateSimOutputs();
            return;
        }
        if (this.GetParameter(e_PID_PARAMS.PID_PARAM_SUMMER.ordinal()) != 0.0) {
            error2 = this.GetParameter(e_PID_PARAMS.PID_PARAM_SPL.ordinal()) - limitVar;
            error3 = limitVar - this.GetParameter(e_PID_PARAMS.PID_PARAM_SPH.ordinal());
        } else {
            error2 = limitVar - this.GetParameter(e_PID_PARAMS.PID_PARAM_SPH.ordinal());
            error3 = this.GetParameter(e_PID_PARAMS.PID_PARAM_SPL.ordinal()) - limitVar;
        }
        pid2_Output = this.GetParameter(e_PID_PARAMS.PID_PARAM_KP2.ordinal()) / this.m_ScaleFactor * error2 + this.GetParameter(e_PID_PARAMS.PID_PARAM_TI2.ordinal()) / this.m_ScaleFactor * this.Integrate(1, error2) + this.GetParameter(e_PID_PARAMS.PID_PARAM_TD2.ordinal()) / this.m_ScaleFactor * this.Derivate(1, error2);
        pid3_Output = this.GetParameter(e_PID_PARAMS.PID_PARAM_KP2.ordinal()) / this.m_ScaleFactor * error3 + this.GetParameter(e_PID_PARAMS.PID_PARAM_TI2.ordinal()) / this.m_ScaleFactor * this.Integrate(2, error3) + this.GetParameter(e_PID_PARAMS.PID_PARAM_TD2.ordinal()) / this.m_ScaleFactor * this.Derivate(2, error3);
        if (pid2_Output > 1000.0) {
            pid2_Output = 1000.0;
        } else if (pid2_Output < 0.0) {
            pid2_Output = 0.0;
        }
        if (pid3_Output > 1000.0) {
            pid3_Output = 1000.0;
        } else if (pid3_Output < 0.0) {
            pid3_Output = 0.0;
        }
        double pidOutput = pid1_Output - pid2_Output + pid3_Output;
        if (pidOutput > 1000.0) {
            pidOutput = 1000.0;
        } else if (pidOutput < 0.0) {
            pidOutput = 0.0;
        }
        if (this.GetParameter(e_PID_PARAMS.PID_PARAM_FORCE10V.ordinal()) != 0.0) {
            pidOutput /= 100.0;
        }
        out.data = pidOutput;
        out.isValid = true;
        this.SetMData(0, out);
    }

    void GetSummer() {
        Double summer = 0.0;
        try {
            summer = ((GenericNode.SimData)this.inputData.get((int)e_PID_INPUTS.PID_IN_SUM.ordinal())).connected ? Double.valueOf(this.GetInputData(e_PID_INPUTS.PID_IN_SUM.ordinal())) : Double.valueOf(this.boolToDouble(this.isSummer));
            this.setParameter(e_PID_PARAMS.PID_PARAM_SUMMER.ordinal(), summer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    double Integrate(int pidIndex, double value) {
        int n = pidIndex;
        this.m_IntegralState[n] = this.m_IntegralState[n] + value;
        if (this.m_IntegralState[pidIndex] > this.m_MaxIntegralError[pidIndex]) {
            this.m_IntegralState[pidIndex] = this.m_MaxIntegralError[pidIndex];
        } else if (this.m_IntegralState[pidIndex] < 0.0) {
            this.m_IntegralState[pidIndex] = 0.0;
        }
        return this.m_IntegralState[pidIndex];
    }

    double Derivate(int pidIndex, double value) {
        double retVal = 0.0;
        retVal = value - this.m_DerivativeState[pidIndex];
        this.m_DerivativeState[pidIndex] = value;
        return retVal;
    }

    static enum e_PID_INPUTS {
        PID_IN_CTRL,
        PID_IN_LMD,
        PID_IN_SP,
        PID_IN_SUM,
        PID_IN_SPH,
        PID_IN_SPL,
        PID_IN_KP1,
        PID_IN_KI1,
        PID_IN_KD1,
        PID_IN_KP2,
        PID_IN_KI2,
        PID_IN_KD2,
        PID_IN_EN,
        PID_IN_RESET,
        PID_NUM_INPUTS;

    }

    static enum e_PID_SCALE {
        PID_SCALE_1,
        PID_SCALE_10,
        PID_SCALE_100,
        PID_SCALE_1000,
        PID_SCALE_10000,
        PID_NUM_SCALE;

    }

    static enum e_PID_PARAMS {
        PID_PARAM_SP,
        PID_PARAM_SPH,
        PID_PARAM_SPL,
        PID_PARAM_SUMMER,
        PID_PARAM_KP1,
        PID_PARAM_TI1,
        PID_PARAM_TD1,
        PID_PARAM_KP2,
        PID_PARAM_TI2,
        PID_PARAM_TD2,
        PID_PARAM_FORCE10V,
        PID_PARAM_SCALEFACTOR,
        PID_NUM_PARAM;

    }

    public static enum Type {
        PID,
        SetPoint,
        SetPointH,
        SetPointL,
        summer,
        Kp_diretto,
        Ti_diretto,
        Td_diretto,
        Kp_limite,
        Ti_limite,
        Td_limite,
        Forzatura0_10V;

    }
}

