/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import VisiProg.AppOptions;
import connection.ICmd;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.GenericNode;
import nodes.gui.PidSingleDialog;
import org.jfree.ui.RefineryUtilities;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class PIDSingleNode
extends GenericNode {
    public String[] pidParameters = new String[]{"5.0", "30.0", "0.0"};
    public String pidSetpoint = "20";
    private static AppOptions options = new AppOptions();
    boolean isSummer = false;
    String neutralZone = "0.1";
    private static final String PID_SETPOINT = "setpoint";
    private static final String PID_BP = "Bp";
    private static final String PID_TI = "Ti";
    private static final String PID_TD = "Td";
    private static final String PID_SUMMER = "summer";
    private static final String PID_NEUTRAL = "neutral";
    public static final int PID_ID_2 = 37;
    static final double PID2_MAX_OUTPUT = 10.0;
    double m_MaxIntegralError = 10.0;
    double m_IntegralState = 0.0;
    double m_DerivativeState = 0.0;
    double m_LastError = 0.0;
    double m_LastPidOutput = 0.0;
    double m_LastPropOutput = 0.0;
    long m_LastTimeSlice;
    GenericNode.SimTimer m_IntegralTimer;
    GenericNode.SimTimer m_DerivativeTimer;

    public PIDSingleNode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        this.blockType = CommonDefinitions.blockTypes.PID;
        this.subType = CommonDefinitions.subBlockTypes.PID_SINGLE;
        options.LoadOptions();
        this.currentLocale = new Locale(PIDSingleNode.options.language, PIDSingleNode.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        this.addressSpace = 8;
        this.numberOfInputs = 0;
        this.CreateWidget();
        this.CreatePropertiesDialog();
        this.codici = new ArrayList();
        this.codici.add(0, "PID");
        this.codici.add(1, "OUT_PID");
        this.codici.add(2, "SetPoint_PID");
        this.codici.add(3, "Summer_PID");
        this.codici.add(4, PID_BP);
        this.codici.add(5, PID_TI);
        this.codici.add(6, PID_TD);
        this.codici.add(7, "Neutral");
        this.setList(this.codici);
        this.cleanSimDialog();
    }

    public String getAddress() {
        String newAddress = ((PidSingleDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("PID Single");
        this.getScene().addNode(this);
        String pinLabel = "OUT";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Ctrl IN";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Setpoint";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Summer";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "BP";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "TI";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "TD";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "BN";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "EN";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "RESET";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        ++this.numberOfInputs;
        newPin.setPinIDString("IN" + this.numberOfInputs);
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new PidSingleDialog(null, true, this);
        ((PidSingleDialog)this.propertiesDialog).txtAddress.setText("NA");
        ((PidSingleDialog)this.propertiesDialog).setTitle("PID Properties");
    }

    private void setDialogFields() {
        ((PidSingleDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((PidSingleDialog)this.propertiesDialog).txtSetpoint.setText(this.pidSetpoint);
        ((PidSingleDialog)this.propertiesDialog).txtBandaProp.setText(this.pidParameters[0]);
        ((PidSingleDialog)this.propertiesDialog).txtTempoIntegrale.setText(this.pidParameters[1]);
        ((PidSingleDialog)this.propertiesDialog).txtTempoDerivativo.setText(this.pidParameters[2]);
        ((PidSingleDialog)this.propertiesDialog).txtBandaNeutra.setText(this.neutralZone);
        ((PidSingleDialog)this.propertiesDialog).chkSummer.setSelected(this.isSummer);
    }

    private void getDialogFields() {
        this.pidSetpoint = ((PidSingleDialog)this.propertiesDialog).txtSetpoint.getText();
        this.pidParameters[0] = ((PidSingleDialog)this.propertiesDialog).txtBandaProp.getText();
        this.pidParameters[1] = ((PidSingleDialog)this.propertiesDialog).txtTempoIntegrale.getText();
        this.pidParameters[2] = ((PidSingleDialog)this.propertiesDialog).txtTempoDerivativo.getText();
        this.neutralZone = ((PidSingleDialog)this.propertiesDialog).txtBandaNeutra.getText();
        this.isSummer = ((PidSingleDialog)this.propertiesDialog).chkSummer.isSelected();
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        this.requestData();
        this.setDialogFields();
        RefineryUtilities.centerFrameOnScreen((Window)this.propertiesDialog);
        ((PidSingleDialog)this.propertiesDialog).indexLabel.setVisible(false);
        this.propertiesDialog.setModal(true);
        this.propertiesDialog.setVisible(true);
        if (((PidSingleDialog)this.propertiesDialog).getReturnStatus() == 1) {
            if (!((PidSingleDialog)this.propertiesDialog).fieldChanged) {
                return;
            }
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.propertiesDialog.setVisible(false);
            this.scene.sceneChanged();
            this.getDialogFields();
            if (this.kernel != null && this.kernel.isConnected()) {
                if (!this.sendingCommandQueue.booleanValue()) {
                    this.commandQueue.clear();
                    int offset = 2;
                    String msg = "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " " + this.pidSetpoint + " >";
                    this.commandQueue.add(msg);
                    msg = ((PidSingleDialog)this.propertiesDialog).chkSummer.isSelected() ? "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " 1.0 >" : "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " 0.0 >";
                    this.commandQueue.add(msg);
                    msg = "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " " + this.pidParameters[0] + " >";
                    this.commandQueue.add(msg);
                    msg = "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " " + this.pidParameters[1] + " >";
                    this.commandQueue.add(msg);
                    msg = "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " " + this.pidParameters[2] + " >";
                    this.commandQueue.add(msg);
                    msg = "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " " + this.neutralZone + " >";
                    this.commandQueue.add(msg);
                    this.sendMessageQueue(true);
                } else {
                    JOptionPane.showMessageDialog(null, "Another Send is in progress", "Warning", 2);
                }
            }
        }
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "subType", this.subType.toString());
        SceneSerializer.setAttribute(document, nodeElement, PID_SETPOINT, this.pidSetpoint);
        SceneSerializer.setAttribute(document, nodeElement, PID_BP, this.pidParameters[0]);
        SceneSerializer.setAttribute(document, nodeElement, PID_TI, this.pidParameters[1]);
        SceneSerializer.setAttribute(document, nodeElement, PID_TD, this.pidParameters[2]);
        SceneSerializer.setAttribute(document, nodeElement, PID_SUMMER, Boolean.toString(this.isSummer));
        SceneSerializer.setAttribute(document, nodeElement, PID_NEUTRAL, this.neutralZone);
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        this.pidSetpoint = SceneSerializer.getAttributeValue(node, PID_SETPOINT);
        this.pidParameters[0] = SceneSerializer.getAttributeValue(node, PID_BP);
        this.pidParameters[1] = SceneSerializer.getAttributeValue(node, PID_TI);
        this.pidParameters[2] = SceneSerializer.getAttributeValue(node, PID_TD);
        this.isSummer = Boolean.parseBoolean(SceneSerializer.getAttributeValue(node, PID_SUMMER));
        this.neutralZone = SceneSerializer.getAttributeValue(node, PID_NEUTRAL);
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        retVal = retVal + "37 " + this.getCommonData() + " ";
        retVal = retVal + this.pidSetpoint;
        retVal = retVal + " " + (double)this.boolToInteger(this.isSummer).intValue();
        retVal = retVal + " " + this.pidParameters[0] + " " + this.pidParameters[1] + " " + this.pidParameters[2];
        retVal = retVal + " " + this.neutralZone;
        return retVal;
    }

    @Override
    public void setConnectionStatus(boolean isConnected) {
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
        } else {
            String value = "";
            int msgAddress = Integer.parseInt(cmd.getValue("ADDRESS"));
            value = cmd.getValue("TOKEN3");
            switch (msgAddress - (Integer)this.addressList.get(0) - 2) {
                case 0: {
                    ((PidSingleDialog)this.propertiesDialog).txtSetpoint.setText(value);
                    this.pidSetpoint = value;
                    break;
                }
                case 1: {
                    if (Double.parseDouble(value) == 0.0) {
                        ((PidSingleDialog)this.propertiesDialog).chkSummer.setSelected(false);
                        this.isSummer = false;
                        break;
                    }
                    ((PidSingleDialog)this.propertiesDialog).chkSummer.setSelected(true);
                    this.isSummer = true;
                    break;
                }
                case 2: {
                    ((PidSingleDialog)this.propertiesDialog).txtBandaProp.setText(value);
                    this.pidParameters[0] = value;
                    break;
                }
                case 3: {
                    ((PidSingleDialog)this.propertiesDialog).txtTempoIntegrale.setText(value);
                    this.pidParameters[1] = value;
                    break;
                }
                case 4: {
                    ((PidSingleDialog)this.propertiesDialog).txtTempoDerivativo.setText(value);
                    this.pidParameters[2] = value;
                    break;
                }
                case 5: {
                    ((PidSingleDialog)this.propertiesDialog).txtBandaNeutra.setText(value);
                    this.neutralZone = value;
                }
            }
        }
        this.propertiesDialog.invalidate();
        return true;
    }

    @Override
    public void initSimulation() {
        super.initSimulation();
        this.m_IntegralTimer = new GenericNode.SimTimer();
        this.m_DerivativeTimer = new GenericNode.SimTimer();
        this.registerArray.clear();
        this.registerArray.add(Double.parseDouble(this.pidSetpoint));
        this.registerArray.add(this.boolToDouble(this.isSummer));
        this.registerArray.add(Double.parseDouble(this.pidParameters[0]));
        this.registerArray.add(Double.parseDouble(this.pidParameters[1]));
        this.registerArray.add(Double.parseDouble(this.pidParameters[2]));
        this.registerArray.add(Double.parseDouble(this.neutralZone));
        this.SetupInternals();
        this.m_IntegralState = 0.0;
        this.m_DerivativeState = 0.0;
        this.m_LastPidOutput = 0.0;
    }

    void AcquireParamIn() {
        Double param = 0.0;
        try {
            param = ((GenericNode.SimData)this.inputData.get((int)e_Inputs.PID2_IN_BP.ordinal())).connected ? Double.valueOf(this.GetInputData(e_Inputs.PID2_IN_BP.ordinal())) : Double.valueOf(Double.parseDouble(this.pidParameters[0]));
            this.setParameter(e_PARAMS.PID2_PARAM_BP.ordinal(), param);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            param = ((GenericNode.SimData)this.inputData.get((int)e_Inputs.PID2_IN_TI.ordinal())).connected ? Double.valueOf(this.GetInputData(e_Inputs.PID2_IN_TI.ordinal())) : Double.valueOf(Double.parseDouble(this.pidParameters[1]));
            this.setParameter(e_PARAMS.PID2_PARAM_TI.ordinal(), param);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            param = ((GenericNode.SimData)this.inputData.get((int)e_Inputs.PID2_IN_TD.ordinal())).connected ? Double.valueOf(this.GetInputData(e_Inputs.PID2_IN_TD.ordinal())) : Double.valueOf(Double.parseDouble(this.pidParameters[2]));
            this.setParameter(e_PARAMS.PID2_PARAM_TD.ordinal(), param);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            if (((GenericNode.SimData)this.inputData.get((int)e_Inputs.PID2_IN_BN.ordinal())).connected) {
                param = this.GetInputData(e_Inputs.PID2_IN_BN.ordinal());
                this.setParameter(e_PARAMS.PID2_PARAM_NEUTRALZONE.ordinal(), param);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void simulate() {
        super.simulate();
        double performUpdate = 1.0;
        this.GetSummer();
        this.GetSetpoint();
        double controlVar = 0.0;
        double error1 = 0.0;
        this.AcquireParamIn();
        GenericNode.SimData out = this.GetMData(0);
        if (this.isInputConnected(e_Inputs.PID2_IN_RESET.ordinal())) {
            double val = 0.0;
            try {
                val = this.GetInputData(e_Inputs.PID2_IN_RESET.ordinal());
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (val != 0.0) {
                this.m_IntegralState = 0.0;
                out.data = 0.0;
                out.isValid = true;
                this.SetMData(0, out);
                this.updateSimOutputs();
                this.m_IntegralTimer.setTimer((int)(this.GetParameter(e_PARAMS.PID2_PARAM_TI.ordinal()) * 1000.0));
                this.m_DerivativeTimer.setTimer((int)(this.GetParameter(e_PARAMS.PID2_PARAM_TD.ordinal()) * 1000.0));
                return;
            }
        }
        if (this.isInputConnected(e_Inputs.PID2_IN_EN.ordinal())) {
            try {
                performUpdate = this.GetInputData(e_Inputs.PID2_IN_EN.ordinal());
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (performUpdate == 0.0) {
                if (out.data < 0.0) {
                    out.data = 0.0;
                }
                this.m_IntegralTimer.setTimer((int)(this.GetParameter(e_PARAMS.PID2_PARAM_TI.ordinal()) * 1000.0));
                this.m_DerivativeTimer.setTimer((int)(this.GetParameter(e_PARAMS.PID2_PARAM_TD.ordinal()) * 1000.0));
                out.isValid = true;
                this.SetMData(0, out);
                this.updateSimOutputs();
                return;
            }
        }
        try {
            controlVar = this.GetInputData(e_Inputs.PID2_IN_CTRL.ordinal());
        }
        catch (Exception ex) {
            this.invalidateOutputs();
            this.updateSimOutputs();
            return;
        }
        double pid1_Output = 0.0;
        error1 = this.GetParameter(e_PARAMS.PID2_PARAM_SUMMER.ordinal()) != 0.0 ? controlVar - this.GetParameter(e_PARAMS.PID2_PARAM_SP.ordinal()) : this.GetParameter(e_PARAMS.PID2_PARAM_SP.ordinal()) - controlVar;
        pid1_Output = this.GetParameter(e_PARAMS.PID2_PARAM_BP.ordinal()) != 0.0 ? 10.0 / this.GetParameter(e_PARAMS.PID2_PARAM_BP.ordinal()) * (this.GetParameter(e_PARAMS.PID2_PARAM_BP.ordinal()) / 2.0 + error1) : 0.0;
        if (pid1_Output - this.m_LastPropOutput > 0.2) {
            this.m_IntegralTimer.setTimer((int)(this.GetParameter(e_PARAMS.PID2_PARAM_TI.ordinal()) * 1000.0));
            this.m_LastPropOutput = pid1_Output;
        }
        if (this.GetParameter(e_PARAMS.PID2_PARAM_TI.ordinal()) > 0.0) {
            if (Math.abs(error1) > 0.2) {
                this.Integrate(error1);
            }
        } else {
            this.m_IntegralState = 0.0;
        }
        pid1_Output += this.m_IntegralState;
        if (this.GetParameter(e_PARAMS.PID2_PARAM_TD.ordinal()) > 0.0 && this.m_DerivativeTimer.isTimerExpired()) {
            this.Derivate(error1);
            this.m_DerivativeTimer.setTimer((int)(this.GetParameter(e_PARAMS.PID2_PARAM_TD.ordinal()) * 1000.0));
        }
        if ((pid1_Output += this.m_DerivativeState) > 10.0) {
            pid1_Output = 10.0;
        } else if (pid1_Output < 0.0) {
            pid1_Output = 0.0;
        }
        if (Math.abs(pid1_Output - this.m_LastPidOutput) > this.GetParameter(e_PARAMS.PID2_PARAM_NEUTRALZONE.ordinal())) {
            this.m_LastPidOutput = pid1_Output;
        }
        out.data = this.m_LastPidOutput;
        out.isValid = true;
        this.SetMData(0, out);
        this.updateSimOutputs();
    }

    void GetSetpoint() {
        double newSP = 0.0;
        try {
            newSP = ((GenericNode.SimData)this.inputData.get((int)e_Inputs.PID2_IN_SP.ordinal())).connected ? this.GetInputData(e_Inputs.PID2_IN_SP.ordinal()) : Double.parseDouble(this.pidSetpoint);
            this.setParameter(e_PARAMS.PID2_PARAM_SP.ordinal(), newSP);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void SetupInternals() {
        this.m_MaxIntegralError = 10.0;
        this.m_IntegralState = 0.0;
        this.m_LastTimeSlice = 0L;
        this.m_LastPropOutput = 0.0;
        this.m_LastError = 0.0;
    }

    void GetSummer() {
        Double summer = 0.0;
        try {
            summer = ((GenericNode.SimData)this.inputData.get((int)e_Inputs.PID2_IN_SUM.ordinal())).connected ? Double.valueOf(this.GetInputData(e_Inputs.PID2_IN_SUM.ordinal())) : Double.valueOf(this.boolToDouble(this.isSummer));
            this.setParameter(e_PARAMS.PID2_PARAM_SUMMER.ordinal(), summer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    double Integrate(double error) {
        double integral = 0.0;
        long timeEl = this.m_IntegralTimer.GetTimeElapsed();
        double timeInt = this.GetParameter(e_PARAMS.PID2_PARAM_TI.ordinal()) * 1000.0;
        integral = (double)timeEl / timeInt;
        this.m_IntegralState += (integral *= error);
        if (this.m_IntegralState > this.m_MaxIntegralError) {
            this.m_IntegralState = this.m_MaxIntegralError;
        } else if (this.m_IntegralState < -this.m_MaxIntegralError) {
            this.m_IntegralState = -this.m_MaxIntegralError;
        }
        this.m_IntegralTimer.setTimer((int)this.GetParameter(e_PARAMS.PID2_PARAM_TI.ordinal()) * 1000);
        return this.m_IntegralState;
    }

    double Derivate(double error) {
        double retVal = 0.0;
        this.m_DerivativeState = retVal = error - this.m_LastError;
        this.m_LastError = error;
        return retVal;
    }

    static enum e_Inputs {
        PID2_IN_CTRL,
        PID2_IN_SP,
        PID2_IN_SUM,
        PID2_IN_BP,
        PID2_IN_TI,
        PID2_IN_TD,
        PID2_IN_BN,
        PID2_IN_EN,
        PID2_IN_RESET,
        PID2_NUM_INPUTS;

    }

    static enum e_PARAMS {
        PID2_PARAM_SP,
        PID2_PARAM_SUMMER,
        PID2_PARAM_BP,
        PID2_PARAM_TI,
        PID2_PARAM_TD,
        PID2_PARAM_NEUTRALZONE,
        PID2_NUM_PARAM;

    }
}

