/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import VisiProg.AppOptions;
import connection.ICmd;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.SpinnerNumberModel;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.GenericNode;
import nodes.gui.DelayDialog;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class PWMNode
extends GenericNode {
    private String sampleTimeMs = "100";
    private static AppOptions options = new AppOptions();
    public static final int DELAY_ID = 53;
    ArrayList<Double> m_SampledDataVector;
    Double m_LastReset;
    GenericNode.SimTimer m_SampleTimer;

    public PWMNode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        this.blockType = CommonDefinitions.blockTypes.PWM;
        this.addressSpace = 3;
        this.numberOfInputs = 3;
        this.CreatePropertiesDialog();
        options.LoadOptions();
        this.currentLocale = new Locale(PWMNode.options.language, PWMNode.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        this.codici = new ArrayList();
        this.codici.add(0, "PWM");
        this.codici.add(1, "OUT_PWM");
        this.codici.add(2, "SampleTime");
        this.setList(this.codici);
        this.CreateWidget();
        this.cleanSimDialog();
    }

    public String getAddress() {
        String newAddress = ((DelayDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("PWM Node");
        this.getScene().addNode(this);
        String pinLabel = "OUT";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        pinLabel = "In";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setPinIDString("IN1");
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        pinLabel = "Sample Time";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setPinIDString("IN2");
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        pinLabel = "Reset";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setPinIDString("IN3");
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        ((AFONodeWidget)this.widget).setSubType("" + this.sampleTimeMs);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new DelayDialog(null, true, this);
        options.LoadOptions();
        this.currentLocale = new Locale(PWMNode.options.language, PWMNode.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        Integer value = new Integer(100);
        Integer min = new Integer(100);
        Integer max = new Integer(100000);
        Integer step = new Integer(1);
        SpinnerNumberModel model = new SpinnerNumberModel(value, min, max, step);
        ((DelayDialog)this.propertiesDialog).spnrDelay.setModel(model);
        ((DelayDialog)this.propertiesDialog).lblRit.setText("Sample Time (ms)");
        ((DelayDialog)this.propertiesDialog).lblDefVal.setVisible(false);
        ((DelayDialog)this.propertiesDialog).spnrDelay.setValue(Integer.parseInt(this.sampleTimeMs));
        ((DelayDialog)this.propertiesDialog).comboTimeBase.removeAllItems();
        ((DelayDialog)this.propertiesDialog).comboTimeBase.setVisible(false);
        ((DelayDialog)this.propertiesDialog).txtDefVal.setVisible(false);
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        this.requestData();
        ((DelayDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((DelayDialog)this.propertiesDialog).spnrDelay.setValue(Integer.parseInt(this.sampleTimeMs));
        ((DelayDialog)this.propertiesDialog).indexLabel.setVisible(false);
        ((DelayDialog)this.propertiesDialog).showDialog();
        if (((DelayDialog)this.propertiesDialog).getReturnStatus() == 1) {
            if (!((DelayDialog)this.propertiesDialog).fieldChanged) {
                return;
            }
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.propertiesDialog.setVisible(false);
            this.sampleTimeMs = ((DelayDialog)this.propertiesDialog).spnrDelay.getValue().toString();
            ((AFONodeWidget)this.widget).setSubType(this.sampleTimeMs);
            if (this.kernel != null && this.kernel.isConnected()) {
                this.commandQueue.clear();
                String msg = "<BL set " + this.addressList.get(2) + " " + Float.parseFloat(this.sampleTimeMs) + " >";
                this.commandQueue.add(msg);
                this.sendMessageQueue(true);
            } else {
                this.scene.sceneChanged();
            }
        }
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        retVal = retVal + "53 " + this.getCommonData();
        retVal = retVal + this.sampleTimeMs;
        return retVal;
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "SampleTime", this.sampleTimeMs);
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        try {
            this.sampleTimeMs = SceneSerializer.getAttributeValue(node, "SampleTime");
        }
        catch (Exception ex) {
            this.sampleTimeMs = "100";
            ex.printStackTrace();
        }
        ((AFONodeWidget)this.widget).setSubType(this.sampleTimeMs);
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
        } else if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(2)).toString())) {
            int delay = (int)Float.parseFloat(cmd.getValue("TOKEN3"));
            this.sampleTimeMs = "" + delay;
            ((AFONodeWidget)this.widget).setSubType(this.sampleTimeMs);
            ((DelayDialog)this.propertiesDialog).spnrDelay.setValue(Integer.parseInt(this.sampleTimeMs));
        }
        return true;
    }

    @Override
    public void initSimulation() {
        super.initSimulation();
        this.registerArray.add(Double.parseDouble(this.sampleTimeMs));
        this.registerArray.add(0.0);
        this.m_SampledDataVector = new ArrayList();
        this.m_SampleTimer = new GenericNode.SimTimer();
        this.m_LastReset = 0.0;
    }

    @Override
    public void simulate() {
        super.simulate();
        GenericNode.SimData out = this.GetMData(0);
        out.data = 0.0;
        out.isValid = true;
        this.SetMData(0, out);
        this.updateSimOutputs();
    }

    void RearmTimer() {
    }

    static enum e_Params {
        PWM_SAMPLETIMEMS;

    }
}

