/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.GenericNode;
import nodes.gui.GenericBlockDialog;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class PumpCtrlNode
extends GenericNode
implements ItemListener {
    private String swapTime = "10.0";
    private Boolean timeIsIndays = true;
    boolean dialogChanged = false;
    public static final int PUMPCTRL_ID = 35;
    final int PUMPCTRL_SWAPTIMEOUT = 20000;
    e_PumpStatus[] m_PumpArray = new e_PumpStatus[2];
    long m_LastSwapTime;
    GenericNode.SimTimer m_SwapTimeOut;

    public PumpCtrlNode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        this.blockType = CommonDefinitions.blockTypes.PumpControl;
        this.addressSpace = 5;
        this.numberOfInputs = 6;
        this.CreateWidget();
        this.CreatePropertiesDialog();
        this.codici = new ArrayList();
        this.codici.add(0, "Pump");
        this.codici.add(1, "CMD1_Pump");
        this.codici.add(2, "CMD2_Pump");
        this.codici.add(3, "SwapTime");
        this.codici.add(4, "FlagTime(Days)");
        this.setList(this.codici);
        this.cleanSimDialog();
    }

    public String getAddress() {
        String newAddress = ((GenericBlockDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("Pump Ctrl");
        this.getScene().addNode(this);
        String pinLabel = "CMD1";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "CMD2";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT2");
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "AL1";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN1");
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "ST1";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN2");
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "AL2";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN3");
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "ST2";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setPinIDString("IN4");
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "Time";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setPinIDString("IN5");
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        pinLabel = "RESET";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setPinIDString("IN6");
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new GenericBlockDialog(null, true, this);
        this.propertiesDialog.setResizable(false);
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.setEnabled(false);
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.removeAllItems();
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.addItem("NA");
        ((GenericBlockDialog)this.propertiesDialog).lblField1.setText(this.message.getString("swap"));
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setText("10");
        ((GenericBlockDialog)this.propertiesDialog).lblField2.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).txtField2.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).chk1.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).chk1.setText(this.message.getString("tempogiorni"));
        ((GenericBlockDialog)this.propertiesDialog).chk1.addItemListener(this);
        ((GenericBlockDialog)this.propertiesDialog).invalidate();
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        retVal = retVal + "35 " + this.getCommonData();
        retVal = retVal + this.swapTime + " ";
        retVal = this.timeIsIndays != false ? retVal + "1.0" : retVal + "0.0";
        return retVal;
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        this.requestData();
        ((GenericBlockDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setText(this.swapTime);
        ((GenericBlockDialog)this.propertiesDialog).indexLabel.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).chk1.setSelected(this.timeIsIndays);
        this.dialogChanged = false;
        this.propertiesDialog.setModal(true);
        this.propertiesDialog.setVisible(true);
        if (((GenericBlockDialog)this.propertiesDialog).getReturnStatus() == 1) {
            if (!((GenericBlockDialog)this.propertiesDialog).fieldChanged && !this.dialogChanged) {
                return;
            }
            if (this.dialogChanged || ((GenericBlockDialog)this.propertiesDialog).fieldChanged) {
                this.scene.sceneChanged();
                this.addressList.clear();
                for (int i = 0; i < this.addressSpace; ++i) {
                    this.addressList.add(Integer.parseInt(this.getAddress()) + i);
                }
                this.addressList.size();
                this.commandQueue.clear();
                this.swapTime = ((GenericBlockDialog)this.propertiesDialog).txtField1.getText();
                this.timeIsIndays = ((GenericBlockDialog)this.propertiesDialog).chk1.isSelected();
                if (this.kernel != null && this.kernelConnected) {
                    String msg = "<BL set " + this.addressList.get(3) + " " + this.swapTime + " >";
                    this.commandQueue.add(msg);
                    msg = "<BL set " + this.addressList.get(4) + " ";
                    msg = this.timeIsIndays != false ? msg + "1.0 >" : msg + "0.0 >";
                    this.commandQueue.add(msg);
                    this.sendMessageQueue(true);
                }
            }
        }
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "SwapTime", this.swapTime);
        SceneSerializer.setAttribute(document, nodeElement, "TimeInDays", this.timeIsIndays.toString());
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        this.swapTime = SceneSerializer.getAttributeValue(node, "SwapTime");
        this.timeIsIndays = Boolean.parseBoolean(SceneSerializer.getAttributeValue(node, "TimeInDays"));
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
        } else {
            String value = "";
            int msgAddress = Integer.parseInt(cmd.getValue("ADDRESS"));
            value = cmd.getValue("TOKEN3");
            switch (msgAddress - (Integer)this.addressList.get(0) - 3) {
                case 0: {
                    ((GenericBlockDialog)this.propertiesDialog).txtField1.setText(value);
                    this.swapTime = value;
                    break;
                }
                case 1: {
                    this.timeIsIndays = (double)Float.parseFloat(value) == 0.0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
                    ((GenericBlockDialog)this.propertiesDialog).chk1.setSelected(this.timeIsIndays);
                }
            }
        }
        this.propertiesDialog.invalidate();
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.dialogChanged = !this.dialogChanged;
    }

    @Override
    public void initSimulation() {
        super.initSimulation();
        this.registerArray.add(Double.parseDouble(this.swapTime));
        this.registerArray.add(this.boolToDouble(this.timeIsIndays));
        this.m_PumpArray[0] = e_PumpStatus.PUMP_OFF;
        this.m_PumpArray[1] = e_PumpStatus.PUMP_OFF;
        this.m_SwapTimeOut = new GenericNode.SimTimer();
    }

    @Override
    public void simulate() {
        super.simulate();
        double al1 = 0.0;
        double st1 = 1.0;
        double al2 = 0.0;
        double st2 = 1.0;
        double param = 0.0;
        long actTimeSec = this.actTimeMs / 1000L;
        boolean swapPumps = false;
        boolean controllerDisabled = false;
        if (!this.m_SwapTimeOut.isTimerExpired()) {
            return;
        }
        if (this.isInputConnected(e_Inputs.IN_EN.ordinal())) {
            double enable = 0.0;
            try {
                enable = this.GetInputData(e_Inputs.IN_EN.ordinal());
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (enable != 0.0) {
                controllerDisabled = true;
            }
        }
        if (this.isInputConnected(e_Inputs.IN_TIME.ordinal())) {
            try {
                param = this.GetInputData(e_Inputs.IN_TIME.ordinal());
                this.setParameter(e_Param.CHANGE_TIME.ordinal(), param);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        long swapIntervalSec = (int)this.GetParameter(e_Param.CHANGE_TIME.ordinal());
        if (this.GetParameter(e_Param.TIME_IS_DAY.ordinal()) != 0.0) {
            swapIntervalSec *= 86400L;
        }
        if (this.isInputConnected(e_Inputs.IN_AL1.ordinal())) {
            try {
                al1 = this.GetInputData(e_Inputs.IN_AL1.ordinal());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (this.isInputConnected(e_Inputs.IN_ST1.ordinal())) {
            try {
                st1 = this.GetInputData(e_Inputs.IN_ST1.ordinal());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (this.isInputConnected(e_Inputs.IN_AL2.ordinal())) {
            try {
                al2 = this.GetInputData(e_Inputs.IN_AL2.ordinal());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (this.isInputConnected(e_Inputs.IN_ST2.ordinal())) {
            try {
                st2 = this.GetInputData(e_Inputs.IN_ST2.ordinal());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        GenericNode.SimData out1 = this.GetMData(e_Output.CMD_PUMP1.ordinal());
        GenericNode.SimData out2 = this.GetMData(e_Output.CMD_PUMP2.ordinal());
        if (controllerDisabled) {
            out1.data = 0.0;
            out1.isValid = true;
            out2.data = 0.0;
            out2.isValid = true;
        } else if (this.m_PumpArray[0] == e_PumpStatus.PUMP_OFF && this.m_PumpArray[1] == e_PumpStatus.PUMP_OFF) {
            swapPumps = true;
        } else if (this.m_PumpArray[0] == e_PumpStatus.PUMP_ON) {
            out1.data = 1.0;
            out1.isValid = true;
            out2.data = 0.0;
            out2.isValid = true;
            if (actTimeSec >= this.m_LastSwapTime + swapIntervalSec) {
                if (this.m_PumpArray[1] != e_PumpStatus.PUMP_ALARM) {
                    swapPumps = true;
                }
            } else if (al1 != 0.0 || st1 == 0.0) {
                this.m_PumpArray[0] = e_PumpStatus.PUMP_ALARM;
                if (this.m_PumpArray[1] != e_PumpStatus.PUMP_ALARM) {
                    this.m_PumpArray[1] = e_PumpStatus.PUMP_ON;
                    out2.data = 1.0;
                    out2.isValid = true;
                    this.m_SwapTimeOut.setTimer(20000);
                }
            }
        } else if (this.m_PumpArray[1] == e_PumpStatus.PUMP_ON) {
            out1.data = 0.0;
            out1.isValid = true;
            out2.data = 1.0;
            out2.isValid = true;
            if (actTimeSec >= this.m_LastSwapTime + swapIntervalSec) {
                if (this.m_PumpArray[0] != e_PumpStatus.PUMP_ALARM) {
                    swapPumps = true;
                }
            } else if (al2 != 0.0 || st2 == 0.0) {
                this.m_PumpArray[1] = e_PumpStatus.PUMP_ALARM;
                if (this.m_PumpArray[0] != e_PumpStatus.PUMP_ALARM) {
                    this.m_PumpArray[0] = e_PumpStatus.PUMP_ON;
                    out1.data = 1.0;
                    out1.isValid = true;
                    this.m_SwapTimeOut.setTimer(20000);
                }
            }
        }
        if (this.m_PumpArray[0] == e_PumpStatus.PUMP_ALARM) {
            if (al1 == 0.0) {
                if (st1 != 0.0) {
                    out1.data = 0.0;
                    out1.isValid = true;
                }
                this.m_PumpArray[0] = e_PumpStatus.PUMP_OFF;
            }
            if (this.m_PumpArray[1] != e_PumpStatus.PUMP_ALARM) {
                out2.data = 1.0;
                out2.isValid = true;
                this.m_PumpArray[1] = e_PumpStatus.PUMP_ON;
            }
        }
        if (this.m_PumpArray[1] == e_PumpStatus.PUMP_ALARM) {
            if (al2 == 0.0) {
                if (st2 != 0.0) {
                    out2.data = 0.0;
                    out2.isValid = true;
                }
                this.m_PumpArray[1] = e_PumpStatus.PUMP_OFF;
            }
            if (this.m_PumpArray[0] != e_PumpStatus.PUMP_ALARM) {
                out1.data = 1.0;
                out1.isValid = true;
                this.m_PumpArray[0] = e_PumpStatus.PUMP_ON;
            }
        }
        if (swapPumps) {
            if (this.m_PumpArray[0] == e_PumpStatus.PUMP_ON) {
                out1.data = 0.0;
                out1.isValid = true;
                out2.data = 1.0;
                out2.isValid = true;
                this.m_LastSwapTime = actTimeSec;
                this.m_PumpArray[0] = e_PumpStatus.PUMP_OFF;
                this.m_PumpArray[1] = e_PumpStatus.PUMP_ON;
            } else {
                out1.data = 1.0;
                out1.isValid = true;
                out2.data = 0.0;
                out2.isValid = true;
                this.m_LastSwapTime = actTimeSec;
                this.m_PumpArray[0] = e_PumpStatus.PUMP_ON;
                this.m_PumpArray[1] = e_PumpStatus.PUMP_OFF;
            }
            this.m_LastSwapTime = actTimeSec;
            this.m_SwapTimeOut.setTimer(20000);
        }
        this.SetMData(e_Output.CMD_PUMP1.ordinal(), out1);
        this.SetMData(e_Output.CMD_PUMP2.ordinal(), out2);
        this.updateSimOutputs();
    }

    static enum e_Output {
        CMD_PUMP1,
        CMD_PUMP2;

    }

    static enum e_Param {
        CHANGE_TIME,
        TIME_IS_DAY,
        PMPCTRL_PARAM_NUMTOT;

    }

    static enum e_PumpStatus {
        PUMP_OFF,
        PUMP_ON,
        PUMP_ALARM;

    }

    static enum e_Inputs {
        IN_AL1,
        IN_ST1,
        IN_AL2,
        IN_ST2,
        IN_TIME,
        IN_EN;

    }
}

