/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import VisiProg.AppOptions;
import connection.ICmd;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.GenericNode;
import nodes.gui.DelayDialog;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class SampleAndHoldNode
extends GenericNode {
    private String sampleTime = "1";
    private String timeBase = "0";
    private static AppOptions options = new AppOptions();
    public static final int SAMPLE_AND_HOLD_ID = 48;
    final double SAMPLE_MAX_AMOUNT = 60.0;
    GenericNode.SimTimer m_SampleTimer;

    public SampleAndHoldNode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        this.blockType = CommonDefinitions.blockTypes.SampleAndHold;
        this.addressSpace = 4;
        this.numberOfInputs = 2;
        this.CreatePropertiesDialog();
        options.LoadOptions();
        this.currentLocale = new Locale(SampleAndHoldNode.options.language, SampleAndHoldNode.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        this.codici = new ArrayList();
        this.codici.add(0, "Sample&Hold");
        this.codici.add(1, "OUT_S&H");
        this.codici.add(2, "SampleTime");
        this.setList(this.codici);
        this.CreateWidget();
        this.cleanSimDialog();
    }

    public String getAddress() {
        String newAddress = ((DelayDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("Sample And Hold");
        this.getScene().addNode(this);
        String pinLabel = "OUT";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        pinLabel = "In";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setPinIDString("IN1");
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        pinLabel = "Sample";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setPinIDString("IN2");
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        String times = "";
        if (this.timeBase.equals("0")) {
            times = "sec";
        }
        if (this.timeBase.equals("1")) {
            times = "min";
        }
        if (this.timeBase.equals("2")) {
            times = "h";
        }
        ((AFONodeWidget)this.widget).setSubType(this.sampleTime + " " + times);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new DelayDialog(null, true, this);
        options.LoadOptions();
        this.currentLocale = new Locale(SampleAndHoldNode.options.language, SampleAndHoldNode.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        ((DelayDialog)this.propertiesDialog).lblRit.setText("Sample Time :");
        ((DelayDialog)this.propertiesDialog).spnrDelay.setValue(Integer.parseInt(this.sampleTime));
        ((DelayDialog)this.propertiesDialog).comboTimeBase.removeAllItems();
        ((DelayDialog)this.propertiesDialog).comboTimeBase.addItem(this.message.getString("secondi"));
        ((DelayDialog)this.propertiesDialog).comboTimeBase.addItem(this.message.getString("minuti"));
        ((DelayDialog)this.propertiesDialog).comboTimeBase.addItem(this.message.getString("ore"));
        ((DelayDialog)this.propertiesDialog).comboTimeBase.setSelectedIndex(Integer.parseInt(this.timeBase));
        ((DelayDialog)this.propertiesDialog).lblDefVal.setVisible(false);
        ((DelayDialog)this.propertiesDialog).txtDefVal.setVisible(false);
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        this.requestData();
        ((DelayDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((DelayDialog)this.propertiesDialog).spnrDelay.setValue(Integer.parseInt(this.sampleTime));
        ((DelayDialog)this.propertiesDialog).comboTimeBase.setSelectedIndex(Integer.parseInt(this.timeBase));
        ((DelayDialog)this.propertiesDialog).indexLabel.setVisible(false);
        ((DelayDialog)this.propertiesDialog).showDialog();
        if (((DelayDialog)this.propertiesDialog).getReturnStatus() == 1) {
            if (!((DelayDialog)this.propertiesDialog).fieldChanged) {
                return;
            }
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.propertiesDialog.setVisible(false);
            this.sampleTime = ((DelayDialog)this.propertiesDialog).spnrDelay.getValue().toString();
            this.timeBase = "" + ((DelayDialog)this.propertiesDialog).comboTimeBase.getSelectedIndex();
            String tim = "";
            if (this.timeBase.equals("0")) {
                tim = "sec";
            }
            if (this.timeBase.equals("1")) {
                tim = "min";
            }
            if (this.timeBase.equals("2")) {
                tim = "h";
            }
            ((AFONodeWidget)this.widget).setSubType(this.sampleTime + " " + tim);
            if (this.kernel != null && this.kernel.isConnected()) {
                this.commandQueue.clear();
                String msg = "<BL set " + this.addressList.get(2) + " " + Float.parseFloat(this.sampleTime) + " >";
                this.commandQueue.add(msg);
                msg = "<BL set " + this.addressList.get(3) + " " + Float.parseFloat(this.timeBase) + " >";
                this.commandQueue.add(msg);
                this.sendMessageQueue(true);
            } else {
                this.scene.sceneChanged();
            }
        }
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        float type = Float.parseFloat(this.sampleTime);
        retVal = retVal + "48 " + this.getCommonData();
        retVal = retVal + this.sampleTime + " " + this.timeBase;
        return retVal;
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "delay", this.sampleTime);
        SceneSerializer.setAttribute(document, nodeElement, "timebase", this.timeBase);
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        try {
            this.sampleTime = SceneSerializer.getAttributeValue(node, "delay");
            this.timeBase = SceneSerializer.getAttributeValue(node, "timebase");
        }
        catch (Exception ex) {
            this.sampleTime = "1";
            this.timeBase = "0";
            ex.printStackTrace();
        }
        String time = "";
        if (this.timeBase.equals("0")) {
            time = "sec";
        }
        if (this.timeBase.equals("1")) {
            time = "min";
        }
        if (this.timeBase.equals("2")) {
            time = "h";
        }
        ((AFONodeWidget)this.widget).setSubType(this.sampleTime + " " + time);
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
        } else if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(2)).toString())) {
            int delay = (int)Float.parseFloat(cmd.getValue("TOKEN3"));
            this.sampleTime = "" + delay;
            ((AFONodeWidget)this.widget).setSubType(this.sampleTime);
            ((DelayDialog)this.propertiesDialog).spnrDelay.setValue(Integer.parseInt(this.sampleTime));
        } else if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(3)).toString())) {
            this.timeBase = "" + (int)Float.parseFloat(cmd.getValue("TOKEN3"));
            ((DelayDialog)this.propertiesDialog).comboTimeBase.setSelectedIndex(Integer.parseInt(this.timeBase));
            ((DelayDialog)this.propertiesDialog).validate();
            ((DelayDialog)this.propertiesDialog).fieldChanged = false;
        }
        return true;
    }

    @Override
    public void initSimulation() {
        super.initSimulation();
        this.registerArray.add(Double.parseDouble(this.sampleTime));
        this.registerArray.add(Double.parseDouble(this.timeBase));
        this.m_SampleTimer = new GenericNode.SimTimer();
    }

    @Override
    public void simulate() {
        super.simulate();
        double inVal = 0.0;
        double data = -100.0;
        boolean sample = false;
        GenericNode.SimData out = this.GetMData(0);
        if (this.m_SampleTimer.isTimerExpired()) {
            sample = true;
            int tmrVal = 1000;
            tmrVal = this.GetParameter(e_Params.SH_TIMEBASE.ordinal()) == 0.0 ? 1000 : (this.GetParameter(e_Params.SH_TIMEBASE.ordinal()) == 1.0 ? 60000 : 3600000);
            if (this.isInputConnected(1)) {
                Double newSampleTime = 0.0;
                try {
                    newSampleTime = this.GetInputData(1);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (newSampleTime > 60.0 || newSampleTime < 0.0) {
                    newSampleTime = 60.0;
                }
                this.setParameter(e_Params.SH_INTERVAL.ordinal(), newSampleTime);
            }
            this.m_SampleTimer.setTimer((int)((double)tmrVal * this.GetParameter(e_Params.SH_INTERVAL.ordinal())));
        }
        if (sample) {
            if (this.isInputConnected(0)) {
                try {
                    data = this.GetInputData(0);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            out.data = data;
            out.isValid = true;
        }
        this.SetMData(0, out);
        this.updateSimOutputs();
    }

    static enum e_Params {
        SH_INTERVAL,
        SH_TIMEBASE,
        SH_DEFVAL,
        SH_NUMTOT;

    }
}

