/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import java.awt.BasicStroke;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.devices.GenericNode;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.netbeans.api.visual.widget.Widget;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class ScopeNode
extends GenericNode
implements ActionListener {
    protected TimeSeriesCollection graphDataSet;
    protected TimeSeries graphSeries;
    protected JFreeChart myChart;
    protected ChartFrame myChartFrame;

    @Override
    public void actionPerformed(ActionEvent e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ScopeNode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        this.CreateWidget();
        this.blockType = CommonDefinitions.blockTypes.Scope;
        this.CreatePropertiesDialog();
        this.graphSeries = new TimeSeries((Comparable)((Object)""));
        this.graphDataSet = new TimeSeriesCollection(this.graphSeries);
        this.myChart = ChartFactory.createTimeSeriesChart((String)this.comment, (String)"Time", (String)"IN", (XYDataset)this.graphDataSet, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = this.myChart.getXYPlot();
        ValueAxis axis = plot.getDomainAxis();
        axis = plot.getRangeAxis();
        axis.setRange(0.0, 35.0);
        axis.setAutoRange(false);
        StandardXYItemRenderer renderer = new StandardXYItemRenderer();
        renderer.setSeriesStroke(0, (Stroke)new BasicStroke(2.5f));
        plot.setRenderer(0, (XYItemRenderer)renderer);
        this.myChartFrame = new ChartFrame(this.comment, this.myChart);
        this.myChartFrame.pack();
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("Scope");
        this.scene.addNode(this);
        String pinLabel = "IN";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN1");
        this.getScene().addPin(this, newPin);
        this.pinList.add(newPin);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    public void addValue(String value) {
        try {
            this.setPinValue("IN1", value);
            if (!this.myChartFrame.isVisible()) {
                return;
            }
            float val = Float.parseFloat(value);
            Second now = new Second();
            this.graphSeries.addOrUpdate((RegularTimePeriod)now, (double)val);
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
        }
    }

    private void CreatePropertiesDialog() {
    }

    public void showChartFrame() {
        if (this.myChartFrame.isVisible()) {
            this.myChartFrame.setVisible(false);
        } else {
            this.graphSeries.setDescription(this.comment);
            this.myChart.setTitle(this.comment);
            this.myChartFrame.setTitle(this.comment);
            this.myChart.setTitle(this.comment);
            this.myChartFrame.setVisible(true);
        }
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        return false;
    }
}

