/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.GenericNode;
import nodes.gui.GenericBlockDialog;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class StepRelayNode
extends GenericNode {
    private String stepTime = "500";
    private int MAX_STEP_TIME = 3600000;
    private int MIN_STEP_TIME = 100;
    public static final int STEP_RELAY_ID = 50;
    final int STEP_TIME_MS = 500;
    GenericNode.SimTimer m_StepTimer;

    public StepRelayNode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        this.subType = CommonDefinitions.subBlockTypes.NONE;
        this.CreateWidget();
        this.blockType = CommonDefinitions.blockTypes.StepRelay;
        this.addressSpace = 3;
        this.numberOfInputs = 2;
        this.codici = new ArrayList();
        this.codici.add(0, "StepRelay");
        this.codici.add(1, "OUT_StepRelay");
        this.setList(this.codici);
        this.CreatePropertiesDialog();
        this.cleanSimDialog();
    }

    public String getAddress() {
        String newAddress = ((GenericBlockDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
        } else if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(2)).toString())) {
            this.stepTime = cmd.getValue("TOKEN3");
            ((GenericBlockDialog)this.propertiesDialog).txtField1.setText(this.stepTime);
            ((AFONodeWidget)this.widget).setSubType(this.stepTime + " ms");
        }
        return true;
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("StepRelay");
        this.getScene().addNode(this);
        String pinLabel = "OUT";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        pinLabel = "Cmd";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setPinIDString("IN1");
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        pinLabel = "State";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setPinIDString("IN2");
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        ((AFONodeWidget)this.widget).setSubType(this.stepTime + " ms");
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new GenericBlockDialog(null, true, this);
        ((GenericBlockDialog)this.propertiesDialog).txtAddress.setText("NA");
        ((GenericBlockDialog)this.propertiesDialog).lblCombo.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).jPanel2.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).lblField1.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).lblField1.setText("Step Time (ms) :");
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).lblField2.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).txtField2.setVisible(false);
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        this.requestData();
        ((GenericBlockDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((GenericBlockDialog)this.propertiesDialog).indexLabel.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setText(this.stepTime);
        this.propertiesDialog.setModal(true);
        this.propertiesDialog.setVisible(true);
        if (((GenericBlockDialog)this.propertiesDialog).getReturnStatus() == 1) {
            if (!((GenericBlockDialog)this.propertiesDialog).fieldChanged) {
                return;
            }
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.propertiesDialog.setVisible(false);
            String newTime = ((GenericBlockDialog)this.propertiesDialog).txtField1.getText();
            try {
                if (Integer.parseInt(newTime) > this.MAX_STEP_TIME || Integer.parseInt(newTime) < this.MIN_STEP_TIME) {
                    JOptionPane.showMessageDialog(null, "Value out of range (100 - 3600000)", "Error", 0);
                    return;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.stepTime = newTime;
            ((AFONodeWidget)this.widget).setSubType(this.stepTime + " ms");
            this.widget.revalidate();
            if (this.kernel != null && this.kernel.isConnected()) {
                this.commandQueue.clear();
                String msg = "<BL set " + this.addressList.get(2) + " " + this.stepTime + " >";
                this.commandQueue.add(msg);
                this.sendMessageQueue(true);
            } else {
                this.scene.sceneChanged();
            }
        }
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        float type = Float.parseFloat("" + this.subType.ordinal());
        retVal = retVal + "50 " + this.getCommonData() + this.stepTime;
        return retVal;
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "StepTime", this.stepTime);
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        this.stepTime = SceneSerializer.getAttributeValue(node, "StepTime");
        if (this.stepTime == null) {
            this.stepTime = "500";
        }
        ((AFONodeWidget)this.widget).setSubType(this.stepTime + " ms");
        this.scene.validate();
    }

    @Override
    public void initSimulation() {
        super.initSimulation();
        this.m_StepTimer = new GenericNode.SimTimer();
        this.m_StepTimer.setTimer(1);
        this.registerArray.add(Double.parseDouble(this.stepTime));
        GenericNode.SimData out = this.GetMData(0);
        out.data = 0.0;
        out.isValid = true;
        this.updateSimOutputs();
    }

    @Override
    public void simulate() {
        super.simulate();
        double in1 = 0.0;
        double in2 = 0.0;
        GenericNode.SimData out = this.GetMData(0);
        if ((int)this.GetParameter(0) != Integer.parseInt(this.stepTime)) {
            this.registerArray.set(0, Double.parseDouble(this.stepTime));
            this.m_StepTimer.setTimer((int)this.GetParameter(0));
        }
        try {
            in1 = this.GetInputData(0);
            in2 = this.GetInputData(1);
        }
        catch (Exception ex) {
            this.invalidateOutputs();
            this.updateSimOutputs();
            return;
        }
        if (this.m_StepTimer.isTimerExpired()) {
            out.isValid = true;
            if (out.data == 0.0) {
                if (in1 != in2) {
                    out.data = 1.0;
                    this.m_StepTimer.setTimer((int)this.GetParameter(0));
                }
            } else {
                out.data = 0.0;
                this.m_StepTimer.setTimer((int)this.GetParameter(0));
            }
        }
        this.SetMData(0, out);
        this.updateSimOutputs();
    }
}

