/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.MyGraphPinScene;
import nodes.devices.GenericNode;
import nodes.gui.DlgSubSystemIO;
import org.netbeans.api.visual.widget.Widget;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class SubSystemIONode
extends GenericNode {
    private Widget parentIOWidget = null;
    private Widget parentIONameWidget = null;
    private AFOPin parentPin = null;
    MyGraphPinScene parentScene;
    private int ioIndex;

    public SubSystemIONode(String id, String label, AFOGraphPinScene scene, int IOindex) {
        super(id, label + IOindex, scene);
        this.ioIndex = IOindex;
        this.blockType = label.equals(CommonDefinitions.blockTypes.IN.toString()) ? CommonDefinitions.blockTypes.IN : CommonDefinitions.blockTypes.OUT;
        this.createWidget();
        this.CreatePropertiesDialog();
    }

    public Widget getParentIONameWidget() {
        return this.parentIONameWidget;
    }

    public void setParentIONameWidget(Widget parentIONameWidget) {
        this.parentIONameWidget = parentIONameWidget;
    }

    public Widget getParentIOWidget() {
        return this.parentIOWidget;
    }

    public void setParentIOWidget(Widget parentIOWidget) {
        this.parentIOWidget = parentIOWidget;
    }

    public AFOPin getParentPin() {
        return this.parentPin;
    }

    public void setParentPin(AFOPin parentPin) {
        this.parentPin = parentPin;
    }

    private void createWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName(this.label);
        if (this.blockType == CommonDefinitions.blockTypes.IN) {
            String pinLabel = "IN";
            String pinID = "pin" + ++this.scene.pinIDCounter;
            AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
            newPin.setAsBusPin(false);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            newPin.setPinIDString("IN1");
            this.pinList.add(newPin);
            this.getScene().addNode(this);
            this.getScene().addPin(this, newPin);
        } else {
            String pinLabel = "OUT";
            String pinID = "pin" + ++this.scene.pinIDCounter;
            AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
            newPin.setAsBusPin(false);
            newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
            newPin.setPinIDString("OUT1");
            this.pinList.add(newPin);
            this.getScene().addNode(this);
            this.getScene().addPin(this, newPin);
        }
        ((AFONodeWidget)this.widget).setSubType(" ");
    }

    public void setParentScene(MyGraphPinScene scene) {
        this.parentScene = scene;
    }

    public MyGraphPinScene getParentScene() {
        return this.parentScene;
    }

    public int getIoIndex() {
        return this.ioIndex;
    }

    @Override
    public void setPinValue(String pinIdx, String value) {
        try {
            this.getPinByID(pinIdx).setValue(value);
            this.getScene().validate();
            if (this.blockType == CommonDefinitions.blockTypes.IN) {
                this.sendValueToChart("IN", value);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        String dlgLabel = ((AFONodeWidget)this.widget).getModuleComment().getLabel();
        ((DlgSubSystemIO)this.propertiesDialog).txtLabel.setText(dlgLabel);
        ((DlgSubSystemIO)this.propertiesDialog).txtLabel.selectAll();
        this.propertiesDialog.setVisible(true);
        if (((DlgSubSystemIO)this.propertiesDialog).getReturnStatus() == 1) {
            this.comment = ((DlgSubSystemIO)this.propertiesDialog).txtLabel.getText();
            if (!this.comment.equals("Comment")) {
                ((AFONodeWidget)this.widget).getModuleComment().setLabel(this.comment);
                this.parentPin.getPinNameWidget().setLabel(this.comment);
                ((AFONodeWidget)this.widget).getModuleComment().setLabel(this.comment);
            }
        }
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        return false;
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new DlgSubSystemIO(null, true);
    }
}

