/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import VisiProg.AppOptions;
import connection.ICmd;
import java.util.Locale;
import java.util.ResourceBundle;
import nodes.AFONodeWidget;
import nodes.BoardsTypesAndDescription;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.GenericNode;
import nodes.gui.TeleportDialog;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class TeleporOUTNode
extends GenericNode {
    private String typeName;
    private String registerAddress = "0";
    public BoardsTypesAndDescription.BoardType boardtypeproj;
    private BoardsTypesAndDescription.BoardType boardType;
    private static AppOptions options = new AppOptions();
    private static int TELEPORTOUT_ID = 54;

    public TeleporOUTNode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        this.typeName = label;
        this.blockType = CommonDefinitions.blockTypes.TeleportOUT;
        this.numberOfInputs = 0;
        this.CreateWidget();
        this.CreatePropertiesDialog();
        this.setConnectionStatus(false);
        this.addressSpace = 2;
    }

    public String getAddress() {
        String newAddress = ((TeleportDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new TeleportDialog(null, true, this);
        options.LoadOptions();
        this.currentLocale = new Locale(TeleporOUTNode.options.language, TeleporOUTNode.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        ((TeleportDialog)this.propertiesDialog).setTitle("Teleport IN");
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName(this.typeName);
        this.getScene().addNode(this);
        String pinLabel = "IN";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN1");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        this.numberOfInputs = 1;
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    private void setDialogFields() {
        TeleportDialog dlg = (TeleportDialog)this.propertiesDialog;
        ((TeleportDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        dlg.txtRegAddress.setText(this.getRegisterAddress());
    }

    private void getDialogFields() {
        TeleportDialog dlg = (TeleportDialog)this.propertiesDialog;
        this.registerAddress = "" + dlg.txtRegAddress.getText();
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        this.setDialogFields();
        ((TeleportDialog)this.propertiesDialog).enableFields(!this.kernelConnected);
        ((TeleportDialog)this.propertiesDialog).fieldChanged = false;
        ((TeleportDialog)this.propertiesDialog).indexLabel.setVisible(false);
        ((TeleportDialog)this.propertiesDialog).txtAddress.setEnabled(true);
        this.propertiesDialog.setVisible(true);
        if (((TeleportDialog)this.propertiesDialog).getExitStatus() == 1) {
            if (!((TeleportDialog)this.propertiesDialog).fieldChanged) {
                return;
            }
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.getDialogFields();
        }
    }

    @Override
    public void setConnectionStatus(boolean isConnected) {
        TeleportDialog dlg = (TeleportDialog)this.propertiesDialog;
        dlg.txtRegAddress.setEnabled(!isConnected);
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        this.registerAddress = SceneSerializer.getAttributeValue(node, "RegisterAddr");
        this.deserializeSimParam(node);
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "RegisterAddr", this.getRegisterAddress());
        this.serializeSimParams(document, nodeElement);
        return nodeElement;
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        retVal = retVal + TELEPORTOUT_ID + " " + this.getCommonData() + this.getRegisterAddress();
        return retVal;
    }

    @Override
    public boolean parseCmd(ICmd com) {
        return false;
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        return false;
    }

    @Override
    public void initSimulation() {
        super.initSimulation();
        this.simInputTimer = new GenericNode.SimTimer();
        this.simDialog.setTitle("TeleportNode: " + this.comment);
    }

    @Override
    public void simulate() {
        double x;
        super.simulate();
        GenericNode.SimData out = this.GetMData(0);
        out.data = x = this.waveGenerator();
        out.isValid = true;
        this.SetMData(0, out);
        this.updateSimOutputs();
    }

    @Override
    public void showSimulationDialog() {
    }

    @Override
    protected void simDialogClosed() {
        super.simDialogClosed();
    }

    public String getRegisterAddress() {
        return this.registerAddress;
    }
}

