/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import java.util.ArrayList;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.DeviceNode;
import nodes.devices.GenericNode;
import nodes.gui.SimInputFrame;
import nodes.gui.SimplePropertiesDlg;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class TempHumiNode
extends DeviceNode {
    private String type;
    public static final int TempUmi_ID = 28;
    private SimInputFrame.SIM_IN_TYPES simInputType1 = SimInputFrame.SIM_IN_TYPES.Costant;
    private String simInputPeriod1 = "60.0";
    private String simInputAmplitude1 = "1.0";
    private String simInputOffset1 = "0.0";

    public TempHumiNode(String id, String label, String analogID, AFOGraphPinScene scene) {
        super(id, label, analogID, scene);
        this.type = label;
        this.propertiesDialog = new SimplePropertiesDlg(null, true, this.deviceID, this);
        ((SimplePropertiesDlg)this.propertiesDialog).jLabel1.setVisible(false);
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.setVisible(false);
        ((SimplePropertiesDlg)this.propertiesDialog).txtValue.setVisible(false);
        ((SimplePropertiesDlg)this.propertiesDialog).lblValue.setVisible(false);
        this.blockType = CommonDefinitions.blockTypes.TempHumi;
        this.numberOfInputs = 0;
        this.setConnectionStatus(false);
        this.createWidget();
        this.addressSpace = 3;
        this.codici = new ArrayList();
        this.codici.add(0, "TempHumi");
        this.codici.add(1, "Temp");
        this.codici.add(2, "Humidity");
        this.setList(this.codici);
        this.simDialog.tabbedPaneMain.setTitleAt(0, "Temp");
        this.simDialog.tabbedPaneMain.setTitleAt(1, "Hum");
    }

    public String getAddress() {
        String newAddress = ((SimplePropertiesDlg)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void createWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName(this.type);
        this.getScene().addNode(this);
        String pinLabel = "T";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        pinLabel = "H";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT2");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        ((AFONodeWidget)this.widget).setSubType(this.deviceID);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.setSelectedItem(this.deviceID);
        ((SimplePropertiesDlg)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((SimplePropertiesDlg)this.propertiesDialog).indexLabel.setVisible(false);
        this.propertiesDialog.setVisible(true);
        if (((SimplePropertiesDlg)this.propertiesDialog).getReturnStatus() == 1 && ((SimplePropertiesDlg)this.propertiesDialog).fieldChanged) {
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.propertiesDialog.setVisible(false);
        }
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        retVal = retVal + "28 " + this.getCommonData() + " ";
        return retVal;
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        this.parseStandardBlockCmd(cmd);
        return true;
    }

    @Override
    public void setConnectionStatus(boolean isConnected) {
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "simInputType1", this.simInputType1.toString());
        SceneSerializer.setAttribute(document, nodeElement, "simInputPeriod1", this.simInputPeriod1);
        SceneSerializer.setAttribute(document, nodeElement, "simInputAmplitude1", this.simInputAmplitude1);
        SceneSerializer.setAttribute(document, nodeElement, "simInputOffset1", this.simInputOffset1);
        this.serializeSimParams(document, nodeElement);
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        this.deviceID = SceneSerializer.getAttributeValue(node, "driverID");
        ((AFONodeWidget)this.widget).setSubType(this.deviceID);
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.removeAllItems();
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.addItem(this.deviceID);
        ((SimplePropertiesDlg)this.propertiesDialog).comboGeneric.setSelectedIndex(0);
        String param = SceneSerializer.getAttributeValue(node, "simInputType1");
        if (param != null) {
            for (SimInputFrame.SIM_IN_TYPES it : SimInputFrame.SIM_IN_TYPES.values()) {
                if (!it.toString().equals(param)) continue;
                this.simInputType1 = it;
                break;
            }
        }
        if ((param = SceneSerializer.getAttributeValue(node, "simInputPeriod1")) != null) {
            this.simInputPeriod1 = param;
        }
        if ((param = SceneSerializer.getAttributeValue(node, "simInputAmplitude1")) != null) {
            this.simInputAmplitude1 = param;
        }
        if ((param = SceneSerializer.getAttributeValue(node, "simInputOffset1")) != null) {
            this.simInputOffset1 = param;
        }
        this.deserializeSimParam(node);
    }

    @Override
    public void initSimulation() {
        super.initSimulation();
        this.simInputTimer = new GenericNode.SimTimer();
        this.simDialog.setTitle(this.deviceID);
    }

    @Override
    public void simulate() {
        double x;
        super.simulate();
        GenericNode.SimData out = this.GetMData(0);
        GenericNode.SimData out1 = this.GetMData(1);
        out.data = x = this.waveGenerator();
        out.isValid = true;
        out1.data = x = this.waveGenerator1();
        out1.isValid = true;
        this.SetMData(0, out);
        this.SetMData(1, out1);
        this.updateSimOutputs();
    }

    @Override
    public void showSimulationDialog() {
        this.simDialog.comboWaveType1.setSelectedItem((Object)this.simInputType1);
        this.simDialog.txtAmplitude1.setText(this.simInputAmplitude1);
        this.simDialog.txtOffset1.setText(this.simInputOffset1);
        this.simDialog.txtPeriod1.setText(this.simInputPeriod1);
        super.showSimulationDialog();
    }

    @Override
    protected void simDialogClosed() {
        super.simDialogClosed();
        this.simInputType1 = (SimInputFrame.SIM_IN_TYPES)((Object)this.simDialog.comboWaveType1.getSelectedItem());
        this.simInputAmplitude1 = this.simDialog.txtAmplitude1.getText();
        this.simInputOffset1 = this.simDialog.txtOffset1.getText();
        this.simInputPeriod1 = this.simDialog.txtPeriod1.getText();
    }

    double waveGenerator1() {
        int nOfSines = 1;
        double x = 0.0;
        double period = Double.parseDouble(this.simInputPeriod1);
        if (this.simInputType1 == SimInputFrame.SIM_IN_TYPES.SawTooth1) {
            nOfSines = 50;
            double t = (double)this.simInputTimer.GetTimeElapsed() / 1000.0;
            for (int k = 1; k <= nOfSines; ++k) {
                x += Math.pow(-1.0, k + 1) * Math.sin(Math.toRadians((double)k * t * 360.0 / period)) / (double)k;
            }
            x = x * 2.0 / Math.PI;
            x = x * Double.parseDouble(this.simInputAmplitude1) + Double.parseDouble(this.simInputOffset1);
        } else if (this.simInputType1 == SimInputFrame.SIM_IN_TYPES.SawTooth2) {
            nOfSines = 50;
            double t = (double)this.simInputTimer.GetTimeElapsed() / 1000.0;
            for (int k = 1; k <= nOfSines; ++k) {
                x += Math.pow(-1.0, k + 1) * Math.sin(Math.toRadians((double)k * t * 360.0 / period)) / (double)k;
            }
            x = x * 2.0 / Math.PI;
            x = -1.0 * x * Double.parseDouble(this.simInputAmplitude1) + Double.parseDouble(this.simInputOffset1);
        } else if (this.simInputType1 == SimInputFrame.SIM_IN_TYPES.Sinusoidal) {
            double t = (double)this.simInputTimer.GetTimeElapsed() / 1000.0;
            x = Math.sin(Math.toRadians(t * 360.0 / period));
            x = x * Double.parseDouble(this.simInputAmplitude1) + Double.parseDouble(this.simInputOffset1);
        } else if (this.simInputType1 == SimInputFrame.SIM_IN_TYPES.Costant) {
            x = Double.parseDouble(this.simInputAmplitude1);
        } else if (this.simInputType1 == SimInputFrame.SIM_IN_TYPES.Triangle) {
            nOfSines = 25;
            double t = (double)this.simInputTimer.GetTimeElapsed() / 1000.0;
            for (int k = 0; k <= nOfSines; ++k) {
                x += Math.pow(-1.0, k) * Math.sin(Math.toRadians((double)(2 * k + 1) * t * 360.0 / period)) / Math.pow(2 * k + 1, 2.0);
            }
            x = x * 8.0 / Math.pow(Math.PI, 2.0);
            x = x * Double.parseDouble(this.simInputAmplitude1) + Double.parseDouble(this.simInputOffset1);
        } else if (this.simInputType1 == SimInputFrame.SIM_IN_TYPES.Square) {
            nOfSines = 50;
            double t = (double)this.simInputTimer.GetTimeElapsed() / 1000.0;
            for (int k = 1; k <= nOfSines; k += 2) {
                x += Math.sin(Math.toRadians((double)k * t * 360.0 / period)) / (double)k;
            }
            if (x > 0.75) {
                x = 1.0;
            } else if (x < -0.75) {
                x = -1.0;
            }
            x = x * Double.parseDouble(this.simInputAmplitude1) + Double.parseDouble(this.simInputOffset1);
        }
        return x;
    }
}

