/*
 * Decompiled with CFR 0.152.
 */
package nodes.devices;

import connection.ICmd;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import nodes.AFONodeWidget;
import nodes.CommonDefinitions;
import nodes.SceneSerializer;
import nodes.devices.GenericNode;
import nodes.gui.GenericBlockDialog;
import org.netbeans.api.visual.widget.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sceneManager.AFOGraphPinScene;
import sceneManager.AFOPin;

public class TimerNode
extends GenericNode {
    public static final int TIMER_ID = 24;
    private String timerBase = "Sec.";
    private int timerBaseIndex = 0;
    long m_ElapsedMs;
    long m_LastUpdateTime;

    public TimerNode(String id, String label, AFOGraphPinScene scene) {
        super(id, label, scene);
        this.blockType = CommonDefinitions.blockTypes.Timer;
        this.numberOfInputs = 2;
        this.addressSpace = 3;
        this.codici = new ArrayList();
        this.codici.add(0, "Timer");
        this.codici.add(1, "OUT_Timer");
        this.setList(this.codici);
        this.CreateWidget();
        this.CreatePropertiesDialog();
        this.cleanSimDialog();
    }

    public String getAddress() {
        String newAddress = ((GenericBlockDialog)this.propertiesDialog).txtAddress.getText();
        return newAddress;
    }

    private void CreateWidget() {
        this.widget = new AFONodeWidget(this.getScene());
        ((AFONodeWidget)this.widget).setName("Timer");
        this.getScene().addNode(this);
        String pinLabel = "Time";
        String pinID = "pin" + ++this.scene.pinIDCounter;
        AFOPin newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_OUTPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("OUT1");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        pinLabel = "Reset";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN1");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        pinLabel = "Start";
        pinID = "pin" + ++this.scene.pinIDCounter;
        newPin = new AFOPin(pinID, pinLabel, AFOPin.E_PinType.PIN_INPUT);
        newPin.setAsBusPin(false);
        newPin.setWidget((Widget)((AFONodeWidget)this.widget).addPin(newPin));
        newPin.setPinIDString("IN2");
        this.pinList.add(newPin);
        this.getScene().addPin(this, newPin);
        ((AFONodeWidget)this.widget).getModuleComment().getActions().addAction(this.editorAction);
        ((AFONodeWidget)this.widget).setSubType("Timer Base: " + this.timerBase);
    }

    private void CreatePropertiesDialog() {
        this.propertiesDialog = new GenericBlockDialog(null, true, this);
        ((GenericBlockDialog)this.propertiesDialog).txtAddress.setText("NA");
        ((GenericBlockDialog)this.propertiesDialog).lblCombo.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).lblCombo.setText("Timer Base:");
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.setVisible(true);
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.removeAllItems();
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.addItem("Sec.");
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.addItem("Min.");
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.addItem("Hour");
        ((GenericBlockDialog)this.propertiesDialog).lblField1.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).txtField1.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).lblField2.setVisible(false);
        ((GenericBlockDialog)this.propertiesDialog).txtField2.setVisible(false);
    }

    @Override
    public void showPropertiesDialog() throws Exception {
        ((GenericBlockDialog)this.propertiesDialog).txtAddress.setText(((Integer)this.addressList.get(0)).toString());
        ((GenericBlockDialog)this.propertiesDialog).comboSubType.setSelectedItem(this.timerBase);
        ((GenericBlockDialog)this.propertiesDialog).indexLabel.setVisible(false);
        this.propertiesDialog.setModal(true);
        this.propertiesDialog.setVisible(true);
        if (((GenericBlockDialog)this.propertiesDialog).getReturnStatus() == 1) {
            if (!((GenericBlockDialog)this.propertiesDialog).fieldChanged) {
                return;
            }
            this.addressList.clear();
            for (int i = 0; i < this.addressSpace; ++i) {
                this.addressList.add(Integer.parseInt(this.getAddress()) + i);
            }
            this.addressList.size();
            this.scene.sceneChanged();
            this.timerBase = ((GenericBlockDialog)this.propertiesDialog).comboSubType.getSelectedItem().toString();
            this.timerBaseIndex = ((GenericBlockDialog)this.propertiesDialog).comboSubType.getSelectedIndex();
            ((AFONodeWidget)this.widget).setSubType("Timer Base: " + this.timerBase);
            if (this.kernel != null && this.kernel.isConnected()) {
                if (!this.sendingCommandQueue.booleanValue()) {
                    this.commandQueue.clear();
                    int offset = 2;
                    String msg = "<BL set " + ((Integer)this.addressList.get(0) + offset++) + " " + this.timerBaseIndex + " >";
                    this.commandQueue.add(msg);
                    this.sendMessageQueue(true);
                } else {
                    JOptionPane.showMessageDialog(null, "Another Send is in progress", "Warning", 2);
                }
            }
        }
    }

    @Override
    public String getConfigString(int deviceIndex) throws Exception {
        String retVal = "";
        retVal = retVal + "24 " + this.getCommonData();
        retVal = retVal + "" + this.timerBaseIndex;
        return retVal;
    }

    @Override
    public Element serializeNode(Document document, Element nodeElement) throws Exception {
        SceneSerializer.setAttribute(document, nodeElement, "TimerBase", this.timerBase);
        SceneSerializer.setAttribute(document, nodeElement, "TimerBaseIndex", "" + this.timerBaseIndex);
        return nodeElement;
    }

    @Override
    public void deserializeNode(Node node) throws Exception {
        try {
            this.timerBase = SceneSerializer.getAttributeValue(node, "TimerBase");
            if (this.timerBase == null) {
                throw new Exception("Errore");
            }
            this.timerBaseIndex = Integer.parseInt(SceneSerializer.getAttributeValue(node, "TimerBaseIndex"));
        }
        catch (Exception ex) {
            this.timerBase = "Sec.";
            this.timerBaseIndex = 0;
        }
        ((AFONodeWidget)this.widget).setSubType("Timer Base: " + this.timerBase);
    }

    @Override
    public boolean execCommand(ICmd cmd) throws Exception {
        if (!this.isMsgForMe(cmd)) {
            return false;
        }
        if (cmd.getValue("ADDRESS").equals(((Integer)this.addressList.get(0)).toString())) {
            this.parseStandardBlockCmd(cmd);
        }
        return true;
    }

    @Override
    public void initSimulation() {
        super.initSimulation();
        this.m_ElapsedMs = 0L;
        this.m_LastUpdateTime = 0L;
        this.registerArray.add(Double.valueOf(this.timerBaseIndex));
    }

    @Override
    public void simulate() {
        super.simulate();
        double res = 0.0;
        double start = 1.0;
        long actTime = this.actTimeMs;
        if (this.isInputConnected(0)) {
            try {
                res = this.GetInputData(0);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (this.isInputConnected(1)) {
            try {
                start = this.GetInputData(1);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (res == 0.0) {
            if (start == 1.0) {
                this.m_ElapsedMs += actTime - this.m_LastUpdateTime;
            }
        } else {
            this.m_ElapsedMs = 0L;
        }
        this.m_LastUpdateTime = actTime;
        GenericNode.SimData out = new GenericNode.SimData(this.CalcTimeElapsed(), true);
        this.SetMData(0, out);
        this.updateSimOutputs();
    }

    long CalcTimeElapsed() {
        if ((int)this.GetParameter(0) == e_TimerCountBase.TMR_SEC.ordinal()) {
            return (long)((double)this.m_ElapsedMs / 1000.0);
        }
        if ((int)this.GetParameter(0) == e_TimerCountBase.TMR_MIN.ordinal()) {
            return (long)((double)this.m_ElapsedMs / 60000.0);
        }
        if ((int)this.GetParameter(0) == e_TimerCountBase.TMR_HOUR.ordinal()) {
            return (long)((double)this.m_ElapsedMs / 3600000.0);
        }
        return 0L;
    }

    static enum e_TimerCountBase {
        TMR_SEC,
        TMR_MIN,
        TMR_HOUR,
        TMR_NUMTOT;

    }
}

