/*
 * Decompiled with CFR 0.152.
 */
package nodes.gui;

import Util.FieldChecker;
import VisiProg.AppOptions;
import VisiProg.VisiProgApp;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import nodes.devices.GenericNode;
import nodes.gui.MyComboBoxEditor;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class ModbusStationDialog
extends JDialog
implements TableModelListener {
    public static final int RET_OK = 1;
    public static final int RET_CANCEL = 0;
    private static final int MAX_NUM_ROWS = 24;
    private int returnStatus;
    public boolean fieldChanged = false;
    Locale currentLocale;
    private AppOptions options = new AppOptions();
    ResourceBundle message;
    boolean dataChanged = false;
    GenericNode parentNode;
    FieldChangeListener fcl = new FieldChangeListener();
    public final String[] modBusFunctions = new String[]{"01 - Read Coil", "02 - Read Discrete", "03 - Read Holding", "04 - Read Input", "05 - Force Single Coil", "06 - Preset Single Register"};
    private int MAX_NUM_VARS = 24;
    public JButton btnCancel;
    private JButton btnDeleteRow;
    public JButton btnGiu;
    public JButton btnInsert;
    public JButton btnOk;
    public JButton btnScaling;
    public JButton btnSu;
    public JComboBox comboPort;
    public JLabel indexLabel;
    private JLabel jLabel1;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    public JTable table;
    public JTextField txtAddress;
    public JTextField txtUpdateInterval;

    public ModbusStationDialog(Frame parent, boolean modal, GenericNode parentNode) {
        super(parent, modal);
        this.initComponents();
        this.options.LoadOptions();
        this.currentLocale = new Locale(this.options.language, this.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        this.btnInsert.setText(this.message.getString("ins"));
        this.btnDeleteRow.setText(this.message.getString("el"));
        JComboBox comboBox = this.createComboBox(this.modBusFunctions);
        this.table.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(comboBox));
        this.center();
        this.setSize(new Dimension(500, 400));
        this.parentNode = parentNode;
        this.addComponentListener(new ComponentAdapter());
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    public void showDialog() {
        this.indexLabel.setVisible(false);
        this.table.getModel().addTableModelListener(this);
        this.dataChanged = false;
        for (int i = 5; i < 9; ++i) {
            this.hideColumn(i);
        }
        this.setVisible(true);
    }

    private void hideColumn(int index) {
        TableColumn column = this.table.getColumnModel().getColumn(index);
        column.setMinWidth(0);
        column.setMaxWidth(0);
        column.setWidth(0);
        column.setPreferredWidth(0);
        this.doLayout();
    }

    private void center() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle frame = this.getBounds();
        this.setLocation((screen.width - frame.width) / 2, (screen.height - frame.height) / 2);
    }

    private JComboBox createComboBox(String ... items) {
        JComboBox<String> retv = new JComboBox<String>();
        for (String item : items) {
            retv.addItem(item);
        }
        return retv;
    }

    public void enableFields(boolean enable) {
    }

    public boolean getDataChanged() {
        return this.fieldChanged;
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jLabel8 = new JLabel();
        this.jLabel1 = new JLabel();
        this.txtAddress = new JTextField();
        this.indexLabel = new JLabel();
        this.comboPort = new JComboBox();
        this.jLabel11 = new JLabel();
        this.jLabel2 = new JLabel();
        this.txtUpdateInterval = new JTextField();
        this.btnCancel = new JButton();
        this.btnOk = new JButton();
        this.jPanel1 = new JPanel();
        this.btnSu = new JButton();
        this.btnGiu = new JButton();
        this.btnDeleteRow = new JButton();
        this.btnInsert = new JButton();
        this.btnScaling = new JButton();
        this.jPanel3 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.setName("Form");
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Addressing"));
        this.jPanel2.setName("jPanel2");
        this.jPanel2.setPreferredSize(new Dimension(300, 150));
        this.jLabel8.setName("jLabel8");
        ResourceMap resourceMap = Application.getInstance(VisiProgApp.class).getContext().getResourceMap(ModbusStationDialog.class);
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.txtAddress.setColumns(5);
        this.txtAddress.setHorizontalAlignment(11);
        this.txtAddress.setName("txtAddress");
        this.txtAddress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModbusStationDialog.this.txtAddressActionPerformed(evt);
            }
        });
        this.txtAddress.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                ModbusStationDialog.this.txtAddressKeyTyped(evt);
            }
        });
        this.indexLabel.setFont(resourceMap.getFont("indexLabel.font"));
        this.indexLabel.setForeground(resourceMap.getColor("indexLabel.foreground"));
        this.indexLabel.setText(resourceMap.getString("indexLabel.text", new Object[0]));
        this.indexLabel.setName("indexLabel");
        this.comboPort.setModel(new DefaultComboBoxModel<String>(new String[]{"RS1", "RS2"}));
        this.comboPort.setName("comboPort");
        this.comboPort.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ModbusStationDialog.this.comboPortcomboSpnrFieldChanged(evt);
            }
        });
        this.jLabel11.setText(resourceMap.getString("jLabel11.text", new Object[0]));
        this.jLabel11.setName("jLabel11");
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.txtUpdateInterval.setColumns(5);
        this.txtUpdateInterval.setHorizontalAlignment(11);
        this.txtUpdateInterval.setText(resourceMap.getString("txtUpdateInterval.text", new Object[0]));
        this.txtUpdateInterval.setName("txtUpdateInterval");
        this.txtUpdateInterval.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                ModbusStationDialog.this.txtUpdateIntervalKeyTyped(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtAddress, -2, 79, -2).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(104, 104, 104).addComponent(this.jLabel8)).addGroup(jPanel2Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtUpdateInterval, -2, -1, -2)).addComponent(this.indexLabel))))).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.comboPort, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1, -2, 22, -2).addComponent(this.txtAddress, -2, -1, -2).addComponent(this.indexLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboPort, -2, -1, -2).addComponent(this.jLabel11).addComponent(this.jLabel2).addComponent(this.txtUpdateInterval, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.btnCancel.setIcon(resourceMap.getIcon("btnCancel.icon"));
        this.btnCancel.setText(resourceMap.getString("btnCancel.text", new Object[0]));
        this.btnCancel.setName("btnCancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModbusStationDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.btnOk.setIcon(resourceMap.getIcon("btnOk.icon"));
        this.btnOk.setText(resourceMap.getString("btnOk.text", new Object[0]));
        this.btnOk.setName("btnOk");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModbusStationDialog.this.btnOkActionPerformed(evt);
            }
        });
        this.jPanel1.setName("jPanel1");
        this.btnSu.setText(resourceMap.getString("btnSu.text", new Object[0]));
        this.btnSu.setName("btnSu");
        this.btnSu.setPreferredSize(new Dimension(100, 25));
        this.btnSu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModbusStationDialog.this.btnSuActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.btnSu);
        this.btnGiu.setText(resourceMap.getString("btnGiu.text", new Object[0]));
        this.btnGiu.setName("btnGiu");
        this.btnGiu.setPreferredSize(new Dimension(100, 25));
        this.btnGiu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModbusStationDialog.this.btnGiuActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.btnGiu);
        this.btnDeleteRow.setText(resourceMap.getString("btnDeleteRow.text", new Object[0]));
        this.btnDeleteRow.setName("btnDeleteRow");
        this.btnDeleteRow.setPreferredSize(new Dimension(100, 25));
        this.btnDeleteRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModbusStationDialog.this.btnDeleteRowActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.btnDeleteRow);
        this.btnInsert.setText(resourceMap.getString("btnInsert.text", new Object[0]));
        this.btnInsert.setName("btnInsert");
        this.btnInsert.setPreferredSize(new Dimension(100, 25));
        this.btnInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModbusStationDialog.this.btnInsertActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.btnInsert);
        this.btnScaling.setText(resourceMap.getString("btnScaling.text", new Object[0]));
        this.btnScaling.setName("btnScaling");
        this.btnScaling.setPreferredSize(new Dimension(100, 25));
        this.jPanel1.add(this.btnScaling);
        this.jPanel3.setName("jPanel3");
        this.jPanel3.setLayout(new BorderLayout());
        this.jScrollPane1.setName("jScrollPane1");
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[]{"Slave Address", "Register Start  Addr.", "Function", "N Of Registers", "Comment", "Type", "Amplitude", "Offset", "Period"}){
            Class[] types;
            {
                this.types = new Class[]{Integer.class, Integer.class, String.class, Integer.class, String.class, String.class, String.class, String.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.table.setName("table");
        this.table.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ModbusStationDialog.this.tablePropertyChange(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.table);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.btnOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, 322, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 322, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, 111, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, 108, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(146, 146, 146).addComponent(this.jPanel3, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 308, Short.MAX_VALUE).addComponent(this.jPanel1, -1, 308, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 18, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCancel).addComponent(this.btnOk)).addContainerGap()));
    }

    private void txtAddressActionPerformed(ActionEvent evt) {
    }

    private void txtAddressKeyTyped(KeyEvent evt) {
        this.fieldChanged = true;
    }

    private void comboPortcomboSpnrFieldChanged(PropertyChangeEvent evt) {
        this.fieldChanged = true;
    }

    private void btnInsertActionPerformed(ActionEvent evt) {
        if (this.table.getRowCount() == 24) {
            JOptionPane.showMessageDialog(null, this.message.getString("maxrow"), this.message.getString("er"), 2);
            return;
        }
        if (this.table.getSelectedRow() >= 0) {
            ((DefaultTableModel)this.table.getModel()).insertRow(this.table.getSelectedRow(), new Object[]{"1", "1", this.modBusFunctions[2], "1", "", "Costant", "1.0", "0.0", "60.0"});
            int vColIndex = 2;
            TableColumn col = this.table.getColumnModel().getColumn(vColIndex);
            col.setCellEditor(new MyComboBoxEditor(this.modBusFunctions));
        } else if (this.table.getRowCount() == 0) {
            ((DefaultTableModel)this.table.getModel()).addRow(new Object[]{"1", "1", this.modBusFunctions[2], "1", "", "Costant", "1.0", "0.0", "60.0"});
            int vColIndex = 2;
            TableColumn col = this.table.getColumnModel().getColumn(vColIndex);
            col.setCellEditor(new MyComboBoxEditor(this.modBusFunctions));
        } else {
            ((DefaultTableModel)this.table.getModel()).addRow(new Object[]{"1", "1", this.modBusFunctions[2], "1", "", "Costant", "1.0", "0.0", "60.0"});
            int vColIndex = 2;
            TableColumn col = this.table.getColumnModel().getColumn(vColIndex);
            col.setCellEditor(new MyComboBoxEditor(this.modBusFunctions));
        }
        this.fieldChanged = true;
    }

    private void btnSuActionPerformed(ActionEvent evt) {
        if (this.table.getSelectedRows().length > 1) {
            JOptionPane.showMessageDialog(null, this.message.getString("seluna"));
        }
        if (this.table.getSelectedRows().length == 0) {
            JOptionPane.showMessageDialog(null, this.message.getString("sel"));
        }
        if (this.table.getSelectedRows().length == 1) {
            int selectedRowIndex = this.table.getSelectedRow();
            if (selectedRowIndex == 0) {
                return;
            }
            ((DefaultTableModel)this.table.getModel()).moveRow(selectedRowIndex, selectedRowIndex, selectedRowIndex - 1);
            this.table.setRowSelectionInterval(selectedRowIndex - 1, selectedRowIndex - 1);
            this.fieldChanged = true;
        }
    }

    private void btnDeleteRowActionPerformed(ActionEvent evt) {
        Object[] myOptions = new Object[]{this.message.getString("yes"), this.message.getString("no")};
        if (JOptionPane.showOptionDialog(null, this.message.getString("sicuro"), this.message.getString("er"), 0, 2, null, myOptions, myOptions[0]) == 1) {
            return;
        }
        boolean finish = false;
        while (!finish) {
            int[] selRows = this.table.getSelectedRows();
            if (selRows.length > 0) {
                ((DefaultTableModel)this.table.getModel()).removeRow(selRows[0]);
                continue;
            }
            finish = true;
        }
        this.fieldChanged = true;
    }

    private void btnGiuActionPerformed(ActionEvent evt) {
        if (this.table.getSelectedRows().length > 1) {
            JOptionPane.showMessageDialog(null, this.message.getString("seluna"));
        }
        if (this.table.getSelectedRows().length == 0) {
            JOptionPane.showMessageDialog(null, this.message.getString("sel"));
        }
        if (this.table.getSelectedRows().length == 1) {
            int selectedRowIndex = this.table.getSelectedRow();
            if (selectedRowIndex == this.table.getRowCount()) {
                return;
            }
            ((DefaultTableModel)this.table.getModel()).moveRow(selectedRowIndex, selectedRowIndex, selectedRowIndex + 1);
            this.table.setRowSelectionInterval(selectedRowIndex + 1, selectedRowIndex + 1);
            this.fieldChanged = true;
        }
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.returnStatus = 0;
        this.fieldChanged = false;
        this.setVisible(false);
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        if (this.indexLabel.isVisible()) {
            JOptionPane.showMessageDialog(null, "L'indirizzo inserito \u00e8 gi\u00e0 in uso!");
            return;
        }
        if (!FieldChecker.checkStringIsNumeric(this.txtUpdateInterval.getText(), "Update Interval non \u00e8 numerico!")) {
            return;
        }
        try {
            int nOfVars = 0;
            DefaultTableModel model = (DefaultTableModel)this.table.getModel();
            for (int i = 0; i < model.getRowCount(); ++i) {
                Integer function;
                if (model.getValueAt(i, 0) == null || model.getValueAt(i, 0).toString().length() == 0) {
                    JOptionPane.showMessageDialog(null, "Riga: " + (i + 1) + " Campo Slave Address vuoto");
                    return;
                }
                if (model.getValueAt(i, 1) == null || model.getValueAt(i, 1).toString().length() == 0) {
                    JOptionPane.showMessageDialog(null, "Riga: " + (i + 1) + " Campo Address vuoto");
                    return;
                }
                if (model.getValueAt(i, 2) == null) {
                    JOptionPane.showMessageDialog(null, "Riga: " + (i + 1) + " Campo Function vuoto");
                    return;
                }
                if (model.getValueAt(i, 4) == null) {
                    model.setValueAt(model.getValueAt(i, 0).toString() + "-" + model.getValueAt(i, 1).toString(), i, 4);
                }
                if ((function = Integer.valueOf(Integer.parseInt(model.getValueAt(i, 2).toString().substring(0, 2)))) > 4 || model.getValueAt(i, 2) == null) {
                    model.setValueAt("1", i, 3);
                }
                nOfVars += Integer.parseInt(model.getValueAt(i, 3).toString());
            }
            if (nOfVars > this.MAX_NUM_VARS) {
                JOptionPane.showMessageDialog(null, "Superato numero massimo tags");
                return;
            }
            this.returnStatus = 1;
            this.setVisible(false);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Errore nei dati !!");
        }
    }

    private void tablePropertyChange(PropertyChangeEvent evt) {
        this.fieldChanged = true;
    }

    private void txtUpdateIntervalKeyTyped(KeyEvent evt) {
        this.fieldChanged = true;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.dataChanged = true;
    }

    class ComponentAdapter
    implements ComponentListener {
        ComponentAdapter() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            ModbusStationDialog.this.txtAddress.setEnabled(!ModbusStationDialog.this.parentNode.kernelConnected);
            ModbusStationDialog.this.txtAddress.getDocument().addDocumentListener(ModbusStationDialog.this.fcl);
            ModbusStationDialog.this.txtUpdateInterval.setEnabled(!ModbusStationDialog.this.parentNode.kernelConnected);
            ModbusStationDialog.this.txtUpdateInterval.getDocument().addDocumentListener(ModbusStationDialog.this.fcl);
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            ModbusStationDialog.this.txtAddress.getDocument().removeDocumentListener(ModbusStationDialog.this.fcl);
            ModbusStationDialog.this.txtUpdateInterval.getDocument().removeDocumentListener(ModbusStationDialog.this.fcl);
        }
    }

    class FieldChangeListener
    implements DocumentListener {
        FieldChangeListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ModbusStationDialog.this.dataChanged = true;
            this.control();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ModbusStationDialog.this.dataChanged = true;
            this.control();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ModbusStationDialog.this.dataChanged = true;
            this.control();
        }

        public void control() {
            if (ModbusStationDialog.this.txtAddress.getText().equals("")) {
                ModbusStationDialog.this.indexLabel.setVisible(true);
            }
            if (ModbusStationDialog.this.parentNode.controlAddress(ModbusStationDialog.this.txtAddress.getText(), false).booleanValue()) {
                ModbusStationDialog.this.indexLabel.setVisible(true);
            } else {
                ModbusStationDialog.this.indexLabel.setVisible(false);
            }
        }
    }
}

