/*
 * Decompiled with CFR 0.152.
 */
package nodes.gui;

import VisiProg.AppOptions;
import VisiProg.VisiProgApp;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import nodes.devices.GenericNode;
import nodes.gui.MyComboBoxEditor;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class MonitorDialog
extends JDialog
implements TableModelListener {
    public static final int RET_OK = 1;
    public static final int RET_CANCEL = 0;
    private static final int MAX_NUM_ROWS = 50;
    private int returnStatus;
    private final String device_ID;
    Locale currentLocale;
    private AppOptions options = new AppOptions();
    ResourceBundle message;
    boolean dataChanged = false;
    GenericNode parentNode;
    FieldChangeListener fcl = new FieldChangeListener();
    public JButton btnCancel;
    public JButton btnDeleteRow;
    public JButton btnGiu;
    public JButton btnInsert;
    public JButton btnOk;
    public JButton btnSu;
    public JComboBox comboPort;
    public JLabel indexLabel;
    public JLabel jLabel1;
    public JLabel jLabel10;
    public JLabel jLabel2;
    public JLabel jLabel3;
    public JScrollPane jScrollPane1;
    public JTable table;
    public JTextField txtAddress;
    public JTextField txtDisplayAddress;
    public JTextField txtID;

    public MonitorDialog(Frame parent, boolean modal, String device_ID, GenericNode parentNode) {
        super(parent, modal);
        this.device_ID = device_ID;
        this.initComponents();
        this.center();
        this.options.LoadOptions();
        this.currentLocale = new Locale(this.options.language, this.options.country);
        this.message = ResourceBundle.getBundle("nodes.resources/MessagesBundle", this.currentLocale);
        this.btnInsert.setText(this.message.getString("ins"));
        this.btnDeleteRow.setText(this.message.getString("el"));
        JComboBox comboBox = this.createComboBox("1", "10", "100");
        this.txtDisplayAddress.getDocument().addDocumentListener(new FieldChangeListener());
        this.table.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(comboBox));
        this.parentNode = parentNode;
        this.addComponentListener(new ComponentAdapter());
    }

    private JComboBox createComboBox(String ... items) {
        JComboBox<String> retv = new JComboBox<String>();
        for (String item : items) {
            retv.addItem(item);
        }
        return retv;
    }

    private void initComponents() {
        this.btnSu = new JButton();
        this.btnGiu = new JButton();
        this.jLabel10 = new JLabel();
        this.jLabel2 = new JLabel();
        this.txtAddress = new JTextField();
        this.txtID = new JTextField();
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        this.btnInsert = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.btnDeleteRow = new JButton();
        this.jLabel1 = new JLabel();
        this.txtDisplayAddress = new JTextField();
        this.jLabel3 = new JLabel();
        this.comboPort = new JComboBox();
        this.indexLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance(VisiProgApp.class).getContext().getResourceMap(MonitorDialog.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        this.btnSu.setText(resourceMap.getString("btnSu.text", new Object[0]));
        this.btnSu.setName("btnSu");
        this.btnSu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MonitorDialog.this.btnSuActionPerformed(evt);
            }
        });
        this.btnGiu.setText(resourceMap.getString("btnGiu.text", new Object[0]));
        this.btnGiu.setName("btnGiu");
        this.btnGiu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MonitorDialog.this.btnGiuActionPerformed(evt);
            }
        });
        this.jLabel10.setText(resourceMap.getString("jLabel10.text", new Object[0]));
        this.jLabel10.setName("jLabel10");
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.txtAddress.setColumns(5);
        this.txtAddress.setHorizontalAlignment(11);
        this.txtAddress.setText(resourceMap.getString("txtAddress.text", new Object[0]));
        this.txtAddress.setName("txtAddress");
        this.txtID.setColumns(5);
        this.txtID.setEditable(false);
        this.txtID.setText(resourceMap.getString("txtID.text", new Object[0]));
        this.txtID.setName("txtID");
        this.btnOk.setIcon(resourceMap.getIcon("btnOk.icon"));
        this.btnOk.setText(resourceMap.getString("btnOk.text", new Object[0]));
        this.btnOk.setName("btnOk");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MonitorDialog.this.btnOkActionPerformed(evt);
            }
        });
        this.btnCancel.setIcon(resourceMap.getIcon("btnCancel.icon"));
        this.btnCancel.setText(resourceMap.getString("btnCancel.text", new Object[0]));
        this.btnCancel.setName("btnCancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MonitorDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.btnInsert.setText(resourceMap.getString("btnInsert.text", new Object[0]));
        this.btnInsert.setName("btnInsert");
        this.btnInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MonitorDialog.this.btnInsertActionPerformed(evt);
            }
        });
        this.jScrollPane1.setName("jScrollPane1");
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null, null}}, new String[]{"Nome", "Scale Factor", "Address", "MIN", "MAX", "STEP"}){
            Class[] types;
            {
                this.types = new Class[]{String.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.table.setName("table");
        this.table.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MonitorDialog.this.tablePropertyChange(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.table);
        this.table.getColumnModel().getColumn(0).setHeaderValue(resourceMap.getString("table.columnModel.title0", new Object[0]));
        this.table.getColumnModel().getColumn(1).setHeaderValue(resourceMap.getString("table.columnModel.title1", new Object[0]));
        this.table.getColumnModel().getColumn(2).setHeaderValue(resourceMap.getString("table.columnModel.title2", new Object[0]));
        this.table.getColumnModel().getColumn(3).setHeaderValue(resourceMap.getString("table.columnModel.title3", new Object[0]));
        this.table.getColumnModel().getColumn(4).setHeaderValue(resourceMap.getString("table.columnModel.title4", new Object[0]));
        this.table.getColumnModel().getColumn(5).setHeaderValue(resourceMap.getString("table.columnModel.title5", new Object[0]));
        this.btnDeleteRow.setText(resourceMap.getString("btnDeleteRow.text", new Object[0]));
        this.btnDeleteRow.setToolTipText(resourceMap.getString("btnDeleteRow.toolTipText", new Object[0]));
        this.btnDeleteRow.setName("btnDeleteRow");
        this.btnDeleteRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MonitorDialog.this.btnDeleteRowActionPerformed(evt);
            }
        });
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.txtDisplayAddress.setColumns(5);
        this.txtDisplayAddress.setText(resourceMap.getString("txtDisplayAddress.text", new Object[0]));
        this.txtDisplayAddress.setName("txtDisplayAddress");
        this.txtDisplayAddress.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                MonitorDialog.this.txtFieldKeyTyped(evt);
            }
        });
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.comboPort.setModel(new DefaultComboBoxModel<String>(new String[]{"RS1", "RS2"}));
        this.comboPort.setName("comboPort");
        this.comboPort.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MonitorDialog.this.comboPortItemStateChanged(evt);
            }
        });
        this.indexLabel.setFont(resourceMap.getFont("indexLabel.font"));
        this.indexLabel.setForeground(resourceMap.getColor("indexLabel.foreground"));
        this.indexLabel.setText(resourceMap.getString("indexLabel.text", new Object[0]));
        this.indexLabel.setName("indexLabel");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, 0, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnDeleteRow, -1, -1, Short.MAX_VALUE).addComponent(this.btnInsert, -1, -1, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnGiu, -1, -1, Short.MAX_VALUE).addComponent(this.btnSu, -1, -1, Short.MAX_VALUE))).addGap(8, 8, 8)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.btnOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtDisplayAddress, -2, -1, -2).addGap(56, 56, 56).addComponent(this.jLabel3).addGap(18, 18, 18).addComponent(this.comboPort, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addGap(18, 18, 18).addComponent(this.txtID, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel10).addGap(18, 18, 18).addComponent(this.txtAddress, -2, -1, -2).addGap(18, 18, 18).addComponent(this.indexLabel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.txtID, -2, -1, -2).addComponent(this.jLabel10).addComponent(this.txtAddress, -2, -1, -2).addComponent(this.indexLabel)).addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.txtDisplayAddress, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.comboPort, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.btnSu).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnGiu, -2, 23, -2).addGap(52, 52, 52).addComponent(this.btnDeleteRow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnInsert)).addComponent(this.jScrollPane1, -1, 337, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCancel).addComponent(this.btnOk)).addContainerGap()));
        this.pack();
    }

    private void btnSuActionPerformed(ActionEvent evt) {
        if (this.table.getSelectedRows().length > 1) {
            JOptionPane.showMessageDialog(null, this.message.getString("seluna"));
        }
        if (this.table.getSelectedRows().length == 0) {
            JOptionPane.showMessageDialog(null, this.message.getString("sel"));
        }
        if (this.table.getSelectedRows().length == 1) {
            int selectedRowIndex = this.table.getSelectedRow();
            if (selectedRowIndex == 0) {
                return;
            }
            ((DefaultTableModel)this.table.getModel()).moveRow(selectedRowIndex, selectedRowIndex, selectedRowIndex - 1);
            this.table.setRowSelectionInterval(selectedRowIndex - 1, selectedRowIndex - 1);
        }
    }

    public boolean getDataChanged() {
        return this.dataChanged;
    }

    public void disableListeners() {
        this.table.getModel().removeTableModelListener(this);
    }

    private void hideColumn(int index) {
        TableColumn column = this.table.getColumnModel().getColumn(index);
        column.setMinWidth(0);
        column.setMaxWidth(0);
        column.setWidth(0);
        column.setPreferredWidth(0);
        this.doLayout();
    }

    public void showDialog() {
        this.table.getModel().addTableModelListener(this);
        this.dataChanged = false;
        this.hideColumn(6);
        this.setVisible(true);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void btnGiuActionPerformed(ActionEvent evt) {
        if (this.table.getSelectedRows().length > 1) {
            JOptionPane.showMessageDialog(null, this.message.getString("seluna"));
        }
        if (this.table.getSelectedRows().length == 0) {
            JOptionPane.showMessageDialog(null, this.message.getString("sel"));
        }
        if (this.table.getSelectedRows().length == 1) {
            int selectedRowIndex = this.table.getSelectedRow();
            if (selectedRowIndex == this.table.getRowCount()) {
                return;
            }
            ((DefaultTableModel)this.table.getModel()).moveRow(selectedRowIndex, selectedRowIndex, selectedRowIndex + 1);
            this.table.setRowSelectionInterval(selectedRowIndex + 1, selectedRowIndex + 1);
        }
    }

    private void btnInsertActionPerformed(ActionEvent evt) {
        if (this.table.getRowCount() == 50) {
            JOptionPane.showMessageDialog(null, this.message.getString("maxrow"), this.message.getString("er"), 2);
            return;
        }
        String[] values = new String[]{"1", "10", "100"};
        if (this.table.getSelectedRow() >= 0) {
            ((DefaultTableModel)this.table.getModel()).insertRow(this.table.getSelectedRow(), new Object[]{""});
            int vColIndex = 1;
            TableColumn col = this.table.getColumnModel().getColumn(vColIndex);
            col.setCellEditor(new MyComboBoxEditor(values));
        } else if (this.table.getRowCount() == 0) {
            ((DefaultTableModel)this.table.getModel()).addRow(new Object[]{""});
            int vColIndex = 1;
            TableColumn col = this.table.getColumnModel().getColumn(vColIndex);
            col.setCellEditor(new MyComboBoxEditor(values));
        } else {
            ((DefaultTableModel)this.table.getModel()).addRow(new Object[]{""});
            int vColIndex = 1;
            TableColumn col = this.table.getColumnModel().getColumn(vColIndex);
            col.setCellEditor(new MyComboBoxEditor(values));
        }
    }

    private void btnDeleteRowActionPerformed(ActionEvent evt) {
        Object[] myOptions = new Object[]{this.message.getString("yes"), this.message.getString("no")};
        if (JOptionPane.showOptionDialog(null, this.message.getString("sicuro"), this.message.getString("er"), 0, 2, null, myOptions, myOptions[0]) == 1) {
            return;
        }
        boolean finish = false;
        while (!finish) {
            int[] selRows = this.table.getSelectedRows();
            if (selRows.length > 0) {
                ((DefaultTableModel)this.table.getModel()).removeRow(selRows[0]);
                continue;
            }
            finish = true;
        }
    }

    private void comboPortItemStateChanged(ItemEvent evt) {
        this.dataChanged = true;
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        if (model.getRowCount() > 24) {
            JOptionPane.showMessageDialog(null, "Un Numero di Righe maggiore di 24 \u00e8 supportato dai MobDSP distribuiti a partire da Gennaio 2013", "Attenzione", 2);
        }
        for (int i = 0; i < model.getRowCount(); ++i) {
            if (model.getValueAt(i, 0) == null) {
                model.setValueAt("NA", i, 0);
            }
            if (model.getValueAt(i, 1) == null) {
                model.setValueAt("1", i, 1);
            }
            for (int j = 1; j < model.getColumnCount() - 1; ++j) {
                if (model.getValueAt(i, j) == null) {
                    model.setValueAt("0", i, j);
                }
                try {
                    String str = model.getValueAt(i, j).toString();
                    int nb = Integer.parseInt(str);
                    continue;
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(null, "La cella:" + (i + 1) + " " + (j + 1) + "contiene dei valori NON validi");
                    this.dataChanged = false;
                    this.returnStatus = 0;
                    return;
                }
            }
        }
        if (this.indexLabel.isVisible()) {
            JOptionPane.showMessageDialog(null, "L'indirizzo inserito \u00e8 gi\u00e0 in uso!");
            return;
        }
        this.returnStatus = 1;
        this.setVisible(false);
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.returnStatus = 0;
        this.setVisible(false);
    }

    private void txtFieldKeyTyped(KeyEvent evt) {
        this.dataChanged = true;
    }

    private void tablePropertyChange(PropertyChangeEvent evt) {
        this.dataChanged = true;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MonitorDialog dialog = new MonitorDialog((Frame)new JFrame(), true, "ds18s20", null);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    private void center() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle frame = this.getBounds();
        this.setLocation((screen.width - frame.width) / 2, (screen.height - frame.height) / 2);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.dataChanged = true;
    }

    class ComponentAdapter
    implements ComponentListener {
        ComponentAdapter() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            MonitorDialog.this.txtAddress.setEnabled(!MonitorDialog.this.parentNode.kernelConnected);
            MonitorDialog.this.txtAddress.getDocument().addDocumentListener(MonitorDialog.this.fcl);
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            MonitorDialog.this.txtAddress.getDocument().removeDocumentListener(MonitorDialog.this.fcl);
        }
    }

    class FieldChangeListener
    implements DocumentListener {
        FieldChangeListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            MonitorDialog.this.dataChanged = true;
            this.control();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            MonitorDialog.this.dataChanged = true;
            this.control();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            MonitorDialog.this.dataChanged = true;
            this.control();
        }

        public void control() {
            if (MonitorDialog.this.txtAddress.getText().equals("")) {
                MonitorDialog.this.indexLabel.setVisible(true);
            }
            if (MonitorDialog.this.parentNode.controlAddress(MonitorDialog.this.txtAddress.getText(), false).booleanValue()) {
                MonitorDialog.this.indexLabel.setVisible(true);
            } else {
                MonitorDialog.this.indexLabel.setVisible(false);
            }
        }
    }
}

